/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.cli.command.SVNCommandEventProcessor;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SVNMergeCommand
extends SVNCommand {
    public void run(InputStream in, PrintStream out, PrintStream err) throws SVNException {
        this.run(out, err);
    }

    public void run(PrintStream out, PrintStream err) throws SVNException {
        boolean useAncestry = !this.getCommandLine().hasArgument(SVNArgument.IGNORE_ANCESTRY);
        boolean recursive = !this.getCommandLine().hasArgument(SVNArgument.NON_RECURSIVE);
        boolean force = this.getCommandLine().hasArgument(SVNArgument.FORCE);
        boolean dryRun = this.getCommandLine().hasArgument(SVNArgument.DRY_RUN);
        this.getClientManager().setEventHandler((ISVNEventHandler)new SVNCommandEventProcessor(out, err, false, false));
        SVNDiffClient differ = this.getClientManager().getDiffClient();
        if (this.getCommandLine().hasArgument(SVNArgument.EXTENSIONS)) {
            SVNDiffOptions diffOptions = new SVNDiffOptions(this.getCommandLine().hasArgument(SVNArgument.IGNORE_ALL_WS), this.getCommandLine().hasArgument(SVNArgument.IGNORE_WS_CHANGE), this.getCommandLine().hasArgument(SVNArgument.IGNORE_EOL_STYLE));
            differ.setMergeOptions(diffOptions);
        }
        if (this.getCommandLine().hasArgument(SVNArgument.REVISION) || this.getCommandLine().hasArgument(SVNArgument.CHANGE)) {
            SVNRevision rN = SVNRevision.UNDEFINED;
            SVNRevision rM = SVNRevision.UNDEFINED;
            String revStr = (String)this.getCommandLine().getArgumentValue(SVNArgument.REVISION);
            if (revStr == null && this.getCommandLine().hasArgument(SVNArgument.CHANGE)) {
                long changeRev = Long.parseLong((String)this.getCommandLine().getArgumentValue(SVNArgument.CHANGE));
                if (changeRev >= 0L) {
                    rM = SVNRevision.create((long)changeRev);
                    rN = SVNRevision.create((long)(changeRev - 1L));
                } else {
                    rN = SVNRevision.create((long)(-changeRev));
                    rM = SVNRevision.create((long)(-changeRev - 1L));
                }
            } else {
                if (revStr.indexOf(58) <= 0 || revStr.indexOf(123) != -1 && revStr.indexOf("}:") == -1 && revStr.indexOf(":{") == -1) {
                    SVNMergeCommand.println(err, "svn: merge needs both source and target revisions to be specified");
                    return;
                }
                SVNRevision[] revRange = this.getStartEndRevisions();
                rN = revRange[0];
                rM = revRange[1];
            }
            if (!rN.isValid() || !rM.isValid() || rN == SVNRevision.WORKING || rM == SVNRevision.WORKING) {
                SVNMergeCommand.println(err, "svn: merge needs both source and target revisions to be specified");
                return;
            }
            if (this.getCommandLine().hasURLs()) {
                String url = this.getCommandLine().getURL(0);
                SVNRevision pegRev = this.getCommandLine().getPegRevision(0);
                File dstPath = null;
                if (this.getCommandLine().getPathCount() > 0) {
                    dstPath = new File(this.getCommandLine().getPathAt(0));
                }
                if (dstPath == null && !(dstPath = new File(SVNEncodingUtil.uriDecode((String)SVNPathUtil.tail((String)url)))).isFile()) {
                    dstPath = new File(".");
                }
                if (pegRev == SVNRevision.UNDEFINED) {
                    pegRev = SVNRevision.HEAD;
                }
                SVNURL svnURL = SVNURL.parseURIEncoded((String)url);
                differ.doMerge(svnURL, pegRev, rN, rM, dstPath, recursive, useAncestry, force, dryRun);
            } else if (this.getCommandLine().hasPaths()) {
                File srcPath = new File(this.getCommandLine().getPathAt(0));
                SVNRevision pegRevision = this.getCommandLine().getPathPegRevision(0);
                if (pegRevision == SVNRevision.UNDEFINED) {
                    pegRevision = SVNRevision.HEAD;
                }
                File dstPath = srcPath;
                if (this.getCommandLine().getPathCount() > 1) {
                    dstPath = new File(this.getCommandLine().getPathAt(1));
                }
                differ.doMerge(srcPath, pegRevision, rN, rM, dstPath, recursive, useAncestry, force, dryRun);
            }
        } else if (this.getCommandLine().getURLCount() == 2) {
            String c2;
            String c1;
            String url1 = this.getCommandLine().getURL(0);
            SVNRevision rN = this.getCommandLine().getPegRevision(0);
            if (!rN.isValid()) {
                rN = SVNRevision.HEAD;
            }
            String url2 = this.getCommandLine().getURL(1);
            SVNRevision rM = this.getCommandLine().getPegRevision(1);
            if (!rM.isValid()) {
                rM = SVNRevision.HEAD;
            }
            File dstPath = null;
            if (this.getCommandLine().getPathCount() > 0) {
                dstPath = new File(this.getCommandLine().getPathAt(0));
            }
            if (dstPath == null && (c1 = SVNPathUtil.tail((String)url1)).equals(c2 = SVNPathUtil.tail((String)url2)) && !(dstPath = new File(SVNEncodingUtil.uriDecode((String)c1))).isFile()) {
                dstPath = new File(".");
            }
            SVNURL svnURL1 = SVNURL.parseURIEncoded((String)url1);
            SVNURL svnURL2 = SVNURL.parseURIEncoded((String)url2);
            differ.doMerge(svnURL1, rN, svnURL2, rM, dstPath, recursive, useAncestry, force, dryRun);
        } else if (this.getCommandLine().getPathCount() >= 2) {
            File path1 = new File(this.getCommandLine().getPathAt(0));
            SVNRevision rN = this.getCommandLine().getPathPegRevision(0);
            if (!rN.isValid()) {
                rN = SVNRevision.HEAD;
            }
            File path2 = new File(this.getCommandLine().getPathAt(1));
            SVNRevision rM = this.getCommandLine().getPathPegRevision(1);
            if (!rM.isValid()) {
                rM = SVNRevision.HEAD;
            }
            File dstPath = new File(".");
            if (this.getCommandLine().getPathCount() > 2) {
                dstPath = new File(this.getCommandLine().getPathAt(2));
            }
            differ.doMerge(path1, rN, path2, rM, dstPath, recursive, useAncestry, force, dryRun);
        } else {
            SVNMergeCommand.println(err, "svn: unsupported merge call format");
        }
    }
}

