/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaReader;
import org.tmatesoft.svn.core.internal.io.svn.SVNReader;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.ISVNEditor;

public class SVNEditModeReader {
    private static final Map COMMANDS_MAP = new HashMap();
    private ISVNEditor myEditor;
    private SVNDeltaReader myDeltaReader;
    private String myFilePath;

    public void setEditor(ISVNEditor editor) {
        this.myEditor = editor;
        this.myDeltaReader = new SVNDeltaReader();
    }

    public boolean processCommand(String commandName, InputStream parameters) throws SVNException {
        String pattern = (String)COMMANDS_MAP.get(commandName);
        if (pattern == null) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_UNKNOWN_CMD));
        }
        if ("textdelta-chunk".equals(commandName)) {
            Object[] items = SVNReader.parse(parameters, "(SB))", null);
            byte[] bytes = (byte[])items[1];
            this.myDeltaReader.nextWindow(bytes, 0, bytes.length, this.myFilePath, this.myEditor);
            return true;
        }
        boolean last = "close-edit".equals(commandName) || "abort-edit".equals(commandName) || "finish-replay".equals(commandName);
        Object[] items = SVNReader.parse(parameters, pattern, new Object[10]);
        if ("target-rev".equals(commandName)) {
            this.myEditor.targetRevision(SVNReader.getLong(items, 0));
        } else if ("open-root".equals(commandName)) {
            this.myEditor.openRoot(SVNReader.getLong(items, 0));
        } else if ("delete-entry".equals(commandName)) {
            this.myEditor.deleteEntry((String)items[0], SVNReader.getLong(items, 1));
        } else if ("add-dir".equals(commandName)) {
            this.myEditor.addDir((String)items[0], (String)items[3], SVNReader.getLong(items, 4));
        } else if ("open-dir".equals(commandName)) {
            this.myEditor.openDir((String)items[0], SVNReader.getLong(items, 3));
        } else if ("change-dir-prop".equals(commandName)) {
            this.myEditor.changeDirProperty((String)items[1], (String)items[2]);
        } else if ("close-dir".equals(commandName)) {
            this.myEditor.closeDir();
        } else if ("add-file".equals(commandName)) {
            this.myEditor.addFile((String)items[0], (String)items[3], SVNReader.getLong(items, 4));
            this.myFilePath = (String)items[0];
        } else if ("open-file".equals(commandName)) {
            this.myEditor.openFile((String)items[0], SVNReader.getLong(items, 3));
            this.myFilePath = (String)items[0];
        } else if ("change-file-prop".equals(commandName)) {
            this.myEditor.changeFileProperty(this.myFilePath, (String)items[1], (String)items[2]);
        } else if ("close-file".equals(commandName)) {
            this.myEditor.closeFile(this.myFilePath, (String)items[1]);
        } else if ("apply-textdelta".equals(commandName)) {
            this.myEditor.applyTextDelta(this.myFilePath, (String)items[1]);
        } else if ("textdelta-end".equals(commandName)) {
            this.myDeltaReader.reset(this.myFilePath, this.myEditor);
            this.myEditor.textDeltaEnd(this.myFilePath);
        } else if ("close-edit".equals(commandName)) {
            this.myEditor.closeEdit();
        } else if ("abort-edit".equals(commandName)) {
            this.myEditor.abortEdit();
        } else if ("absent-dir".equals(commandName)) {
            this.myEditor.absentDir((String)items[0]);
        } else if ("absent-file".equals(commandName)) {
            this.myEditor.absentFile((String)items[0]);
        }
        return !last;
    }

    static {
        COMMANDS_MAP.put("target-rev", "(N)");
        COMMANDS_MAP.put("open-root", "((?N)S)");
        COMMANDS_MAP.put("delete-entry", "(S(?N)S)");
        COMMANDS_MAP.put("add-dir", "(SSS(?S?N))");
        COMMANDS_MAP.put("open-dir", "(SSS(?N))");
        COMMANDS_MAP.put("change-dir-prop", "(SS(?S))");
        COMMANDS_MAP.put("close-dir", "(S)");
        COMMANDS_MAP.put("add-file", "(SSS(?S?N))");
        COMMANDS_MAP.put("open-file", "(SSS(?N))");
        COMMANDS_MAP.put("apply-textdelta", "(S(?S))");
        COMMANDS_MAP.put("textdelta-chunk", "(SS)");
        COMMANDS_MAP.put("textdelta-end", "(S)");
        COMMANDS_MAP.put("change-file-prop", "(SS(?S))");
        COMMANDS_MAP.put("close-file", "(S(?S))");
        COMMANDS_MAP.put("close-edit", "()");
        COMMANDS_MAP.put("abort-edit", "()");
        COMMANDS_MAP.put("finish-replay", "()");
        COMMANDS_MAP.put("absent-dir", "(SS)");
        COMMANDS_MAP.put("absent-file", "(SS)");
    }
}

