/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaReader;
import org.tmatesoft.svn.core.internal.io.svn.ISVNConnector;
import org.tmatesoft.svn.core.internal.io.svn.SVNCommitEditor;
import org.tmatesoft.svn.core.internal.io.svn.SVNConnection;
import org.tmatesoft.svn.core.internal.io.svn.SVNReader;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNTimeUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNFileRevisionHandler;
import org.tmatesoft.svn.core.io.ISVNLocationEntryHandler;
import org.tmatesoft.svn.core.io.ISVNLockHandler;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.ISVNSession;
import org.tmatesoft.svn.core.io.ISVNWorkspaceMediator;
import org.tmatesoft.svn.core.io.SVNFileRevision;
import org.tmatesoft.svn.core.io.SVNLocationEntry;
import org.tmatesoft.svn.core.io.SVNRepository;

public class SVNRepositoryImpl
extends SVNRepository
implements ISVNReporter {
    private SVNConnection myConnection;
    private String myRealm;
    private String myExternalUserName;

    protected SVNRepositoryImpl(SVNURL location, ISVNSession options) {
        super(location, options);
    }

    public void testConnection() throws SVNException {
        try {
            this.openConnection();
        }
        catch (SVNException e) {
            this.closeSession();
            throw e;
        }
        finally {
            this.closeConnection();
        }
    }

    public void setLocation(SVNURL url, boolean forceReconnect) throws SVNException {
        if (url == null) {
            return;
        }
        if (!url.getProtocol().equals(this.myLocation.getProtocol())) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED, "SVNRepository URL could not be changed from ''{0}'' to ''{1}''; create new SVNRepository instance instead", new Object[]{this.myLocation, url});
            SVNErrorManager.error(err);
        }
        if (forceReconnect) {
            this.closeSession();
            this.myLocation = url;
            this.myRealm = null;
            this.myRepositoryRoot = null;
            this.myRepositoryUUID = null;
            return;
        }
        try {
            this.openConnection();
            if (this.reparent(url)) {
                this.myLocation = url;
                return;
            }
            this.setLocation(url, true);
        }
        catch (SVNException e) {
            this.closeSession();
            throw e;
        }
        finally {
            this.closeConnection();
        }
    }

    private boolean reparent(SVNURL url) throws SVNException {
        block4: {
            if (this.myConnection != null) {
                if (this.getLocation().equals(url)) {
                    return true;
                }
                try {
                    Object[] buffer = new Object[]{"reparent", url.toString()};
                    this.write("(w(s))", buffer);
                    this.authenticate();
                    this.read("[()]", null, true);
                    String newLocation = url.toString();
                    String rootLocation = this.myRepositoryRoot.toString();
                    return newLocation.startsWith(rootLocation) && (newLocation.length() == rootLocation.length() || newLocation.length() > rootLocation.length() && newLocation.charAt(rootLocation.length()) == '/');
                }
                catch (SVNException e) {
                    if (!(e instanceof SVNCancelException) && !(e instanceof SVNAuthenticationException)) break block4;
                    throw e;
                }
            }
        }
        return false;
    }

    public long getLatestRevision() throws SVNException {
        Object[] buffer = new Object[]{"get-latest-rev"};
        try {
            this.openConnection();
            this.write("(w())", buffer);
            this.authenticate();
            buffer = this.read("[(N)]", buffer, true);
        }
        catch (SVNException e) {
            this.closeSession();
            throw e;
        }
        finally {
            this.closeConnection();
        }
        return SVNReader.getLong(buffer, 0);
    }

    public long getDatedRevision(Date date) throws SVNException {
        if (date == null) {
            date = new Date(System.currentTimeMillis());
        }
        Object[] buffer = new Object[]{"get-dated-rev", date};
        try {
            this.openConnection();
            this.write("(w(s))", buffer);
            this.authenticate();
            buffer = this.read("[(N)]", buffer, true);
        }
        catch (SVNException e) {
            this.closeSession();
            throw e;
        }
        finally {
            this.closeConnection();
        }
        return SVNReader.getLong(buffer, 0);
    }

    public Map getRevisionProperties(long revision, Map properties) throws SVNException {
        SVNRepositoryImpl.assertValidRevision(revision);
        if (properties == null) {
            properties = new HashMap();
        }
        Object[] buffer = new Object[]{"rev-proplist", SVNRepositoryImpl.getRevisionObject(revision)};
        try {
            this.openConnection();
            this.write("(w(n))", buffer);
            this.authenticate();
            buffer[0] = properties;
            this.read("[((*P))]", buffer, true);
        }
        catch (SVNException e) {
            this.closeSession();
            throw e;
        }
        finally {
            this.closeConnection();
        }
        return properties;
    }

    public String getRevisionPropertyValue(long revision, String propertyName) throws SVNException {
        SVNRepositoryImpl.assertValidRevision(revision);
        Object[] buffer = new Object[]{"rev-prop", SVNRepositoryImpl.getRevisionObject(revision), propertyName};
        try {
            this.openConnection();
            this.write("(w(ns))", buffer);
            this.authenticate();
            buffer = this.read("[((?S))]", buffer, true);
        }
        catch (SVNException e) {
            this.closeSession();
            throw e;
        }
        finally {
            this.closeConnection();
        }
        return (String)buffer[0];
    }

    public SVNNodeKind checkPath(String path, long revision) throws SVNException {
        try {
            this.openConnection();
            path = this.getRepositoryPath(path);
            Object[] buffer = new Object[]{"check-path", path, SVNRepositoryImpl.getRevisionObject(revision)};
            this.write("(w(s(n)))", buffer);
            this.authenticate();
            this.read("[(W)]", buffer, true);
            SVNNodeKind sVNNodeKind = SVNNodeKind.parseKind((String)buffer[0]);
            return sVNNodeKind;
        }
        catch (SVNException e) {
            this.closeSession();
            throw e;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLocations(String path, long pegRevision, long[] revisions, ISVNLocationEntryHandler handler) throws SVNException {
        SVNRepositoryImpl.assertValidRevision(pegRevision);
        for (int i = 0; i < revisions.length; ++i) {
            SVNRepositoryImpl.assertValidRevision(revisions[i]);
        }
        int count = 0;
        try {
            this.openConnection();
            path = this.getRepositoryPath(path);
            Object[] buffer = new Object[]{"get-locations", path, SVNRepositoryImpl.getRevisionObject(pegRevision), revisions};
            this.write("(w(sn(*n)))", buffer);
            this.authenticate();
            while (true) {
                try {
                    this.read("(NS)", buffer, false);
                }
                catch (SVNException e) {
                    break;
                }
                ++count;
                if (handler == null) continue;
                long revision = SVNReader.getLong(buffer, 0);
                String location = SVNReader.getString(buffer, 1);
                if (location == null) continue;
                handler.handleLocationEntry(new SVNLocationEntry(revision, location));
            }
            this.read("x", buffer, true);
            this.read("[()]", buffer, true);
        }
        catch (SVNException e) {
            this.closeSession();
            this.handleUnsupportedCommand(e, "'get-locations' not implemented");
        }
        finally {
            this.closeConnection();
        }
        return count;
    }

    public long getFile(String path, long revision, Map properties, OutputStream contents) throws SVNException {
        Long rev = revision > 0L ? new Long(revision) : null;
        try {
            this.openConnection();
            Object[] buffer = new Object[]{"get-file", this.getRepositoryPath(path), rev, properties != null, contents != null};
            this.write("(w(s(n)ww))", buffer);
            this.authenticate();
            buffer[2] = properties;
            buffer = this.read("[((?S)N(*P))]", buffer, true);
            if (properties != null) {
                properties.put("svn:entry:revision", buffer[1].toString());
                properties.put("svn:entry:checksum", buffer[0].toString());
            }
            if (contents != null) {
                Object[] buffer2 = new Object[]{contents};
                this.read("*I", buffer2, true);
                this.read("[()]", buffer2, true);
            }
            long l = SVNReader.getLong(buffer, 1);
            return l;
        }
        catch (SVNException e) {
            this.closeSession();
            throw e;
        }
        finally {
            this.closeConnection();
        }
    }

    public long getDir(String path, long revision, Map properties, final ISVNDirEntryHandler handler) throws SVNException {
        Long rev = SVNRepositoryImpl.getRevisionObject(revision);
        try {
            this.openConnection();
            String fullPath = this.getFullPath(path);
            final SVNURL url = this.getLocation().setPath(fullPath, false);
            path = this.getRepositoryPath(path);
            Object[] buffer = new Object[]{"get-dir", path, rev, properties != null, handler != null};
            this.write("(w(s(n)ww))", buffer);
            this.authenticate();
            buffer[1] = properties;
            buffer = this.read("[(N(*P)", buffer, true);
            revision = buffer[0] != null ? SVNReader.getLong(buffer, 0) : revision;
            ISVNDirEntryHandler nestedHandler = new ISVNDirEntryHandler(){

                public void handleDirEntry(SVNDirEntry dirEntry) throws SVNException {
                    handler.handleDirEntry(new SVNDirEntry(url.appendPath(dirEntry.getName(), false), dirEntry.getName(), dirEntry.getKind(), dirEntry.getSize(), dirEntry.hasProperties(), dirEntry.getRevision(), dirEntry.getDate(), dirEntry.getAuthor()));
                }
            };
            if (handler != null) {
                buffer[0] = nestedHandler;
                this.read("(*D)))", buffer, true);
            } else {
                this.read("()))", null, true);
            }
        }
        catch (SVNException e) {
            this.closeSession();
            throw e;
        }
        finally {
            this.closeConnection();
        }
        return revision;
    }

    public SVNDirEntry getDir(String path, long revision, boolean includeComment, final Collection entries) throws SVNException {
        Long rev = SVNRepositoryImpl.getRevisionObject(revision);
        SVNDirEntry parentEntry = null;
        try {
            this.openConnection();
            final SVNURL url = this.getLocation().setPath(this.getFullPath(path), false);
            ISVNDirEntryHandler handler = new ISVNDirEntryHandler(){

                public void handleDirEntry(SVNDirEntry dirEntry) throws SVNException {
                    dirEntry = new SVNDirEntry(url.appendPath(dirEntry.getName(), false), dirEntry.getName(), dirEntry.getKind(), dirEntry.getSize(), dirEntry.hasProperties(), dirEntry.getRevision(), dirEntry.getDate(), dirEntry.getAuthor());
                    entries.add(dirEntry);
                }
            };
            path = this.getRepositoryPath(path);
            Object[] buffer = new Object[]{"stat", path, SVNRepositoryImpl.getRevisionObject(revision)};
            this.write("(w(s(n)))", buffer);
            this.authenticate();
            this.read("[((?F))]", buffer, true);
            parentEntry = (SVNDirEntry)buffer[0];
            parentEntry = new SVNDirEntry(url, "", parentEntry.getKind(), parentEntry.getSize(), parentEntry.hasProperties(), parentEntry.getRevision(), parentEntry.getDate(), parentEntry.getAuthor());
            buffer = new Object[]{"get-dir", path, rev, Boolean.FALSE, Boolean.TRUE};
            this.write("(w(s(n)ww))", buffer);
            this.authenticate();
            buffer = this.read("[(N(*P)", buffer, true);
            long l = revision = buffer[0] != null ? SVNReader.getLong(buffer, 0) : revision;
            if (handler != null) {
                buffer[0] = handler;
                this.read("(*D)))", buffer, true);
            } else {
                this.read("()))", null, true);
            }
            if (includeComment) {
                HashMap<Long, Object> messages = new HashMap<Long, Object>();
                Iterator ents = entries.iterator();
                while (ents.hasNext()) {
                    SVNDirEntry entry = (SVNDirEntry)ents.next();
                    Long key = SVNRepositoryImpl.getRevisionObject(entry.getRevision());
                    if (messages.containsKey(key)) {
                        entry.setCommitMessage((String)messages.get(key));
                        continue;
                    }
                    buffer = new Object[]{"rev-prop", key, "svn:log"};
                    this.write("(w(ns))", buffer);
                    this.authenticate();
                    buffer = this.read("[((?S))]", buffer, true);
                    messages.put(key, buffer[0]);
                    entry.setCommitMessage((String)buffer[0]);
                }
            }
        }
        catch (SVNException e) {
            this.closeSession();
            throw e;
        }
        finally {
            this.closeConnection();
        }
        return parentEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getFileRevisions(String path, long sRevision, long eRevision, ISVNFileRevisionHandler handler) throws SVNException {
        Long srev = SVNRepositoryImpl.getRevisionObject(sRevision);
        Long erev = SVNRepositoryImpl.getRevisionObject(eRevision);
        int count = 0;
        SVNDeltaReader deltaReader = new SVNDeltaReader();
        try {
            this.openConnection();
            Object[] buffer = new Object[]{"get-file-revs", this.getRepositoryPath(path), srev, erev};
            this.write("(w(s(n)(n)))", buffer);
            this.authenticate();
            buffer = new Object[5];
            while (true) {
                SVNFileRevision fileRevision = null;
                boolean skipDelta = false;
                try {
                    buffer = this.read("(SN(*P)(*Z)?S", buffer, false);
                    if (buffer[4] != null && ((String)buffer[4]).length() == 0) {
                        buffer[4] = null;
                        skipDelta = true;
                    } else {
                        this.read(")", null, false);
                    }
                    ++count;
                }
                catch (SVNException e) {
                    this.read("x", buffer, true);
                    this.read("[()]", buffer, true);
                    int n = count;
                    this.closeConnection();
                    return n;
                }
                String name = null;
                if (handler != null) {
                    name = (String)buffer[0];
                    long revision = SVNReader.getLong(buffer, 1);
                    Map properties = SVNReader.getMap(buffer, 2);
                    Map propertiesDelta = SVNReader.getMap(buffer, 3);
                    if (name != null) {
                        fileRevision = new SVNFileRevision(name, revision, properties, propertiesDelta);
                    }
                    buffer[2] = null;
                    buffer[3] = null;
                }
                if (handler != null && fileRevision != null) {
                    handler.openRevision(fileRevision);
                }
                if (skipDelta) {
                    if (handler == null) continue;
                    handler.closeRevision(name == null ? path : name);
                    continue;
                }
                boolean windowRead = false;
                while (true) {
                    byte[] line;
                    if ((line = (byte[])this.read("?W?B", buffer, true)[1]) == null) {
                        this.read("[]", buffer, true);
                        break;
                    }
                    if (line.length == 0) break;
                    if (!windowRead && handler != null) {
                        handler.applyTextDelta(name == null ? path : name, null);
                        windowRead = true;
                    }
                    deltaReader.nextWindow(line, 0, line.length, name == null ? path : name, handler);
                }
                deltaReader.reset(name == null ? path : name, handler);
                if (windowRead) {
                    handler.textDeltaEnd(name == null ? path : name);
                }
                if (handler == null) continue;
                handler.closeRevision(name == null ? path : name);
                continue;
                break;
            }
        }
        catch (SVNException e) {
            this.closeSession();
            this.handleUnsupportedCommand(e, "'get-file-revs' not implemented");
            return -1;
        }
        finally {
            this.closeConnection();
        }
    }

    public long log(String[] targetPaths, long startRevision, long endRevision, boolean changedPaths, boolean strictNode, long limit, ISVNLogEntryHandler handler) throws SVNException {
        long count = 0L;
        long latestRev = -1L;
        if (SVNRepositoryImpl.isInvalidRevision(startRevision)) {
            startRevision = latestRev = this.getLatestRevision();
        }
        if (SVNRepositoryImpl.isInvalidRevision(endRevision)) {
            endRevision = latestRev != -1L ? latestRev : this.getLatestRevision();
        }
        try {
            this.openConnection();
            String[] repositoryPaths = this.getRepositoryPaths(targetPaths);
            if (repositoryPaths == null || repositoryPaths.length == 0) {
                repositoryPaths = new String[]{""};
            }
            Object[] buffer = new Object[]{"log", repositoryPaths, SVNRepositoryImpl.getRevisionObject(startRevision), SVNRepositoryImpl.getRevisionObject(endRevision), changedPaths, strictNode, limit > 0L ? new Long(limit) : null};
            this.write("(w((*s)(n)(n)wwn))", buffer);
            this.authenticate();
            try {
                while (true) {
                    this.read("((", buffer, false);
                    HashMap<String, SVNLogEntryPath> changedPathsMap = null;
                    if (changedPaths) {
                        changedPathsMap = handler != null ? new HashMap<String, SVNLogEntryPath>() : null;
                        try {
                            while (true) {
                                String path;
                                this.read("(SW(?S?N))", buffer, false);
                                if (changedPathsMap == null || (path = SVNReader.getString(buffer, 0)) == null || "".equals(path.trim())) continue;
                                String type = SVNReader.getString(buffer, 1);
                                String copyPath = SVNReader.getString(buffer, 2);
                                long copyRev = SVNReader.getLong(buffer, 3);
                                changedPathsMap.put(path, new SVNLogEntryPath(path, type.charAt(0), copyPath, copyRev));
                            }
                        }
                        catch (SVNException e) {
                            // empty catch block
                        }
                    }
                    this.read(")N(?S)(?S)(?S))", buffer, false);
                    if (handler == null || limit > 0L && ++count > limit) continue;
                    long revision = SVNReader.getLong(buffer, 0);
                    String author = SVNReader.getString(buffer, 1);
                    Date date = SVNReader.getDate(buffer, 2);
                    if (date == SVNTimeUtil.NULL) {
                        date = null;
                    }
                    String message = SVNReader.getString(buffer, 3);
                    handler.handleLogEntry(new SVNLogEntry(changedPathsMap, revision, author, date, message));
                }
            }
            catch (SVNException e) {
                if (e instanceof SVNCancelException || e instanceof SVNAuthenticationException) {
                    throw e;
                }
                this.read("x", buffer, true);
                if (limit <= 0L || limit > 0L && count <= limit) {
                    this.read("[()]", buffer, true);
                }
                long l = count;
                return l;
            }
        }
        catch (SVNException e) {
            this.closeSession();
            throw e;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replay(long lowRevision, long highRevision, boolean sendDeltas, ISVNEditor editor) throws SVNException {
        Object[] buffer = new Object[]{"replay", SVNRepositoryImpl.getRevisionObject(highRevision), SVNRepositoryImpl.getRevisionObject(lowRevision), sendDeltas};
        try {
            this.openConnection();
            this.write("(w(nnw))", buffer);
            this.authenticate();
            this.read("*E", new Object[]{editor}, true);
            this.read("[()]", null, true);
        }
        catch (SVNException e) {
            this.closeSession();
            this.handleUnsupportedCommand(e, "Server doesn't support the replay command");
        }
        finally {
            this.closeConnection();
        }
    }

    public void update(long revision, String target, boolean recursive, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        target = target == null ? "" : target;
        Object[] buffer = new Object[]{"update", SVNRepositoryImpl.getRevisionObject(revision), target, recursive};
        try {
            this.openConnection();
            this.write("(w((n)sw))", buffer);
            this.authenticate();
            reporter.report(this);
            this.authenticate();
            this.read("*E", new Object[]{editor}, true);
            this.write("(w())", new Object[]{"success"});
            this.read("[()]", null, true);
        }
        catch (SVNException e) {
            this.closeSession();
            throw e;
        }
        finally {
            this.closeConnection();
        }
    }

    public void update(SVNURL url, long revision, String target, boolean recursive, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        String string = target = target == null ? "" : target;
        if (url == null) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.BAD_URL, "URL can not be NULL"));
        }
        Object[] buffer = new Object[]{"switch", SVNRepositoryImpl.getRevisionObject(revision), target, recursive, url.toString()};
        try {
            this.openConnection();
            this.write("(w((n)sws))", buffer);
            this.authenticate();
            reporter.report(this);
            this.authenticate();
            this.read("*E", new Object[]{editor}, true);
            this.write("(w())", new Object[]{"success"});
            this.read("[()]", null, true);
        }
        catch (SVNException e) {
            this.closeSession();
            throw e;
        }
        finally {
            this.closeConnection();
        }
    }

    public void diff(SVNURL url, long revision, String target, boolean ignoreAncestry, boolean recursive, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        this.diff(url, revision, revision, target, ignoreAncestry, recursive, reporter, editor);
    }

    public void diff(SVNURL url, long tRevision, long revision, String target, boolean ignoreAncestry, boolean recursive, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        this.diff(url, revision, revision, target, ignoreAncestry, recursive, true, reporter, editor);
    }

    public void diff(SVNURL url, long tRevision, long revision, String target, boolean ignoreAncestry, boolean recursive, boolean getContents, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        Object[] objectArray;
        String string = target = target == null ? "" : target;
        if (url == null) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.BAD_URL, "URL can not be NULL"));
        }
        if (getContents) {
            Object[] objectArray2 = new Object[6];
            objectArray2[0] = "diff";
            objectArray2[1] = SVNRepositoryImpl.getRevisionObject(tRevision);
            objectArray2[2] = target;
            objectArray2[3] = recursive;
            objectArray2[4] = ignoreAncestry;
            objectArray = objectArray2;
            objectArray2[5] = url.toString();
        } else {
            Object[] objectArray3 = new Object[7];
            objectArray3[0] = "diff";
            objectArray3[1] = SVNRepositoryImpl.getRevisionObject(tRevision);
            objectArray3[2] = target;
            objectArray3[3] = recursive;
            objectArray3[4] = ignoreAncestry;
            objectArray3[5] = url.toString();
            objectArray = objectArray3;
            objectArray3[6] = getContents;
        }
        Object[] buffer = objectArray;
        try {
            this.openConnection();
            this.write(getContents ? "(w((n)swws))" : "(w((n)swwsw))", buffer);
            this.authenticate();
            reporter.report(this);
            this.authenticate();
            this.read("*E", new Object[]{editor}, true);
            this.write("(w())", new Object[]{"success"});
            this.read("[()]", null, true);
        }
        catch (SVNException e) {
            this.closeSession();
            throw e;
        }
        finally {
            this.closeConnection();
        }
    }

    public void status(long revision, String target, boolean recursive, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        target = target == null ? "" : target;
        Object[] buffer = new Object[]{"status", target, recursive, SVNRepositoryImpl.getRevisionObject(revision)};
        try {
            this.openConnection();
            this.write("(w(sw(n)))", buffer);
            this.authenticate();
            reporter.report(this);
            this.authenticate();
            this.read("*E", new Object[]{editor}, true);
            this.write("(w())", new Object[]{"success"});
            this.read("[()]", null, true);
        }
        catch (SVNException e) {
            this.closeSession();
            throw e;
        }
        finally {
            this.closeConnection();
        }
    }

    public void setRevisionPropertyValue(long revision, String propertyName, String propertyValue) throws SVNException {
        SVNRepositoryImpl.assertValidRevision(revision);
        Object[] buffer = new Object[]{"change-rev-prop", SVNRepositoryImpl.getRevisionObject(revision), propertyName, propertyValue};
        try {
            this.openConnection();
            this.write("(w(nss))", buffer);
            this.authenticate();
            this.read("[()]", buffer, true);
        }
        catch (SVNException e) {
            this.closeSession();
            throw e;
        }
        finally {
            this.closeConnection();
        }
    }

    public ISVNEditor getCommitEditor(String logMessage, Map locks, boolean keepLocks, ISVNWorkspaceMediator mediator) throws SVNException {
        try {
            this.openConnection();
            if (locks != null) {
                this.write("(w(s(*l)w))", new Object[]{"commit", logMessage, locks, keepLocks});
            } else {
                this.write("(w(s))", new Object[]{"commit", logMessage});
            }
            this.authenticate();
            this.read("[()]", null, true);
            return new SVNCommitEditor(this, this.myConnection, new SVNCommitEditor.ISVNCommitCallback(){

                public void run(SVNException error) {
                    if (error != null) {
                        SVNRepositoryImpl.this.closeSession();
                    }
                    SVNRepositoryImpl.this.closeConnection();
                }
            });
        }
        catch (SVNException e) {
            this.closeSession();
            this.closeConnection();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNLock getLock(String path) throws SVNException {
        try {
            this.openConnection();
            path = this.getRepositoryPath(path);
            Object[] buffer = new Object[]{"get-lock", path};
            this.write("(w(s))", buffer);
            this.authenticate();
            this.read("[((?L))]", buffer, true);
            SVNLock sVNLock = (SVNLock)buffer[0];
            return sVNLock;
        }
        catch (SVNException e) {
            this.closeSession();
            this.handleUnsupportedCommand(e, "Server doesn't support the get-lock command");
        }
        finally {
            this.closeConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNLock[] getLocks(String path) throws SVNException {
        try {
            this.openConnection();
            path = this.getRepositoryPath(path);
            Object[] buffer = new Object[]{"get-locks", path};
            this.write("(w(s))", buffer);
            this.authenticate();
            this.read("[((*L))]", buffer, true);
            Collection lockObjects = (Collection)buffer[0];
            SVNLock[] sVNLockArray = lockObjects == null ? new SVNLock[]{} : lockObjects.toArray(new SVNLock[lockObjects.size()]);
            return sVNLockArray;
        }
        catch (SVNException e) {
            this.closeSession();
            this.handleUnsupportedCommand(e, "Server doesn't support the get-lock command");
        }
        finally {
            this.closeConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Map pathsToRevisions, String comment, boolean force, ISVNLockHandler handler) throws SVNException {
        block13: {
            Iterator paths;
            Object[] buffer;
            try {
                this.openConnection();
                buffer = new Object[]{"lock-many", comment, force};
                this.write("(w((s)w(", buffer);
                buffer = new Object[2];
                paths = pathsToRevisions.keySet().iterator();
                while (paths.hasNext()) {
                    buffer[0] = paths.next();
                    buffer[1] = pathsToRevisions.get(buffer[0]);
                    this.write("(s(n))", buffer);
                }
                this.write(")))", buffer);
                try {
                    this.authenticate();
                }
                catch (SVNException e) {
                    if (e.getErrorMessage() != null && e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_SVN_UNKNOWN_CMD) {
                        this.closeSession();
                        this.closeConnection();
                        this.openConnection();
                        this.lock12(pathsToRevisions, comment, force, handler);
                        this.closeConnection();
                        return;
                    }
                    this.closeSession();
                    throw e;
                }
                paths = pathsToRevisions.keySet().iterator();
            }
            catch (SVNException e) {
                this.closeSession();
                this.handleUnsupportedCommand(e, "Server doesn't support the lock command");
                break block13;
            }
            finally {
                this.closeConnection();
            }
            while (paths.hasNext()) {
                String path = (String)paths.next();
                SVNLock lock = null;
                SVNErrorMessage error = null;
                try {
                    this.read("[L]", buffer, false);
                    lock = (SVNLock)buffer[0];
                    path = lock.getPath();
                }
                catch (SVNException e) {
                    path = this.getRepositoryPath(path);
                    error = e.getErrorMessage();
                }
                if (handler == null) continue;
                handler.handleLock(path, lock, error);
            }
            this.read("x", buffer, true);
            this.read("[()]", buffer, true);
        }
    }

    private void lock12(Map pathsToRevisions, String comment, boolean force, ISVNLockHandler handler) throws SVNException {
        Iterator paths = pathsToRevisions.keySet().iterator();
        while (paths.hasNext()) {
            SVNErrorMessage error;
            Object[] buffer;
            String path;
            block4: {
                path = (String)paths.next();
                Long revision = (Long)pathsToRevisions.get(path);
                path = this.getRepositoryPath(path);
                buffer = new Object[]{"lock", path, comment, force, revision};
                this.write("(w(s(s)w(n)))", buffer);
                this.authenticate();
                error = null;
                try {
                    this.read("[(L)]", buffer, false);
                }
                catch (SVNException e) {
                    SVNErrorCode code;
                    if (e.getErrorMessage() != null && ((code = e.getErrorMessage().getErrorCode()) == SVNErrorCode.FS_PATH_ALREADY_LOCKED || code == SVNErrorCode.FS_OUT_OF_DATE)) {
                        error = e.getErrorMessage();
                    }
                    if (error != null) break block4;
                    throw e;
                }
            }
            if (handler == null) continue;
            SVNLock lock = (SVNLock)buffer[0];
            handler.handleLock(path, lock, error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(Map pathToTokens, boolean force, ISVNLockHandler handler) throws SVNException {
        block13: {
            Iterator paths;
            Object[] buffer;
            try {
                this.openConnection();
                buffer = new Object[]{"unlock-many", force};
                this.write("(w(w(", buffer);
                buffer = new Object[2];
                paths = pathToTokens.keySet().iterator();
                while (paths.hasNext()) {
                    buffer[0] = paths.next();
                    buffer[1] = pathToTokens.get(buffer[0]);
                    this.write("(s(s))", buffer);
                }
                this.write(")))", buffer);
                try {
                    this.authenticate();
                }
                catch (SVNException e) {
                    if (e.getErrorMessage() != null && e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_SVN_UNKNOWN_CMD) {
                        this.closeSession();
                        this.closeConnection();
                        this.openConnection();
                        this.unlock12(pathToTokens, force, handler);
                        this.closeConnection();
                        return;
                    }
                    throw e;
                }
                paths = pathToTokens.keySet().iterator();
            }
            catch (SVNException e) {
                this.closeSession();
                this.handleUnsupportedCommand(e, "Server doesn't support the unlock command");
                break block13;
            }
            finally {
                this.closeConnection();
            }
            while (paths.hasNext()) {
                String path = (String)paths.next();
                String id = (String)pathToTokens.get(path);
                SVNErrorMessage error = null;
                try {
                    this.read("[(S)]", buffer, false);
                    path = (String)buffer[0];
                }
                catch (SVNException e) {
                    error = e.getErrorMessage();
                }
                path = this.getRepositoryPath(path);
                if (handler == null) continue;
                handler.handleUnlock(path, new SVNLock(path, id, null, null, null, null), error);
            }
            this.read("x", buffer, true);
            this.read("[()]", buffer, true);
        }
    }

    private void unlock12(Map pathToTokens, boolean force, ISVNLockHandler handler) throws SVNException {
        Iterator paths = pathToTokens.keySet().iterator();
        while (paths.hasNext()) {
            Object[] buffer;
            String path = (String)paths.next();
            String id = (String)pathToTokens.get(path);
            path = this.getRepositoryPath(path);
            if (id == null) {
                buffer = new Object[]{"get-lock", path};
                this.write("(w(s))", buffer);
                this.authenticate();
                this.read("[((?L))]", buffer, true);
                SVNLock lock = (SVNLock)buffer[0];
                if (lock == null) {
                    lock = new SVNLock(path, "", null, null, null, null);
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_NOT_LOCKED, "No lock on path ''{0}''", path);
                    handler.handleUnlock(path, lock, err);
                    continue;
                }
                id = lock.getID();
            }
            buffer = new Object[]{"unlock", path, id, force};
            this.write("(w(s(s)w))", buffer);
            this.authenticate();
            SVNErrorMessage error = null;
            try {
                this.read("[()]", buffer, true);
            }
            catch (SVNException e) {
                if (e.getErrorMessage() != null && e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_NOT_LOCKED) {
                    error = e.getErrorMessage();
                    error = SVNErrorMessage.create(error.getErrorCode(), error.getMessageTemplate(), path);
                }
                throw e;
            }
            if (handler == null) continue;
            SVNLock lock = new SVNLock(path, id, null, null, null, null);
            handler.handleUnlock(path, lock, error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNDirEntry info(String path, long revision) throws SVNException {
        try {
            this.openConnection();
            String fullPath = this.getFullPath(path);
            SVNURL url = this.getLocation().setPath(fullPath, false);
            path = this.getRepositoryPath(path);
            Object[] buffer = new Object[]{"stat", path, SVNRepositoryImpl.getRevisionObject(revision)};
            this.write("(w(s(n)))", buffer);
            this.authenticate();
            this.read("[((?F))]", buffer, true);
            SVNDirEntry entry = (SVNDirEntry)buffer[0];
            if (entry != null) {
                entry = new SVNDirEntry(url, SVNPathUtil.tail(path), entry.getKind(), entry.getSize(), entry.hasProperties(), entry.getRevision(), entry.getDate(), entry.getAuthor());
            }
            SVNDirEntry sVNDirEntry = entry;
            return sVNDirEntry;
        }
        catch (SVNException e) {
            this.closeSession();
            this.handleUnsupportedCommand(e, "'stat' not implemented");
        }
        finally {
            this.closeConnection();
        }
        return null;
    }

    void updateCredentials(String uuid, SVNURL rootURL) throws SVNException {
        if (this.getRepositoryRoot(false) != null) {
            return;
        }
        this.setRepositoryCredentials(uuid, rootURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openConnection() throws SVNException {
        this.lock();
        this.fireConnectionOpened();
        if (this.myConnection != null && this.myConnection.isConnectionStale()) {
            this.closeSession();
        }
        if (this.myConnection != null) {
            if (this.reparent(this.getLocation())) {
                return;
            }
            this.closeSession();
        }
        ISVNConnector connector = SVNRepositoryFactoryImpl.getConnectorFactory().createConnector(this);
        this.myConnection = new SVNConnection(connector, this);
        try {
            this.myConnection.open(this);
            this.authenticate();
            Object var3_2 = null;
            if (this.myConnection != null) {
                this.myRealm = this.myConnection.getRealm();
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this.myConnection != null) {
                this.myRealm = this.myConnection.getRealm();
            }
            throw throwable;
        }
    }

    protected void closeConnection() {
        if (!this.getOptions().keepConnection(this)) {
            this.closeSession();
        }
        this.unlock();
        this.fireConnectionClosed();
    }

    public String getRealm() {
        return this.myRealm;
    }

    void authenticate() throws SVNException {
        if (this.myConnection != null) {
            this.myConnection.authenticate(this);
        }
    }

    private void write(String template, Object[] values) throws SVNException {
        if (this.myConnection == null) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_CONNECTION_CLOSED));
        }
        this.myConnection.write(template, values);
    }

    private Object[] read(String template, Object[] values, boolean readMalformedData) throws SVNException {
        if (this.myConnection == null) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_CONNECTION_CLOSED));
        }
        return this.myConnection.read(template, values, readMalformedData);
    }

    public void setPath(String path, String lockToken, long revision, boolean startEmpty) throws SVNException {
        SVNRepositoryImpl.assertValidRevision(revision);
        if (lockToken == null) {
            this.write("(w(snw))", new Object[]{"set-path", path, SVNRepositoryImpl.getRevisionObject(revision), startEmpty});
        } else {
            this.write("(w(snw(s)))", new Object[]{"set-path", path, SVNRepositoryImpl.getRevisionObject(revision), startEmpty, lockToken});
        }
    }

    public void deletePath(String path) throws SVNException {
        this.write("(w(s))", new Object[]{"delete-path", path});
    }

    public void linkPath(SVNURL url, String path, String lockToken, long revison, boolean startEmpty) throws SVNException {
        SVNRepositoryImpl.assertValidRevision(revison);
        if (lockToken == null) {
            this.write("(w(ssnw))", new Object[]{"link-path", path, url.toString(), SVNRepositoryImpl.getRevisionObject(revison), startEmpty});
        } else {
            this.write("(w(ssnw(s)))", new Object[]{"link-path", path, url.toString(), SVNRepositoryImpl.getRevisionObject(revison), startEmpty, lockToken});
        }
    }

    public void finishReport() throws SVNException {
        this.write("(w())", new Object[]{"finish-report"});
    }

    public void abortReport() throws SVNException {
        this.write("(w())", new Object[]{"abort-report"});
    }

    private String[] getRepositoryPaths(String[] paths) throws SVNException {
        if (paths == null || paths.length == 0) {
            return paths;
        }
        String[] fullPaths = new String[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            fullPaths[i] = this.getRepositoryPath(paths[i]);
        }
        return fullPaths;
    }

    public void setExternalUserName(String userName) {
        this.myExternalUserName = userName;
    }

    public String getExternalUserName() {
        return this.myExternalUserName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closeSession() {
        this.lock(true);
        try {
            if (this.myConnection == null) return;
            try {
                this.myConnection.close();
                this.myConnection = null;
                return;
            }
            catch (SVNException sVNException) {
                return;
            }
            finally {
                this.myConnection = null;
            }
        }
        finally {
            this.unlock();
        }
    }

    private void handleUnsupportedCommand(SVNException e, String message) throws SVNException {
        if (e.getErrorMessage() != null && e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_SVN_UNKNOWN_CMD) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED, message);
            SVNErrorManager.error(err, e.getErrorMessage());
        }
        throw e;
    }
}

