/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.internal.util.SVNTimeUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.util.SVNDebugLog;

public class SVNLogRunner {
    private boolean myIsEntriesChanged;
    private boolean myIsWCPropertiesChanged;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void runCommand(SVNAdminArea adminArea, String name, Map attributes, int count) throws SVNException {
        SVNErrorMessage err;
        SVNErrorCode code;
        SVNException error;
        block84: {
            String dstName;
            SVNEntry entry;
            File dst;
            File src;
            File file;
            SVNErrorCode code22;
            String fileName;
            block94: {
                block93: {
                    block92: {
                        block91: {
                            block90: {
                                block89: {
                                    block88: {
                                        error = null;
                                        fileName = (String)attributes.get("name");
                                        if ("delete-entry".equals(name)) {
                                            File path = adminArea.getFile(fileName);
                                            SVNAdminArea dir = adminArea.getWCAccess().probeRetrieve(path);
                                            SVNEntry entry2 = dir.getWCAccess().getEntry(path, false);
                                            if (entry2 == null) {
                                                return;
                                            }
                                            try {
                                                if (entry2.isDirectory()) {
                                                    try {
                                                        SVNAdminArea childDir = dir.getWCAccess().retrieve(path);
                                                        if (childDir != null) {
                                                            childDir.removeFromRevisionControl(childDir.getThisDirName(), true, false);
                                                        } else {
                                                            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED));
                                                        }
                                                        break block84;
                                                    }
                                                    catch (SVNException e) {
                                                        if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) {
                                                            if (!entry2.isScheduledForAddition()) {
                                                                adminArea.deleteEntry(fileName);
                                                                adminArea.saveEntries(false);
                                                            }
                                                            break block84;
                                                        }
                                                        throw e;
                                                    }
                                                }
                                                if (entry2.isFile()) {
                                                    adminArea.removeFromRevisionControl(fileName, true, false);
                                                }
                                                break block84;
                                            }
                                            catch (SVNException e) {
                                                if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_LEFT_LOCAL_MOD) {
                                                    error = e;
                                                }
                                                break block84;
                                            }
                                        }
                                        if (!"modify-entry".equals(name)) break block88;
                                        try {
                                            String value;
                                            HashMap<String, String> entryAttrs = new HashMap<String, String>(attributes);
                                            entryAttrs.remove("");
                                            entryAttrs.remove("name");
                                            if (entryAttrs.containsKey(SVNProperty.shortPropertyName("svn:entry:text-time")) && "working".equals(value = (String)entryAttrs.get(SVNProperty.shortPropertyName("svn:entry:text-time")))) {
                                                File file2 = adminArea.getFile(fileName);
                                                value = SVNTimeUtil.formatDate(new Date(file2.lastModified()));
                                                entryAttrs.put(SVNProperty.shortPropertyName("svn:entry:text-time"), value);
                                            }
                                            if (entryAttrs.containsKey(SVNProperty.shortPropertyName("svn:entry:prop-time")) && "working".equals(value = (String)entryAttrs.get(SVNProperty.shortPropertyName("svn:entry:prop-time")))) {
                                                SVNEntry entry3 = adminArea.getEntry(fileName, false);
                                                if (entry3 == null) {
                                                    return;
                                                }
                                                value = adminArea.getPropertyTime(fileName);
                                                entryAttrs.put(SVNProperty.shortPropertyName("svn:entry:prop-time"), value);
                                            }
                                            try {
                                                adminArea.modifyEntry(fileName, entryAttrs, false, false);
                                            }
                                            catch (SVNException svne) {
                                                SVNErrorCode code3 = count <= 1 ? SVNErrorCode.WC_BAD_ADM_LOG_START : SVNErrorCode.WC_BAD_ADM_LOG;
                                                SVNErrorMessage err2 = SVNErrorMessage.create(code3, "Error modifying entry for ''{0}''", fileName);
                                                SVNErrorManager.error(err2, svne);
                                            }
                                            this.setEntriesChanged(true);
                                        }
                                        catch (SVNException svne) {
                                            error = svne;
                                        }
                                        break block84;
                                    }
                                    if (!"modify-wcprop".equals(name)) break block89;
                                    try {
                                        SVNVersionedProperties wcprops = adminArea.getWCProperties(fileName);
                                        if (wcprops != null) {
                                            String propName = (String)attributes.get("propname");
                                            String propValue = (String)attributes.get("propval");
                                            wcprops.setPropertyValue(propName, propValue);
                                            this.setWCPropertiesChanged(true);
                                        }
                                        break block84;
                                    }
                                    catch (SVNException svne) {
                                        error = svne;
                                    }
                                    break block84;
                                }
                                if (!"delete-lock".equals(name)) break block90;
                                try {
                                    SVNEntry entry4 = adminArea.getEntry(fileName, true);
                                    if (entry4 != null) {
                                        entry4.setLockToken(null);
                                        entry4.setLockOwner(null);
                                        entry4.setLockCreationDate(null);
                                        entry4.setLockComment(null);
                                        this.setEntriesChanged(true);
                                    }
                                    break block84;
                                }
                                catch (SVNException svne) {
                                    code22 = count <= 1 ? SVNErrorCode.WC_BAD_ADM_LOG_START : SVNErrorCode.WC_BAD_ADM_LOG;
                                    SVNErrorMessage err3 = SVNErrorMessage.create(code22, "Error removing lock from entry for ''{0}''", fileName);
                                    error = new SVNException(err3, (Throwable)svne);
                                }
                                break block84;
                            }
                            if (!"rm".equals(name)) break block91;
                            file = adminArea.getFile(fileName);
                            SVNFileUtil.deleteFile(file);
                            break block84;
                        }
                        if (!"readonly".equals(name)) break block92;
                        file = adminArea.getFile(fileName);
                        SVNFileUtil.setReadonly(file, true);
                        break block84;
                    }
                    if (!"mv".equals(name)) break block93;
                    src = adminArea.getFile(fileName);
                    dst = adminArea.getFile((String)attributes.get("dest"));
                    try {
                        SVNFileUtil.rename(src, dst);
                    }
                    catch (SVNException svne) {
                        error = new SVNException(svne.getErrorMessage().wrap("Can't move source to dest"), (Throwable)svne);
                    }
                    break block84;
                }
                if (!"append".equals(name)) break block94;
                src = adminArea.getFile(fileName);
                dst = adminArea.getFile((String)attributes.get("dest"));
                OutputStream os = null;
                InputStream is = null;
                try {
                    int r;
                    os = SVNFileUtil.openFileForWriting(dst, true);
                    is = SVNFileUtil.openFileForReading(src);
                    while ((r = is.read()) >= 0) {
                        os.write(r);
                    }
                }
                catch (IOException e) {
                    block85: {
                        if (!src.exists()) break block85;
                        SVNErrorMessage err4 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot write to ''{0}'': {1}", new Object[]{dst, e.getLocalizedMessage()});
                        error = new SVNException(err4, (Throwable)e);
                    }
                    SVNFileUtil.closeFile(os);
                    SVNFileUtil.closeFile(is);
                    break block84;
                }
                catch (SVNException svne) {
                    block86: {
                        if (!src.exists()) break block86;
                        error = svne;
                        {
                            catch (Throwable throwable) {
                                SVNFileUtil.closeFile(os);
                                SVNFileUtil.closeFile(is);
                                throw throwable;
                            }
                        }
                    }
                    SVNFileUtil.closeFile(os);
                    SVNFileUtil.closeFile(is);
                    break block84;
                }
                SVNFileUtil.closeFile(os);
                SVNFileUtil.closeFile(is);
                break block84;
            }
            if ("set-timestamp".equals(name)) {
                file = adminArea.getFile(fileName);
                String timestamp = (String)attributes.get("timestamp");
                try {
                    Date time;
                    if (timestamp == null) {
                        SVNErrorCode code4 = count <= 1 ? SVNErrorCode.WC_BAD_ADM_LOG_START : SVNErrorCode.WC_BAD_ADM_LOG;
                        SVNErrorMessage err5 = SVNErrorMessage.create(code4, "Missing 'timestamp' attribute in ''{0}''", adminArea.getRoot());
                        SVNErrorManager.error(err5);
                    }
                    if (!file.setLastModified((time = SVNTimeUtil.parseDate(timestamp)).getTime()) && !file.canWrite() && file.isFile()) {
                        SVNFileUtil.setReadonly(file, false);
                        file.setLastModified(time.getTime());
                        SVNFileUtil.setReadonly(file, true);
                    }
                }
                catch (SVNException svne) {
                    error = svne;
                }
            } else if ("upgrade-format".equals(name)) {
                String format = (String)attributes.get("format");
                code22 = count <= 1 ? SVNErrorCode.WC_BAD_ADM_LOG_START : SVNErrorCode.WC_BAD_ADM_LOG;
                try {
                    if (format == null) {
                        SVNErrorMessage err6 = SVNErrorMessage.create(code22, "Invalid 'format' attribute");
                        SVNErrorManager.error(err6);
                    }
                    int number = -1;
                    try {
                        number = Integer.parseInt(format);
                    }
                    catch (NumberFormatException e) {
                        SVNErrorMessage err7 = SVNErrorMessage.create(code22, "Invalid 'format' attribute");
                        SVNErrorManager.error(err7, e);
                    }
                    adminArea.postUpgradeFormat(number);
                    this.setEntriesChanged(true);
                }
                catch (SVNException svne) {
                    error = svne;
                }
            } else if ("maybe-readonly".equals(name)) {
                file = adminArea.getFile(fileName);
                try {
                    entry = adminArea.getEntry(fileName, false);
                    if (entry == null) break block84;
                    SVNVersionedProperties props = adminArea.getProperties(fileName);
                    String needsLock = props.getPropertyValue("svn:needs-lock");
                    if (entry.getLockToken() == null && needsLock != null) {
                        SVNFileUtil.setReadonly(file, true);
                    }
                }
                catch (SVNException svne) {
                    error = svne;
                }
            } else if ("cp-and-translate".equals(name)) {
                dstName = (String)attributes.get("dest");
                File src2 = adminArea.getFile(fileName);
                File dst2 = adminArea.getFile(dstName);
                try {
                    SVNEntry entry5;
                    boolean executable;
                    block87: {
                        try {
                            SVNTranslator.translate(adminArea, dstName, fileName, dstName, true);
                        }
                        catch (SVNException svne) {
                            if (!src2.exists()) break block87;
                            throw svne;
                        }
                    }
                    SVNVersionedProperties props = adminArea.getProperties(dstName);
                    boolean bl = SVNFileUtil.isWindows ? false : (executable = props.getPropertyValue("svn:executable") != null);
                    if (executable) {
                        SVNFileUtil.setExecutable(dst2, true);
                    }
                    if ((entry5 = adminArea.getEntry(dstName, false)) != null && entry5.getLockToken() == null && props.getPropertyValue("svn:needs-lock") != null) {
                        SVNFileUtil.setReadonly(dst2, true);
                    }
                }
                catch (SVNException svne) {
                    error = svne;
                }
            } else if ("cp-and-detranslate".equals(name)) {
                dstName = (String)attributes.get("dest");
                try {
                    SVNTranslator.translate(adminArea, fileName, fileName, dstName, false);
                }
                catch (SVNException svne) {
                    error = svne;
                }
            } else if ("cp".equals(name)) {
                src = adminArea.getFile(fileName);
                dst = adminArea.getFile((String)attributes.get("dest"));
                try {
                    SVNFileUtil.copy(src, dst, true, false);
                }
                catch (SVNException svne) {
                    error = svne;
                }
            } else if ("merge".equals(name)) {
                File target = adminArea.getFile(fileName);
                try {
                    String leftLabel;
                    String rightPath;
                    code22 = count <= 1 ? SVNErrorCode.WC_BAD_ADM_LOG_START : SVNErrorCode.WC_BAD_ADM_LOG;
                    String leftPath = (String)attributes.get("arg1");
                    if (leftPath == null) {
                        SVNErrorMessage err8 = SVNErrorMessage.create(code22, "Missing 'left' attribute in ''{0}''", adminArea.getRoot());
                        SVNErrorManager.error(err8);
                    }
                    if ((rightPath = (String)attributes.get("arg2")) == null) {
                        SVNErrorMessage err9 = SVNErrorMessage.create(code22, "Missing 'right' attribute in ''{0}''", adminArea.getRoot());
                        SVNErrorManager.error(err9);
                    }
                    leftLabel = (leftLabel = (String)attributes.get("arg3")) == null ? ".old" : leftLabel;
                    String rightLabel = (String)attributes.get("arg4");
                    rightLabel = rightLabel == null ? ".new" : rightLabel;
                    String targetLabel = (String)attributes.get("arg5");
                    targetLabel = targetLabel == null ? ".working" : targetLabel;
                    SVNVersionedProperties props = adminArea.getProperties(fileName);
                    SVNEntry entry6 = adminArea.getEntry(fileName, true);
                    String leaveConglictsAttr = (String)attributes.get("arg6");
                    boolean leaveConflicts = Boolean.TRUE.toString().equals(leaveConglictsAttr);
                    SVNStatusType mergeResult = adminArea.mergeText(fileName, adminArea.getFile(leftPath), adminArea.getFile(rightPath), targetLabel, leftLabel, rightLabel, leaveConflicts, false);
                    if (props.getPropertyValue("svn:executable") != null) {
                        SVNFileUtil.setExecutable(target, true);
                    }
                    if (props.getPropertyValue("svn:needs-lock") != null && entry6.getLockToken() == null) {
                        SVNFileUtil.setReadonly(target, true);
                    }
                    this.setEntriesChanged(mergeResult == SVNStatusType.CONFLICTED || mergeResult == SVNStatusType.CONFLICTED_UNRESOLVED);
                }
                catch (SVNException svne) {
                    error = svne;
                }
            } else if ("committed".equals(name)) {
                try {
                    SVNErrorCode sVNErrorCode = code = count <= 1 ? SVNErrorCode.WC_BAD_ADM_LOG_START : SVNErrorCode.WC_BAD_ADM_LOG;
                    if (attributes.get("revision") == null) {
                        err = SVNErrorMessage.create(code, "Missing revision attribute for ''{0}''", fileName);
                        SVNErrorManager.error(err);
                    }
                    if ((entry = adminArea.getEntry(fileName, true)) == null || !adminArea.getThisDirName().equals(fileName) && entry.getKind() != SVNNodeKind.FILE) {
                        SVNErrorMessage err10 = SVNErrorMessage.create(code, "Log command for directory ''{0}'' is mislocated", adminArea.getRoot());
                        SVNErrorManager.error(err10);
                    }
                    boolean implicit = attributes.get("implicit") != null && entry.isCopied();
                    this.setEntriesChanged(true);
                    long revisionNumber = Long.parseLong((String)attributes.get("revision"));
                    adminArea.postCommit(fileName, revisionNumber, implicit, code);
                }
                catch (SVNException svne) {
                    error = svne;
                }
            } else {
                code = count <= 1 ? SVNErrorCode.WC_BAD_ADM_LOG_START : SVNErrorCode.WC_BAD_ADM_LOG;
                err = SVNErrorMessage.create(code, "Unrecognized logfile element ''{0}'' in ''{1}''", new Object[]{name, adminArea.getRoot()});
                SVNErrorManager.error(err.wrap("In directory ''{0}''", adminArea.getRoot()));
            }
        }
        if (error != null) {
            code = count <= 1 ? SVNErrorCode.WC_BAD_ADM_LOG_START : SVNErrorCode.WC_BAD_ADM_LOG;
            err = SVNErrorMessage.create(code, "Error processing command ''{0}'' in ''{1}''", new Object[]{name, adminArea.getRoot()});
            SVNErrorManager.error(err, error);
        }
    }

    private void setEntriesChanged(boolean modified) {
        this.myIsEntriesChanged |= modified;
    }

    private void setWCPropertiesChanged(boolean modified) {
        this.myIsWCPropertiesChanged |= modified;
    }

    public void logFailed(SVNAdminArea adminArea) throws SVNException {
        if (this.myIsWCPropertiesChanged) {
            adminArea.saveWCProperties(true);
        } else {
            adminArea.closeWCProperties();
        }
        if (this.myIsEntriesChanged) {
            adminArea.saveEntries(false);
        } else {
            adminArea.closeEntries();
        }
    }

    public void logCompleted(SVNAdminArea adminArea) throws SVNException {
        boolean killMe;
        if (this.myIsWCPropertiesChanged) {
            adminArea.saveWCProperties(true);
        }
        if (this.myIsEntriesChanged) {
            adminArea.saveEntries(false);
        }
        if (killMe = adminArea.isKillMe()) {
            boolean isWCRoot;
            SVNWCAccess access;
            File dir;
            long dirRevision;
            block7: {
                SVNEntry entry = adminArea.getEntry(adminArea.getThisDirName(), false);
                dirRevision = entry != null ? entry.getRevision() : -1L;
                dir = adminArea.getRoot();
                access = adminArea.getWCAccess();
                isWCRoot = access.isWCRoot(adminArea.getRoot());
                try {
                    adminArea.removeFromRevisionControl(adminArea.getThisDirName(), true, false);
                }
                catch (SVNException svne) {
                    SVNDebugLog.getDefaultLog().info(svne);
                    if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LEFT_LOCAL_MOD) break block7;
                    throw svne;
                }
            }
            if (isWCRoot) {
                return;
            }
            SVNAdminArea parentArea = access.retrieve(dir.getParentFile());
            SVNEntry parentEntry = parentArea.getEntry(parentArea.getThisDirName(), false);
            if (dirRevision > parentEntry.getRevision()) {
                SVNEntry entryInParent = parentArea.addEntry(dir.getName());
                entryInParent.setDeleted(true);
                entryInParent.setKind(SVNNodeKind.DIR);
                entryInParent.setRevision(dirRevision);
                parentArea.saveEntries(false);
            }
        }
        this.myIsEntriesChanged = false;
        this.myIsWCPropertiesChanged = false;
    }
}

