/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.util.Date;
import java.util.Map;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SVNStatus {
    private SVNURL myURL;
    private File myFile;
    private SVNNodeKind myKind;
    private SVNRevision myRevision;
    private SVNRevision myCommittedRevision;
    private Date myCommittedDate;
    private String myAuthor;
    private SVNStatusType myContentsStatus;
    private SVNStatusType myPropertiesStatus;
    private SVNStatusType myRemoteContentsStatus;
    private SVNStatusType myRemotePropertiesStatus;
    private boolean myIsLocked;
    private boolean myIsCopied;
    private boolean myIsSwitched;
    private File myConflictNewFile;
    private File myConflictOldFile;
    private File myConflictWrkFile;
    private File myPropRejectFile;
    private String myCopyFromURL;
    private SVNRevision myCopyFromRevision;
    private SVNLock myRemoteLock;
    private SVNLock myLocalLock;
    private Map myEntryProperties;
    private SVNRevision myRemoteRevision;
    private SVNURL myRemoteURL;
    private SVNNodeKind myRemoteKind;
    private String myRemoteAuthor;
    private Date myRemoteDate;
    private Date myLocalContentsDate;
    private Date myLocalPropertiesDate;
    private SVNEntry myEntry;

    public SVNStatus(SVNURL url, File file, SVNNodeKind kind, SVNRevision revision, SVNRevision committedRevision, Date committedDate, String author, SVNStatusType contentsStatus, SVNStatusType propertiesStatus, SVNStatusType remoteContentsStatus, SVNStatusType remotePropertiesStatus, boolean isLocked, boolean isCopied, boolean isSwitched, File conflictNewFile, File conflictOldFile, File conflictWrkFile, File projRejectFile, String copyFromURL, SVNRevision copyFromRevision, SVNLock remoteLock, SVNLock localLock, Map entryProperties) {
        this.myURL = url;
        this.myFile = file;
        this.myKind = kind == null ? SVNNodeKind.NONE : kind;
        this.myRevision = revision == null ? SVNRevision.UNDEFINED : revision;
        this.myCommittedRevision = committedRevision == null ? SVNRevision.UNDEFINED : committedRevision;
        this.myCommittedDate = committedDate;
        this.myAuthor = author;
        this.myContentsStatus = contentsStatus == null ? SVNStatusType.STATUS_NONE : contentsStatus;
        this.myPropertiesStatus = propertiesStatus == null ? SVNStatusType.STATUS_NONE : propertiesStatus;
        this.myRemoteContentsStatus = remoteContentsStatus == null ? SVNStatusType.STATUS_NONE : remoteContentsStatus;
        this.myRemotePropertiesStatus = remotePropertiesStatus == null ? SVNStatusType.STATUS_NONE : remotePropertiesStatus;
        this.myIsLocked = isLocked;
        this.myIsCopied = isCopied;
        this.myIsSwitched = isSwitched;
        this.myConflictNewFile = conflictNewFile;
        this.myConflictOldFile = conflictOldFile;
        this.myConflictWrkFile = conflictWrkFile;
        this.myCopyFromURL = copyFromURL;
        this.myCopyFromRevision = copyFromRevision == null ? SVNRevision.UNDEFINED : copyFromRevision;
        this.myRemoteLock = remoteLock;
        this.myLocalLock = localLock;
        this.myPropRejectFile = projRejectFile;
        this.myEntryProperties = entryProperties;
    }

    public SVNURL getURL() {
        return this.myURL;
    }

    public SVNURL getRemoteURL() {
        return this.myRemoteURL;
    }

    public File getFile() {
        return this.myFile;
    }

    public SVNNodeKind getKind() {
        return this.myKind;
    }

    public SVNRevision getRevision() {
        return this.myRevision;
    }

    public SVNRevision getCommittedRevision() {
        return this.myCommittedRevision;
    }

    public Date getCommittedDate() {
        return this.myCommittedDate;
    }

    public String getAuthor() {
        return this.myAuthor;
    }

    public SVNStatusType getContentsStatus() {
        return this.myContentsStatus;
    }

    public SVNStatusType getPropertiesStatus() {
        return this.myPropertiesStatus;
    }

    public SVNStatusType getRemoteContentsStatus() {
        return this.myRemoteContentsStatus;
    }

    public SVNStatusType getRemotePropertiesStatus() {
        return this.myRemotePropertiesStatus;
    }

    public boolean isLocked() {
        return this.myIsLocked;
    }

    public boolean isCopied() {
        return this.myIsCopied;
    }

    public boolean isSwitched() {
        return this.myIsSwitched;
    }

    public File getConflictNewFile() {
        return this.myConflictNewFile;
    }

    public File getConflictOldFile() {
        return this.myConflictOldFile;
    }

    public File getConflictWrkFile() {
        return this.myConflictWrkFile;
    }

    public File getPropRejectFile() {
        return this.myPropRejectFile;
    }

    public String getCopyFromURL() {
        return this.myCopyFromURL;
    }

    public SVNRevision getCopyFromRevision() {
        return this.myCopyFromRevision;
    }

    public SVNLock getRemoteLock() {
        return this.myRemoteLock;
    }

    public SVNLock getLocalLock() {
        return this.myLocalLock;
    }

    public Map getEntryProperties() {
        return this.myEntryProperties;
    }

    public SVNRevision getRemoteRevision() {
        return this.myRemoteRevision;
    }

    public SVNNodeKind getRemoteKind() {
        return this.myRemoteKind;
    }

    public Date getRemoteDate() {
        return this.myRemoteDate;
    }

    public String getRemoteAuthor() {
        return this.myRemoteAuthor;
    }

    public Date getWorkingContentsDate() {
        if (this.myLocalContentsDate == null) {
            this.myLocalContentsDate = this.getFile() != null && this.getKind() == SVNNodeKind.FILE ? new Date(this.getFile().lastModified()) : new Date(0L);
        }
        return this.myLocalContentsDate;
    }

    public Date getWorkingPropertiesDate() {
        if (this.myLocalPropertiesDate == null) {
            File propFile = null;
            if (this.getFile() != null && this.getKind() == SVNNodeKind.DIR) {
                propFile = new File(this.getFile().getAbsoluteFile().getParentFile(), SVNFileUtil.getAdminDirectoryName());
                propFile = new File(propFile, "dir-props");
            } else if (this.getFile() != null && this.getKind() == SVNNodeKind.FILE) {
                propFile = new File(this.getFile().getAbsoluteFile().getParentFile(), SVNFileUtil.getAdminDirectoryName());
                propFile = new File(propFile, "props/" + this.getFile().getName() + ".svn-work");
            }
            this.myLocalPropertiesDate = propFile != null ? new Date(propFile.lastModified()) : new Date(0L);
        }
        return this.myLocalPropertiesDate;
    }

    public void markExternal() {
        this.myContentsStatus = SVNStatusType.STATUS_EXTERNAL;
    }

    public void setRemoteStatus(SVNStatusType contents, SVNStatusType props, SVNLock lock, SVNNodeKind kind) {
        if (contents == SVNStatusType.STATUS_ADDED && this.myRemoteContentsStatus == SVNStatusType.STATUS_DELETED) {
            contents = SVNStatusType.STATUS_REPLACED;
        }
        this.myRemoteContentsStatus = contents != null ? contents : this.myRemoteContentsStatus;
        SVNStatusType sVNStatusType = this.myRemotePropertiesStatus = props != null ? props : this.myRemotePropertiesStatus;
        if (lock != null) {
            this.myRemoteLock = lock;
        }
        if (kind != null) {
            this.myRemoteKind = kind;
        }
    }

    public void setRemoteStatus(SVNURL url, SVNStatusType contents, SVNStatusType props, SVNLock lock, SVNNodeKind kind, SVNRevision revision, Date date, String author) {
        this.setRemoteStatus(contents, props, lock, kind);
        this.myRemoteURL = url;
        this.myRemoteRevision = revision == null ? SVNRevision.UNDEFINED : revision;
        this.myRemoteDate = date;
        this.myRemoteAuthor = author;
        this.myRemoteKind = kind;
    }

    public void setContentsStatus(SVNStatusType statusType) {
        this.myContentsStatus = statusType;
    }

    public void setEntry(SVNEntry entry) {
        this.myEntry = entry;
    }

    public SVNEntry getEntry() {
        return this.myEntry;
    }
}

