/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.javahl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.InputInterface;
import org.tigris.subversion.javahl.JavaHLObjectFactory;
import org.tigris.subversion.javahl.Lock;
import org.tigris.subversion.javahl.OutputInterface;
import org.tigris.subversion.javahl.Revision;
import org.tigris.subversion.javahl.Version;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.fs.FSRepository;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.javahl.SVNClientImpl;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.core.wc.admin.SVNAdminClient;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEvent;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEventAction;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEventAdapter;
import org.tmatesoft.svn.core.wc.admin.SVNUUIDAction;

public class SVNAdmin {
    protected long cppAddr;
    private SVNClientImpl myDelegate = SVNClientImpl.newInstance();
    private SVNAdminClient mySVNAdminClient;
    public static final String BDB = "bdb";
    public static final String FSFS = "fsfs";

    public void dispose() {
        this.myDelegate.dispose();
        this.mySVNAdminClient = null;
    }

    public Version getVersion() {
        return this.myDelegate.getVersion();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void create(String path, boolean disableFsyncCommit, boolean keepLog, String configPath, String fstype) throws ClientException {
        if (BDB.equalsIgnoreCase(fstype)) {
            this.notImplementedYet("Only fsfs type of repositories are supported by " + this.getVersion().toString());
        }
        try {
            SVNRepositoryFactory.createLocalRepository((File)new File(path), (boolean)false, (boolean)false);
            if (configPath == null) return;
        }
        catch (SVNException e) {
            JavaHLObjectFactory.throwException(e, this.myDelegate);
        }
    }

    public void deltify(String path, Revision start, Revision end) throws ClientException {
        this.notImplementedYet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(String path, OutputInterface dataOut, final OutputInterface errorOut, Revision start, Revision end, boolean incremental) throws ClientException {
        OutputStream os = SVNAdmin.createOutputStream(dataOut);
        try {
            this.getAdminClient().setEventHandler((ISVNEventHandler)new SVNAdminEventAdapter(){

                public void handleAdminEvent(SVNAdminEvent event, double progress) throws SVNException {
                    if (errorOut != null && event.getAction() == SVNAdminEventAction.REVISION_DUMPED) {
                        try {
                            errorOut.write(event.getMessage().getBytes());
                            errorOut.write(SVNTranslator.NATIVE);
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                }
            });
            this.getAdminClient().doDump(new File(path).getAbsoluteFile(), os, JavaHLObjectFactory.getSVNRevision(start), JavaHLObjectFactory.getSVNRevision(end), incremental, false);
        }
        catch (SVNException e) {
            try {
                if (errorOut != null) {
                    errorOut.write(e.getErrorMessage().getFullMessage().getBytes("UTF-8"));
                    errorOut.write(SVNTranslator.NATIVE);
                }
            }
            catch (IOException e1) {
                // empty catch block
            }
            JavaHLObjectFactory.throwException(e, this.myDelegate);
        }
        finally {
            this.getAdminClient().setEventHandler(null);
        }
    }

    public void hotcopy(String path, String targetPath, boolean cleanLogs) throws ClientException {
        this.notImplementedYet();
    }

    public void listDBLogs(String path, MessageReceiver receiver) throws ClientException {
        this.notImplementedYet("Only fsfs type of repositories are supported by " + this.getVersion().toString());
    }

    public void listUnusedDBLogs(String path, MessageReceiver receiver) throws ClientException {
        this.notImplementedYet("Only fsfs type of repositories are supported by " + this.getVersion().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String path, InputInterface dataInput, final OutputInterface messageOutput, boolean ignoreUUID, boolean forceUUID, String relativePath) throws ClientException {
        InputStream is = SVNAdmin.createInputStream(dataInput);
        try {
            SVNUUIDAction uuidAction = SVNUUIDAction.DEFAULT;
            if (ignoreUUID) {
                uuidAction = SVNUUIDAction.IGNORE_UUID;
            } else if (forceUUID) {
                uuidAction = SVNUUIDAction.FORCE_UUID;
            }
            this.getAdminClient().setEventHandler((ISVNEventHandler)new SVNAdminEventAdapter(){
                private boolean myIsNodeOpened;

                public void handleAdminEvent(SVNAdminEvent event, double progress) throws SVNException {
                    if (messageOutput != null) {
                        try {
                            messageOutput.write(this.getLoadMessage(event).getBytes("UTF-8"));
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                }

                protected String getLoadMessage(SVNAdminEvent event) {
                    StringBuffer message = new StringBuffer();
                    if (event.getAction() != SVNAdminEventAction.REVISION_LOAD && this.myIsNodeOpened) {
                        message.append(" done.");
                        message.append(SVNTranslator.NATIVE);
                        this.myIsNodeOpened = false;
                    }
                    if (event.getAction() == SVNAdminEventAction.REVISION_LOADED) {
                        message.append(SVNTranslator.NATIVE);
                    }
                    message.append(event.getMessage());
                    message.append(SVNTranslator.NATIVE);
                    if (event.getAction() == SVNAdminEventAction.REVISION_LOADED) {
                        message.append(SVNTranslator.NATIVE);
                    }
                    this.myIsNodeOpened = event.getAction() != SVNAdminEventAction.REVISION_LOAD;
                    return message.toString();
                }
            });
            this.getAdminClient().doLoad(new File(path).getAbsoluteFile(), is, false, false, uuidAction, relativePath);
        }
        catch (SVNException e) {
            if (messageOutput != null) {
                try {
                    messageOutput.write(e.getErrorMessage().getFullMessage().getBytes("UTF-8"));
                    messageOutput.write(SVNTranslator.NATIVE);
                }
                catch (IOException e1) {
                    // empty catch block
                }
            }
            JavaHLObjectFactory.throwException(e, this.myDelegate);
        }
        finally {
            this.getAdminClient().setEventHandler(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lstxns(String path, final MessageReceiver receiver) throws ClientException {
        this.getAdminClient().setEventHandler((ISVNEventHandler)new SVNAdminEventAdapter(){

            public void handleAdminEvent(SVNAdminEvent event, double progress) throws SVNException {
                if (receiver != null && event.getTxnName() != null) {
                    receiver.receiveMessageLine(event.getTxnName());
                }
            }
        });
        try {
            this.getAdminClient().doListTransactions(new File(path).getAbsoluteFile());
        }
        catch (SVNException e) {
            JavaHLObjectFactory.throwException(e, this.myDelegate);
        }
        finally {
            this.getAdminClient().setEventHandler(null);
        }
    }

    public long recover(String path) throws ClientException {
        this.notImplementedYet("Only fsfs type of repositories are supported by " + this.getVersion().toString());
        return -1L;
    }

    public void rmtxns(String path, String[] transactions) throws ClientException {
        try {
            this.getAdminClient().doRemoveTransactions(new File(path).getAbsoluteFile(), transactions);
        }
        catch (SVNException e) {
            JavaHLObjectFactory.throwException(e, this.myDelegate);
        }
    }

    public void setLog(String path, Revision rev, String message, boolean bypassHooks) throws ClientException {
        try {
            SVNRepository repository = SVNRepositoryFactory.create((SVNURL)SVNURL.fromFile((File)new File(path).getAbsoluteFile()));
            ((FSRepository)repository).setRevisionPropertyValue(JavaHLObjectFactory.getSVNRevision(rev).getNumber(), "svn:log", message, bypassHooks);
        }
        catch (SVNException e) {
            JavaHLObjectFactory.throwException(e, this.myDelegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verify(String path, final OutputInterface messageOut, Revision start, Revision end) throws ClientException {
        try {
            this.getAdminClient().setEventHandler((ISVNEventHandler)new SVNAdminEventAdapter(){

                public void handleAdminEvent(SVNAdminEvent event, double progress) throws SVNException {
                    if (messageOut != null && event.getAction() == SVNAdminEventAction.REVISION_DUMPED) {
                        try {
                            messageOut.write(event.getMessage().getBytes());
                            messageOut.write(SVNTranslator.NATIVE);
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                }
            });
            this.getAdminClient().doVerify(new File(path).getAbsoluteFile(), JavaHLObjectFactory.getSVNRevision(start), JavaHLObjectFactory.getSVNRevision(end));
        }
        catch (SVNException e) {
            try {
                if (messageOut != null) {
                    messageOut.write(e.getErrorMessage().getFullMessage().getBytes("UTF-8"));
                    messageOut.write(SVNTranslator.NATIVE);
                }
            }
            catch (IOException e1) {
                // empty catch block
            }
            JavaHLObjectFactory.throwException(e, this.myDelegate);
        }
        finally {
            this.getAdminClient().setEventHandler(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lock[] lslocks(String path) throws ClientException {
        final ArrayList locks = new ArrayList();
        this.getAdminClient().setEventHandler((ISVNEventHandler)new SVNAdminEventAdapter(){

            public void handleAdminEvent(SVNAdminEvent event, double progress) throws SVNException {
                if (event.getAction() == SVNAdminEventAction.LOCK_LISTED) {
                    SVNLock svnLock = event.getLock();
                    Lock lock = JavaHLObjectFactory.createLock(svnLock);
                    locks.add(lock);
                }
            }
        });
        try {
            this.getAdminClient().doListLocks(new File(path).getAbsoluteFile());
        }
        catch (SVNException e) {
            JavaHLObjectFactory.throwException(e, this.myDelegate);
        }
        finally {
            this.getAdminClient().setEventHandler(null);
        }
        return locks.toArray(new Lock[locks.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rmlocks(String path, String[] locks) throws ClientException {
        try {
            this.getAdminClient().doRemoveLocks(new File(path).getAbsoluteFile(), locks);
        }
        catch (SVNException e) {
            JavaHLObjectFactory.throwException(e, this.myDelegate);
        }
        finally {
            this.getAdminClient().setEventHandler(null);
        }
    }

    private void notImplementedYet() throws ClientException {
        this.notImplementedYet(null);
    }

    private void notImplementedYet(String message) throws ClientException {
        SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNSUPPORTED_FEATURE, (String)(message == null ? "Requested SVNAdmin functionality is not yet implemented" : message));
        JavaHLObjectFactory.throwException(new SVNException(err), this.myDelegate);
    }

    protected SVNAdminClient getAdminClient() {
        if (this.mySVNAdminClient == null) {
            this.mySVNAdminClient = new SVNAdminClient(SVNWCUtil.createDefaultAuthenticationManager(), SVNWCUtil.createDefaultOptions((boolean)true));
        }
        return this.mySVNAdminClient;
    }

    private static OutputStream createOutputStream(final OutputInterface dataOut) {
        if (dataOut == null) {
            return SVNFileUtil.DUMMY_OUT;
        }
        return new OutputStream(){

            public void write(int b) throws IOException {
                dataOut.write(new byte[]{(byte)(b & 0xFF)});
            }

            public void write(byte[] b) throws IOException {
                dataOut.write(b);
            }

            public void close() throws IOException {
                dataOut.close();
            }

            public void write(byte[] b, int off, int len) throws IOException {
                byte[] copy = new byte[len];
                System.arraycopy(b, off, copy, 0, len);
                dataOut.write(copy);
            }
        };
    }

    private static InputStream createInputStream(final InputInterface dataIn) {
        if (dataIn == null) {
            return SVNFileUtil.DUMMY_IN;
        }
        return new InputStream(){

            public int read() throws IOException {
                byte[] b = new byte[1];
                int r = dataIn.read(b);
                if (r <= 0) {
                    return -1;
                }
                return b[0];
            }

            public void close() throws IOException {
                dataIn.close();
            }

            public int read(byte[] b, int off, int len) throws IOException {
                byte[] copy = new byte[len];
                int realLen = dataIn.read(copy);
                if (realLen <= 0) {
                    return realLen;
                }
                System.arraycopy(copy, 0, b, off, realLen);
                return realLen;
            }

            public int read(byte[] b) throws IOException {
                return dataIn.read(b);
            }
        };
    }

    public static interface MessageReceiver {
        public void receiveMessageLine(String var1);
    }
}

