/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.ISVNFileFetcher;
import org.tmatesoft.svn.core.internal.wc.ISVNUpdateEditor;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNMergeCallback;
import org.tmatesoft.svn.core.internal.wc.SVNMergeCallback15;
import org.tmatesoft.svn.core.internal.wc.SVNMergeDriver;
import org.tmatesoft.svn.core.internal.wc.SVNUpdateEditor;
import org.tmatesoft.svn.core.internal.wc.SVNUpdateEditor15;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNCleanupHandler;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNEntryHandler;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNWCAccess
implements ISVNEventHandler {
    public static final int INFINITE_DEPTH = -1;
    private ISVNEventHandler myEventHandler;
    private ISVNOptions myOptions;
    private Map myAdminAreas;
    private Map myCleanupHandlers;
    private File myAnchor;
    private static boolean ourNeverDescendIntoSymlinks = Boolean.getBoolean("svnkit.symlinks.neverDescend");

    public static SVNWCAccess newInstance(ISVNEventHandler eventHandler) {
        return new SVNWCAccess(eventHandler);
    }

    private SVNWCAccess(ISVNEventHandler handler) {
        this.myEventHandler = handler;
    }

    public void setEventHandler(ISVNEventHandler handler) {
        this.myEventHandler = handler;
    }

    public ISVNEventHandler getEventHandler() {
        return this.myEventHandler;
    }

    public void checkCancelled() throws SVNCancelException {
        if (this.myEventHandler != null) {
            this.myEventHandler.checkCancelled();
        }
    }

    public void handleEvent(SVNEvent event) throws SVNException {
        this.handleEvent(event, -1.0);
    }

    public void registerCleanupHandler(SVNAdminArea area, ISVNCleanupHandler handler) {
        if (area == null || handler == null) {
            return;
        }
        if (this.myCleanupHandlers == null) {
            this.myCleanupHandlers = new SVNHashMap();
        }
        this.myCleanupHandlers.put(area, handler);
    }

    public void handleEvent(SVNEvent event, double progress) throws SVNException {
        if (this.myEventHandler != null) {
            try {
                this.myEventHandler.handleEvent(event, progress);
            }
            catch (SVNException e) {
                throw e;
            }
            catch (Throwable th) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Error while dispatching event: {0}", th.getMessage());
                SVNErrorManager.error(err, th, SVNLogType.WC);
            }
        }
    }

    public void setOptions(ISVNOptions options) {
        this.myOptions = options;
    }

    public ISVNOptions getOptions() {
        if (this.myOptions == null) {
            this.myOptions = new DefaultSVNOptions();
        }
        return this.myOptions;
    }

    public void setAnchor(File anchor) {
        this.myAnchor = anchor;
    }

    public File getAnchor() {
        return this.myAnchor;
    }

    public SVNAdminAreaInfo openAnchor(File path, boolean writeLock, int depth) throws SVNException {
        SVNException parentError;
        SVNAdminArea targetArea;
        SVNAdminArea parentArea;
        String name;
        File parent;
        block37: {
            block36: {
                parent = path.getParentFile();
                if (parent == null || "..".equals(path.getName())) {
                    SVNAdminArea anchor = this.open(path, writeLock, depth);
                    return new SVNAdminAreaInfo(this, anchor, anchor, "");
                }
                name = path.getName();
                parentArea = null;
                targetArea = null;
                parentError = null;
                try {
                    parentArea = this.open(parent, writeLock, false, 0);
                }
                catch (SVNException svne) {
                    if (writeLock && svne.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LOCKED) {
                        try {
                            parentArea = this.open(parent, false, false, 0);
                        }
                        catch (SVNException svne2) {
                            throw svne;
                        }
                        parentError = svne;
                    }
                    if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) break block36;
                    throw svne;
                }
            }
            try {
                targetArea = this.open(path, writeLock, false, depth);
            }
            catch (SVNException svne) {
                if (parentArea != null && svne.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) break block37;
                try {
                    this.close();
                }
                catch (SVNException svne2) {
                    // empty catch block
                }
                throw svne;
            }
        }
        if (parentArea != null && targetArea != null) {
            SVNEntry parentEntry = null;
            SVNEntry targetEntry = null;
            SVNEntry targetInParent = null;
            try {
                targetInParent = parentArea.getEntry(name, false);
                targetEntry = targetArea.getEntry(targetArea.getThisDirName(), false);
                parentEntry = parentArea.getEntry(parentArea.getThisDirName(), false);
            }
            catch (SVNException svne) {
                try {
                    this.close();
                }
                catch (SVNException svne2) {
                    // empty catch block
                }
                throw svne;
            }
            SVNURL parentURL = parentEntry != null ? parentEntry.getSVNURL() : null;
            SVNURL targetURL = targetEntry != null ? targetEntry.getSVNURL() : null;
            String encodedName = SVNEncodingUtil.uriEncode(name);
            if (targetInParent == null || parentURL != null && targetURL != null && (!parentURL.equals(targetURL.removePathTail()) || !encodedName.equals(SVNPathUtil.tail(targetURL.getURIEncodedPath())))) {
                if (this.myAdminAreas != null) {
                    this.myAdminAreas.remove(parent);
                }
                try {
                    this.doClose(parentArea, false);
                }
                catch (SVNException svne) {
                    try {
                        this.close();
                    }
                    catch (SVNException svne2) {
                        // empty catch block
                    }
                    throw svne;
                }
                parentArea = null;
            }
        }
        if (parentArea != null && parentError != null && targetArea != null) {
            if (parentError.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LOCKED) {
                try {
                    this.doClose(parentArea, false);
                }
                catch (SVNException svne) {
                    try {
                        this.close();
                    }
                    catch (SVNException svne2) {
                        // empty catch block
                    }
                    throw svne;
                }
                parentArea = null;
            } else {
                try {
                    this.close();
                }
                catch (SVNException svne) {
                    // empty catch block
                }
                throw parentError;
            }
        }
        if (targetArea == null) {
            SVNEntry targetEntry = null;
            try {
                targetEntry = parentArea.getEntry(name, false);
            }
            catch (SVNException svne) {
                try {
                    this.close();
                }
                catch (SVNException svne2) {
                    // empty catch block
                }
                throw svne;
            }
            if (targetEntry != null && targetEntry.isDirectory() && this.myAdminAreas != null) {
                this.myAdminAreas.put(path, null);
            }
        }
        SVNAdminArea anchor = parentArea != null ? parentArea : targetArea;
        SVNAdminArea target = targetArea != null ? targetArea : parentArea;
        return new SVNAdminAreaInfo(this, anchor, target, parentArea == null ? "" : name);
    }

    public SVNAdminArea open(File path, boolean writeLock, int depth) throws SVNException {
        return this.open(path, writeLock, false, depth);
    }

    public SVNAdminArea open(File path, boolean writeLock, boolean stealLock, int depth) throws SVNException {
        return this.open(path, writeLock, stealLock, true, depth, Level.FINE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNAdminArea open(File path, boolean writeLock, boolean stealLock, boolean upgradeFormat, int depth, Level logLevel) throws SVNException {
        Iterator paths2;
        SVNAdminArea area;
        SVNHashMap tmp = new SVNHashMap();
        try {
            area = this.doOpen(path, writeLock, stealLock, upgradeFormat, depth, tmp, logLevel);
            Object var10_9 = null;
            paths2 = tmp.keySet().iterator();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            Iterator paths2 = tmp.keySet().iterator();
            while (paths2.hasNext()) {
                Object childPath = paths2.next();
                SVNAdminArea childArea = (SVNAdminArea)tmp.get(childPath);
                this.myAdminAreas.put(childPath, childArea);
            }
            throw throwable;
        }
        while (paths2.hasNext()) {
            Object childPath = paths2.next();
            SVNAdminArea childArea = (SVNAdminArea)tmp.get(childPath);
            this.myAdminAreas.put(childPath, childArea);
        }
        return area;
    }

    public SVNAdminArea probeOpen(File path, boolean writeLock, int depth) throws SVNException {
        return this.probeOpen(path, writeLock, depth, Level.FINE);
    }

    public SVNAdminArea probeOpen(File path, boolean writeLock, int depth, Level logLevel) throws SVNException {
        File dir = this.probe(path, logLevel);
        if (dir == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "''{0}'' is not a working copy", path);
            SVNErrorManager.error(err, logLevel, SVNLogType.WC);
        }
        if (!path.equals(dir)) {
            depth = 0;
        }
        SVNAdminArea adminArea = null;
        try {
            adminArea = this.open(dir, writeLock, false, true, depth, logLevel);
        }
        catch (SVNException svne) {
            SVNFileType childKind = SVNFileType.getType(path);
            SVNErrorCode errCode = svne.getErrorMessage().getErrorCode();
            if (!path.equals(dir) && childKind == SVNFileType.DIRECTORY && errCode == SVNErrorCode.WC_NOT_DIRECTORY) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "''{0}'' is not a working copy", path);
                SVNErrorManager.error(err, logLevel, SVNLogType.WC);
            }
            throw svne;
        }
        return adminArea;
    }

    public SVNAdminArea probeTry(File path, boolean writeLock, int depth) throws SVNException {
        SVNAdminArea adminArea;
        block6: {
            adminArea = null;
            try {
                adminArea = this.probeRetrieve(path);
            }
            catch (SVNException svne) {
                if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) {
                    try {
                        adminArea = this.probeOpen(path, writeLock, depth);
                    }
                    catch (SVNException svne2) {
                        if (svne2.getErrorMessage().getErrorCode() != SVNErrorCode.WC_NOT_DIRECTORY) {
                            throw svne2;
                        }
                        break block6;
                    }
                }
                throw svne;
            }
        }
        return adminArea;
    }

    public void close() throws SVNException {
        if (this.myAdminAreas != null) {
            this.doClose(this.myAdminAreas, false);
            this.myAdminAreas.clear();
        }
        this.myCleanupHandlers = null;
    }

    public void closeAdminArea(File path) throws SVNException {
        SVNAdminArea area;
        if (this.myAdminAreas != null && (area = (SVNAdminArea)this.myAdminAreas.get(path)) != null) {
            this.doClose(area, false);
            this.myAdminAreas.remove(path);
        }
    }

    private SVNAdminArea doOpen(File path, boolean writeLock, boolean stealLock, boolean upgradeFormat, int depth, Map tmp, Level logLevel) throws SVNException {
        Map map = tmp = tmp == null ? new SVNHashMap() : tmp;
        if (this.myAdminAreas != null) {
            SVNAdminArea existing = (SVNAdminArea)this.myAdminAreas.get(path);
            if (this.myAdminAreas.containsKey(path) && existing != null) {
                SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "Working copy ''{0}'' locked", path);
                SVNErrorManager.error(error, SVNLogType.WC);
            }
        } else {
            this.myAdminAreas = new SVNHashMap();
        }
        SVNAdminArea area = SVNAdminAreaFactory.open(path, logLevel);
        area.setWCAccess(this);
        if (writeLock) {
            area.lock(stealLock);
            if (upgradeFormat) {
                area = SVNAdminAreaFactory.upgrade(area);
            }
        }
        tmp.put(path, area);
        if (depth != 0) {
            if (depth > 0) {
                --depth;
            }
            Iterator entries = area.entries(false);
            while (entries.hasNext()) {
                try {
                    this.checkCancelled();
                }
                catch (SVNCancelException e) {
                    this.doClose(tmp, false);
                    throw e;
                }
                SVNEntry entry = (SVNEntry)entries.next();
                if (entry.getKind() != SVNNodeKind.DIR || area.getThisDirName().equals(entry.getName()) || entry.getDepth() == SVNDepth.EXCLUDE) continue;
                File childPath = new File(path, entry.getName());
                try {
                    this.doOpen(childPath, writeLock, stealLock, upgradeFormat, depth, tmp, logLevel);
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_NOT_DIRECTORY) {
                        this.doClose(tmp, false);
                        throw e;
                    }
                    tmp.put(childPath, null);
                }
            }
        }
        return area;
    }

    private void doClose(Map adminAreas, boolean preserveLocks) throws SVNException {
        Iterator paths = adminAreas.keySet().iterator();
        while (paths.hasNext()) {
            File path = (File)paths.next();
            SVNAdminArea adminArea = (SVNAdminArea)adminAreas.get(path);
            if (adminArea == null) {
                paths.remove();
                continue;
            }
            this.doClose(adminArea, preserveLocks);
            paths.remove();
        }
    }

    private void doClose(SVNAdminArea adminArea, boolean preserveLocks) throws SVNException {
        ISVNCleanupHandler handler;
        if (adminArea == null) {
            return;
        }
        if (this.myCleanupHandlers != null && (handler = (ISVNCleanupHandler)this.myCleanupHandlers.remove(adminArea)) != null) {
            handler.cleanup(adminArea);
        }
        if (!preserveLocks && adminArea.isLocked()) {
            adminArea.unlock();
        }
    }

    public SVNAdminArea probeRetrieve(File path) throws SVNException {
        File dir = this.probe(path, Level.FINE);
        if (dir == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "''{0}'' is not a working copy", path);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        return this.retrieve(dir);
    }

    public boolean isMissing(File path) {
        if (this.myAdminAreas != null) {
            return this.myAdminAreas.containsKey(path) && this.myAdminAreas.get(path) == null;
        }
        return false;
    }

    public boolean isLocked(File path) throws SVNException {
        File lockFile = new File(path, SVNFileUtil.getAdminDirectoryName());
        if (SVNFileType.getType(lockFile = new File(lockFile, "lock")) == SVNFileType.FILE) {
            return true;
        }
        if (SVNFileType.getType(lockFile) == SVNFileType.NONE) {
            return false;
        }
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_LOCKED, "Lock file ''{0}'' is not a regular file", lockFile);
        SVNErrorManager.error(err, SVNLogType.WC);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean isWCRoot(File path) throws SVNException {
        block21: {
            block22: {
                block19: {
                    block20: {
                        entry = this.getEntry(path, false);
                        parent = path.getParentFile();
                        if (parent == null && entry != null) {
                            return true;
                        }
                        parentArea = this.getAdminArea(parent);
                        tmpAccess = null;
                        access = this;
                        try {
                            if (parentArea != null) ** GOTO lbl38
                            tmpAccess = new SVNWCAccess(null);
                            try {
                                parentArea = tmpAccess.probeOpen(parent, false, 0, Level.FINEST);
                            }
                            catch (SVNException svne) {
                                var8_9 = true;
                                var10_13 = null;
                                if (tmpAccess != null) {
                                    try {
                                        tmpAccess.close();
                                    }
                                    catch (SVNException svne) {
                                        // empty catch block
                                    }
                                }
                                return var8_9;
                            }
                        }
                        catch (Throwable var9_23) {
                            var10_17 = null;
                            if (tmpAccess != null) {
                                try {
                                    tmpAccess.close();
                                }
                                catch (SVNException svne) {
                                    // empty catch block
                                }
                            }
                            throw var9_23;
                        }
                        access = tmpAccess;
lbl38:
                        // 2 sources

                        if ((parentEntry = access.getEntry(parent, false)) != null && parentEntry.isThisDir()) break block19;
                        var8_10 = true;
                        var10_14 = null;
                        if (tmpAccess == null) break block20;
                        try {
                            tmpAccess.close();
                        }
                        catch (SVNException svne) {
                            // empty catch block
                        }
                    }
                    return var8_10;
                }
                if (parentEntry.getURL() == null) {
                    err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no ancestry information", parent);
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
                if ((entry = parentArea.getEntry(path.getName(), false)) != null) break block21;
                var8_12 = true;
                var10_15 = null;
                if (tmpAccess == null) break block22;
                try {
                    tmpAccess.close();
                }
                catch (SVNException svne) {
                    // empty catch block
                }
            }
            return var8_12;
        }
        var10_16 = null;
        ** if (tmpAccess == null) goto lbl-1000
lbl-1000:
        // 1 sources

        {
            try {
                tmpAccess.close();
            }
            catch (SVNException svne) {}
        }
lbl-1000:
        // 2 sources

        {
        }
        return false;
    }

    public SVNTreeConflictDescription getTreeConflict(File path) throws SVNException {
        SVNAdminArea parentArea;
        boolean closeParentArea;
        File parent;
        block8: {
            parent = path.getParentFile();
            if (parent == null) {
                return null;
            }
            closeParentArea = false;
            parentArea = null;
            try {
                parentArea = this.retrieve(parent);
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) {
                    e = null;
                    try {
                        parentArea = this.open(parent, false, 0);
                        closeParentArea = true;
                    }
                    catch (SVNException internal) {
                        if (internal.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) {
                            return null;
                        }
                        e = internal;
                    }
                }
                if (e == null) break block8;
                throw e;
            }
        }
        SVNTreeConflictDescription treeConflict = parentArea.getTreeConflict(path.getName());
        if (closeParentArea) {
            this.closeAdminArea(parent);
        }
        return treeConflict;
    }

    public boolean hasTreeConflict(File path) throws SVNException {
        SVNTreeConflictDescription treeConflict = this.getTreeConflict(path);
        return treeConflict != null;
    }

    public SVNEntry getEntry(File path, boolean showHidden) throws SVNException {
        SVNAdminArea adminArea = this.getAdminArea(path);
        String entryName = null;
        if (adminArea == null) {
            adminArea = this.getAdminArea(path.getParentFile());
            entryName = path.getName();
        } else {
            entryName = adminArea.getThisDirName();
        }
        if (adminArea != null) {
            return adminArea.getEntry(entryName, showHidden);
        }
        return null;
    }

    public SVNEntry getVersionedEntry(File path, boolean showHidden) throws SVNException {
        SVNEntry entry = this.getEntry(path, showHidden);
        if (entry == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", path);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        return entry;
    }

    public void setRepositoryRoot(File path, SVNURL reposRoot) throws SVNException {
        SVNEntry entry = this.getEntry(path, false);
        if (entry == null) {
            return;
        }
        SVNAdminArea adminArea = null;
        String name = null;
        if (entry.isFile()) {
            adminArea = this.getAdminArea(path.getParentFile());
            name = path.getName();
        } else {
            adminArea = this.getAdminArea(path);
            String string = name = adminArea != null ? adminArea.getThisDirName() : null;
        }
        if (adminArea == null) {
            return;
        }
        if (adminArea.tweakEntry(name, null, reposRoot.toString(), -1L, false)) {
            adminArea.saveEntries(false);
        }
    }

    public SVNAdminArea[] getAdminAreas() {
        if (this.myAdminAreas != null) {
            return this.myAdminAreas.values().toArray(new SVNAdminArea[this.myAdminAreas.size()]);
        }
        return new SVNAdminArea[0];
    }

    public SVNAdminArea upgrade(File path) throws SVNException {
        SVNAdminArea area;
        SVNAdminArea upgradedArea = null;
        if (this.myAdminAreas != null && (area = (SVNAdminArea)this.myAdminAreas.get(path)) != null) {
            ISVNCleanupHandler cleanupHandler = null;
            if (this.myCleanupHandlers != null) {
                cleanupHandler = (ISVNCleanupHandler)this.myCleanupHandlers.get(area);
            }
            if ((upgradedArea = SVNAdminAreaFactory.upgrade(area)) != area) {
                this.myAdminAreas.put(path, upgradedArea);
                if (cleanupHandler != null) {
                    this.myCleanupHandlers.remove(area);
                    this.myCleanupHandlers.put(upgradedArea, cleanupHandler);
                }
            }
        }
        return upgradedArea;
    }

    public SVNAdminArea retrieve(File path) throws SVNException {
        SVNAdminArea adminArea = this.getAdminArea(path);
        if (adminArea == null) {
            SVNErrorMessage err;
            SVNEntry subEntry = null;
            try {
                SVNAdminArea dirAdminArea = this.getAdminArea(path.getParentFile());
                if (dirAdminArea != null) {
                    subEntry = dirAdminArea.getEntry(path.getName(), true);
                }
            }
            catch (SVNException svne) {
                subEntry = null;
            }
            SVNFileType type = SVNFileType.getType(path);
            if (subEntry != null) {
                SVNErrorMessage err2;
                if (subEntry.getKind() == SVNNodeKind.DIR && type == SVNFileType.FILE) {
                    err2 = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Expected ''{0}'' to be a directory but found a file", path);
                    SVNErrorManager.error(err2, SVNLogType.WC);
                } else if (subEntry.getKind() == SVNNodeKind.FILE && type == SVNFileType.DIRECTORY) {
                    err2 = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Expected ''{0}'' to be a file but found a directory", path);
                    SVNErrorManager.error(err2, SVNLogType.WC);
                }
            }
            File adminDir = new File(path, SVNFileUtil.getAdminDirectoryName());
            SVNFileType wcType = SVNFileType.getType(adminDir);
            if (type == SVNFileType.NONE) {
                SVNErrorMessage childErr = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "Directory ''{0}'' is missing", path);
                SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Directory ''{0}'' is missing", path);
                err3.setChildErrorMessage(childErr);
                SVNErrorManager.error(err3, SVNLogType.WC);
            } else if (type == SVNFileType.DIRECTORY && wcType == SVNFileType.NONE) {
                err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Directory ''{0}'' containing working copy admin area is missing", adminDir);
                SVNErrorManager.error(err, SVNLogType.WC);
            } else if (type == SVNFileType.DIRECTORY && wcType == SVNFileType.DIRECTORY) {
                err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Unable to lock ''{0}''", path);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Working copy ''{0}'' is not locked", path);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        return adminArea;
    }

    public SVNAdminArea getAdminArea(File path) {
        SVNAdminArea adminArea = null;
        if (this.myAdminAreas != null) {
            adminArea = (SVNAdminArea)this.myAdminAreas.get(path);
        }
        return adminArea;
    }

    public void walkEntries(File path, ISVNEntryHandler handler, boolean showHidden, SVNDepth depth) throws SVNException {
        this.walkEntries(path, handler, showHidden, false, depth);
    }

    public void walkEntries(File path, ISVNEntryHandler handler, boolean showHidden, boolean includeTC, SVNDepth depth) throws SVNException {
        SVNEntry entry;
        if (includeTC) {
            handler = new TCEntryHandler(path, this, handler, depth);
        }
        if ((entry = this.getEntry(path, showHidden)) == null) {
            SVNTreeConflictDescription tc;
            if (includeTC && (tc = this.getTreeConflict(path)) != null) {
                handler.handleEntry(path, null);
                return;
            }
            handler.handleError(path, SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "''{0}'' is not under version control", path));
            return;
        }
        if (entry.isFile()) {
            try {
                handler.handleEntry(path, entry);
            }
            catch (SVNException svne) {
                handler.handleError(path, svne.getErrorMessage());
            }
        } else if (entry.isDirectory()) {
            SVNAdminArea adminArea = entry.getAdminArea();
            try {
                adminArea.walkThisDirectory(handler, includeTC ? true : showHidden, depth);
            }
            catch (SVNException svne) {
                handler.handleError(path, svne.getErrorMessage());
            }
        } else {
            handler.handleError(path, SVNErrorMessage.create(SVNErrorCode.NODE_UNKNOWN_KIND, "''{0}'' has an unrecognized node kind", path));
        }
    }

    private File probe(File path, Level logLevel) throws SVNException {
        boolean eligible;
        int wcFormat = -1;
        SVNFileType type = SVNFileType.getType(path);
        boolean bl = eligible = type == SVNFileType.DIRECTORY;
        if (eligible) {
            wcFormat = SVNAdminAreaFactory.checkWC(path, true, logLevel);
        } else if (type == SVNFileType.SYMLINK && path.isDirectory()) {
            boolean bl2 = eligible = !ourNeverDescendIntoSymlinks && this.isWCRoot(path);
            if (eligible) {
                wcFormat = SVNAdminAreaFactory.checkWC(path, true, logLevel);
            }
        } else {
            wcFormat = 0;
        }
        if (!eligible || wcFormat == 0) {
            if ("..".equals(path.getName()) || ".".equals(path.getName())) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_BAD_PATH, "Path ''{0}'' ends in ''{1}'', which is unsupported for this operation", new Object[]{path, path.getName()});
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            path = path.getParentFile();
        }
        return path;
    }

    public static boolean matchesChangeList(Collection changeLists, SVNEntry entry) {
        return changeLists == null || changeLists.isEmpty() || entry != null && entry.getChangelistName() != null && changeLists.contains(entry.getChangelistName());
    }

    private int getMaxFormatVersion() {
        int maxVersion = -1;
        Iterator iterator = this.myAdminAreas.values().iterator();
        while (iterator.hasNext()) {
            SVNAdminArea adminArea = (SVNAdminArea)iterator.next();
            if (adminArea == null || adminArea.getFormatVersion() <= maxVersion) continue;
            maxVersion = adminArea.getFormatVersion();
        }
        return maxVersion;
    }

    public ISVNUpdateEditor createUpdateEditor(SVNAdminAreaInfo info, String switchURL, boolean allowUnversionedObstructions, boolean depthIsSticky, SVNDepth depth, String[] preservedExtensions, ISVNFileFetcher fileFetcher, boolean lockOnDemand) throws SVNException {
        int maxVersion = this.getMaxFormatVersion();
        if (0 < maxVersion && maxVersion < 10) {
            return SVNUpdateEditor15.createUpdateEditor(info, switchURL, allowUnversionedObstructions, depthIsSticky, depth, preservedExtensions, fileFetcher, lockOnDemand);
        }
        return SVNUpdateEditor.createUpdateEditor(info, switchURL, allowUnversionedObstructions, depthIsSticky, depth, preservedExtensions, fileFetcher, lockOnDemand);
    }

    public SVNMergeCallback createMergeCallback(SVNMergeDriver mergeDriver, SVNAdminArea adminArea, SVNURL url, SVNDiffOptions mergeOptions, Map conflictedPaths, boolean force, boolean dryRun) {
        int maxVersion = this.getMaxFormatVersion();
        if (maxVersion < 10) {
            return new SVNMergeCallback15(adminArea, url, force, dryRun, mergeOptions, conflictedPaths, mergeDriver);
        }
        return new SVNMergeCallback(adminArea, url, force, dryRun, mergeOptions, conflictedPaths, mergeDriver);
    }

    private static class TCEntryHandler
    implements ISVNEntryHandler {
        private ISVNEntryHandler myDelegate;
        private SVNDepth myDepth;
        private File myTargetPath;
        private SVNWCAccess myWCAccess;

        public TCEntryHandler(File target, SVNWCAccess wcAccess, ISVNEntryHandler delegate, SVNDepth depth) {
            this.myDelegate = delegate;
            this.myDepth = depth;
            this.myTargetPath = target;
            this.myWCAccess = wcAccess;
        }

        public void handleEntry(File path, SVNEntry entry) throws SVNException {
            this.myDelegate.handleEntry(path, entry);
            if (!entry.isDirectory() || entry.isHidden()) {
                return;
            }
            boolean checkChildren = false;
            if (this.myDepth == SVNDepth.IMMEDIATES || this.myDepth == SVNDepth.FILES) {
                checkChildren = path.equals(this.myTargetPath);
            } else if (this.myDepth == SVNDepth.INFINITY || this.myDepth == SVNDepth.EXCLUDE || this.myDepth == SVNDepth.UNKNOWN) {
                checkChildren = true;
            } else {
                return;
            }
            if (!checkChildren) {
                return;
            }
            Map tcs = entry.getTreeConflicts();
            Iterator paths = tcs.keySet().iterator();
            while (paths.hasNext()) {
                SVNEntry conflictEntry;
                File p = (File)paths.next();
                SVNTreeConflictDescription tc = (SVNTreeConflictDescription)tcs.get(p);
                if (tc.getNodeKind() == SVNNodeKind.DIR && this.myDepth == SVNDepth.FILES || (conflictEntry = this.myWCAccess.getEntry(p, true)) != null && !conflictEntry.isDeleted()) continue;
                this.myDelegate.handleEntry(p, null);
            }
        }

        public void handleError(File path, SVNErrorMessage error) throws SVNException {
            SVNTreeConflictDescription tc;
            if (error != null && error.getErrorCode() == SVNErrorCode.UNVERSIONED_RESOURCE && (tc = this.myWCAccess.getTreeConflict(path)) != null) {
                this.myDelegate.handleEntry(path, null);
                return;
            }
            this.myDelegate.handleError(path, error);
        }
    }
}

