/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svnadmin;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.tmatesoft.svn.cli.AbstractSVNCommand;
import org.tmatesoft.svn.cli.svnadmin.SVNAdminCommandEnvironment;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNLogType;

public abstract class SVNAdminCommand
extends AbstractSVNCommand {
    protected SVNAdminCommand(String name, String[] aliases) {
        super(name, aliases);
    }

    protected SVNAdminCommandEnvironment getSVNAdminEnvironment() {
        return (SVNAdminCommandEnvironment)this.getEnvironment();
    }

    protected File getLocalRepository() throws SVNException {
        return this.getLocalRepository(0);
    }

    protected File getLocalRepository(int index) throws SVNException {
        SVNPath target;
        List targets = this.getEnvironment().combineTargets(null, false);
        if (targets.isEmpty()) {
            targets.add("");
        }
        if (targets.isEmpty() || index > targets.size() - 1) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"Repository argument required"), (SVNLogType)SVNLogType.CLIENT);
        }
        if ((target = new SVNPath((String)targets.get(index))).isURL()) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)("'" + target.getTarget() + "' is an URL when it should be a path")), (SVNLogType)SVNLogType.CLIENT);
        }
        return target.getFile();
    }

    protected String getResourceBundleName() {
        return "org.tmatesoft.svn.cli.svnadmin.commands";
    }

    protected long getRevisionNumber(SVNRevision rev, long latestRevision, SVNRepository repos) throws SVNException {
        long result = -1L;
        if (rev.getNumber() >= 0L) {
            result = rev.getNumber();
        } else if (rev == SVNRevision.HEAD) {
            result = latestRevision;
        } else if (rev.getDate() != null) {
            result = repos.getDatedRevision(rev.getDate());
        } else if (rev != SVNRevision.UNDEFINED) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"Invalid revision specifier"), (SVNLogType)SVNLogType.CLIENT);
        }
        if (result > latestRevision) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)("Revisions must not be greater than the youngest revision (" + latestRevision + ")")), (SVNLogType)SVNLogType.CLIENT);
        }
        return result;
    }

    public Collection getGlobalOptions() {
        return Collections.EMPTY_LIST;
    }
}

