/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svnadmin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.tmatesoft.svn.cli.svnadmin.SVNAdminCommand;
import org.tmatesoft.svn.cli.svnadmin.SVNAdminOption;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.admin.ISVNAdminEventHandler;
import org.tmatesoft.svn.core.wc.admin.SVNAdminClient;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEvent;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEventAction;

public class SVNAdminRemoveTransactionsCommand
extends SVNAdminCommand
implements ISVNAdminEventHandler {
    public SVNAdminRemoveTransactionsCommand() {
        super("rmtxns", null);
    }

    protected Collection createSupportedOptions() {
        ArrayList<SVNAdminOption> options = new ArrayList<SVNAdminOption>();
        options.add(SVNAdminOption.QUIET);
        return options;
    }

    public void run() throws SVNException {
        SVNAdminClient client = this.getEnvironment().getClientManager().getAdminClient();
        List targets = this.getEnvironment().combineTargets(null, false);
        if (!targets.isEmpty()) {
            targets.remove(0);
        }
        String[] transactions = targets.toArray(new String[targets.size()]);
        client.setEventHandler((ISVNEventHandler)this);
        client.doRemoveTransactions(this.getLocalRepository(), transactions);
    }

    public void handleAdminEvent(SVNAdminEvent event, double progress) throws SVNException {
        if (event != null && event.getAction() == SVNAdminEventAction.TRANSACTION_REMOVED) {
            if (!this.getSVNAdminEnvironment().isQuiet()) {
                String txnName = event.getTxnName();
                this.getEnvironment().getOut().println("Transaction '" + txnName + "' removed.");
            }
        } else if (event.getError() != null) {
            this.getEnvironment().handleError(event.getError());
        }
    }

    public void handleEvent(SVNEvent event, double progress) throws SVNException {
    }

    public void checkCancelled() throws SVNCancelException {
        this.getEnvironment().checkCancelled();
    }
}

