/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svndumpfilter;

import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import org.tmatesoft.svn.cli.svndumpfilter.SVNDumpFilterCommand;
import org.tmatesoft.svn.cli.svndumpfilter.SVNDumpFilterCommandEnvironment;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.admin.ISVNAdminEventHandler;
import org.tmatesoft.svn.core.wc.admin.SVNAdminClient;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEvent;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEventAction;

public class SVNDumpFilterIncludeCommand
extends SVNDumpFilterCommand
implements ISVNAdminEventHandler {
    private boolean myHasPrintedRenumberedRevisionsHeader;
    private boolean myIsPrintFinalEOL;

    public SVNDumpFilterIncludeCommand() {
        super("include", null, 0);
    }

    public void run() throws SVNException {
        SVNDumpFilterCommandEnvironment environment = this.getSVNDumpFilterEnvironment();
        if (!environment.isQuiet()) {
            if (environment.isDropEmptyRevisions()) {
                environment.getErr().println("Including (and dropping empty revisions for) prefixes:");
            } else {
                environment.getErr().println("Including prefixes:");
            }
            Iterator prefixesIter = environment.getPrefixes().iterator();
            while (prefixesIter.hasNext()) {
                String prefix = (String)prefixesIter.next();
                environment.getErr().println("   '" + prefix + "'");
            }
            environment.getErr().println();
        }
        SVNAdminClient client = this.getEnvironment().getClientManager().getAdminClient();
        client.setEventHandler((ISVNEventHandler)this);
        client.doFilter(environment.getIn(), (OutputStream)environment.getOut(), false, environment.isRenumberRevisions(), environment.isDropEmptyRevisions(), environment.isPreserveRevisionProperties(), (Collection)environment.getPrefixes(), environment.isSkipMissingMergeSources());
        if (!environment.isQuiet() && this.myIsPrintFinalEOL) {
            environment.getErr().println();
        }
    }

    public void handleAdminEvent(SVNAdminEvent event, double progress) throws SVNException {
        SVNDumpFilterCommandEnvironment environment = this.getSVNDumpFilterEnvironment();
        if (!environment.isQuiet()) {
            SVNAdminEventAction action = event.getAction();
            if (action == SVNAdminEventAction.DUMP_FILTER_REVISION_COMMITTED || action == SVNAdminEventAction.DUMP_FILTER_REVISION_SKIPPED) {
                environment.getErr().println(event.getMessage());
            } else if (action == SVNAdminEventAction.DUMP_FILTER_TOTAL_REVISIONS_DROPPED) {
                environment.getErr().println();
                environment.getErr().println(event.getMessage());
                environment.getErr().println();
                environment.getErr().println();
            } else if (action == SVNAdminEventAction.DUMP_FILTER_RENUMBERED_REVISION || action == SVNAdminEventAction.DUMP_FILTER_DROPPED_RENUMBERED_REVISION) {
                if (!this.myHasPrintedRenumberedRevisionsHeader) {
                    environment.getErr().println("Revisions renumbered as follows:");
                    this.myHasPrintedRenumberedRevisionsHeader = true;
                }
                environment.getErr().println("   " + event.getMessage());
            } else if (action == SVNAdminEventAction.DUMP_FILTER_TOTAL_NODES_DROPPED) {
                if (this.myHasPrintedRenumberedRevisionsHeader) {
                    environment.getErr().println();
                }
                environment.getErr().println(event.getMessage());
                this.myIsPrintFinalEOL = true;
            } else if (action == SVNAdminEventAction.DUMP_FILTER_DROPPED_NODE) {
                environment.getErr().println("   " + event.getMessage());
            }
        }
    }

    public void handleEvent(SVNEvent event, double progress) throws SVNException {
    }

    public void checkCancelled() throws SVNCancelException {
    }
}

