/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svnsync;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import org.tmatesoft.svn.cli.AbstractSVNCommand;
import org.tmatesoft.svn.cli.SVNCommandUtil;
import org.tmatesoft.svn.cli.svnsync.SVNSyncCommand;
import org.tmatesoft.svn.core.SVNException;

public class SVNSyncHelpCommand
extends SVNSyncCommand {
    private static final String GENERIC_HELP_HEADER = "general usage: {0} SUBCOMMAND DEST_URL  [ARGS & OPTIONS ...]\nType ''{0} help <subcommand>'' for help on a specific subcommand.\nType ''{0} --version'' to see the program version and RA modules.\n\nAvailable subcommands:";
    private static final String VERSION_HELP_FOOTER = "\nThe following repository access (RA) modules are available:\n\n* org.tmatesoft.svn.core.internal.io.dav : Module for accessing a repository via WebDAV protocol.\n  - handles 'http' scheme\n  - handles 'https' scheme\n* org.tmatesoft.svn.core.internal.io.svn: Module for accessing a repository using the svn network protocol.\n  - handles 'svn' scheme\n* org.tmatesoft.svn.core.internal.io.fs: Module for accessing a repository on local disk.\n  - handles 'file' scheme (only FSFS repositories are supported)\n";

    public SVNSyncHelpCommand() {
        super("help", new String[]{"?", "h"}, 2);
    }

    protected Collection createSupportedOptions() {
        return new LinkedList();
    }

    public void run() throws SVNException {
        if (!this.getSVNSyncEnvironment().getArguments().isEmpty()) {
            Iterator commands = this.getSVNSyncEnvironment().getArguments().iterator();
            while (commands.hasNext()) {
                String commandName = (String)commands.next();
                AbstractSVNCommand command = AbstractSVNCommand.getCommand(commandName);
                if (command == null) {
                    this.getSVNSyncEnvironment().getErr().println("\"" + commandName + "\": unknown command.\n");
                    continue;
                }
                String help = SVNCommandUtil.getCommandHelp(command, this.getEnvironment().getProgramName(), true);
                this.getSVNSyncEnvironment().getOut().println(help);
            }
        } else if (this.getSVNSyncEnvironment().isVersion()) {
            String version = SVNCommandUtil.getVersion(this.getEnvironment(), this.getSVNSyncEnvironment().isQuiet());
            this.getEnvironment().getOut().println(version);
            this.getEnvironment().getOut().println(VERSION_HELP_FOOTER);
        } else if (this.getSVNSyncEnvironment().getArguments().isEmpty()) {
            Comparator commandComparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    AbstractSVNCommand c1 = (AbstractSVNCommand)o1;
                    AbstractSVNCommand c2 = (AbstractSVNCommand)o2;
                    if (c1 instanceof SVNSyncCommand && c2 instanceof SVNSyncCommand) {
                        SVNSyncCommand syncCommand1 = (SVNSyncCommand)c1;
                        SVNSyncCommand syncCommand2 = (SVNSyncCommand)c2;
                        if (syncCommand1.getOutputPriority() != syncCommand2.getOutputPriority()) {
                            return syncCommand1.getOutputPriority() < syncCommand2.getOutputPriority() ? -1 : 1;
                        }
                    }
                    return c1.getName().compareTo(c2.getName());
                }
            };
            String help = SVNCommandUtil.getGenericHelp(this.getEnvironment().getProgramName(), GENERIC_HELP_HEADER, null, commandComparator);
            this.getSVNSyncEnvironment().getOut().print(help);
        } else {
            String message = MessageFormat.format("Type ''{0} help'' for usage.", this.getSVNSyncEnvironment().getProgramName());
            this.getSVNSyncEnvironment().getOut().println(message);
        }
    }
}

