/*****************************************************************************
*
* File: SN76489.h
*
* Project: Osmose emulator.
*
* Description: This class will define SN76489 interface.
*
* Author: Vedder Bruno
* Date: 18/11/2004, 18h00
*
* URL: http://bcz.emu-france.com/
*****************************************************************************/
#ifndef SN76489_H
#define SN76489_H
#include <iomanip>
#include <iostream>
#include <SDL/SDL.h>
#include <math.h>

using namespace std;

#define SND_BUFFER_SIZE	4096
#define WHITE_NOISE_FEEDBACK 0xF037   
#define PERIODIC_NOISE_FEEDBACK 0x8000

//#define SN76489_VERBOSE

class SN76489 
{

public:
    
    unsigned char  latch;	 // Latched channel 	  
    unsigned char  lastRegister; // Last written register  
    unsigned char  volume[4];	 // 4 bits volume registers.
    int            volTable[16];
    short  	   l_volume[4];  // Copy of volume registers.
    unsigned short period[4];    // Period length in sample nbr.
    unsigned short count [4];    // Flip/Flop counter. Goes from period[] to 0. 
    unsigned short p_count [4];  // previous count to correct fract part of note.
    float fract [4];  		 // Fractionnal part of count.
    float c_fract[4];		 // Cumulated fractionnal part.
    unsigned short freqDiv[4];   // Frequence divider / 10 bits Tone registers.

    SN76489();				      // Constructor. 
    void writePort(unsigned char value);      // Handle port writing.
    void setWave(unsigned char *s, int size); // Set wave to SDL audio buffer.
    bool update_sound_buffer(short *);        // Add 1 value in audio wave.
    bool bufferFull();			      
    void reset();			      // Reset PSG.
    void  setGain(unsigned short gain);
    
protected:

    bool  whiteNoise;			// WhiteNoise/Periodic mode flag.
    unsigned short LFSR;		// 
    short snd_buffer [SND_BUFFER_SIZE]; // Our sound buffer, not SDL's.
    int   snd_genera_ind;		// sound filling index in our buffer.
    int   snd_played_ind;		// sound index played by SDL.
    unsigned int  total_generated;	// generated samples
    unsigned int  total_played;		// played samples
    int   parity(int v);
    
};
#endif
