/*****************************************************************************
*
* File: Options.cpp
*
* Project: Osmose emulator.
*
* Description: This file contains resets function for Options, and 
* emulator options. It's nothing else than default values.
*
* Author: Vedder Bruno
* Date: 11/01/2005, 18h40
*
* URL: http://bcz.emu-france.com/
*****************************************************************************/
#include "Options.h"

void Options::reset()
{
    // Setup defaut machine options.
    smsVersion = true;		                // Not japanese sms, Export machine.
    codemaster = false;		                // No codemaster mapper.
    ntsc = true;		                // Default NTSC video timing.
    inputType = DEFAULT_PAD;	                // Default PAD instead SPORT PAD.
    acceleration = DEFAULT_ACCELERATION;	// Default Paddle acceleration.
}

void EmulatorOptions::reset()
{
    // Setup defaut emulator options.
    time_limited      = false;
    fullscreen_flag   = false;
    videoFilterType   = 0;
    sound             = true;
    bright_palette    = true;
    default_config    = true;
    display_fps       = false;
    memset(ini_file,0,512);
}
