//---------------------------------------------------------------------------
// Copyright (C) 2000 Dallas Semiconductor Corporation, All Rights Reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY,  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL DALLAS SEMICONDUCTOR BE LIABLE FOR ANY CLAIM, DAMAGES
// OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.
//
// Except as contained in this notice, the name of Dallas Semiconductor
// shall not be used except as stated in the Dallas Semiconductor
// Branding Policy.
//---------------------------------------------------------------------------
//
//  temp.c -   Application to find and read the 1-Wire Net
//             DS1920/DS1820/DS18S20 - temperature measurement.
//
//             This application uses the files from the 'Public Domain'
//             1-Wire Net libraries ('general' and 'userial').
//
//
//  Version: 2.00
//

#include "ownet.h"
#include "ser550.h"

// defines
#define MAXDEVICES         20

// external One Wire functions
extern SMALLINT owAcquire(int, char *);
extern void owRelease(int);
extern SMALLINT owVerify(int, SMALLINT);
extern void owSerialNum (int, uchar *, SMALLINT);
extern int ReadTemperature(int, uchar *, float *);
extern SMALLINT FindDevices(int, uchar FamilySN[][8], SMALLINT, SMALLINT);
extern void msDelay(int);

// local functions
void PrintSerialNum(uchar FamilySN[8]);

// global serial numbers
uchar FamilySN[MAXDEVICES][8];

// variables
int family_code;

// serial init functions for I/O
extern void serial0_init(uchar);
extern void serial1_init(uchar);

//----------------------------------------------------------------------
//  Main Test for DS1920/DS1820 temperature measurement
//
void main(void)
{
   float current_temp;
   int i = 0;
   int j = 0;
   int NumDevices=0;

   //use port number for 1-wire
   uchar portnum = ONEWIRE_P;

   //initialize I/O port
#if STDOUT_P==0
   serial0_init(BAUD9600_TIMER_RELOAD_VALUE);
#else
   serial1_init(BAUD9600_TIMER_RELOAD_VALUE);
#endif

   //----------------------------------------
   // Introduction header
   printf("\r\nTemperature\r\n");

   // attempt to acquire the 1-Wire Net
   if (!owAcquire(portnum,NULL))
   {
      printf("Acquire failed\r\n");
      return;
   }

   // Find the device(s)
   NumDevices = FindDevices(portnum, FamilySN, 0x10, MAXDEVICES);
   if (NumDevices>0)
   {
      // (stops on CTRL-C)
      do
      {
         // read the temperature and print serial number and temperature
         for (i = NumDevices; i; i--)
         {

            PrintSerialNum(FamilySN[i-1]);
            if (ReadTemperature(portnum, FamilySN[i-1],&current_temp))
               printf(" %5.1f \r\n", current_temp);
            else
               printf("  - owVerify: %d\r\n",(int)owVerify(portnum, FALSE));
         }
      }
      while (!key_abort());
   }
   else
      printf("No temperature devices found!\r\n");

   // release the 1-Wire Net
   owRelease(portnum);

   return;
}

// -------------------------------------------------------------------------------
// Read and print the serial number.
//
void PrintSerialNum(uchar FamilySN[8])
{
   int i;

   for (i = 7; i>=0; i--)
      printf("%02X", (int)FamilySN[i]);
}
