//---------------------------------------------------------------------------
// Copyright (C) 2000 Dallas Semiconductor Corporation, All Rights Reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY,  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL DALLAS SEMICONDUCTOR BE LIABLE FOR ANY CLAIM, DAMAGES
// OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.
//
// Except as contained in this notice, the name of Dallas Semiconductor
// shall not be used except as stated in the Dallas Semiconductor
// Branding Policy.
//---------------------------------------------------------------------------
//
//  owsestmx.c - Acquire and release a Session on the 1-Wire Net using TMEX.
//               (Requires TMEX 3.11 or newer)
//
//  Version: 2.01
//
//  History: 1.03 -> 2.00  Changed 'MLan' to 'ow'. Added support for
//                         multiple ports.
//           2.00 -> 2.01  Added support for owError library.
//

#include <stdio.h>
#include <windows.h>
#include "ownet.h"

// external function prototypes
extern long  far pascal TMExtendedStartSession(short, short, void far *);
extern short far pascal TMEndSession(long);
extern short far pascal TMClose(long);
extern short far pascal TMSetup(long);
extern short far pascal TMReadDefaultPort(short far *, short far *);

// local functions defined in owsestmx.c
SMALLINT owAcquire(int,char *);
void     owRelease(int);

short PortNum=1,PortType=2;
long  SessionHandle[MAX_PORTNUM];

//---------------------------------------------------------------------------
// Attempt to acquire a 1-Wire net using a com port and a DS2480 based
// adapter.
//
// 'portnum'    - number 0 to MAX_PORTNUM-1.  This number is provided to
//                indicate the symbolic port number.
// 'port_zstr'  - zero terminated port name.  For this platform
//                use format COMX where X is the port number.
//
// Returns: TRUE - success, COM port opened
//
SMALLINT owAcquire(int portnum, char *port_zstr)
{
   // read the default PortNum and PortType
   TMReadDefaultPort(&PortNum,&PortType);

   // convert the string in port_zstr to be the port number
   PortNum = atoi(port_zstr);

   // open a session
   SessionHandle[portnum] = TMExtendedStartSession(PortNum,PortType,NULL);

   // check the session handle
   if (SessionHandle[portnum] <= 0)
   {
      OWERROR(OWERROR_GET_SYSTEM_RESOURCE_FAILED);
      return FALSE;
   }

   // setup the port
   if (TMSetup(SessionHandle[portnum]) != 1)
   {
      TMClose(SessionHandle[portnum]);
      TMEndSession(SessionHandle[portnum]);
      OWERROR(OWERROR_SYSTEM_RESOURCE_INIT_FAILED);
      return FALSE;
   }

   return TRUE;
}

//---------------------------------------------------------------------------
// Release the previously acquired a 1-Wire net.
//
// 'portnum'    - number 0 to MAX_PORTNUM-1.  This number is provided to
//                indicate the symbolic port number.
//
void owRelease(int portnum)
{
   TMClose(SessionHandle[portnum]);
   TMEndSession(SessionHandle[portnum]);
}

