#!/usr/bin/perl
use strict;

#system("hg fclone http://hg.openjdk.org/jdk7/jdk7 _jdk7");
#system("hg fclone http://hg.openjdk.org/bsd-port/bsd-port _bsd-port");

#system("rm -rf jdk7");
#system("rm -rf bsd-port");
#system("cp -Rp _jdk7 jdk7");
#system("cp -Rp _bsd-port bsd-port");


#system("find jdk7 -type d -name .hg -exec rm -rf '{}' ';'");
#system("find bsd-port -type d -name .hg -exec rm -rf '{}' ';'");

my $PATCH_NAME="jdk7_bsd_changes_20090203";
my %dir_changes;


my $jdk6dir = "jdk6";
my $olddir = "jdk7";
my $newdir = "bsd-port";


if ( -d "$PATCH_NAME.newfiles" ) {
   print "Clearing out previous patch\n";

   system("rm -rf $PATCH_NAME.newfiles 2> /dev/null");
   system("rm -rf $PATCH_NAME.patches 2> /dev/null");
   system("rm -rf $PATCH_NAME.linuxfiles 2> /dev/null");
   system("rm -rf $PATCH_NAME.linuxpatches 2> /dev/null");
   system("rm -rf $PATCH_NAME.linuxmakefiles 2> /dev/null");
   system("rm -rf $PATCH_NAME.makepatches 2> /dev/null");
}
system("mkdir $PATCH_NAME.newfiles 2> /dev/null");
system("mkdir $PATCH_NAME.patches 2> /dev/null");
system("mkdir $PATCH_NAME.linuxfiles 2> /dev/null");
system("mkdir $PATCH_NAME.linuxpatches 2> /dev/null");
system("mkdir $PATCH_NAME.linuxmakefiles 2> /dev/null");
system("mkdir $PATCH_NAME.makepatches 2> /dev/null");


###
# populate dir_changes
###
dir_diff($olddir,$newdir);





my $path;
foreach $path ( @{$dir_changes{'new'}}) {
   system("cd bsd-port && rsync -Ra .$path ../$PATCH_NAME.newfiles/");
}

open (RMFILES, ">$PATCH_NAME.rmfiles.sh");

print RMFILES "#!/bin/sh\n\n";

foreach $path ( @{$dir_changes{'remove'}}) {
   print RMFILES "rm -rf $path\n";
}
close(RMFILES);


foreach $path ( @{$dir_changes{'changed'}}) {
   my $patch_filename = format_filename($path);
   system("diff -u $olddir$path $newdir$path > $PATCH_NAME.patches/$patch_filename.patch");

}

foreach $path ( @{$dir_changes{'copy_and_patch_jdk6_linux'}}) {
   

   my $path_dirname = `dirname $path`;
   chomp $path_dirname;

   my $linux_fullname = $path;
   $linux_fullname =~ s/Bsd/Linux/g;
   $linux_fullname =~ s/bsd/linux/g;

   # handle the one file taken from solaris vs linux
   if ($path =~ /native_threads\/src\/threads_bsd.c/) {
      $linux_fullname =~ s/Bsd/Solaris/g;
      $linux_fullname =~ s/bsd/solaris/g;
   }

   my $patch_filename = format_filename($path);
   (system("mkdir -p ./$PATCH_NAME.linuxfiles/$path_dirname") == 0) || die "can't mkdir ./$PATCH_NAME.linuxfiles/$path_dirname";
   (system("cd jdk6 && cp -Rp .$linux_fullname ../$PATCH_NAME.linuxfiles/$path") == 0) || die "can't copy linux file ($linux_fullname) to bsd";
#   print "(system(\"diff -u $olddir$linux_fullname $newdir$path > $PATCH_NAME.linuxpatches/$patch_filename.patch\") == 0) || die \"can't create linuxpatch for $path from $linux_fullname\"; \n";
   system("diff -u $olddir$linux_fullname $newdir$path > $PATCH_NAME.linuxpatches/$patch_filename.patch");

}

foreach $path ( @{$dir_changes{'bsdmakefiles'}}) {


   my $linux_fullname = $path;
   $linux_fullname =~ s/Bsd/Linux/g;
   $linux_fullname =~ s/bsd/linux/g;

   my $jdk6_path = $path;
   $jdk6_path =~ s/\/make\//\/build\//g;

   my $jdk6_path_dirname = `dirname $jdk6_path`;
   chomp $jdk6_path_dirname;

   my $jdk6_linux_fullname = $jdk6_path;
   $jdk6_linux_fullname =~ s/Bsd/Linux/g;
   $jdk6_linux_fullname =~ s/bsd/linux/g;

   my $patch_filename = format_filename($path);

   if (-f "$jdk6dir/$jdk6_linux_fullname") {
      (system("mkdir -p ./$PATCH_NAME.linuxmakefiles/$jdk6_path_dirname") == 0) || die "can't mkdir ./$PATCH_NAME.linuxfiles/$jdk6_path_dirname";
      (system("cd $jdk6dir && cp -Rp .$jdk6_linux_fullname ../$PATCH_NAME.linuxmakefiles/$jdk6_path") == 0) || die "can't copy linux file ($linux_fullname) to bsd";
#   print "(system(\"diff -u $olddir$linux_fullname $newdir$path > $PATCH_NAME.linuxpatches/$patch_filename.patch\") == 0) || die \"can't create linuxpatch for $path from $linux_fullname\"; \n";
      system("diff -u $olddir$linux_fullname $newdir$path | sed -e 's/\\/make\\//\\/build\\//' -e 's/\\/build\\/defs.make/\\/make\\/defs.make/' -e 's/\\/build\\/scm.make/\\/make\\/scm.make/' -e 's/\\/build\\/jprt.make/\\/make\\/jprt.make/' -e 's/\\/build\\/hotspot_version/\\/make\\/hotspot_version/' -e 's/\\/build\\/openjdk_distro/\\/build\\/hotspot_distro/' > $PATCH_NAME.makepatches/$patch_filename.patch");
   } else {
      print STDERR "$path is specific to jdk7 and doesn't appear in jdk6\n";
   }


}

sub format_filename {
   my $fullname = $_[0];
   $fullname =~ s/\//__/g;
   return $fullname;
}




# post patching cleanup
system("mv ./$PATCH_NAME.linuxmakefiles/__jdk__make__java__nio__mapfile-bsd.patch ./$PATCH_NAME.linuxmakefiles_jdk__make__java__nio__mapfile-bsd.dontpatch");


#system("hg fclone http://hg.openjdk.java.net/jdk6/jdk6 jdk6");
#system("cp -Rp jdk6 bsd-port6");
#system("cd bsd-port6 && patch -p1 < ../jdk7_bsd_changes_20090126.patch");



sub dir_diff($$;$) {
   my ($olddir,$newdir,$dir) = @_;
#   print "Processing: $dir\n";

   opendir(OLDDIR, "$olddir/$dir");
   my @oldfiles = readdir(OLDDIR);
   closedir(OLDDIR);

   opendir(NEWDIR, "$newdir/$dir");
   my @newfiles = readdir(NEWDIR);
   closedir(NEWDIR);

   my %exists_check;
   foreach(@oldfiles) {
      $exists_check{$_} =  $exists_check{$_} | 1;
   }

   foreach(@newfiles) {
      $exists_check{$_} =  $exists_check{$_} | 2;
   }


   my $filename;


   foreach  $filename (keys %exists_check) {
      next if ($filename eq '.' || $filename eq ".." || $filename eq ".hg");

      my $fullname = "$dir/$filename";
      if (-d "$newdir/$fullname") {
         dir_diff($olddir,$newdir,$fullname);
      } else {
         if ($exists_check{$filename} == 3) {
            if ( -s "$olddir/$fullname" ne -s "$newdir/$fullname" && -f "$jdk6dir/$fullname") {
               push(@{$dir_changes{'changed'}},"$fullname");
            }
         } elsif ($exists_check{$filename} == 2) {
            my $linux_fullname = $fullname;
            $linux_fullname =~ s/Bsd/Linux/g;
            $linux_fullname =~ s/bsd/linux/g;

            if ($fullname =~ /hotspot\/make\/bsd/) {
               push(@{ $dir_changes{'bsdmakefiles'}}, $fullname);
            } elsif ( $linux_fullname ne $fullname && -f "$olddir/$linux_fullname" && -f "$jdk6dir/$linux_fullname" ) {
               push(@{$dir_changes{'copy_and_patch_jdk6_linux'}},"$fullname");
            } else {
               push(@{$dir_changes{'new'}},"$fullname");
            }

         } elsif ($exists_check{$filename} == 1) {
            push(@{$dir_changes{'remove'}},"$fullname");
         }

      }

   }

}
