/*
 * Decompiled with CFR 0.152.
 */
package pauker.program;

import java.rmi.server.UID;
import java.util.LinkedList;
import java.util.List;
import pauker.program.CardSide;
import pauker.program.SearchHit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Card {
    private CardSide frontSide;
    private CardSide reverseSide;
    private String id = null;
    private long expirationTime;

    public Card(CardSide frontSide, CardSide reverseSide) {
        this.frontSide = frontSide;
        this.reverseSide = reverseSide;
    }

    public void setFrontSide(CardSide frontSide) {
        this.frontSide = frontSide;
    }

    public CardSide getFrontSide() {
        return this.frontSide;
    }

    public void setReverseSide(CardSide reverseSide) {
        this.reverseSide = reverseSide;
    }

    public CardSide getReverseSide() {
        return this.reverseSide;
    }

    public long getLearnedTimestamp() {
        return this.frontSide.getLearnedTimestamp();
    }

    public String getId() {
        if (this.id == null) {
            this.id = new UID().toString();
        }
        return this.id;
    }

    public void setLearned(boolean learned) {
        this.frontSide.setLearned(learned);
        if (learned) {
            this.frontSide.setLearnedTimestamp(System.currentTimeMillis());
        }
    }

    public void updateLernedTimeStamp() {
        this.frontSide.setLearnedTimestamp(System.currentTimeMillis());
    }

    public boolean isLearned() {
        return this.frontSide.isLearned();
    }

    public void setLongTermBatchNumber(int batchNumber) {
        this.frontSide.setLongTermBatchNumber(batchNumber);
    }

    public int getLongTermBatchNumber() {
        return this.frontSide.getLongTermBatchNumber();
    }

    public void setExpirationTime(long expirationTime) {
        this.expirationTime = expirationTime;
    }

    public long getExpirationTime() {
        if (this.frontSide.isLearned()) {
            return this.frontSide.getLearnedTimestamp() + this.expirationTime;
        }
        return -1L;
    }

    public void expire() {
        long expiredTime = System.currentTimeMillis() - this.expirationTime - 60000L;
        this.frontSide.setLearned(true);
        this.frontSide.setLearnedTimestamp(expiredTime);
    }

    public boolean isRepeatedByTyping() {
        return this.frontSide.isRepeatedByTyping();
    }

    public void setRepeatByTyping(boolean repeatByTyping) {
        this.frontSide.setRepeatByTyping(repeatByTyping);
    }

    public List<SearchHit> search(Element cardSide, String pattern, boolean matchCase) {
        LinkedList<SearchHit> searchHits = new LinkedList<SearchHit>();
        if (cardSide == Element.FRONT_SIDE) {
            searchHits.addAll(this.frontSide.search(this, Element.FRONT_SIDE, pattern, matchCase));
            this.reverseSide.cancelSearch();
        } else if (cardSide == Element.REVERSE_SIDE) {
            this.frontSide.cancelSearch();
            searchHits.addAll(this.reverseSide.search(this, Element.REVERSE_SIDE, pattern, matchCase));
        } else {
            searchHits.addAll(this.frontSide.search(this, Element.FRONT_SIDE, pattern, matchCase));
            searchHits.addAll(this.reverseSide.search(this, Element.REVERSE_SIDE, pattern, matchCase));
        }
        return searchHits;
    }

    public List<SearchHit> getSearchHits() {
        LinkedList<SearchHit> searchHits = new LinkedList<SearchHit>();
        searchHits.addAll(this.frontSide.getSearchHits());
        searchHits.addAll(this.reverseSide.getSearchHits());
        return searchHits;
    }

    public void stopSearching() {
        this.frontSide.cancelSearch();
        this.reverseSide.cancelSearch();
    }

    public void flip() {
        CardSide tmpCardSide = this.frontSide;
        this.frontSide = this.reverseSide;
        this.reverseSide = tmpCardSide;
    }

    public float getAverageFontSize() {
        return (float)(this.frontSide.getFontSize() + this.reverseSide.getFontSize()) / 2.0f;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Element {
        FRONT_SIDE,
        REVERSE_SIDE,
        BOTH_SIDES,
        BATCH_NUMBER,
        LEARNED_DATE,
        EXPIRED_DATE,
        REPEATING_MODE;

    }
}

