/*
 * Decompiled with CFR 0.152.
 */
package pauker.program;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import pauker.program.Batch;
import pauker.program.Card;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongTermBatch
extends Batch {
    private final int batchNumber;
    private Set<Card> expiredCards;
    private static final long ONE_SECOND = 1000L;
    private static final long ONE_MINUTE = 60000L;
    private static final long ONE_HOUR = 3600000L;
    private static final long ONE_DAY = 86400000L;
    private static final long expirationUnit = 86400000L;
    private long expirationTime;

    public LongTermBatch(int batchNumber) {
        super(null);
        this.batchNumber = batchNumber;
        double factor = Math.pow(Math.E, batchNumber);
        this.expirationTime = (long)(8.64E7 * factor);
        this.expiredCards = new HashSet<Card>();
    }

    public int getBatchNumber() {
        return this.batchNumber;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    @Override
    public void addCard(Card card) {
        card.setLongTermBatchNumber(this.batchNumber);
        card.setExpirationTime(this.expirationTime);
        this.cards.add(card);
    }

    @Override
    public void removeCard(Card card) {
        this.expiredCards.remove(card);
        super.removeCard(card);
    }

    @Override
    public Card removeCard(int index) {
        Card card = super.removeCard(index);
        this.expiredCards.remove(card);
        return card;
    }

    public Set<Card> getExpiredCards() {
        return this.expiredCards;
    }

    public int getNumberOfExpiredCards() {
        return this.expiredCards.size();
    }

    public Card getOldestExpiredCard() {
        Iterator<Card> iterator = this.expiredCards.iterator();
        Card oldestCard = iterator.next();
        while (iterator.hasNext()) {
            Card tmpCard = iterator.next();
            if (tmpCard.getExpirationTime() >= oldestCard.getExpirationTime()) continue;
            oldestCard = tmpCard;
        }
        return oldestCard;
    }

    public void refreshExpiration() {
        this.expiredCards.clear();
        long currentTime = System.currentTimeMillis();
        for (Card card : this.cards) {
            long learnedTime = card.getLearnedTimestamp();
            long diff = currentTime - learnedTime;
            if (diff <= this.expirationTime) continue;
            this.expiredCards.add(card);
        }
    }
}

