/*
 * Decompiled with CFR 0.152.
 */
package pauker.program;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import pauker.program.Batch;
import pauker.program.Card;
import pauker.program.CardSide;
import pauker.program.Lesson;
import pauker.program.LongTermBatch;
import pauker.program.SummaryBatch;
import tools.CsvParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pauker {
    public static final String LESSON_FORMAT_V16 = "1.6";
    public static final String LESSON_FORMAT_V17 = "1.7";
    private static LearningPhase learningPhase = LearningPhase.NOTHING;
    public static final int USTM_TIME = 18;
    public static final int STM_TIME = 720;
    private static final String lineSeparator = System.getProperty("line.separator");
    private static final SimpleDateFormat unifiedDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");

    public static LearningPhase getLearningPhase() {
        return learningPhase;
    }

    public static void setLearningPhase(LearningPhase learningPhase) {
        Pauker.learningPhase = learningPhase;
    }

    public static Lesson openLesson(String path, String encoding) throws Exception {
        Lesson lesson = null;
        String lowerCasePath = path.toLowerCase();
        if (lowerCasePath.endsWith(".xml.gz") || lowerCasePath.endsWith(".pau.gz") || lowerCasePath.endsWith(".xml") || lowerCasePath.endsWith(".pau")) {
            try {
                lesson = Pauker.readXMLFile(path);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                lesson = Pauker.readCSVFile(path, encoding);
            }
        } else {
            try {
                lesson = Pauker.readCSVFile(path, encoding);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                lesson = Pauker.readXMLFile(path);
            }
        }
        return lesson;
    }

    public static String lessonToXML(Lesson lesson) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        document.appendChild(document.createComment("This is a lesson file for Pauker (http://pauker.sourceforge.net)"));
        Element lessonElement = document.createElement("Lesson");
        lessonElement.setAttribute("LessonFormat", LESSON_FORMAT_V17);
        document.appendChild(lessonElement);
        Element comment = document.createElement("Description");
        lessonElement.appendChild(comment);
        comment.appendChild(document.createTextNode(lesson.getDescription()));
        Element unlearnedBatchElement = Pauker.addBatch(document, lessonElement);
        Batch unlearnedBatch = lesson.getUnlearnedBatch();
        for (Card card : unlearnedBatch.getCards()) {
            Pauker.addCard(document, unlearnedBatchElement, card);
        }
        Pauker.addBatch(document, lessonElement);
        Pauker.addBatch(document, lessonElement);
        for (LongTermBatch longTermBatch : lesson.getLongTermBatches()) {
            Element batchElement = Pauker.addBatch(document, lessonElement);
            for (Card card : longTermBatch.getCards()) {
                Pauker.addCard(document, batchElement, card);
            }
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        DOMSource source = new DOMSource(document);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(outputStream);
        transformer.transform(source, result);
        return outputStream.toString("UTF-8");
    }

    public static String lessonToCSV(Lesson lesson) {
        StringBuilder csvString = new StringBuilder();
        Pauker.batchToCSV(lesson.getUnlearnedBatch(), csvString);
        for (LongTermBatch longTermBatch : lesson.getLongTermBatches()) {
            Pauker.batchToCSV(longTermBatch, csvString);
        }
        return csvString.toString();
    }

    private static Lesson readXMLFile(String path) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringComments(true);
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        InputStream inputStream = path.endsWith(".gz") ? new GZIPInputStream(new FileInputStream(path)) : new FileInputStream(path);
        Document document = documentBuilder.parse(inputStream);
        NodeList documentNodes = document.getChildNodes();
        Lesson newLesson = new Lesson();
        int length = documentNodes.getLength();
        for (int i = 0; i < length; ++i) {
            Node documentNode = documentNodes.item(i);
            if (documentNode.getNodeType() != 1 || !documentNode.getNodeName().equals("Lesson")) continue;
            NamedNodeMap lessonAttributes = documentNode.getAttributes();
            Node lessonFormatAttribute = lessonAttributes.getNamedItem("LessonFormat");
            if (lessonFormatAttribute != null) {
                boolean ver1_67;
                String ver = lessonFormatAttribute.getNodeValue();
                boolean bl = ver1_67 = ver.equals(LESSON_FORMAT_V16) || ver.equals(LESSON_FORMAT_V17);
                if (ver1_67) {
                    Pauker.parseLessonv1_67(documentNode, newLesson, ver);
                    continue;
                }
                Pauker.parseLessonv0(documentNode, newLesson);
                continue;
            }
            Pauker.parseLessonv0(documentNode, newLesson);
        }
        newLesson.trim();
        return newLesson;
    }

    private static Lesson readCSVFile(String fileName, String encoding) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(fileName);
        InputStreamReader reader = null;
        reader = encoding == null ? new InputStreamReader(fileInputStream) : new InputStreamReader((InputStream)fileInputStream, encoding);
        List<List<String>> csvFile = CsvParser.parseCsvFile(reader);
        Lesson newLesson = new Lesson();
        Batch unlearnedBatch = newLesson.getUnlearnedBatch();
        SummaryBatch summaryBatch = newLesson.getSummaryBatch();
        for (List<String> csvRow : csvFile) {
            CardSide frontSide = Pauker.getCsvCardSide(csvRow, 0);
            CardSide reverseSide = Pauker.getCsvCardSide(csvRow, 1);
            Card card = new Card(frontSide, reverseSide);
            summaryBatch.addCard(card);
            unlearnedBatch.addCard(card);
        }
        return newLesson;
    }

    private static CardSide getCsvCardSide(List<String> csvRow, int index) {
        String string;
        if (csvRow.size() > index && (string = csvRow.get(index)) != null) {
            return new CardSide(string);
        }
        return new CardSide("");
    }

    private static void batchToCSV(Batch batch, StringBuilder stringBuilder) {
        int numberOfCards = batch.getNumberOfCards();
        for (int i = 0; i < numberOfCards; ++i) {
            Card card = batch.getCard(i);
            String frontText = card.getFrontSide().getText();
            Pauker.escapeCSVString(stringBuilder, frontText);
            stringBuilder.append(',');
            String reverseText = card.getReverseSide().getText();
            Pauker.escapeCSVString(stringBuilder, reverseText);
            if (i == numberOfCards - 1) continue;
            stringBuilder.append(lineSeparator);
        }
    }

    private static boolean mustQuote(String string) {
        return string.indexOf(32) != -1 || string.indexOf(34) != -1 || string.indexOf(44) != -1 || string.indexOf(10) != -1;
    }

    private static void escapeCSVString(StringBuilder stringBuilder, String string) {
        boolean mustQuote = Pauker.mustQuote(string);
        if (mustQuote) {
            stringBuilder.append('\"');
        }
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            char currentChar = string.charAt(i);
            if (currentChar == '\"') {
                stringBuilder.append('\"');
                stringBuilder.append('\"');
                continue;
            }
            stringBuilder.append(currentChar);
        }
        if (mustQuote) {
            stringBuilder.append('\"');
        }
    }

    private static void parseLessonv0(Node documentNode, Lesson newLesson) {
        SummaryBatch summaryBatch = newLesson.getSummaryBatch();
        int newLessonBatchIndex = 0;
        NodeList lessonNodes = documentNode.getChildNodes();
        int lessonLength = lessonNodes.getLength();
        for (int i = 0; i < lessonLength; ++i) {
            Node lessonNode = lessonNodes.item(i);
            String lessonNodeName = lessonNode.getNodeName();
            if (lessonNodeName.equals("Description")) {
                String description;
                Node descriptionNode = lessonNode.getFirstChild();
                if (descriptionNode == null || (description = descriptionNode.getNodeValue()) == null) continue;
                newLesson.setDescription(description);
                continue;
            }
            if (!lessonNodeName.equals("Batch")) continue;
            if (newLesson.getNumberOfLongTermBatches() < newLessonBatchIndex - 2) {
                newLesson.addLongTermBatch();
            }
            NodeList batchNodes = lessonNode.getChildNodes();
            int batchLength = batchNodes.getLength();
            for (int j = 0; j < batchLength; ++j) {
                Node batchNode = batchNodes.item(j);
                String batchNodeName = batchNode.getNodeName();
                if (!batchNodeName.equals("Card")) continue;
                CardSide frontSide = new CardSide();
                CardSide reverseSide = new CardSide();
                Card newCard = new Card(frontSide, reverseSide);
                NamedNodeMap attributes = batchNode.getAttributes();
                Node attribute = attributes.getNamedItem("RepeatByTyping");
                if (attribute != null && attribute.getNodeValue().equals("true")) {
                    frontSide.setRepeatByTyping(true);
                }
                if ((attribute = attributes.getNamedItem("Flipped_RepeatByTyping")) != null && attribute.getNodeValue().equals("true")) {
                    reverseSide.setRepeatByTyping(true);
                }
                NodeList cardNodes = batchNode.getChildNodes();
                int cardLength = cardNodes.getLength();
                for (int l = 0; l < cardLength; ++l) {
                    Date learnedTimeStamp;
                    String learnedDate;
                    Node textNode;
                    Node cardNode = cardNodes.item(l);
                    String cardNodeName = cardNode.getNodeName();
                    if (cardNodeName.equals("Learned_Date")) {
                        textNode = cardNode.getFirstChild();
                        if (textNode == null) continue;
                        learnedDate = textNode.getNodeValue();
                        try {
                            learnedTimeStamp = unifiedDateFormat.parse(learnedDate);
                            frontSide.setLearnedTimestamp(learnedTimeStamp.getTime());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    if (cardNodeName.equals("Flipped_Learned_Date")) {
                        textNode = cardNode.getFirstChild();
                        if (textNode == null) continue;
                        learnedDate = textNode.getNodeValue();
                        try {
                            learnedTimeStamp = unifiedDateFormat.parse(learnedDate);
                            reverseSide.setLearnedTimestamp(learnedTimeStamp.getTime());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    if (cardNodeName.equals("FrontSide")) {
                        textNode = cardNode.getFirstChild();
                        if (textNode == null) continue;
                        frontSide.setText(textNode.getNodeValue());
                        continue;
                    }
                    if (cardNodeName.equals("ReverseSide") || cardNodeName.equals("BackSide")) {
                        textNode = cardNode.getFirstChild();
                        if (textNode == null) continue;
                        reverseSide.setText(textNode.getNodeValue());
                        continue;
                    }
                    if (cardNodeName.equals("Flipped_Batch_Number")) {
                        textNode = cardNode.getFirstChild();
                        if (textNode == null) continue;
                        try {
                            reverseSide.setLongTermBatchNumber(Integer.parseInt(textNode.getNodeValue()));
                        }
                        catch (Exception e) {
                            newCard.setLearned(false);
                        }
                        continue;
                    }
                    if (cardNodeName.equals("FrontSideFont")) {
                        Pauker.readFont(frontSide, cardNode);
                        continue;
                    }
                    if (!cardNodeName.equals("ReverseSideFont") && !cardNodeName.equals("BackSideFont")) continue;
                    Pauker.readFont(reverseSide, cardNode);
                }
                Batch batch = null;
                batch = newCard.isLearned() ? newLesson.getLongTermBatch(newLessonBatchIndex - 3) : newLesson.getUnlearnedBatch();
                batch.addCard(newCard);
                ((Batch)summaryBatch).addCard(newCard);
            }
            ++newLessonBatchIndex;
        }
    }

    private static void parseLessonv1_67(Node lessonNode, Lesson newLesson, String version) {
        SummaryBatch summaryBatch = newLesson.getSummaryBatch();
        int newLessonBatchIndex = 0;
        NodeList lessonChildNodes = lessonNode.getChildNodes();
        int lessonLength = lessonChildNodes.getLength();
        for (int i = 0; i < lessonLength; ++i) {
            Node lessonChildNode = lessonChildNodes.item(i);
            String lessonChildNodeName = lessonChildNode.getNodeName();
            if (lessonChildNodeName.equals("Description")) {
                String description;
                Node descriptionNode = lessonChildNode.getFirstChild();
                if (descriptionNode == null || (description = descriptionNode.getNodeValue()) == null) continue;
                newLesson.setDescription(description);
                continue;
            }
            if (!lessonChildNodeName.equals("Batch")) continue;
            if (newLesson.getNumberOfLongTermBatches() < newLessonBatchIndex - 2) {
                newLesson.addLongTermBatch();
            }
            NodeList cardNodes = lessonChildNode.getChildNodes();
            int cardLength = cardNodes.getLength();
            for (int j = 0; j < cardLength; ++j) {
                Node cardNode = cardNodes.item(j);
                String cardNodeName = cardNode.getNodeName();
                if (!cardNodeName.equals("Card")) continue;
                CardSide frontSide = new CardSide();
                CardSide reverseSide = new CardSide();
                Card newCard = new Card(frontSide, reverseSide);
                NodeList cardSideNodes = cardNode.getChildNodes();
                int cardSideLength = cardSideNodes.getLength();
                for (int k = 0; k < cardSideLength; ++k) {
                    Node cardSideNode = cardSideNodes.item(k);
                    String cardSideNodeName = cardSideNode.getNodeName();
                    if (cardSideNodeName.equals("FrontSide")) {
                        Pauker.parseCardSidev1_67(cardSideNode, frontSide, version);
                        continue;
                    }
                    if (!cardSideNodeName.equals("ReverseSide")) continue;
                    Pauker.parseCardSidev1_67(cardSideNode, reverseSide, version);
                }
                if (newCard.isLearned() && newLessonBatchIndex < 3) {
                    newCard.setLearned(false);
                }
                Batch batch = null;
                batch = newCard.isLearned() ? newLesson.getLongTermBatch(newLessonBatchIndex - 3) : newLesson.getUnlearnedBatch();
                batch.addCard(newCard);
                ((Batch)summaryBatch).addCard(newCard);
            }
            ++newLessonBatchIndex;
        }
    }

    private static void parseCardSidev1_67(Node cardSideNode, CardSide cardSide, String version) {
        Node batchAttribute;
        Node learnedTimestampAttribute;
        Node repeatByTypingAttribute;
        NamedNodeMap cardSideAttributes = cardSideNode.getAttributes();
        Node orientationAttribute = cardSideAttributes.getNamedItem("Orientation");
        if (orientationAttribute != null && orientationAttribute.getNodeValue().equals("RTL")) {
            cardSide.setOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        }
        if ((repeatByTypingAttribute = cardSideAttributes.getNamedItem("RepeatByTyping")) != null && repeatByTypingAttribute.getNodeValue().equals("true")) {
            cardSide.setRepeatByTyping(true);
        }
        if ((learnedTimestampAttribute = cardSideAttributes.getNamedItem("LearnedTimestamp")) != null) {
            cardSide.setLearned(true);
            String learnedTimestamp = learnedTimestampAttribute.getNodeValue();
            if (version.equals(LESSON_FORMAT_V16)) {
                try {
                    Date learnedDate = unifiedDateFormat.parse(learnedTimestamp);
                    cardSide.setLearnedTimestamp(learnedDate.getTime());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (version.equals(LESSON_FORMAT_V17)) {
                cardSide.setLearnedTimestamp(Long.parseLong(learnedTimestamp));
            } else {
                throw new IllegalArgumentException("LessonFormat is not supported by this method!");
            }
        }
        if ((batchAttribute = cardSideAttributes.getNamedItem("Batch")) != null) {
            try {
                int batchNumber = Integer.parseInt(batchAttribute.getNodeValue());
                cardSide.setLongTermBatchNumber(batchNumber);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        NodeList cardSideNodes = cardSideNode.getChildNodes();
        int cardSideLegth = cardSideNodes.getLength();
        for (int i = 0; i < cardSideLegth; ++i) {
            Node subNode = cardSideNodes.item(i);
            String subNodeName = subNode.getNodeName();
            if (subNodeName.equals("Text")) {
                Node textNode = subNode.getFirstChild();
                if (textNode == null) continue;
                String text = textNode.getNodeValue();
                cardSide.setText(text);
                continue;
            }
            if (!subNodeName.equals("Font")) continue;
            Pauker.readFont(cardSide, subNode);
        }
    }

    private static void readFont(CardSide cardSide, Node node) {
        String family = null;
        int style = 0;
        int size = 12;
        Color fontColor = null;
        Color backgroundColor = null;
        NamedNodeMap attributes = node.getAttributes();
        Node attribute = attributes.getNamedItem("Family");
        if (attribute != null) {
            int rgbValue;
            family = attribute.getNodeValue();
            attribute = attributes.getNamedItem("Size");
            if (attribute != null) {
                size = Integer.parseInt(attribute.getNodeValue());
            }
            if ((attribute = attributes.getNamedItem("Bold")) != null && attribute.getNodeValue().equals("true")) {
                style = 1;
            }
            if ((attribute = attributes.getNamedItem("Italic")) != null && attribute.getNodeValue().equals("true")) {
                style += 2;
            }
            Font font = new Font(family, style, size);
            attribute = attributes.getNamedItem("Foreground");
            if (attribute != null) {
                rgbValue = Integer.parseInt(attribute.getNodeValue());
                fontColor = new Color(rgbValue);
            }
            if ((attribute = attributes.getNamedItem("Background")) != null) {
                rgbValue = Integer.parseInt(attribute.getNodeValue());
                backgroundColor = new Color(rgbValue);
            }
            cardSide.setFont(font);
            cardSide.setForegroundColor(fontColor);
            cardSide.setBackgroundColor(backgroundColor);
        }
    }

    private static Element addBatch(Document document, Element lesson) {
        Element batch = document.createElement("Batch");
        lesson.appendChild(batch);
        return batch;
    }

    private static void addCard(Document document, Element batch, Card card) {
        Element cardElement = document.createElement("Card");
        batch.appendChild(cardElement);
        Element frontSideElement = document.createElement("FrontSide");
        Pauker.addCardSide(document, frontSideElement, card.getFrontSide(), false);
        cardElement.appendChild(frontSideElement);
        Element reverseSideElement = document.createElement("ReverseSide");
        Pauker.addCardSide(document, reverseSideElement, card.getReverseSide(), true);
        cardElement.appendChild(reverseSideElement);
    }

    private static void addCardSide(Document document, Element cardSideElement, CardSide cardSide, boolean reverseSide) {
        boolean repeatedByTyping;
        Element textElement = document.createElement("Text");
        String cardSideText = cardSide.getText();
        Text text = document.createTextNode(cardSideText);
        textElement.appendChild(text);
        cardSideElement.appendChild(textElement);
        Font font = cardSide.getFont();
        if (font != null) {
            Color backgroundColor;
            Element fontElement = document.createElement("Font");
            fontElement.setAttribute("Family", font.getFamily());
            fontElement.setAttribute("Size", String.valueOf(font.getSize()));
            fontElement.setAttribute("Bold", font.isBold() ? "true" : "false");
            fontElement.setAttribute("Italic", font.isItalic() ? "true" : "false");
            Color foregroundColor = cardSide.getForegroundColor();
            if (foregroundColor != null) {
                fontElement.setAttribute("Foreground", String.valueOf(foregroundColor.getRGB()));
            }
            if ((backgroundColor = cardSide.getBackgroundColor()) != null) {
                fontElement.setAttribute("Background", String.valueOf(backgroundColor.getRGB()));
            }
            cardSideElement.appendChild(fontElement);
        }
        ComponentOrientation componentOrientation = cardSide.getOrientation();
        String orientationString = "RTL";
        if (componentOrientation == null || componentOrientation.isLeftToRight()) {
            orientationString = "LTR";
        }
        cardSideElement.setAttribute("Orientation", orientationString);
        if (cardSide.isLearned()) {
            cardSideElement.setAttribute("LearnedTimestamp", String.valueOf(cardSide.getLearnedTimestamp()));
            if (reverseSide) {
                cardSideElement.setAttribute("Batch", String.valueOf(cardSide.getLongTermBatchNumber()));
            }
        }
        cardSideElement.setAttribute("RepeatByTyping", (repeatedByTyping = cardSide.isRepeatedByTyping()) ? "true" : "false");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LearningPhase {
        NOTHING,
        FILLING_USTM,
        WAITING_FOR_USTM,
        REPEATING_USTM,
        WAITING_FOR_STM,
        REPEATING_STM,
        REPEATING_LTM;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PutbackStrategy {
        ON_TOP,
        AT_BOTTOM,
        ANYWHERE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RepeatingStrategy {
        OLDEST_FIRST,
        NEWEST_FIRST,
        RANDOM_ORDER;

    }
}

