/*
 * Decompiled with CFR 0.152.
 */
package pauker.program.gui.swing;

import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdesktop.layout.GroupLayout;
import pauker.program.gui.swing.PaukerFrame;

public class AboutDialog
extends JDialog {
    private JEditorPane creditsEditorPane;
    private JScrollPane creditsScrollPane;
    private JEditorPane licenseEditorPane;
    private JScrollPane licenseScrollPane;
    private JButton okButton;
    private JPanel okButtonPanel;
    private JTabbedPane tabbedPane;
    private JLabel versionLabel;

    public AboutDialog(Frame parent) {
        super(parent, true);
        this.initComponents();
        ResourceBundle bundle = ResourceBundle.getBundle("pauker/Strings");
        String title = bundle.getString("ProgramTitle");
        String versionString = bundle.getString("Pauker_Version");
        title = MessageFormat.format(title, versionString);
        this.versionLabel.setText(title);
        Class<?> thisClass = this.getClass();
        String aboutFileName = bundle.getString("About_Message_File");
        URL fileURL = thisClass.getResource(aboutFileName);
        try {
            this.creditsEditorPane.setPage(fileURL);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        String licenseFileName = bundle.getString("License_File");
        fileURL = thisClass.getResource(licenseFileName);
        try {
            this.licenseEditorPane.setPage(fileURL);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.setLocationRelativeTo(parent);
    }

    private void initComponents() {
        this.versionLabel = new JLabel();
        this.tabbedPane = new JTabbedPane();
        this.creditsScrollPane = new JScrollPane();
        this.creditsEditorPane = new JEditorPane();
        this.licenseScrollPane = new JScrollPane();
        this.licenseEditorPane = new JEditorPane();
        this.okButtonPanel = new JPanel();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("pauker/Strings");
        this.setTitle(bundle.getString("AboutDialogTitle"));
        this.versionLabel.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/repeat.png")));
        this.versionLabel.setText(bundle.getString("ProgramTitle"));
        this.creditsEditorPane.setContentType("text/html");
        this.creditsEditorPane.setEditable(false);
        this.creditsEditorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent evt) {
                AboutDialog.this.creditsEditorPaneHyperlinkUpdate(evt);
            }
        });
        this.creditsScrollPane.setViewportView(this.creditsEditorPane);
        this.tabbedPane.addTab(bundle.getString("Credits"), this.creditsScrollPane);
        this.licenseEditorPane.setContentType("text/html");
        this.licenseEditorPane.setEditable(false);
        this.licenseEditorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent evt) {
                AboutDialog.this.licenseEditorPaneHyperlinkUpdate(evt);
            }
        });
        this.licenseScrollPane.setViewportView(this.licenseEditorPane);
        this.tabbedPane.addTab(bundle.getString("License"), this.licenseScrollPane);
        this.okButton.setText(bundle.getString("OK"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AboutDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.okButtonPanel.add(this.okButton);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(2).add(1, this.tabbedPane, -1, 510, Short.MAX_VALUE).add(1, this.versionLabel).add(1, this.okButtonPanel, -1, 510, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().addContainerGap().add(this.versionLabel).addPreferredGap(0).add(this.tabbedPane, -1, 440, Short.MAX_VALUE).addPreferredGap(0).add(this.okButtonPanel, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void licenseEditorPaneHyperlinkUpdate(HyperlinkEvent evt) {
        this.openLink(evt);
    }

    private void creditsEditorPaneHyperlinkUpdate(HyperlinkEvent evt) {
        this.openLink(evt);
    }

    private void openLink(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            PaukerFrame.openUrlInBrowser(hyperlinkEvent.getURL().toString());
            final JEditorPane source = (JEditorPane)hyperlinkEvent.getSource();
            Thread guiThread = new Thread(){

                public void run() {
                    source.setEnabled(false);
                    AboutDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        Thread.sleep(4000L);
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                    source.setEnabled(true);
                    AboutDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            };
            guiThread.start();
        }
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.dispose();
        this.setVisible(false);
    }
}

