/*
 * Decompiled with CFR 0.152.
 */
package pauker.program.gui.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.View;
import pauker.program.Card;
import pauker.program.CardSide;
import pauker.program.SearchHit;
import pauker.program.gui.swing.PaukerFrame;

public class BatchListCellRenderer
extends JPanel
implements ListCellRenderer {
    private final Color selectedColor;
    private final Color backgroundColor;
    private final PaukerFrame paukerFrame;
    private static final Icon typingIcon = new ImageIcon(BatchListCellRenderer.class.getResource("/pauker/icons/key_enter.png"));
    private static final Icon brainIcon = new ImageIcon(BatchListCellRenderer.class.getResource("/pauker/icons/smallbrain.png"));
    private static final Highlighter.HighlightPainter yellowPainter = new DefaultHighlighter.DefaultHighlightPainter(Color.yellow);
    private static final Highlighter.HighlightPainter redPainter = new DefaultHighlighter.DefaultHighlightPainter(Color.red);
    private static final String expiredString = PaukerFrame.strings.getString("Expired_At");
    private static final String expiresString = PaukerFrame.strings.getString("Expires_At");
    private static final String learnedString = PaukerFrame.strings.getString("Learned_At");
    private static final String notLearnedString = PaukerFrame.strings.getString("Not_learned");
    private static final DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 3);
    private boolean brainIconSet;
    private boolean wasSelected;
    private boolean lineWrapping;
    private JLabel batchNumberLabel;
    private JTextField batchNumberTextField;
    private JPanel contentsPanel;
    private JTextField expirationTextField;
    private JLabel expiredLabel;
    private JTextArea frontSideTextArea;
    private JPanel infoPanel;
    private JSeparator jSeparator1;
    private JTextField learnedDateTextField;
    private JLabel learnedLabel;
    private JLabel repeatByTypingLabel;
    private JTextArea reverseSideTextArea;

    public BatchListCellRenderer(PaukerFrame paukerFrame, Color selectedColor) {
        this.paukerFrame = paukerFrame;
        this.selectedColor = selectedColor;
        this.backgroundColor = this.getBackground();
        this.initComponents();
        this.brainIconSet = true;
    }

    public Component getListCellRendererComponent(JList list, Object object, int index, boolean isSelected, boolean cellHasFocus) {
        Card card = (Card)object;
        CardSide frontSide = card.getFrontSide();
        PaukerFrame.fillTextAreaWithCardSide(frontSide, this.frontSideTextArea, false);
        CardSide reverseSide = card.getReverseSide();
        PaukerFrame.fillTextAreaWithCardSide(reverseSide, this.reverseSideTextArea, false);
        this.highLight(card, Card.Element.FRONT_SIDE, this.frontSideTextArea);
        this.highLight(card, Card.Element.REVERSE_SIDE, this.reverseSideTextArea);
        if (isSelected) {
            if (!this.wasSelected) {
                this.setBackgroundColor(this.selectedColor);
                this.wasSelected = true;
            }
        } else if (this.wasSelected) {
            this.setBackgroundColor(this.backgroundColor);
            this.wasSelected = false;
        }
        if (card.isLearned()) {
            int longTermBatchNumber = card.getLongTermBatchNumber();
            String longTermBatchString = String.valueOf(longTermBatchNumber + 1);
            PaukerFrame.lazyStringChange(this.batchNumberTextField, longTermBatchString);
            if (isSelected) {
                this.lazyBackgroundChange(this.batchNumberTextField, this.selectedColor);
            } else {
                this.lazyBackgroundChange(this.batchNumberTextField, this.backgroundColor);
            }
            long now = System.currentTimeMillis();
            long expirationTime = card.getExpirationTime();
            if (expirationTime < now) {
                if (isSelected) {
                    this.lazyBackgroundChange(this.learnedLabel, this.selectedColor);
                    this.lazyBackgroundChange(this.learnedDateTextField, this.selectedColor);
                } else {
                    this.lazyBackgroundChange(this.learnedLabel, this.backgroundColor);
                    this.lazyBackgroundChange(this.learnedDateTextField, this.backgroundColor);
                }
                PaukerFrame.lazyStringChange(this.expiredLabel, expiredString);
                this.lazyBackgroundChange(this.expiredLabel, PaukerFrame.blue);
                this.lazyBackgroundChange(this.expirationTextField, PaukerFrame.blue);
            } else {
                PaukerFrame.lazyStringChange(this.expiredLabel, expiresString);
                this.lazyBackgroundChange(this.learnedLabel, PaukerFrame.green);
                this.lazyBackgroundChange(this.learnedDateTextField, PaukerFrame.green);
                if (isSelected) {
                    this.lazyBackgroundChange(this.expiredLabel, this.selectedColor);
                    this.lazyBackgroundChange(this.expirationTextField, this.selectedColor);
                } else {
                    this.lazyBackgroundChange(this.expiredLabel, this.backgroundColor);
                    this.lazyBackgroundChange(this.expirationTextField, this.backgroundColor);
                }
            }
            PaukerFrame.lazyStringChange(this.learnedLabel, learnedString);
            Date learnedDate = new Date(card.getLearnedTimestamp());
            this.learnedDateTextField.setText(dateFormat.format(learnedDate));
            this.expirationTextField.setText(dateFormat.format(expirationTime));
        } else {
            PaukerFrame.lazyStringChange(this.batchNumberTextField, notLearnedString);
            this.lazyBackgroundChange(this.batchNumberTextField, PaukerFrame.red);
            PaukerFrame.lazyStringChange(this.learnedLabel, "");
            PaukerFrame.lazyStringChange(this.learnedDateTextField, "");
            PaukerFrame.lazyStringChange(this.expiredLabel, "");
            PaukerFrame.lazyStringChange(this.expirationTextField, "");
            if (isSelected) {
                this.lazyBackgroundChange(this.learnedDateTextField, this.selectedColor);
                this.lazyBackgroundChange(this.expirationTextField, this.selectedColor);
            } else {
                this.lazyBackgroundChange(this.learnedDateTextField, this.backgroundColor);
                this.lazyBackgroundChange(this.expirationTextField, this.backgroundColor);
            }
        }
        if (card.isRepeatedByTyping()) {
            if (this.brainIconSet) {
                this.repeatByTypingLabel.setIcon(typingIcon);
                this.brainIconSet = false;
            }
        } else if (!this.brainIconSet) {
            this.repeatByTypingLabel.setIcon(brainIcon);
            this.brainIconSet = true;
        }
        if (this.lineWrapping) {
            String frontSideText = frontSide.getText();
            int frontTextLenth = BatchListCellRenderer.getUnWrappedTextWidth(this.frontSideTextArea, frontSideText);
            String reverseSideText = reverseSide.getText();
            int reverseTextLenth = BatchListCellRenderer.getUnWrappedTextWidth(this.reverseSideTextArea, reverseSideText);
            int textLengthSum = frontTextLenth + reverseTextLenth;
            int listWidth = list.getWidth();
            int widthForText = listWidth - 23;
            if (frontTextLenth > reverseTextLenth) {
                BatchListCellRenderer.layoutTextAreas(widthForText, textLengthSum, reverseTextLenth, this.reverseSideTextArea, frontTextLenth, this.frontSideTextArea);
            } else {
                BatchListCellRenderer.layoutTextAreas(widthForText, textLengthSum, frontTextLenth, this.frontSideTextArea, reverseTextLenth, this.reverseSideTextArea);
            }
        }
        return this;
    }

    public void setLineWrap(boolean lineWrap) {
        this.lineWrapping = lineWrap;
        this.frontSideTextArea.setLineWrap(lineWrap);
        this.reverseSideTextArea.setLineWrap(lineWrap);
        if (!lineWrap) {
            this.reverseSideTextArea.setPreferredSize(null);
            this.frontSideTextArea.setPreferredSize(null);
            this.setPreferredSize(null);
        }
    }

    public void disableInfoPanel() {
        this.infoPanel.setVisible(false);
    }

    private static int getUnWrappedTextWidth(JTextArea textArea, String text) {
        FontMetrics fontMetrics = textArea.getFontMetrics(textArea.getFont());
        return fontMetrics.stringWidth(text);
    }

    private static void layoutTextAreas(int widthForText, int textLengthSum, int shortTextWidth, JTextArea shortTextArea, int longTextWidth, JTextArea longTextArea) {
        int xAxisSpan = widthForText * shortTextWidth / textLengthSum;
        FontMetrics fontMetrics = shortTextArea.getFontMetrics(shortTextArea.getFont());
        int charWidth = fontMetrics.charWidth('m');
        if (xAxisSpan < charWidth) {
            xAxisSpan = charWidth;
        }
        BatchListCellRenderer.setPreferredSize(shortTextArea, xAxisSpan);
        int remainingWidth = widthForText - xAxisSpan;
        if (longTextWidth > remainingWidth) {
            longTextWidth = remainingWidth;
        }
        BatchListCellRenderer.setPreferredSize(longTextArea, longTextWidth);
    }

    private static void setPreferredSize(JTextArea textArea, int xAxisSpan) {
        View view = textArea.getUI().getRootView(textArea);
        view.setSize(xAxisSpan, Float.MAX_VALUE);
        int preferredYSpan = (int)view.getPreferredSpan(1);
        textArea.setPreferredSize(new Dimension(xAxisSpan, preferredYSpan + 6));
    }

    private void lazyBackgroundChange(JComponent component, Color color) {
        if (!component.getBackground().equals(color)) {
            component.setBackground(color);
        }
    }

    private void setBackgroundColor(Color color) {
        this.setBackground(color);
        this.contentsPanel.setBackground(color);
        this.infoPanel.setBackground(color);
        this.learnedLabel.setBackground(color);
        this.learnedDateTextField.setBackground(color);
        this.expiredLabel.setBackground(color);
        this.expirationTextField.setBackground(color);
    }

    private void highLight(Card card, Card.Element cardSide, JTextArea textArea) {
        Highlighter highlighter = textArea.getHighlighter();
        highlighter.removeAllHighlights();
        List<SearchHit> searchHits = null;
        searchHits = cardSide == Card.Element.FRONT_SIDE ? card.getFrontSide().getSearchHits() : card.getReverseSide().getSearchHits();
        if (searchHits != null && this.paukerFrame != null) {
            try {
                int patternLength = this.paukerFrame.getSearchPatternLength();
                SearchHit currentSearchHit = this.paukerFrame.getCurrentSearchHit();
                if (currentSearchHit != null && currentSearchHit.getCard() == card && currentSearchHit.getCardSide() == cardSide) {
                    int index = currentSearchHit.getCardSideIndex();
                    highlighter.addHighlight(index, index + patternLength, redPainter);
                }
                for (SearchHit searchHit : searchHits) {
                    int index = searchHit.getCardSideIndex();
                    highlighter.addHighlight(index, index + patternLength, yellowPainter);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void initComponents() {
        this.contentsPanel = new JPanel();
        this.frontSideTextArea = new JTextArea();
        this.reverseSideTextArea = new JTextArea();
        this.infoPanel = new JPanel();
        this.batchNumberLabel = new JLabel();
        this.batchNumberTextField = new JTextField();
        this.learnedLabel = new JLabel();
        this.learnedDateTextField = new JTextField();
        this.repeatByTypingLabel = new JLabel();
        this.expiredLabel = new JLabel();
        this.expirationTextField = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.setLayout(new GridBagLayout());
        this.contentsPanel.setLayout(new GridBagLayout());
        this.frontSideTextArea.setWrapStyleWord(true);
        this.frontSideTextArea.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(null), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.contentsPanel.add((Component)this.frontSideTextArea, gridBagConstraints);
        this.reverseSideTextArea.setWrapStyleWord(true);
        this.reverseSideTextArea.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(null), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.contentsPanel.add((Component)this.reverseSideTextArea, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.contentsPanel, gridBagConstraints);
        this.infoPanel.setLayout(new GridBagLayout());
        this.batchNumberLabel.setFont(new Font("Dialog", 0, 10));
        ResourceBundle bundle = ResourceBundle.getBundle("pauker/Strings");
        this.batchNumberLabel.setText(bundle.getString("Batch"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 4, 0, 0);
        this.infoPanel.add((Component)this.batchNumberLabel, gridBagConstraints);
        this.batchNumberTextField.setEditable(false);
        this.batchNumberTextField.setFont(new Font("Dialog", 0, 10));
        this.batchNumberTextField.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 10, 0, 0);
        this.infoPanel.add((Component)this.batchNumberTextField, gridBagConstraints);
        this.learnedLabel.setFont(new Font("Dialog", 0, 10));
        this.learnedLabel.setText(bundle.getString("Learned_At"));
        this.learnedLabel.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 10, 0, 0);
        this.infoPanel.add((Component)this.learnedLabel, gridBagConstraints);
        this.learnedDateTextField.setEditable(false);
        this.learnedDateTextField.setFont(new Font("Dialog", 0, 10));
        this.learnedDateTextField.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 10, 0, 3);
        this.infoPanel.add((Component)this.learnedDateTextField, gridBagConstraints);
        this.repeatByTypingLabel.setFont(new Font("Dialog", 0, 10));
        this.repeatByTypingLabel.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/smallbrain.png")));
        this.repeatByTypingLabel.setText(bundle.getString("Repeating_Method_Colon"));
        this.repeatByTypingLabel.setHorizontalTextPosition(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(1, 4, 0, 0);
        this.infoPanel.add((Component)this.repeatByTypingLabel, gridBagConstraints);
        this.expiredLabel.setFont(new Font("Dialog", 0, 10));
        this.expiredLabel.setText(bundle.getString("Expires_At"));
        this.expiredLabel.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 10, 0, 0);
        this.infoPanel.add((Component)this.expiredLabel, gridBagConstraints);
        this.expirationTextField.setEditable(false);
        this.expirationTextField.setFont(new Font("Dialog", 0, 10));
        this.expirationTextField.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 10, 0, 3);
        this.infoPanel.add((Component)this.expirationTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.add((Component)this.infoPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.add((Component)this.jSeparator1, gridBagConstraints);
    }
}

