/*
 * Decompiled with CFR 0.152.
 */
package pauker.program.gui.swing;

import javax.swing.AbstractListModel;
import pauker.program.Batch;
import pauker.program.Card;

public class BatchListModel
extends AbstractListModel {
    private Batch batch;

    public void clear() {
        int size;
        if (this.batch != null && (size = this.batch.getNumberOfCards()) > 0) {
            this.batch.clear();
            this.fireIntervalRemoved(this, 0, size - 1);
        }
    }

    public Object get(int index) {
        return this.batch.getCard(index);
    }

    public Object getElementAt(int index) {
        return this.batch.getCard(index);
    }

    public int getSize() {
        if (this.batch == null) {
            return 0;
        }
        return this.batch.getNumberOfCards();
    }

    public void remove(int index) {
        this.batch.removeCard(index);
        this.fireIntervalRemoved(this, index, index);
    }

    public void setBatch(Batch batch) {
        int oldSize = 0;
        if (this.batch != null) {
            oldSize = this.batch.getNumberOfCards();
        }
        this.batch = batch;
        int numberOfCards = batch.getNumberOfCards();
        if (oldSize < numberOfCards) {
            this.fireContentsChanged(this, 0, oldSize - 1);
            this.fireIntervalAdded(this, oldSize, numberOfCards);
        } else if (oldSize > numberOfCards) {
            this.fireIntervalRemoved(this, numberOfCards, oldSize - 1);
            this.fireContentsChanged(this, 0, numberOfCards - 1);
        } else {
            this.fireContentsChanged(this, 0, numberOfCards - 1);
        }
    }

    public void addCard(Card card) {
        this.batch.addCard(card);
        int cardIndex = this.batch.getNumberOfCards() - 1;
        this.fireIntervalAdded(this, cardIndex, cardIndex);
    }

    public void cardAdded() {
        int cardIndex = this.batch.getNumberOfCards() - 1;
        this.fireIntervalAdded(this, cardIndex, cardIndex);
    }

    public void cardsChanged(int firstIndex, int lastIndex) {
        this.fireContentsChanged(this, firstIndex, lastIndex);
    }

    public void cardsRemoved(int firstIndex, int lastIndex) {
        this.fireIntervalRemoved(this, firstIndex, lastIndex);
    }
}

