/*
 * Decompiled with CFR 0.152.
 */
package pauker.program.gui.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import pauker.program.Card;
import pauker.program.CardSide;
import pauker.program.SearchEngine;
import pauker.program.gui.swing.EditCardPanel;
import pauker.program.gui.swing.PaukerFrame;

public class EditCardDialog
extends JDialog {
    private Card card;
    private boolean okPressed;
    private SearchEngine searchEngine;
    private JPanel buttonPanel;
    private JButton editCancelButton;
    private EditCardPanel editCardPanel;
    private JButton editOKButton;
    private JPanel expirationPanel;
    private JLabel expiresLabel;
    private JTextField expiresTextField;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JLabel learnedLabel;
    private JTextField learnedTextField;

    public EditCardDialog(Dialog dialog, PaukerFrame paukerFrame, Card card, SearchEngine searchEngine) {
        super(dialog, true);
        this.initDialog(dialog, paukerFrame, card, searchEngine);
    }

    public EditCardDialog(PaukerFrame paukerFrame, Card card, SearchEngine searchEngine) {
        super((Frame)paukerFrame, true);
        this.initDialog(paukerFrame, paukerFrame, card, searchEngine);
    }

    private void initDialog(Component parent, PaukerFrame paukerFrame, Card card, SearchEngine searchEngine) {
        this.card = card;
        this.searchEngine = searchEngine;
        this.okPressed = false;
        this.initComponents();
        this.setTitle(PaukerFrame.strings.getString("Edit_Card"));
        this.editCardPanel.setPaukerFrame(paukerFrame);
        this.editCardPanel.setSplitOrientation(paukerFrame.getSplitOrientation());
        this.editCardPanel.applyWrapSettings();
        this.editCardPanel.setCard(card);
        this.editCardPanel.setRepeatByTyping(card.isRepeatedByTyping());
        if (card.isLearned()) {
            long now = System.currentTimeMillis();
            long expirationTime = card.getExpirationTime();
            if (expirationTime < now) {
                this.expiresLabel.setText(PaukerFrame.strings.getString("Expired_At"));
                this.expiresLabel.setForeground(Color.red);
                this.expiresTextField.setForeground(Color.red);
            }
            DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 3);
            this.learnedTextField.setText(dateFormat.format(card.getLearnedTimestamp()));
            this.expiresTextField.setText(dateFormat.format(expirationTime));
        } else {
            this.remove(this.expirationPanel);
        }
        this.getRootPane().setDefaultButton(this.editOKButton);
        this.pack();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public boolean okPressed() {
        return this.okPressed;
    }

    private void initComponents() {
        this.editCardPanel = new EditCardPanel();
        this.jSeparator1 = new JSeparator();
        this.expirationPanel = new JPanel();
        this.learnedLabel = new JLabel();
        this.learnedTextField = new JTextField();
        this.expiresLabel = new JLabel();
        this.expiresTextField = new JTextField();
        this.jSeparator2 = new JSeparator();
        this.buttonPanel = new JPanel();
        this.editOKButton = new JButton();
        this.editCancelButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent evt) {
                EditCardDialog.this.formWindowOpened(evt);
            }

            public void windowClosing(WindowEvent evt) {
                EditCardDialog.this.closeDialog(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this.editCardPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.expirationPanel.setLayout(new GridBagLayout());
        this.learnedLabel.setFont(new Font("Dialog", 0, 10));
        ResourceBundle bundle = ResourceBundle.getBundle("pauker/Strings");
        this.learnedLabel.setText(bundle.getString("Learned_At"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.expirationPanel.add((Component)this.learnedLabel, gridBagConstraints);
        this.learnedTextField.setEditable(false);
        this.learnedTextField.setFont(new Font("Dialog", 0, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.expirationPanel.add((Component)this.learnedTextField, gridBagConstraints);
        this.expiresLabel.setFont(new Font("Dialog", 0, 10));
        this.expiresLabel.setText(bundle.getString("Expires_At"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.expirationPanel.add((Component)this.expiresLabel, gridBagConstraints);
        this.expiresTextField.setEditable(false);
        this.expiresTextField.setFont(new Font("Dialog", 0, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.expirationPanel.add((Component)this.expiresTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.expirationPanel.add((Component)this.jSeparator2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.expirationPanel, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.editOKButton.setFont(new Font("Dialog", 0, 10));
        this.editOKButton.setText(bundle.getString("OK"));
        this.editOKButton.setName("editOKButton");
        this.editOKButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditCardDialog.this.editOKButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.buttonPanel.add((Component)this.editOKButton, gridBagConstraints);
        this.editCancelButton.setFont(new Font("Dialog", 0, 10));
        this.editCancelButton.setText(bundle.getString("Cancel"));
        this.editCancelButton.setName("editCancelButton");
        this.editCancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditCardDialog.this.editCancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.buttonPanel.add((Component)this.editCancelButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
    }

    private void formWindowOpened(WindowEvent evt) {
        this.editCardPanel.setFocus(Card.Element.FRONT_SIDE);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EditCardDialog.this.getRootPane().setDefaultButton(EditCardDialog.this.editOKButton);
            }
        });
    }

    private void editCancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void editOKButtonActionPerformed(ActionEvent evt) {
        String frontSideText = this.editCardPanel.getFrontSide();
        String reverseSideText = this.editCardPanel.getReverseSide();
        if (frontSideText.length() == 0) {
            JOptionPane.showMessageDialog(this, PaukerFrame.strings.getString("FrontSide_Is_Empty"), PaukerFrame.strings.getString("Error"), 0);
            this.editCardPanel.setFocus(Card.Element.FRONT_SIDE);
            return;
        }
        if (reverseSideText.length() == 0) {
            JOptionPane.showMessageDialog(this, PaukerFrame.strings.getString("ReverseSide_Is_Empty"), PaukerFrame.strings.getString("Error"), 0);
            this.editCardPanel.setFocus(Card.Element.REVERSE_SIDE);
            return;
        }
        CardSide frontSide = this.card.getFrontSide();
        frontSide.setText(frontSideText);
        frontSide.setFont(this.editCardPanel.getFrontSideFont());
        frontSide.setForegroundColor(this.editCardPanel.getFrontForegroundColor());
        frontSide.setBackgroundColor(this.editCardPanel.getFrontBackgroundColor());
        frontSide.setOrientation(this.editCardPanel.getFrontSideComponentOrientation());
        frontSide.setRepeatByTyping(this.editCardPanel.getRepeatByTyping());
        CardSide reverseSide = this.card.getReverseSide();
        reverseSide.setText(reverseSideText);
        reverseSide.setFont(this.editCardPanel.getReverseSideFont());
        reverseSide.setForegroundColor(this.editCardPanel.getReverseSideForegroundColor());
        reverseSide.setBackgroundColor(this.editCardPanel.getReverseSideBackgroundColor());
        reverseSide.setOrientation(this.editCardPanel.getReverseSideComponentOrientation());
        this.searchEngine.index(this.card);
        this.okPressed = true;
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

