/*
 * Decompiled with CFR 0.152.
 */
package pauker.program.gui.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import pauker.program.Card;
import pauker.program.gui.swing.MyUndoManager;
import pauker.program.gui.swing.PaukerFrame;

public class EditCardPanel
extends JPanel
implements UndoableEditListener,
DocumentListener {
    private MyUndoManager undoManager;
    private Document frontSideDocument;
    private Document reverseSideDocument;
    private Hashtable<Object, Action> editActions;
    private Action cutAction;
    private Action copyAction;
    private Action pasteAction;
    private Action insertTabAction;
    private static Card.Element lastFocusSide;
    private Point lastMousePoint;
    private int scrollIncrement;
    private Component nextFocusComponent;
    private PaukerFrame paukerFrame;
    private Timer scrollTimer = new Timer(50, new ActionListener(){

        public void actionPerformed(ActionEvent evt) {
            JScrollBar scrollbar = EditCardPanel.this.popupScrollPane.getVerticalScrollBar();
            int position = scrollbar.getValue();
            scrollbar.setValue(position + EditCardPanel.this.scrollIncrement);
            ((EditCardPanel)EditCardPanel.this).lastMousePoint.y += EditCardPanel.this.scrollIncrement;
            EditCardPanel.this.updatePopup();
        }
    });
    private ButtonGroup alignmentButtonGroup;
    private JButton backgroundButton;
    private JToggleButton boldToggleButton;
    private JMenuItem clearMenuItem;
    private JButton copyButton;
    private JMenuItem copyMenuItem;
    private JButton cutButton;
    private JMenuItem cutMenuItem;
    private JPanel editButtonPanel;
    private JComboBox fontComboBox;
    private JPanel fontPanel;
    private JComboBox fontSizeComboBox;
    private JButton foregroundButton;
    private JLabel frontSideLabel;
    private JPanel frontSidePanel;
    private JScrollPane frontSideScrollPane;
    private JTextArea frontSideTextArea;
    private JToggleButton italicToggleButton;
    private JLabel jLabel1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JToggleButton leftToRightToggleButton;
    private JLabel memorizingLabel;
    private JButton pasteButton;
    private JMenuItem pasteMenuItem;
    private JList popupList;
    private JPopupMenu popupMenu;
    private JPanel popupPanel;
    private JScrollPane popupScrollPane;
    private JButton redoButton;
    private JPanel redoButtonPanel;
    private JButton redoListButton;
    private JMenuItem redoMenuItem;
    private JComboBox repeatingMethodComboBox;
    private JLabel reverseSideLabel;
    private JPanel reverseSidePanel;
    private JScrollPane reverseSideScrollPane;
    private JTextArea reverseSideTextArea;
    private JToggleButton rightToLeftToggleButton;
    private JMenuItem selectAllMenuItem;
    private JSplitPane splitPane;
    private JButton switchLayoutButton;
    private JButton tabButton;
    private JPopupMenu textAreaPopupMenu;
    private JLabel typingLabel;
    private JButton undoButton;
    private JPanel undoButtonPanel;
    private JLabel undoCounterLabel;
    private JButton undoListButton;
    private JMenuItem undoMenuItem;

    public EditCardPanel() {
        String[] fontFamilyNames;
        Action[] actions;
        this.initComponents();
        this.undoManager = new MyUndoManager();
        this.frontSideDocument = this.frontSideTextArea.getDocument();
        this.reverseSideDocument = this.reverseSideTextArea.getDocument();
        this.frontSideDocument.addDocumentListener(this);
        this.reverseSideDocument.addDocumentListener(this);
        this.frontSideDocument.addUndoableEditListener(this);
        this.reverseSideDocument.addUndoableEditListener(this);
        this.editActions = new Hashtable();
        for (Action action : actions = this.frontSideTextArea.getActions()) {
            this.editActions.put(action.getValue("Name"), action);
        }
        this.cutAction = this.editActions.get("cut-to-clipboard");
        this.copyAction = this.editActions.get("copy-to-clipboard");
        this.pasteAction = this.editActions.get("paste-from-clipboard");
        this.insertTabAction = this.editActions.get("insert-tab");
        AbstractAction focusButtonPanelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent event) {
                EditCardPanel.this.tabButton.requestFocusInWindow();
            }
        };
        AbstractAction focusFrontSideAction = new AbstractAction(){

            public void actionPerformed(ActionEvent event) {
                EditCardPanel.this.setFocus(Card.Element.FRONT_SIDE);
            }
        };
        AbstractAction focusReverseSideAction = new AbstractAction(){

            public void actionPerformed(ActionEvent event) {
                EditCardPanel.this.setFocus(Card.Element.REVERSE_SIDE);
            }
        };
        AbstractAction transferFocusAction = new AbstractAction(){

            public void actionPerformed(ActionEvent event) {
                if (EditCardPanel.this.nextFocusComponent != null) {
                    EditCardPanel.this.nextFocusComponent.requestFocusInWindow();
                } else {
                    EditCardPanel.this.repeatingMethodComboBox.requestFocusInWindow();
                }
            }
        };
        KeyStroke tabKeyStroke = KeyStroke.getKeyStroke(9, 0);
        KeyStroke shiftTabKeyStroke = KeyStroke.getKeyStroke(9, 1);
        InputMap frontSideInputMap = this.frontSideTextArea.getInputMap();
        frontSideInputMap.put(tabKeyStroke, "tabAction");
        frontSideInputMap.put(shiftTabKeyStroke, "shiftTabAction");
        ActionMap frontSideActionMap = this.frontSideTextArea.getActionMap();
        frontSideActionMap.put("tabAction", focusReverseSideAction);
        frontSideActionMap.put("shiftTabAction", focusButtonPanelAction);
        InputMap reverseSideInputMap = this.reverseSideTextArea.getInputMap();
        reverseSideInputMap.put(tabKeyStroke, "tabAction");
        reverseSideInputMap.put(shiftTabKeyStroke, "shiftTabAction");
        ActionMap reverseSideActionMap = this.reverseSideTextArea.getActionMap();
        reverseSideActionMap.put("tabAction", transferFocusAction);
        reverseSideActionMap.put("shiftTabAction", focusFrontSideAction);
        DefaultComboBoxModel<String> fontComboModel = new DefaultComboBoxModel<String>();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (String fontFamilyName : fontFamilyNames = graphicsEnvironment.getAvailableFontFamilyNames()) {
            fontComboModel.addElement(fontFamilyName);
        }
        this.fontComboBox.setModel(fontComboModel);
        DefaultComboBoxModel<Integer> fontSizeComboModel = new DefaultComboBoxModel<Integer>();
        for (int i = 6; i < 41; ++i) {
            fontSizeComboModel.addElement(i);
        }
        this.fontSizeComboBox.setModel(fontSizeComboModel);
        Font defaultFont = this.frontSideTextArea.getFont();
        this.fontComboBox.setSelectedItem(defaultFont.getFamily());
        this.fontSizeComboBox.setSelectedItem(defaultFont.getSize());
        this.boldToggleButton.setSelected(defaultFont.isBold());
        this.italicToggleButton.setSelected(defaultFont.isItalic());
        this.repeatingMethodComboBox.addItem(this.typingLabel);
        this.repeatingMethodComboBox.addItem(this.memorizingLabel);
        ComponentOrientation defaultOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
        this.frontSideTextArea.setComponentOrientation(defaultOrientation);
        this.reverseSideTextArea.setComponentOrientation(defaultOrientation);
        if (defaultOrientation.isLeftToRight()) {
            this.leftToRightToggleButton.setSelected(true);
        } else {
            this.rightToLeftToggleButton.setSelected(true);
        }
        this.setMinimumSize(this.getPreferredSize());
    }

    public void applyWrapSettings() {
        if (this.paukerFrame != null) {
            this.frontSideTextArea.setLineWrap(this.paukerFrame.isLineWrapping());
            this.reverseSideTextArea.setLineWrap(this.paukerFrame.isLineWrapping());
        }
    }

    public void setPaukerFrame(PaukerFrame paukerFrame) {
        this.paukerFrame = paukerFrame;
    }

    public ComponentOrientation getFrontSideComponentOrientation() {
        return this.frontSideTextArea.getComponentOrientation();
    }

    public ComponentOrientation getReverseSideComponentOrientation() {
        return this.reverseSideTextArea.getComponentOrientation();
    }

    public int getOrientation() {
        return this.splitPane.getOrientation();
    }

    public void setFocus(Card.Element cardSide) {
        if (cardSide == Card.Element.FRONT_SIDE) {
            this.frontSideTextArea.requestFocusInWindow();
        } else {
            this.reverseSideTextArea.requestFocusInWindow();
        }
    }

    public static Card.Element getLastFocusSide() {
        return lastFocusSide;
    }

    public void clear() {
        this.frontSideTextArea.setText("");
        this.reverseSideTextArea.setText("");
    }

    public void reset() {
        this.clear();
        this.frontSideTextArea.requestFocusInWindow();
        this.undoManager.discardAllEdits();
        this.undoButton.setEnabled(false);
        this.undoListButton.setEnabled(false);
        this.redoButton.setEnabled(false);
        this.redoListButton.setEnabled(false);
        this.applyWrapSettings();
    }

    public void setNextFocusComponent(Component nextFocusComponent) {
        this.nextFocusComponent = nextFocusComponent;
    }

    public Font getFrontSideFont() {
        return this.frontSideTextArea.getFont();
    }

    public Font getReverseSideFont() {
        return this.reverseSideTextArea.getFont();
    }

    public Color getFrontForegroundColor() {
        return this.frontSideTextArea.getForeground();
    }

    public Color getFrontBackgroundColor() {
        return this.frontSideTextArea.getBackground();
    }

    public Color getReverseSideForegroundColor() {
        return this.reverseSideTextArea.getForeground();
    }

    public Color getReverseSideBackgroundColor() {
        return this.reverseSideTextArea.getBackground();
    }

    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        this.undoManager.addEdit(undoableEditEvent.getEdit());
        this.updateUndoRedoButtons();
    }

    private void updateUndoRedoButtons() {
        boolean canUndo = this.undoManager.canUndo();
        this.undoButton.setEnabled(canUndo);
        this.undoListButton.setEnabled(canUndo);
        this.undoMenuItem.setEnabled(canUndo);
        boolean canRedo = this.undoManager.canRedo();
        this.redoButton.setEnabled(canRedo);
        this.redoListButton.setEnabled(canRedo);
        this.redoMenuItem.setEnabled(canRedo);
    }

    public String getFrontSide() {
        return this.frontSideTextArea.getText();
    }

    public JTextComponent getFrontSideTextComponent() {
        return this.frontSideTextArea;
    }

    public void setCard(Card card) {
        PaukerFrame.fillTextAreaWithCardSide(card.getFrontSide(), this.frontSideTextArea, true);
        PaukerFrame.fillTextAreaWithCardSide(card.getReverseSide(), this.reverseSideTextArea, true);
        this.undoManager.discardAllEdits();
        this.undoButton.setEnabled(false);
        this.undoListButton.setEnabled(false);
    }

    public String getReverseSide() {
        return this.reverseSideTextArea.getText();
    }

    public JTextComponent getReverseSideTextComponent() {
        return this.reverseSideTextArea;
    }

    public void setFrontSideFont(Font frontSideFont) {
        this.frontSideTextArea.setFont(frontSideFont);
    }

    public void setReverseSideFont(Font reverseSideFont) {
        this.reverseSideTextArea.setFont(reverseSideFont);
    }

    public boolean getRepeatByTyping() {
        return this.repeatingMethodComboBox.getSelectedItem().equals(this.typingLabel);
    }

    public void setRepeatByTyping(boolean repeatByTyping) {
        if (repeatByTyping) {
            this.repeatingMethodComboBox.setSelectedItem(this.typingLabel);
        } else {
            this.repeatingMethodComboBox.setSelectedItem(this.memorizingLabel);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.documentChanged(documentEvent);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.documentChanged(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.documentChanged(documentEvent);
    }

    public void setSplitOrientation(int orientation) {
        if (this.paukerFrame != null) {
            this.paukerFrame.setSplitOrientation(orientation);
        }
        this.splitPane.setOrientation(orientation);
        int lines = this.frontSideTextArea.getLineCount();
        this.frontSideTextArea.setRows(lines < 5 ? 5 : lines);
        lines = this.reverseSideTextArea.getLineCount();
        this.reverseSideTextArea.setRows(lines < 5 ? 5 : lines);
        this.splitPane.resetToPreferredSizes();
        if (orientation == 1) {
            this.switchLayoutButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/view_top_bottom.png")));
            this.switchLayoutButton.setToolTipText(ResourceBundle.getBundle("pauker/Strings").getString("Cardsides_Top_Down"));
        } else {
            this.switchLayoutButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/view_left_right.png")));
            this.switchLayoutButton.setToolTipText(ResourceBundle.getBundle("pauker/Strings").getString("Cardsides_Left_Right"));
        }
    }

    private void initComponents() {
        this.popupPanel = new JPanel();
        this.popupScrollPane = new JScrollPane();
        this.popupList = new JList();
        this.undoCounterLabel = new JLabel();
        this.popupMenu = new JPopupMenu();
        this.typingLabel = new JLabel();
        this.memorizingLabel = new JLabel();
        this.alignmentButtonGroup = new ButtonGroup();
        this.textAreaPopupMenu = new JPopupMenu();
        this.undoMenuItem = new JMenuItem();
        this.redoMenuItem = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.cutMenuItem = new JMenuItem();
        this.copyMenuItem = new JMenuItem();
        this.pasteMenuItem = new JMenuItem();
        this.clearMenuItem = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.selectAllMenuItem = new JMenuItem();
        this.editButtonPanel = new JPanel();
        this.undoButtonPanel = new JPanel();
        this.undoButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.undoListButton = new JButton();
        this.redoButtonPanel = new JPanel();
        this.redoButton = new JButton();
        this.jSeparator2 = new JSeparator();
        this.redoListButton = new JButton();
        this.cutButton = new JButton();
        this.copyButton = new JButton();
        this.pasteButton = new JButton();
        this.leftToRightToggleButton = new JToggleButton();
        this.rightToLeftToggleButton = new JToggleButton();
        this.tabButton = new JButton();
        this.switchLayoutButton = new JButton();
        this.fontPanel = new JPanel();
        this.fontComboBox = new JComboBox();
        this.fontSizeComboBox = new JComboBox();
        this.boldToggleButton = new JToggleButton();
        this.italicToggleButton = new JToggleButton();
        this.foregroundButton = new JButton();
        this.backgroundButton = new JButton();
        this.splitPane = new JSplitPane();
        this.frontSidePanel = new JPanel();
        this.frontSideLabel = new JLabel();
        this.frontSideScrollPane = new JScrollPane();
        this.frontSideTextArea = new JTextArea();
        this.reverseSidePanel = new JPanel();
        this.reverseSideLabel = new JLabel();
        this.reverseSideScrollPane = new JScrollPane();
        this.reverseSideTextArea = new JTextArea();
        this.jLabel1 = new JLabel();
        this.repeatingMethodComboBox = new JComboBox();
        this.popupPanel.setLayout(new GridBagLayout());
        this.popupList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                EditCardPanel.this.popupListMouseClicked(evt);
            }

            public void mouseExited(MouseEvent evt) {
                EditCardPanel.this.popupListMouseExited(evt);
            }
        });
        this.popupList.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent evt) {
                EditCardPanel.this.popupListMouseMoved(evt);
            }
        });
        this.popupScrollPane.setViewportView(this.popupList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.popupPanel.add((Component)this.popupScrollPane, gridBagConstraints);
        this.undoCounterLabel.setText("number of undos");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.popupPanel.add((Component)this.undoCounterLabel, gridBagConstraints);
        this.popupMenu.add(this.popupPanel);
        this.typingLabel.setFont(new Font("Dialog", 0, 10));
        this.typingLabel.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/key_enter.png")));
        ResourceBundle bundle = ResourceBundle.getBundle("pauker/Strings");
        this.typingLabel.setText(bundle.getString("Repeat_By_Typing"));
        this.typingLabel.setOpaque(true);
        this.memorizingLabel.setFont(new Font("Dialog", 0, 10));
        this.memorizingLabel.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/smallbrain.png")));
        this.memorizingLabel.setText(bundle.getString("Repeat_By_Remembering"));
        this.memorizingLabel.setOpaque(true);
        this.undoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.undoMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/16x16/undo.png")));
        this.undoMenuItem.setText(bundle.getString("Undo"));
        this.undoMenuItem.setEnabled(false);
        this.undoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditCardPanel.this.undoMenuItemActionPerformed(evt);
            }
        });
        this.textAreaPopupMenu.add(this.undoMenuItem);
        this.redoMenuItem.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        this.redoMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/16x16/redo.png")));
        this.redoMenuItem.setText(bundle.getString("Redo"));
        this.redoMenuItem.setEnabled(false);
        this.redoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditCardPanel.this.redoMenuItemActionPerformed(evt);
            }
        });
        this.textAreaPopupMenu.add(this.redoMenuItem);
        this.textAreaPopupMenu.add(this.jSeparator3);
        this.cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.cutMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/16x16/editcut.png")));
        this.cutMenuItem.setText(bundle.getString("Cut"));
        this.cutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditCardPanel.this.cutMenuItemActionPerformed(evt);
            }
        });
        this.textAreaPopupMenu.add(this.cutMenuItem);
        this.copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.copyMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/16x16/editcopy.png")));
        this.copyMenuItem.setText(bundle.getString("Copy"));
        this.copyMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditCardPanel.this.copyMenuItemActionPerformed(evt);
            }
        });
        this.textAreaPopupMenu.add(this.copyMenuItem);
        this.pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.pasteMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/16x16/editpaste.png")));
        this.pasteMenuItem.setText(bundle.getString("Paste"));
        this.pasteMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditCardPanel.this.pasteMenuItemActionPerformed(evt);
            }
        });
        this.textAreaPopupMenu.add(this.pasteMenuItem);
        this.clearMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/16x16/editclear.png")));
        this.clearMenuItem.setText(bundle.getString("Clear"));
        this.clearMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditCardPanel.this.clearMenuItemActionPerformed(evt);
            }
        });
        this.textAreaPopupMenu.add(this.clearMenuItem);
        this.textAreaPopupMenu.add(this.jSeparator4);
        this.selectAllMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.selectAllMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/16x16/text_block.png")));
        this.selectAllMenuItem.setText(bundle.getString("Select_All"));
        this.selectAllMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditCardPanel.this.selectAllMenuItemActionPerformed(evt);
            }
        });
        this.textAreaPopupMenu.add(this.selectAllMenuItem);
        this.setLayout(new GridBagLayout());
        this.editButtonPanel.setLayout(new GridBagLayout());
        this.editButtonPanel.setBorder(BorderFactory.createEtchedBorder());
        this.undoButtonPanel.setLayout(new GridBagLayout());
        this.undoButtonPanel.setBorder(BorderFactory.createEtchedBorder());
        this.undoButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/undo.png")));
        this.undoButton.setToolTipText(bundle.getString("Undo"));
        this.undoButton.setBorder(null);
        this.undoButton.setEnabled(false);
        this.undoButton.setMargin(new Insets(0, 0, 0, 0));
        this.undoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditCardPanel.this.undoButtonActionPerformed(evt);
            }
        });
        this.undoButtonPanel.add((Component)this.undoButton, new GridBagConstraints());
        this.jSeparator1.setOrientation(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        this.undoButtonPanel.add((Component)this.jSeparator1, gridBagConstraints);
        this.undoListButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/down_small.png")));
        this.undoListButton.setBorder(null);
        this.undoListButton.setEnabled(false);
        this.undoListButton.setFocusPainted(false);
        this.undoListButton.setMargin(new Insets(0, 0, 0, 0));
        this.undoListButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditCardPanel.this.undoListButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        this.undoButtonPanel.add((Component)this.undoListButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.editButtonPanel.add((Component)this.undoButtonPanel, gridBagConstraints);
        this.redoButtonPanel.setLayout(new GridBagLayout());
        this.redoButtonPanel.setBorder(BorderFactory.createEtchedBorder());
        this.redoButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/redo.png")));
        this.redoButton.setToolTipText(bundle.getString("Redo"));
        this.redoButton.setBorder(null);
        this.redoButton.setEnabled(false);
        this.redoButton.setMargin(new Insets(0, 0, 0, 0));
        this.redoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditCardPanel.this.redoButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.redoButtonPanel.add((Component)this.redoButton, gridBagConstraints);
        this.jSeparator2.setOrientation(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        this.redoButtonPanel.add((Component)this.jSeparator2, gridBagConstraints);
        this.redoListButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/down_small.png")));
        this.redoListButton.setBorder(null);
        this.redoListButton.setEnabled(false);
        this.redoListButton.setFocusPainted(false);
        this.redoListButton.setMargin(new Insets(0, 0, 0, 0));
        this.redoListButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditCardPanel.this.redoListButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        this.redoButtonPanel.add((Component)this.redoListButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.editButtonPanel.add((Component)this.redoButtonPanel, gridBagConstraints);
        this.cutButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/editcut.png")));
        this.cutButton.setToolTipText(bundle.getString("Cut"));
        this.cutButton.setEnabled(false);
        this.cutButton.setMargin(new Insets(0, 0, 0, 0));
        this.cutButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditCardPanel.this.cutButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.editButtonPanel.add((Component)this.cutButton, gridBagConstraints);
        this.copyButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/editcopy.png")));
        this.copyButton.setToolTipText(bundle.getString("Copy"));
        this.copyButton.setEnabled(false);
        this.copyButton.setMargin(new Insets(0, 0, 0, 0));
        this.copyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditCardPanel.this.copyButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.editButtonPanel.add((Component)this.copyButton, gridBagConstraints);
        this.pasteButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/editpaste.png")));
        this.pasteButton.setToolTipText(bundle.getString("Paste"));
        this.pasteButton.setMargin(new Insets(0, 0, 0, 0));
        this.pasteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditCardPanel.this.pasteButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.editButtonPanel.add((Component)this.pasteButton, gridBagConstraints);
        this.alignmentButtonGroup.add(this.leftToRightToggleButton);
        this.leftToRightToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/leftjust.png")));
        this.leftToRightToggleButton.setToolTipText(bundle.getString("LTR_Tooltip"));
        this.leftToRightToggleButton.setMargin(new Insets(0, 0, 0, 0));
        this.leftToRightToggleButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                EditCardPanel.this.leftToRightToggleButtonItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.editButtonPanel.add((Component)this.leftToRightToggleButton, gridBagConstraints);
        this.alignmentButtonGroup.add(this.rightToLeftToggleButton);
        this.rightToLeftToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/rightjust.png")));
        this.rightToLeftToggleButton.setToolTipText(bundle.getString("RTL_Tooltip"));
        this.rightToLeftToggleButton.setMargin(new Insets(0, 0, 0, 0));
        this.rightToLeftToggleButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                EditCardPanel.this.rightToLeftToggleButtonItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.editButtonPanel.add((Component)this.rightToLeftToggleButton, gridBagConstraints);
        this.tabButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/indent.png")));
        this.tabButton.setToolTipText(bundle.getString("Insert_TAB"));
        this.tabButton.setMargin(new Insets(0, 0, 0, 0));
        this.tabButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditCardPanel.this.tabButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.editButtonPanel.add((Component)this.tabButton, gridBagConstraints);
        this.switchLayoutButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/view_top_bottom.png")));
        this.switchLayoutButton.setToolTipText(bundle.getString("Cardsides_Top_Down"));
        this.switchLayoutButton.setMargin(new Insets(0, 0, 0, 0));
        this.switchLayoutButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditCardPanel.this.switchLayoutButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 5);
        this.editButtonPanel.add((Component)this.switchLayoutButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.editButtonPanel, gridBagConstraints);
        this.fontPanel.setLayout(new GridBagLayout());
        this.fontPanel.setBorder(BorderFactory.createEtchedBorder());
        this.fontComboBox.setFont(new Font("Dialog", 0, 10));
        this.fontComboBox.setName("fontComboBox");
        this.fontComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditCardPanel.this.fontComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.fontPanel.add((Component)this.fontComboBox, gridBagConstraints);
        this.fontSizeComboBox.setEditable(true);
        this.fontSizeComboBox.setFont(new Font("Dialog", 0, 10));
        this.fontSizeComboBox.setPreferredSize(new Dimension(60, 24));
        this.fontSizeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditCardPanel.this.fontSizeComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.fontPanel.add((Component)this.fontSizeComboBox, gridBagConstraints);
        this.boldToggleButton.setText(bundle.getString("Bold_Mnemonic"));
        this.boldToggleButton.setToolTipText(bundle.getString("Bold"));
        this.boldToggleButton.setMargin(new Insets(2, 0, 2, 0));
        this.boldToggleButton.setPreferredSize(new Dimension(26, 26));
        this.boldToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditCardPanel.this.boldToggleButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.fontPanel.add((Component)this.boldToggleButton, gridBagConstraints);
        this.italicToggleButton.setFont(new Font("Dialog", 3, 12));
        this.italicToggleButton.setText(bundle.getString("Italic_Mnemonic"));
        this.italicToggleButton.setToolTipText(bundle.getString("Italic"));
        this.italicToggleButton.setMargin(new Insets(2, 0, 2, 0));
        this.italicToggleButton.setPreferredSize(new Dimension(26, 26));
        this.italicToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditCardPanel.this.italicToggleButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.fontPanel.add((Component)this.italicToggleButton, gridBagConstraints);
        this.foregroundButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/foreground.png")));
        this.foregroundButton.setToolTipText(bundle.getString("Font_Color"));
        this.foregroundButton.setFocusPainted(false);
        this.foregroundButton.setMargin(new Insets(0, 0, 0, 0));
        this.foregroundButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditCardPanel.this.foregroundButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.fontPanel.add((Component)this.foregroundButton, gridBagConstraints);
        this.backgroundButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/background.png")));
        this.backgroundButton.setToolTipText(bundle.getString("Background_Color"));
        this.backgroundButton.setFocusPainted(false);
        this.backgroundButton.setMargin(new Insets(0, 0, 0, 0));
        this.backgroundButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditCardPanel.this.backgroundButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.fontPanel.add((Component)this.backgroundButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.fontPanel, gridBagConstraints);
        this.splitPane.setResizeWeight(0.5);
        this.splitPane.setContinuousLayout(true);
        this.frontSidePanel.setLayout(new GridBagLayout());
        this.frontSideLabel.setFont(new Font("Dialog", 0, 10));
        this.frontSideLabel.setText(bundle.getString("Card_Frontside"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.frontSidePanel.add((Component)this.frontSideLabel, gridBagConstraints);
        this.frontSideTextArea.setComponentPopupMenu(this.textAreaPopupMenu);
        this.frontSideTextArea.setWrapStyleWord(true);
        this.frontSideTextArea.setName("frontSideTextArea");
        this.frontSideTextArea.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent evt) {
                EditCardPanel.this.frontSideTextAreaCaretUpdate(evt);
            }
        });
        this.frontSideTextArea.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                EditCardPanel.this.frontSideTextAreaFocusGained(evt);
            }
        });
        this.frontSideScrollPane.setViewportView(this.frontSideTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.frontSidePanel.add((Component)this.frontSideScrollPane, gridBagConstraints);
        this.splitPane.setLeftComponent(this.frontSidePanel);
        this.reverseSidePanel.setLayout(new GridBagLayout());
        this.reverseSideLabel.setFont(new Font("Dialog", 0, 10));
        this.reverseSideLabel.setText(bundle.getString("Card_ReverseSide"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.reverseSidePanel.add((Component)this.reverseSideLabel, gridBagConstraints);
        this.reverseSideTextArea.setComponentPopupMenu(this.textAreaPopupMenu);
        this.reverseSideTextArea.setWrapStyleWord(true);
        this.reverseSideTextArea.setName("reverseSideTextArea");
        this.reverseSideTextArea.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent evt) {
                EditCardPanel.this.reverseSideTextAreaCaretUpdate(evt);
            }
        });
        this.reverseSideTextArea.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                EditCardPanel.this.reverseSideTextAreaFocusGained(evt);
            }
        });
        this.reverseSideScrollPane.setViewportView(this.reverseSideTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.reverseSidePanel.add((Component)this.reverseSideScrollPane, gridBagConstraints);
        this.splitPane.setRightComponent(this.reverseSidePanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.splitPane, gridBagConstraints);
        this.jLabel1.setFont(new Font("Dialog", 0, 10));
        this.jLabel1.setText(bundle.getString("Repeating_Method_Colon"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.repeatingMethodComboBox.setFont(new Font("Dialog", 0, 10));
        this.repeatingMethodComboBox.setName("repeatingMethodComboBox");
        this.repeatingMethodComboBox.setRenderer(new MyListCellRenderer());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.repeatingMethodComboBox, gridBagConstraints);
    }

    private void clearMenuItemActionPerformed(ActionEvent evt) {
        JTextArea textArea = (JTextArea)this.textAreaPopupMenu.getInvoker();
        textArea.setText(null);
    }

    private void selectAllMenuItemActionPerformed(ActionEvent evt) {
        JTextArea textArea = (JTextArea)this.textAreaPopupMenu.getInvoker();
        textArea.selectAll();
    }

    private void redoMenuItemActionPerformed(ActionEvent evt) {
        this.redo();
    }

    private void undoMenuItemActionPerformed(ActionEvent evt) {
        this.undo();
    }

    private void pasteMenuItemActionPerformed(ActionEvent evt) {
        JTextArea textArea = (JTextArea)this.textAreaPopupMenu.getInvoker();
        textArea.paste();
    }

    private void copyMenuItemActionPerformed(ActionEvent evt) {
        JTextArea textArea = (JTextArea)this.textAreaPopupMenu.getInvoker();
        textArea.copy();
    }

    private void cutMenuItemActionPerformed(ActionEvent evt) {
        JTextArea textArea = (JTextArea)this.textAreaPopupMenu.getInvoker();
        textArea.cut();
    }

    private void caretUpdate(CaretEvent evt) {
        boolean selection = evt.getDot() != evt.getMark();
        this.cutButton.setEnabled(selection);
        this.copyButton.setEnabled(selection);
        this.cutMenuItem.setEnabled(selection);
        this.copyMenuItem.setEnabled(selection);
    }

    private void reverseSideTextAreaCaretUpdate(CaretEvent evt) {
        this.caretUpdate(evt);
    }

    private void reverseSideTextAreaFocusGained(FocusEvent evt) {
        lastFocusSide = Card.Element.REVERSE_SIDE;
        this.setFontElements(this.reverseSideTextArea);
    }

    private void frontSideTextAreaCaretUpdate(CaretEvent evt) {
        this.caretUpdate(evt);
    }

    private void frontSideTextAreaFocusGained(FocusEvent evt) {
        lastFocusSide = Card.Element.FRONT_SIDE;
        this.setFontElements(this.frontSideTextArea);
    }

    private void leftToRightToggleButtonItemStateChanged(ItemEvent evt) {
        if (this.leftToRightToggleButton.isSelected()) {
            if (lastFocusSide == Card.Element.FRONT_SIDE) {
                this.frontSideTextArea.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            } else {
                this.reverseSideTextArea.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            }
        }
        this.restoreFocus();
    }

    private void rightToLeftToggleButtonItemStateChanged(ItemEvent evt) {
        if (this.rightToLeftToggleButton.isSelected()) {
            if (lastFocusSide == Card.Element.FRONT_SIDE) {
                this.frontSideTextArea.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            } else {
                this.reverseSideTextArea.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            }
        }
        this.restoreFocus();
    }

    private void switchLayoutButtonActionPerformed(ActionEvent evt) {
        if (this.splitPane.getOrientation() == 1) {
            this.setSplitOrientation(0);
        } else {
            this.setSplitOrientation(1);
        }
    }

    private void backgroundButtonActionPerformed(ActionEvent evt) {
        Color background = JColorChooser.showDialog(this, PaukerFrame.strings.getString("Choose_Background_Color"), Color.white);
        if (background != null) {
            if (lastFocusSide == Card.Element.FRONT_SIDE) {
                this.frontSideTextArea.setBackground(background);
            } else {
                this.reverseSideTextArea.setBackground(background);
            }
        }
        this.restoreFocus();
    }

    private void foregroundButtonActionPerformed(ActionEvent evt) {
        Color foreground = JColorChooser.showDialog(this, PaukerFrame.strings.getString("Choose_Font_Color"), Color.black);
        if (foreground != null) {
            if (lastFocusSide == Card.Element.FRONT_SIDE) {
                this.frontSideTextArea.setForeground(foreground);
            } else {
                this.reverseSideTextArea.setForeground(foreground);
            }
        }
        this.restoreFocus();
    }

    private void italicToggleButtonActionPerformed(ActionEvent evt) {
        if (lastFocusSide == Card.Element.FRONT_SIDE) {
            this.setFontStyle(2, this.italicToggleButton.isSelected(), this.frontSideTextArea);
        } else {
            this.setFontStyle(2, this.italicToggleButton.isSelected(), this.reverseSideTextArea);
        }
        this.restoreFocus();
    }

    private void boldToggleButtonActionPerformed(ActionEvent evt) {
        if (lastFocusSide == Card.Element.FRONT_SIDE) {
            this.setFontStyle(1, this.boldToggleButton.isSelected(), this.frontSideTextArea);
        } else {
            this.setFontStyle(1, this.boldToggleButton.isSelected(), this.reverseSideTextArea);
        }
        this.restoreFocus();
    }

    private void fontSizeComboBoxActionPerformed(ActionEvent evt) {
        if (lastFocusSide == Card.Element.FRONT_SIDE) {
            this.changeFontSize(this.frontSideTextArea);
        } else {
            this.changeFontSize(this.reverseSideTextArea);
        }
        this.restoreFocus();
    }

    private void fontComboBoxActionPerformed(ActionEvent evt) {
        if (lastFocusSide == Card.Element.FRONT_SIDE) {
            this.changeFont(this.frontSideTextArea);
        } else {
            this.changeFont(this.reverseSideTextArea);
        }
        this.restoreFocus();
    }

    private void popupListMouseExited(MouseEvent evt) {
        this.scrollTimer.stop();
    }

    private void popupListMouseClicked(MouseEvent evt) {
        Point point = evt.getPoint();
        int index = this.popupList.locationToIndex(point);
        Component invoker = this.popupMenu.getInvoker();
        if (invoker == this.undoButtonPanel) {
            this.undoManager.undoTo(index);
        } else {
            this.undoManager.redoTo(index);
        }
        this.updateUndoRedoButtons();
        this.popupMenu.setVisible(false);
        this.scrollTimer.stop();
        this.restoreFocus();
    }

    private void popupListMouseMoved(MouseEvent evt) {
        this.lastMousePoint = evt.getPoint();
        this.updatePopup();
        Rectangle viewRectangle = this.popupScrollPane.getViewport().getViewRect();
        int uppderDiff = this.lastMousePoint.y - viewRectangle.y;
        if (uppderDiff < 15) {
            this.scrollIncrement = uppderDiff - 15;
            this.scrollTimer.start();
        } else {
            int lowerDiff = viewRectangle.y + viewRectangle.height - this.lastMousePoint.y;
            if (lowerDiff < 15) {
                this.scrollIncrement = 15 - lowerDiff;
                this.scrollTimer.start();
            } else {
                this.scrollTimer.stop();
            }
        }
    }

    private void redoListButtonActionPerformed(ActionEvent evt) {
        this.showPopup(this.redoButtonPanel, this.undoManager.getRedoPresentations());
    }

    private void undoListButtonActionPerformed(ActionEvent evt) {
        this.showPopup(this.undoButtonPanel, this.undoManager.getUndoPresentations());
    }

    private void tabButtonActionPerformed(ActionEvent evt) {
        this.insertTabAction.actionPerformed(new ActionEvent(this.tabButton, 1001, "TabInsert"));
        this.restoreFocus();
    }

    private void cutButtonActionPerformed(ActionEvent evt) {
        this.cutAction.actionPerformed(new ActionEvent(this.cutButton, 1001, "Cut"));
        this.cutButton.setEnabled(false);
        this.copyButton.setEnabled(false);
        this.restoreFocus();
    }

    private void copyButtonActionPerformed(ActionEvent evt) {
        this.copyAction.actionPerformed(new ActionEvent(this.copyButton, 1001, "Copy"));
        this.restoreFocus();
    }

    private void pasteButtonActionPerformed(ActionEvent evt) {
        this.pasteAction.actionPerformed(new ActionEvent(this.pasteButton, 1001, "Paste"));
        this.restoreFocus();
    }

    private void undoButtonActionPerformed(ActionEvent evt) {
        this.undo();
    }

    private void redoButtonActionPerformed(ActionEvent evt) {
        this.redo();
    }

    private void redo() {
        try {
            this.undoManager.redo();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateUndoRedoButtons();
        this.restoreFocus();
    }

    private void undo() {
        try {
            this.undoManager.undo();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateUndoRedoButtons();
        this.restoreFocus();
    }

    private void documentChanged(DocumentEvent documentEvent) {
        lastFocusSide = documentEvent.getDocument() == this.frontSideDocument ? Card.Element.FRONT_SIDE : Card.Element.REVERSE_SIDE;
    }

    private void setFontStyle(int style, boolean setStyle, JTextComponent textComponent) {
        Font oldFont = textComponent.getFont();
        int newStyle = oldFont.getStyle();
        newStyle = setStyle ? (newStyle += style) : (newStyle -= style);
        Font newFont = oldFont.deriveFont(newStyle);
        textComponent.setFont(newFont);
    }

    private void changeFontSize(JTextComponent textComponent) {
        int fontSize = (Integer)this.fontSizeComboBox.getSelectedItem();
        Font oldFont = textComponent.getFont();
        Font newFont = oldFont.deriveFont((float)fontSize);
        textComponent.setFont(newFont);
    }

    private void changeFont(JTextComponent textComponent) {
        Font oldFont = textComponent.getFont();
        int fontSize = oldFont.getSize();
        int fontStyle = oldFont.getStyle();
        String fontFamilyName = (String)this.fontComboBox.getSelectedItem();
        Font font = new Font(fontFamilyName, fontStyle, fontSize);
        textComponent.setFont(font);
    }

    private void showPopup(JPanel panel, List presentations) {
        Object[] presentationArray = presentations.toArray();
        this.popupList.setListData(presentationArray);
        int presentationCounter = presentationArray.length;
        String counterString = null;
        if (presentationCounter == 1) {
            counterString = "1 " + PaukerFrame.strings.getString("Nr_Of_Action_Sng");
        } else {
            counterString = PaukerFrame.strings.getString("Nr_Of_Action_Pl");
            counterString = MessageFormat.format(counterString, presentationCounter);
        }
        this.undoCounterLabel.setText(counterString);
        Dimension panelSize = panel.getSize();
        this.popupMenu.setPreferredSize(null);
        Dimension popupSize = this.popupMenu.getPreferredSize();
        popupSize.width += 30;
        this.popupMenu.setPreferredSize(popupSize);
        Point popupLocation = new Point(panelSize.width - popupSize.width, panelSize.height);
        this.popupScrollPane.getVerticalScrollBar().setValue(0);
        this.popupMenu.show(panel, popupLocation.x, popupLocation.y);
    }

    private void updatePopup() {
        int index = this.popupList.locationToIndex(this.lastMousePoint);
        this.popupList.setSelectionInterval(0, index);
        String counterString = null;
        int counter = this.popupList.getModel().getSize();
        if (counter == 1) {
            counterString = "1/1 " + PaukerFrame.strings.getString("Nr_Of_Action_Sng");
        } else {
            counterString = PaukerFrame.strings.getString("Nr_Of_Action_Pl");
            counterString = MessageFormat.format(counterString, index + 1 + "/" + counter);
        }
        this.undoCounterLabel.setText(counterString);
    }

    private void setFontElements(JTextComponent textComponent) {
        Font font = textComponent.getFont();
        this.fontComboBox.setSelectedItem(font.getFamily());
        this.fontSizeComboBox.setSelectedItem(font.getSize());
        this.boldToggleButton.setSelected(font.isBold());
        this.italicToggleButton.setSelected(font.isItalic());
        if (textComponent.getComponentOrientation().isLeftToRight()) {
            this.leftToRightToggleButton.setSelected(true);
        } else {
            this.rightToLeftToggleButton.setSelected(true);
        }
    }

    private void restoreFocus() {
        if (lastFocusSide == Card.Element.FRONT_SIDE) {
            this.frontSideTextArea.requestFocusInWindow();
        } else {
            this.reverseSideTextArea.requestFocusInWindow();
        }
    }

    private static class MyListCellRenderer
    implements ListCellRenderer {
        private MyListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)value;
            if (isSelected) {
                label.setBackground(list.getSelectionBackground());
                label.setForeground(list.getSelectionForeground());
            } else {
                label.setBackground(list.getBackground());
                label.setForeground(list.getForeground());
            }
            return label;
        }
    }
}

