/*
 * Decompiled with CFR 0.152.
 */
package pauker.program.gui.swing;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.DateFormat;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableColumnModel;
import org.jdesktop.layout.GroupLayout;
import pauker.program.Lesson;
import pauker.program.Pauker;
import pauker.program.gui.swing.StatisticTableCellRenderer;
import pauker.program.gui.swing.StatisticTableModel;

public class FileChooserAccessory
extends JPanel
implements PropertyChangeListener {
    private final ResourceBundle strings = ResourceBundle.getBundle("pauker/Strings");
    private final Lesson emptyLesson = new Lesson();
    private final DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
    private final StatisticTableModel statisticTableModel;
    private String encoding;
    private CardLayout cardLayout;
    private JPanel lessonPanel;
    private JLabel nextExpirationLabel;
    private JTextField nextExpirationTextField;
    private JLabel noLessonLabel;
    private JPanel noLessonPanel;
    private JScrollPane statisticScrollPane;
    private JTable statisticTable;

    public FileChooserAccessory() {
        this.initComponents();
        this.cardLayout = (CardLayout)this.getLayout();
        this.statisticTableModel = new StatisticTableModel(this.emptyLesson, this.statisticTable, new Dimension(400, 400));
        StatisticTableCellRenderer statisticTableCellRenderer = new StatisticTableCellRenderer();
        TableColumnModel statisticTableColumnModel = this.statisticTable.getColumnModel();
        statisticTableColumnModel.getColumn(0).setCellRenderer(statisticTableCellRenderer);
        statisticTableColumnModel.getColumn(1).setCellRenderer(statisticTableCellRenderer);
        statisticTableColumnModel.getColumn(2).setCellRenderer(statisticTableCellRenderer);
        this.setLesson(this.emptyLesson);
        Dimension preferredSize = this.getPreferredSize();
        this.setPreferredSize(preferredSize);
    }

    private void initComponents() {
        this.noLessonPanel = new JPanel();
        this.noLessonLabel = new JLabel();
        this.lessonPanel = new JPanel();
        this.statisticScrollPane = new JScrollPane();
        this.statisticTable = new JTable();
        this.nextExpirationLabel = new JLabel();
        this.nextExpirationTextField = new JTextField();
        this.setLayout(new CardLayout());
        this.noLessonPanel.setLayout(new GridBagLayout());
        this.noLessonPanel.setName("noLessonPanel");
        ResourceBundle bundle = ResourceBundle.getBundle("pauker/Strings");
        this.noLessonLabel.setText(bundle.getString("Not_A_Pauker_Lesson"));
        this.noLessonPanel.add((Component)this.noLessonLabel, new GridBagConstraints());
        this.add((Component)this.noLessonPanel, "noLessonPanel");
        this.lessonPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("Statistics")));
        this.lessonPanel.setName("lessonPanel");
        this.statisticTable.setRowSelectionAllowed(false);
        this.statisticScrollPane.setViewportView(this.statisticTable);
        this.nextExpirationLabel.setText(bundle.getString("Next_Expiration"));
        this.nextExpirationTextField.setEditable(false);
        GroupLayout lessonPanelLayout = new GroupLayout(this.lessonPanel);
        this.lessonPanel.setLayout(lessonPanelLayout);
        lessonPanelLayout.setHorizontalGroup(lessonPanelLayout.createParallelGroup(1).add(2, lessonPanelLayout.createSequentialGroup().addContainerGap().add(this.nextExpirationLabel).addPreferredGap(0).add(this.nextExpirationTextField, -1, 163, Short.MAX_VALUE).addContainerGap()).add(this.statisticScrollPane, -1, 294, Short.MAX_VALUE));
        lessonPanelLayout.setVerticalGroup(lessonPanelLayout.createParallelGroup(1).add(2, lessonPanelLayout.createSequentialGroup().add(this.statisticScrollPane, -1, 237, Short.MAX_VALUE).addPreferredGap(0).add(lessonPanelLayout.createParallelGroup(3).add(this.nextExpirationLabel).add(this.nextExpirationTextField, -2, -1, -2)).addContainerGap()));
        this.add((Component)this.lessonPanel, "lessonPanel");
    }

    public void setLesson(Lesson newLesson) {
        this.cardLayout.show(this, "lessonPanel");
        newLesson.refreshExpiration();
        newLesson.trim();
        long nextExpirationDate = newLesson.getNextExpirationTime();
        if (nextExpirationDate == Long.MAX_VALUE) {
            this.setExpirationDateVisible(false);
        } else {
            String nextExpirationDateString = this.dateFormat.format(nextExpirationDate);
            this.nextExpirationTextField.setText(nextExpirationDateString);
            this.setExpirationDateVisible(true);
        }
        this.statisticTableModel.setLesson(newLesson);
    }

    public void setNoPaukerLessonSelected() {
        this.cardLayout.show(this, "noLessonPanel");
        this.noLessonLabel.setText(this.strings.getString("Not_A_Pauker_Lesson"));
    }

    public void setNoFileSelected() {
        this.cardLayout.show(this, "noLessonPanel");
        this.noLessonLabel.setText(this.strings.getString("No_File_Selected"));
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    private void setExpirationDateVisible(boolean visible) {
        this.nextExpirationLabel.setVisible(visible);
        this.nextExpirationTextField.setVisible(visible);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String property = propertyChangeEvent.getPropertyName();
        if (property.equals("SelectedFileChangedProperty")) {
            try {
                File selectedFile = (File)propertyChangeEvent.getNewValue();
                if (selectedFile == null || !selectedFile.exists()) {
                    this.setNoFileSelected();
                } else {
                    String path = selectedFile.getPath();
                    Lesson newLesson = Pauker.openLesson(path, this.encoding);
                    this.setLesson(newLesson);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.setNoPaukerLessonSelected();
            }
        }
    }
}

