/*
 * Decompiled with CFR 0.152.
 */
package pauker.program.gui.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import pauker.program.Card;
import pauker.program.gui.swing.PaukerFrame;

public class SearchDialog
extends JDialog {
    private PaukerFrame paukerFrame;
    private JPanel searchArea;
    private static final int additionalDistance = 10;
    private String oldSearchPattern = "";
    private JRadioButton backRadioButton;
    private JRadioButton backwardRadioButton;
    private JRadioButton bothRadioButton;
    private JButton cancelButton;
    private ButtonGroup directionButtonGroup;
    private JRadioButton forwardRadioButton;
    private JRadioButton frontRadioButton;
    private JCheckBox matchCaseCheckBox;
    private JTextField patternField;
    private JLabel patternLabel;
    private JPanel radioButtonPanel;
    private JButton searchButton;
    private ButtonGroup sideButtonGroup;
    private JLabel statusLabel;

    public SearchDialog(PaukerFrame paukerFrame, JPanel searchArea) {
        super((Frame)paukerFrame, false);
        this.paukerFrame = paukerFrame;
        this.searchArea = searchArea;
        this.initComponents();
        this.pack();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.setLocationRelativeTo(this.paukerFrame);
            Point location = this.getLocation();
            Dimension size = this.getSize();
            Point searchAreaLocation = this.searchArea.getLocationOnScreen();
            if (searchAreaLocation.x > size.width) {
                location.x = searchAreaLocation.x - size.width - 10;
            } else {
                Dimension searchAreaDimension = this.searchArea.getSize();
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                int rightSpace = screenSize.width - searchAreaLocation.x - searchAreaDimension.width;
                if (rightSpace > size.width) {
                    location.x = searchAreaLocation.x + searchAreaDimension.width + 10;
                } else if (searchAreaLocation.y > size.height) {
                    location.y = searchAreaLocation.y - size.height - 10;
                } else {
                    int lowerSpace = screenSize.height - searchAreaLocation.y - searchAreaDimension.height;
                    if (lowerSpace > size.height) {
                        location.y = searchAreaLocation.y + searchAreaDimension.height + 10;
                    } else {
                        location.x = 0;
                    }
                }
            }
            this.setLocation(location);
        }
        super.setVisible(visible);
    }

    private void initComponents() {
        this.sideButtonGroup = new ButtonGroup();
        this.directionButtonGroup = new ButtonGroup();
        this.patternLabel = new JLabel();
        this.patternField = new JTextField();
        this.searchButton = new JButton();
        this.radioButtonPanel = new JPanel();
        this.bothRadioButton = new JRadioButton();
        this.forwardRadioButton = new JRadioButton();
        this.frontRadioButton = new JRadioButton();
        this.backwardRadioButton = new JRadioButton();
        this.backRadioButton = new JRadioButton();
        this.matchCaseCheckBox = new JCheckBox();
        this.cancelButton = new JButton();
        this.statusLabel = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle(ResourceBundle.getBundle("pauker/Strings").getString("Search"));
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                SearchDialog.this.formComponentShown(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                SearchDialog.this.closeDialog(evt);
            }

            public void windowActivated(WindowEvent evt) {
                SearchDialog.this.formWindowActivated(evt);
            }
        });
        this.patternLabel.setText(ResourceBundle.getBundle("pauker/Strings").getString("Pattern"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.getContentPane().add((Component)this.patternLabel, gridBagConstraints);
        this.patternField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchDialog.this.patternFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.getContentPane().add((Component)this.patternField, gridBagConstraints);
        this.searchButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/filefind.png")));
        this.searchButton.setText(ResourceBundle.getBundle("pauker/Strings").getString("Search"));
        this.searchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchDialog.this.searchButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.getContentPane().add((Component)this.searchButton, gridBagConstraints);
        this.radioButtonPanel.setLayout(new GridBagLayout());
        this.sideButtonGroup.add(this.bothRadioButton);
        this.bothRadioButton.setSelected(true);
        this.bothRadioButton.setText(ResourceBundle.getBundle("pauker/Strings").getString("Both_Sides"));
        this.bothRadioButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SearchDialog.this.bothRadioButtonItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 17;
        this.radioButtonPanel.add((Component)this.bothRadioButton, gridBagConstraints);
        this.directionButtonGroup.add(this.forwardRadioButton);
        this.forwardRadioButton.setSelected(true);
        this.forwardRadioButton.setText(ResourceBundle.getBundle("pauker/Strings").getString("Forward"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.radioButtonPanel.add((Component)this.forwardRadioButton, gridBagConstraints);
        this.sideButtonGroup.add(this.frontRadioButton);
        this.frontRadioButton.setText(ResourceBundle.getBundle("pauker/Strings").getString("Frontside"));
        this.frontRadioButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SearchDialog.this.frontRadioButtonItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 17;
        this.radioButtonPanel.add((Component)this.frontRadioButton, gridBagConstraints);
        this.directionButtonGroup.add(this.backwardRadioButton);
        this.backwardRadioButton.setText(ResourceBundle.getBundle("pauker/Strings").getString("Backward"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.radioButtonPanel.add((Component)this.backwardRadioButton, gridBagConstraints);
        this.sideButtonGroup.add(this.backRadioButton);
        this.backRadioButton.setText(ResourceBundle.getBundle("pauker/Strings").getString("Reverse_Side"));
        this.backRadioButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SearchDialog.this.backRadioButtonItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 17;
        this.radioButtonPanel.add((Component)this.backRadioButton, gridBagConstraints);
        this.matchCaseCheckBox.setText(ResourceBundle.getBundle("pauker/Strings").getString("Match_Case"));
        this.matchCaseCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SearchDialog.this.matchCaseCheckBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.radioButtonPanel.add((Component)this.matchCaseCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.getContentPane().add((Component)this.radioButtonPanel, gridBagConstraints);
        this.cancelButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/stop.png")));
        this.cancelButton.setText(ResourceBundle.getBundle("pauker/Strings").getString("Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.getContentPane().add((Component)this.cancelButton, gridBagConstraints);
        this.statusLabel.setText("  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.statusLabel, gridBagConstraints);
    }

    private void formComponentShown(ComponentEvent evt) {
        this.statusLabel.setText(" ");
        this.patternField.selectAll();
        this.pack();
    }

    private void formWindowActivated(WindowEvent evt) {
        this.patternField.requestFocusInWindow();
    }

    private void backRadioButtonItemStateChanged(ItemEvent evt) {
        this.paukerFrame.setSearchCardSide(Card.Element.REVERSE_SIDE);
    }

    private void bothRadioButtonItemStateChanged(ItemEvent evt) {
        this.paukerFrame.setSearchCardSide(Card.Element.BOTH_SIDES);
    }

    private void frontRadioButtonItemStateChanged(ItemEvent evt) {
        this.paukerFrame.setSearchCardSide(Card.Element.FRONT_SIDE);
    }

    private void matchCaseCheckBoxItemStateChanged(ItemEvent evt) {
        this.paukerFrame.setMatchCase(this.matchCaseCheckBox.isSelected());
    }

    private void patternFieldActionPerformed(ActionEvent evt) {
        this.search();
    }

    private void searchButtonActionPerformed(ActionEvent evt) {
        this.search();
    }

    private void search() {
        String searchPattern = this.patternField.getText();
        boolean stringFound = false;
        if (this.oldSearchPattern.equals(searchPattern)) {
            stringFound = this.paukerFrame.continueSearch(this.forwardRadioButton.isSelected());
        } else {
            Card.Element cardSide = Card.Element.REVERSE_SIDE;
            if (this.bothRadioButton.isSelected()) {
                cardSide = Card.Element.BOTH_SIDES;
            } else if (this.frontRadioButton.isSelected()) {
                cardSide = Card.Element.FRONT_SIDE;
            }
            stringFound = this.paukerFrame.search(searchPattern, cardSide, this.matchCaseCheckBox.isSelected(), this.forwardRadioButton.isSelected());
            this.oldSearchPattern = searchPattern;
        }
        if (stringFound) {
            this.statusLabel.setText(" ");
        } else {
            String statusMessage = PaukerFrame.strings.getString("String_Not_Found");
            statusMessage = MessageFormat.format(statusMessage, searchPattern);
            this.statusLabel.setText(statusMessage);
            this.statusLabel.setForeground(Color.red);
        }
        this.patternField.requestFocusInWindow();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.quit();
    }

    private void closeDialog(WindowEvent evt) {
        this.quit();
    }

    private void quit() {
        this.setVisible(false);
        this.dispose();
        this.oldSearchPattern = "";
        this.paukerFrame.stopSearching();
    }
}

