/*
 * Decompiled with CFR 0.152.
 */
package pauker.program.gui.swing;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pauker.program.Pauker;
import pauker.program.gui.swing.PaukerFrame;

public class SettingsDialog
extends JDialog {
    private CardLayout cardLayout;
    private int ustmTime;
    private int stmTime;
    private int searchLimit;
    private boolean okPressed;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JPanel cardPanel;
    private JCheckBox caseCheckBox;
    private JButton defaultButton;
    private JSeparator jSeparator1;
    private JList menuList;
    private JScrollPane menuScrollPane;
    private JPanel miscPanel;
    private JButton okButton;
    private JCheckBox playRingToneCheckBox;
    private JRadioButton putBackBottomRadioButton;
    private JPanel putBackPanel;
    private JRadioButton putBackRandomRadioButton;
    private ButtonGroup putBackStrategyButtonGroup;
    private JRadioButton putBackTopRadioButton;
    private JRadioButton repeatNewestFirstRadioButton;
    private JRadioButton repeatOldestFirstRadioButton;
    private JRadioButton repeatRandomRadioButton;
    private JPanel repeatingPanel;
    private ButtonGroup repeatingStrategyButtonGroup;
    private JLabel searchLimitLabel;
    private JTextField searchLimitTextField;
    private JLabel stmLabel;
    private JTextField stmTextField;
    private JLabel stmUnitLabel;
    private JPanel strategyPanel;
    private JPanel timePanel;
    private JLabel ustmLabel;
    private JTextField ustmTextField;
    private JLabel ustmUnitLabel;
    private JCheckBox wordWrapCheckBox;

    public SettingsDialog(PaukerFrame paukerFrame) {
        super((Frame)paukerFrame, true);
        this.initComponents();
        this.cardLayout = (CardLayout)this.cardPanel.getLayout();
        DefaultListModel<String> menuListmodel = new DefaultListModel<String>();
        menuListmodel.addElement(PaukerFrame.strings.getString("Strategies"));
        menuListmodel.addElement(PaukerFrame.strings.getString("Times"));
        menuListmodel.addElement(PaukerFrame.strings.getString("Misc"));
        this.menuList.setModel(menuListmodel);
        this.menuList.setCellRenderer(new MyListCellRenderer());
        this.menuList.setSelectedIndex(0);
        int scrollPaneHeight = this.menuList.getCellBounds((int)0, (int)(this.menuList.getModel().getSize() - 1)).height;
        Dimension preferredScrollPaneSize = this.menuScrollPane.getPreferredSize();
        preferredScrollPaneSize.height = scrollPaneHeight + 10;
        this.menuScrollPane.setPreferredSize(preferredScrollPaneSize);
        this.menuScrollPane.setMinimumSize(preferredScrollPaneSize);
        switch (paukerFrame.getRepeatingStrategy()) {
            case OLDEST_FIRST: {
                this.repeatOldestFirstRadioButton.setSelected(true);
                break;
            }
            case NEWEST_FIRST: {
                this.repeatNewestFirstRadioButton.setSelected(true);
                break;
            }
            case RANDOM_ORDER: {
                this.repeatRandomRadioButton.setSelected(true);
            }
        }
        switch (paukerFrame.getPutBackStrategy()) {
            case ON_TOP: {
                this.putBackTopRadioButton.setSelected(true);
                break;
            }
            case AT_BOTTOM: {
                this.putBackBottomRadioButton.setSelected(true);
                break;
            }
            case ANYWHERE: {
                this.putBackRandomRadioButton.setSelected(true);
            }
        }
        this.ustmTextField.setText(String.valueOf(paukerFrame.getUstmTime()));
        this.stmTextField.setText(String.valueOf(paukerFrame.getStmTime() / 60));
        this.caseCheckBox.setSelected(paukerFrame.isMatchCase());
        this.wordWrapCheckBox.setSelected(paukerFrame.isLineWrapping());
        this.searchLimitTextField.setText(String.valueOf(paukerFrame.getSearchLimit()));
        this.playRingToneCheckBox.setSelected(paukerFrame.isPlayRingTone());
        this.pack();
        this.setLocationRelativeTo(paukerFrame);
    }

    public boolean okPressed() {
        return this.okPressed;
    }

    public Pauker.RepeatingStrategy getRepeatingStrategy() {
        if (this.repeatNewestFirstRadioButton.isSelected()) {
            return Pauker.RepeatingStrategy.NEWEST_FIRST;
        }
        if (this.repeatOldestFirstRadioButton.isSelected()) {
            return Pauker.RepeatingStrategy.OLDEST_FIRST;
        }
        return Pauker.RepeatingStrategy.RANDOM_ORDER;
    }

    public Pauker.PutbackStrategy getPutBackStrategy() {
        if (this.putBackTopRadioButton.isSelected()) {
            return Pauker.PutbackStrategy.ON_TOP;
        }
        if (this.putBackBottomRadioButton.isSelected()) {
            return Pauker.PutbackStrategy.AT_BOTTOM;
        }
        return Pauker.PutbackStrategy.ANYWHERE;
    }

    public int getUSTMTime() {
        return this.ustmTime;
    }

    public int getSTMTime() {
        return this.stmTime * 60;
    }

    public boolean getMatchCase() {
        return this.caseCheckBox.isSelected();
    }

    public boolean getLineWrapping() {
        return this.wordWrapCheckBox.isSelected();
    }

    public int getSearchLimit() {
        return this.searchLimit;
    }

    public boolean getPlayRingTone() {
        return this.playRingToneCheckBox.isSelected();
    }

    private void initComponents() {
        this.repeatingStrategyButtonGroup = new ButtonGroup();
        this.putBackStrategyButtonGroup = new ButtonGroup();
        this.menuScrollPane = new JScrollPane();
        this.menuList = new JList();
        this.cardPanel = new JPanel();
        this.strategyPanel = new JPanel();
        this.repeatingPanel = new JPanel();
        this.repeatOldestFirstRadioButton = new JRadioButton();
        this.repeatNewestFirstRadioButton = new JRadioButton();
        this.repeatRandomRadioButton = new JRadioButton();
        this.putBackPanel = new JPanel();
        this.putBackTopRadioButton = new JRadioButton();
        this.putBackBottomRadioButton = new JRadioButton();
        this.putBackRandomRadioButton = new JRadioButton();
        this.timePanel = new JPanel();
        this.ustmLabel = new JLabel();
        this.ustmTextField = new JTextField();
        this.ustmUnitLabel = new JLabel();
        this.stmLabel = new JLabel();
        this.stmTextField = new JTextField();
        this.stmUnitLabel = new JLabel();
        this.defaultButton = new JButton();
        this.miscPanel = new JPanel();
        this.caseCheckBox = new JCheckBox();
        this.wordWrapCheckBox = new JCheckBox();
        this.searchLimitLabel = new JLabel();
        this.searchLimitTextField = new JTextField();
        this.playRingToneCheckBox = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("pauker/Strings");
        this.setTitle(bundle.getString("Settings"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                SettingsDialog.this.closeDialog(evt);
            }
        });
        this.menuList.setSelectionMode(0);
        this.menuList.setName("menuList");
        this.menuList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                SettingsDialog.this.menuListValueChanged(evt);
            }
        });
        this.menuScrollPane.setViewportView(this.menuList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.getContentPane().add((Component)this.menuScrollPane, gridBagConstraints);
        this.cardPanel.setLayout(new CardLayout());
        this.cardPanel.setBorder(BorderFactory.createEtchedBorder());
        this.strategyPanel.setLayout(new GridBagLayout());
        this.repeatingPanel.setLayout(new GridBagLayout());
        this.repeatingPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("Repeating_Strategy")));
        this.repeatingStrategyButtonGroup.add(this.repeatOldestFirstRadioButton);
        this.repeatOldestFirstRadioButton.setText(bundle.getString("Oldest_Cards_First"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.repeatingPanel.add((Component)this.repeatOldestFirstRadioButton, gridBagConstraints);
        this.repeatingStrategyButtonGroup.add(this.repeatNewestFirstRadioButton);
        this.repeatNewestFirstRadioButton.setText(bundle.getString("Newest_Cards_First"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.repeatingPanel.add((Component)this.repeatNewestFirstRadioButton, gridBagConstraints);
        this.repeatingStrategyButtonGroup.add(this.repeatRandomRadioButton);
        this.repeatRandomRadioButton.setText(bundle.getString("Random_Order"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 5, 10);
        this.repeatingPanel.add((Component)this.repeatRandomRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.strategyPanel.add((Component)this.repeatingPanel, gridBagConstraints);
        this.putBackPanel.setLayout(new GridBagLayout());
        this.putBackPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("Putback_Strategy")));
        this.putBackStrategyButtonGroup.add(this.putBackTopRadioButton);
        this.putBackTopRadioButton.setText(bundle.getString("On_Top"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.putBackPanel.add((Component)this.putBackTopRadioButton, gridBagConstraints);
        this.putBackStrategyButtonGroup.add(this.putBackBottomRadioButton);
        this.putBackBottomRadioButton.setText(bundle.getString("At_Bottom"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.putBackPanel.add((Component)this.putBackBottomRadioButton, gridBagConstraints);
        this.putBackStrategyButtonGroup.add(this.putBackRandomRadioButton);
        this.putBackRandomRadioButton.setText(bundle.getString("Anywhere"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 5, 10);
        this.putBackPanel.add((Component)this.putBackRandomRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.strategyPanel.add((Component)this.putBackPanel, gridBagConstraints);
        this.cardPanel.add((Component)this.strategyPanel, "strategyPanel");
        this.timePanel.setLayout(new GridBagLayout());
        this.ustmLabel.setHorizontalAlignment(2);
        this.ustmLabel.setText(bundle.getString("Ultra_Shortterm_Memory"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(15, 15, 0, 0);
        this.timePanel.add((Component)this.ustmLabel, gridBagConstraints);
        this.ustmTextField.setColumns(3);
        this.ustmTextField.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(15, 5, 0, 0);
        this.timePanel.add((Component)this.ustmTextField, gridBagConstraints);
        this.ustmUnitLabel.setText(bundle.getString("Seconds"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 5, 0, 10);
        this.timePanel.add((Component)this.ustmUnitLabel, gridBagConstraints);
        this.stmLabel.setHorizontalAlignment(2);
        this.stmLabel.setText(bundle.getString("Shortterm_Memory"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 15, 0, 0);
        this.timePanel.add((Component)this.stmLabel, gridBagConstraints);
        this.stmTextField.setColumns(3);
        this.stmTextField.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.timePanel.add((Component)this.stmTextField, gridBagConstraints);
        this.stmUnitLabel.setText(bundle.getString("Minutes"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 10);
        this.timePanel.add((Component)this.stmUnitLabel, gridBagConstraints);
        this.defaultButton.setText(bundle.getString("Default_Values"));
        this.defaultButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.defaultButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 15, 0, 0);
        this.timePanel.add((Component)this.defaultButton, gridBagConstraints);
        this.cardPanel.add((Component)this.timePanel, "timePanel");
        this.miscPanel.setLayout(new GridBagLayout());
        this.caseCheckBox.setText(bundle.getString("Match_Case"));
        this.caseCheckBox.setToolTipText(bundle.getString("Match_Case_Tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.miscPanel.add((Component)this.caseCheckBox, gridBagConstraints);
        this.wordWrapCheckBox.setText(bundle.getString("Use_Word_Wrapping"));
        this.wordWrapCheckBox.setToolTipText(bundle.getString("Use_Word_Wrapping_Tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.miscPanel.add((Component)this.wordWrapCheckBox, gridBagConstraints);
        this.searchLimitLabel.setText(bundle.getString("Search_Limit"));
        this.searchLimitLabel.setToolTipText(bundle.getString("Search_Limit_Tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.miscPanel.add((Component)this.searchLimitLabel, gridBagConstraints);
        this.searchLimitTextField.setToolTipText(bundle.getString("Search_Limit_Tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 5, 0, 10);
        this.miscPanel.add((Component)this.searchLimitTextField, gridBagConstraints);
        this.playRingToneCheckBox.setText(bundle.getString("Play_Ringtone"));
        this.playRingToneCheckBox.setToolTipText(bundle.getString("Play_Ringtone_Tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.miscPanel.add((Component)this.playRingToneCheckBox, gridBagConstraints);
        this.cardPanel.add((Component)this.miscPanel, "miscPanel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this.cardPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.okButton.setText(bundle.getString("OK"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        this.cancelButton.setText(bundle.getString("Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
    }

    private void defaultButtonActionPerformed(ActionEvent evt) {
        this.ustmTextField.setText(String.valueOf(18));
        this.stmTextField.setText(String.valueOf(12));
    }

    private void menuListValueChanged(ListSelectionEvent evt) {
        int index = this.menuList.getSelectedIndex();
        switch (index) {
            case 0: {
                this.cardLayout.show(this.cardPanel, "strategyPanel");
                break;
            }
            case 1: {
                this.cardLayout.show(this.cardPanel, "timePanel");
                break;
            }
            case 2: {
                this.cardLayout.show(this.cardPanel, "miscPanel");
            }
        }
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.ustmTime = this.getNumber(this.ustmTextField, 1, "Invalid_Time");
        if (this.ustmTime == -1) {
            return;
        }
        this.stmTime = this.getNumber(this.stmTextField, 1, "Invalid_Time");
        if (this.stmTime == -1) {
            return;
        }
        this.searchLimit = this.getNumber(this.searchLimitTextField, 2, "Invalid_Number");
        if (this.searchLimit == -1) {
            return;
        }
        this.okPressed = true;
        this.setVisible(false);
        this.dispose();
    }

    private int getNumber(JTextField textField, int menuIndex, String invalidString) {
        int time;
        String text = textField.getText();
        try {
            time = Integer.parseInt(text);
        }
        catch (Exception e) {
            this.menuList.setSelectedIndex(menuIndex);
            textField.requestFocusInWindow();
            String errorMessage = PaukerFrame.strings.getString(invalidString);
            errorMessage = MessageFormat.format(errorMessage, text);
            JOptionPane.showMessageDialog(this, errorMessage, PaukerFrame.strings.getString("Error"), 0);
            return -1;
        }
        if (time < 1) {
            this.menuList.setSelectedIndex(menuIndex);
            textField.requestFocusInWindow();
            String errorMessage = PaukerFrame.strings.getString("Number_Too_Small");
            JOptionPane.showMessageDialog(this, errorMessage, PaukerFrame.strings.getString("Error"), 0);
            return -1;
        }
        return time;
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class MyListCellRenderer
    extends DefaultListCellRenderer {
        private ImageIcon strategiesIcon = new ImageIcon(this.getClass().getResource("/pauker/icons/strategies.png"));
        private ImageIcon timesIcon = new ImageIcon(this.getClass().getResource("/pauker/icons/clock.png"));
        private ImageIcon miscIcon = new ImageIcon(this.getClass().getResource("/pauker/icons/misc.png"));

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            switch (index) {
                case 0: {
                    this.setIcon(this.strategiesIcon);
                    break;
                }
                case 1: {
                    this.setIcon(this.timesIcon);
                    break;
                }
                case 2: {
                    this.setIcon(this.miscIcon);
                }
            }
            this.setHorizontalTextPosition(0);
            this.setVerticalTextPosition(3);
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
            this.setBorder(new EmptyBorder(12, 4, 12, 4));
            return this;
        }
    }
}

