/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class PreferredSizesTableModel
extends DefaultTableModel {
    private JTable table;
    private Dimension maxDimension;
    private Dimension[][] dimensionCache;

    public PreferredSizesTableModel(JTable table, Dimension maxDimension) {
        this.table = table;
        this.maxDimension = maxDimension;
        table.setModel(this);
    }

    public void initSizes() {
        int columns = this.getColumnCount();
        int rows = this.getRowCount();
        this.dimensionCache = new Dimension[columns][rows + 1];
        this.updateHeaderDimensions();
        this.updateCellDimensions(0, rows - 1);
        this.resetTableColumnWidths();
        this.resetViewPortSize();
    }

    public void fireTableDataChanged() {
        super.fireTableDataChanged();
        int columns = this.getColumnCount();
        int rows = this.getRowCount();
        this.dimensionCache = new Dimension[columns][rows + 1];
        this.updateHeaderDimensions();
        this.updateCellDimensions(0, rows - 1);
        this.resetTableColumnWidths();
        this.resetViewPortSize();
    }

    private void updateHeaderDimensions() {
        TableColumnModel columnModel = this.table.getColumnModel();
        TableCellRenderer headerRenderer = this.table.getTableHeader().getDefaultRenderer();
        int columns = this.getColumnCount();
        for (int column = 0; column < columns; ++column) {
            Object headerValue = columnModel.getColumn(column).getHeaderValue();
            Component header = headerRenderer.getTableCellRendererComponent(this.table, headerValue, false, false, 0, column);
            this.dimensionCache[column][0] = header.getPreferredSize();
        }
    }

    private void updateCellDimensions(int firstRow, int lastRow) {
        TableColumnModel columnModel = this.table.getColumnModel();
        int columns = this.getColumnCount();
        for (int column = 0; column < columns; ++column) {
            TableCellRenderer renderer = columnModel.getColumn(column).getCellRenderer();
            if (renderer == null) {
                renderer = this.table.getDefaultRenderer(this.getColumnClass(column));
            }
            for (int row = firstRow; row <= lastRow; ++row) {
                Dimension cellSize;
                Object object = this.getValueAt(row, column);
                Component component = renderer.getTableCellRendererComponent(this.table, object, false, false, row, column);
                this.dimensionCache[column][row + 1] = cellSize = component.getPreferredSize();
            }
        }
        this.resetTableRowHeights(firstRow, lastRow);
    }

    private void resetTableRowHeights(int firstRow, int lastRow) {
        int[] maxHeights = new int[lastRow - firstRow + 1];
        int columns = this.getColumnCount();
        for (int column = 0; column < columns; ++column) {
            for (int row = firstRow; row <= lastRow; ++row) {
                Dimension cellDimension = this.dimensionCache[column][row + 1];
                int arrayIndex = row - firstRow;
                maxHeights[arrayIndex] = Math.max(maxHeights[arrayIndex], cellDimension.height);
            }
        }
        for (int row = firstRow; row <= lastRow; ++row) {
            this.table.setRowHeight(row, maxHeights[row - firstRow]);
        }
    }

    private void resetTableColumnWidths() {
        int rows = this.getRowCount();
        TableColumnModel columnModel = this.table.getColumnModel();
        int columns = this.getColumnCount();
        for (int column = 0; column < columns; ++column) {
            TableColumn tableColumn = columnModel.getColumn(column);
            int preferredColumnWidth = 0;
            for (int row = 0; row < rows + 1; ++row) {
                Dimension cellSize = this.dimensionCache[column][row];
                preferredColumnWidth = Math.max(preferredColumnWidth, cellSize.width);
            }
            tableColumn.setPreferredWidth(preferredColumnWidth + 5);
        }
    }

    private void resetViewPortSize() {
        int perfectTableWidth = 0;
        int perfectTableHeight = 0;
        int columns = this.getColumnCount();
        TableColumnModel columnModel = this.table.getColumnModel();
        for (int column = 0; column < columns; ++column) {
            perfectTableWidth += columnModel.getColumn(column).getPreferredWidth();
        }
        int rows = this.getRowCount();
        for (int row = 0; row < rows; ++row) {
            perfectTableHeight += this.table.getRowHeight(row);
        }
        perfectTableWidth = Math.min(perfectTableWidth + columns * 10, this.maxDimension.width);
        perfectTableHeight = Math.min(perfectTableHeight + 5, this.maxDimension.height);
        this.table.setPreferredScrollableViewportSize(new Dimension(perfectTableWidth, perfectTableHeight));
    }
}

