/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;
import pcgen.util.BigDecimalHelper;
import pcgen.util.Delta;
import pcgen.util.Logging;

public class ArmorToken
extends Token {
    public static final String TOKENNAME = "ARMOR";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String string, PlayerCharacter playerCharacter, ExportHandler exportHandler) {
        if (string.startsWith(TOKENNAME) && (string.charAt(5) == '.' || Character.isDigit(string.charAt(5)))) {
            return ArmorToken.getArmorToken(string, playerCharacter, exportHandler);
        }
        return "";
    }

    public static String getArmorToken(String string, PlayerCharacter playerCharacter, ExportHandler exportHandler) {
        return ArmorToken.replaceTokenArmor(string, playerCharacter, exportHandler);
    }

    private static String replaceTokenArmor(String string, PlayerCharacter playerCharacter, ExportHandler exportHandler) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        String string2 = "";
        if (stringArray.length > 0) {
            string2 = stringArray[stringArray.length - 1];
        }
        int n2 = 3;
        int n3 = 0;
        String string3 = "";
        String string4 = "";
        int n4 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (TOKENNAME.equals(stringArray[i])) continue;
            if (stringArray[i].startsWith(TOKENNAME)) {
                try {
                    n3 = Integer.parseInt(stringArray[i].substring(5));
                }
                catch (NumberFormatException numberFormatException) {
                    n3 = 0;
                }
                Logging.errorPrint((String)"Old syntax ARMORx will be replaced for ARMOR.x");
                continue;
            }
            if ("ALL".equals(stringArray[i])) {
                n2 = 3;
                continue;
            }
            if (stringArray[i].startsWith("ALL")) {
                Logging.errorPrint((String)"Old syntax ALLx will be replaced for ALL.x");
                n3 = Integer.parseInt(stringArray[i].substring(3));
                n2 = 3;
                continue;
            }
            if ("EQUIPPED".equals(stringArray[i])) {
                n2 = 1;
                continue;
            }
            if (stringArray[i].startsWith("EQUIPPED")) {
                Logging.errorPrint((String)"Old syntax EQUIPPEDx will be replaced for EQUIPPED.x");
                n3 = Integer.parseInt(stringArray[i].substring(8));
                n2 = 1;
                continue;
            }
            if ("NOT_EQUIPPED".equals(stringArray[i])) {
                n2 = 2;
                continue;
            }
            if (stringArray[i].startsWith("NOT_EQUIPPED")) {
                Logging.errorPrint((String)"Old syntax NOT_EQUIPPEDx will be replaced for NOT_EQUIPPED.x");
                n3 = Integer.parseInt(stringArray[i].substring(12));
                n2 = 2;
                continue;
            }
            if (stringArray[i].equals("MERGENONE")) {
                n4 = 1;
                continue;
            }
            if (stringArray[i].equals("MERGELOC")) {
                n4 = 2;
                continue;
            }
            if (stringArray[i].equals("MERGEALL")) {
                n4 = 0;
                continue;
            }
            if (stringArray[i].equals("ISTYPE")) {
                string2 = stringArray[i] + "." + stringArray[i + 1];
                break;
            }
            if (stringArray[i].equals("NAME")) {
                string2 = stringArray[i];
                if (i >= stringArray.length - 1) break;
                string2 = string2 + "." + stringArray[i + 1];
                break;
            }
            if (i < stringArray.length - 1) {
                try {
                    n3 = Integer.parseInt(stringArray[i]);
                }
                catch (NumberFormatException numberFormatException) {
                    if ("".equals(string3)) {
                        string3 = stringArray[i];
                        continue;
                    }
                    string4 = stringArray[i];
                }
                continue;
            }
            string2 = stringArray[i];
        }
        if ("".equals(string3)) {
            return ArmorToken._replaceTokenArmor(n3, string2, n2, n4, playerCharacter, exportHandler);
        }
        if ("SUIT".equals(string3)) {
            return ArmorToken._replaceTokenArmorSuit(n3, string4, string2, n2, n4, playerCharacter, exportHandler);
        }
        if ("SHIRT".equals(string3)) {
            return ArmorToken._replaceTokenArmorShirt(n3, string4, string2, n2, n4, playerCharacter, exportHandler);
        }
        if ("SHIELD".equals(string3)) {
            return ArmorToken._replaceTokenArmorShield(n3, string4, string2, n2, n4, playerCharacter, exportHandler);
        }
        if ("ITEM".equals(string3) || "ACITEM".equals(string3)) {
            return ArmorToken._replaceTokenArmorItem(n3, string4, string2, n2, n4, playerCharacter, exportHandler);
        }
        return ArmorToken._replaceTokenArmorVarious(n3, string3, string4, string2, n2, n4, playerCharacter, exportHandler);
    }

    private static String _replaceTokenArmor(int n, String string, int n2, int n3, PlayerCharacter playerCharacter, ExportHandler exportHandler) {
        List list = playerCharacter.getEquipmentOfTypeInOutputOrder("Armor", n2, n3);
        List list2 = playerCharacter.getEquipmentOfTypeInOutputOrder("Shield", n2, n3);
        for (Equipment equipment : list2) {
            list.remove(equipment);
        }
        if (n < list.size()) {
            Equipment equipment = (Equipment)list.get(n);
            return ArmorToken._writeArmorProperty(equipment, string, playerCharacter);
        }
        exportHandler.setNoMoreItems(true);
        return "";
    }

    private static String _replaceTokenArmorItem(int n, String string, String string2, int n2, int n3, PlayerCharacter playerCharacter, ExportHandler exportHandler) {
        ArrayList<Equipment> arrayList = new ArrayList<Equipment>();
        for (Equipment equipment : playerCharacter.getEquipmentListInOutputOrder(n3)) {
            if (!"".equals(string) && !equipment.isType(string) || n2 != 3 && (n2 != 2 || equipment.isEquipped()) && (n2 != 1 || !equipment.isEquipped()) || !equipment.getBonusListString("AC") || equipment.isArmor() || equipment.isShield()) continue;
            arrayList.add(equipment);
        }
        if (n < arrayList.size()) {
            Equipment equipment = (Equipment)arrayList.get(n);
            return ArmorToken._writeArmorProperty(equipment, string2, playerCharacter);
        }
        exportHandler.setNoMoreItems(true);
        return "";
    }

    private static String _replaceTokenArmorShield(int n, String string, String string2, int n2, int n3, PlayerCharacter playerCharacter, ExportHandler exportHandler) {
        List list = playerCharacter.getEquipmentOfTypeInOutputOrder("Shield", string, n2, n3);
        if (n < list.size()) {
            Equipment equipment = (Equipment)list.get(n);
            return ArmorToken._writeArmorProperty(equipment, string2, playerCharacter);
        }
        exportHandler.setNoMoreItems(true);
        return "";
    }

    private static String _replaceTokenArmorShirt(int n, String string, String string2, int n2, int n3, PlayerCharacter playerCharacter, ExportHandler exportHandler) {
        List list = playerCharacter.getEquipmentOfTypeInOutputOrder("Shirt", string, n2, n3);
        if (n < list.size()) {
            Equipment equipment = (Equipment)list.get(n);
            return ArmorToken._writeArmorProperty(equipment, string2, playerCharacter);
        }
        exportHandler.setNoMoreItems(true);
        return "";
    }

    private static String _replaceTokenArmorSuit(int n, String string, String string2, int n2, int n3, PlayerCharacter playerCharacter, ExportHandler exportHandler) {
        List list = playerCharacter.getEquipmentOfTypeInOutputOrder("Suit", string, n2, n3);
        if (n < list.size()) {
            Equipment equipment = (Equipment)list.get(n);
            return ArmorToken._writeArmorProperty(equipment, string2, playerCharacter);
        }
        exportHandler.setNoMoreItems(true);
        return "";
    }

    private static String _replaceTokenArmorVarious(int n, String string, String string2, String string3, int n2, int n3, PlayerCharacter playerCharacter, ExportHandler exportHandler) {
        ArrayList<Equipment> arrayList = new ArrayList<Equipment>();
        for (Equipment equipment : playerCharacter.getEquipmentOfTypeInOutputOrder(string, string2, n2, n3)) {
            if (equipment.getACMod(playerCharacter) > 0) {
                arrayList.add(equipment);
                continue;
            }
            if (!equipment.getBonusListString("AC")) continue;
            arrayList.add(equipment);
        }
        if (n < arrayList.size()) {
            Equipment equipment = (Equipment)arrayList.get(n);
            return ArmorToken._writeArmorProperty(equipment, string3, playerCharacter);
        }
        exportHandler.setNoMoreItems(true);
        return "";
    }

    private static String _writeArmorProperty(Equipment equipment, String string, PlayerCharacter playerCharacter) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.startsWith("NAME")) {
            if (equipment.isEquipped() && !string.equals("NAMENOSTAR")) {
                stringBuffer.append("*");
            }
            stringBuffer.append(equipment.parseOutputName(equipment.getOutputName(), playerCharacter));
            stringBuffer.append(equipment.getAppliedName());
        } else if (string.startsWith("OUTPUTNAME")) {
            if (equipment.isEquipped()) {
                stringBuffer.append("*");
            }
            stringBuffer.append(equipment.parseOutputName(equipment.getOutputName(), playerCharacter));
            stringBuffer.append(equipment.getAppliedName());
        } else if (string.startsWith("TOTALAC")) {
            stringBuffer.append(Delta.toString((int)((int)equipment.bonusTo(playerCharacter, "COMBAT", "AC", true))));
        } else if (string.startsWith("BASEAC")) {
            stringBuffer.append(Delta.toString((int)((int)equipment.bonusTo("COMBAT", "AC", (Object)playerCharacter, playerCharacter))));
        } else if (string.startsWith("ACBONUS")) {
            stringBuffer.append(Delta.toString((int)((int)equipment.bonusTo(playerCharacter, "COMBAT", "AC", true))));
        } else if (string.startsWith("MAXDEX")) {
            int n = equipment.getMaxDex(playerCharacter);
            if (n != 100) {
                stringBuffer.append(Delta.toString((int)n));
            }
        } else if (string.startsWith("ACCHECK")) {
            stringBuffer.append(Delta.toString((Integer)equipment.acCheck(playerCharacter)));
        } else if (string.startsWith("EDR")) {
            stringBuffer.append(Delta.toString((Integer)equipment.eDR(playerCharacter)));
        } else if (string.startsWith("ISTYPE")) {
            if (equipment.isType(string.substring(string.indexOf(".") + 1))) {
                stringBuffer.append("TRUE");
            } else {
                stringBuffer.append("FALSE");
            }
        } else if (string.startsWith("SPELLFAIL")) {
            stringBuffer.append(equipment.spellFailure(playerCharacter).toString());
        } else if (string.startsWith("MOVE")) {
            StringTokenizer stringTokenizer = new StringTokenizer(equipment.moveString(), ",", false);
            String string2 = "";
            if (("M".equals(playerCharacter.getSize()) || "S".equals(playerCharacter.getSize())) && stringTokenizer.countTokens() > 0) {
                string2 = stringTokenizer.nextToken();
                if ("S".equals(playerCharacter.getSize()) && stringTokenizer.countTokens() > 1) {
                    string2 = stringTokenizer.nextToken();
                }
            }
            stringBuffer.append(string2);
        } else if (string.startsWith("SPROP")) {
            stringBuffer.append(equipment.getSpecialProperties(playerCharacter));
        } else if (string.startsWith("TYPE")) {
            String string3 = "";
            if (equipment.isLight()) {
                string3 = "Light";
            } else if (equipment.isMedium()) {
                string3 = "Medium";
            } else if (equipment.isHeavy()) {
                string3 = "Heavy";
            } else if (equipment.isShield()) {
                string3 = "Shield";
            } else if (equipment.isExtra()) {
                string3 = "Extra";
            }
            stringBuffer.append(string3);
        } else if (string.startsWith("WT")) {
            stringBuffer.append(BigDecimalHelper.trimZeros((String)equipment.getWeight(playerCharacter).toString()));
        }
        return stringBuffer.toString();
    }
}

