/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import java.util.List;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.SpecialAbility;
import pcgen.core.utils.ListKey;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;
import pcgen.util.PropertyFactory;

public class RaceToken
extends Token {
    private static final String TOKENNAME = "RACE";
    private static final String[] SUBTOKENLIST = new String[]{"ABILITYLIST"};

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String string, PlayerCharacter playerCharacter, ExportHandler exportHandler) {
        String string2 = "";
        if (TOKENNAME.equals(string)) {
            string2 = RaceToken.getRaceToken(playerCharacter);
        } else {
            for (int i = 0; i < SUBTOKENLIST.length; ++i) {
                String string3 = "RACE." + SUBTOKENLIST[i];
                if (!string3.equals(string)) continue;
                string2 = RaceToken.getSubToken(SUBTOKENLIST[i], playerCharacter);
            }
        }
        return string2;
    }

    private static String getSubToken(String string, PlayerCharacter playerCharacter) {
        if (!string.equals(SUBTOKENLIST[0])) {
            return "";
        }
        List list = playerCharacter.getRace().getListFor(ListKey.SPECIAL_ABILITY);
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (SpecialAbility specialAbility : list) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            bl = false;
            stringBuffer.append(specialAbility.getDisplayName());
        }
        return stringBuffer.toString();
    }

    private static String getRaceToken(PlayerCharacter playerCharacter) {
        PCClass pCClass;
        String string;
        String string2 = "";
        String string3 = playerCharacter.getRace().getOutputName();
        if (string3 == null || string3.length() == 0) {
            string3 = playerCharacter.getRace().getDisplayName();
        }
        StringBuffer stringBuffer = new StringBuffer(40);
        if (!playerCharacter.getSubRace().equals("None")) {
            stringBuffer.append(playerCharacter.getSubRace());
        }
        if (SettingsHandler.hideMonsterClasses() && (string = playerCharacter.getRace().getMonsterClass(playerCharacter, false)) != null && (pCClass = playerCharacter.getClassKeyed(string)) != null) {
            int n = playerCharacter.getRace().hitDice(playerCharacter) + playerCharacter.getRace().getMonsterClassLevels(playerCharacter);
            int n2 = playerCharacter.getRace().hitDice(playerCharacter) + pCClass.getLevel();
            if (n2 != n) {
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(n2).append(PropertyFactory.getString((String)"in_hdLabel"));
            }
        }
        string2 = string3;
        if (stringBuffer.length() != 0) {
            string2 = string2 + " (" + stringBuffer + ')';
        }
        return string2;
    }
}

