/*
 * Decompiled with CFR 0.152.
 */
package plugin.charactersheet.gui;

import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;
import pcgen.core.PlayerCharacter;
import pcgen.io.exporttoken.VarToken;
import plugin.charactersheet.gui.CharacterPanel;

public class RagePane
extends JPanel {
    private PlayerCharacter pc;
    private List<JCheckBox> checkList = new ArrayList<JCheckBox>();
    private static final String rageText1 = "The Barbarian temporarily gains +4 to Strength, +4 to Constitution, and a +2 morale bonus on Will saves, but suffers a -2 penalty to AC.";
    private static final String rageText2 = "The Barbarian temporarily gains +6 to Strength, +6 to Constitution, and a +3 morale bonus on Will saves, but suffers a -2 penalty to AC.";
    private static final String rageText3 = "The Barbarian temporarily gains +8 to Strength, +8 to Constitution, and a +4 morale bonus on Will saves, but suffers a -2 penalty to AC.";
    private static final String rageTextLength = "A fit of rage lasts for a number of rounds equal to 3 + the character's (newly improved) Constitution modifier. ";
    private static final String rageTextFatigue = "At the end of the rage, the barbarian is fatigued (-2 to Strength, -2 to Dexterity, can't charge or run) for the duration of that encounter";
    private static final String rageTextFrequency = "The barbarian can only fly into a rage once per encounter, and only a certain number of times per day (determined by level). Entering a rage takes no time itself, but the barbarian can only do it during his action.";
    private static final String BARBARIAN_RAGE = "BARBARIAN RAGE";
    private static final String PER_DAY = "Uses Per Day";
    private static final String RAGE_TIMES = "RageTimes";
    private static final String GREATER_RAGE = "GreaterRage";
    private static final String TIRELESS_RAGE = "TirelessRage";
    private static final String MIGHTY_RAGE = "MightyRage";
    private static final String SPACE = " ";
    private static final String PROPERTY_RAGEPANE = "cs.RagePane";
    private static final Font FONT_FOURTEEN = new Font("Dialog", 1, 14);
    private static final Font FONT_TEN = new Font("Dialog", 0, 10);
    private Properties pcProperties;
    private boolean updateProperties = false;
    private JPanel checkPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JTextArea rageText;

    public RagePane() {
        this.initComponents();
        this.setLocalColor();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.checkPanel = new JPanel();
        this.rageText = new JTextArea();
        this.setLayout(new BoxLayout(this, 1));
        this.jPanel1.setLayout(new FlowLayout(1, 1, 0));
        this.jLabel1.setFont(FONT_FOURTEEN);
        this.jLabel1.setText(BARBARIAN_RAGE);
        this.jPanel1.add(this.jLabel1);
        this.add(this.jPanel1);
        this.jPanel3.setLayout(new BoxLayout(this.jPanel3, 0));
        this.jPanel2.setLayout(new FlowLayout(1, 1, 0));
        this.jLabel2.setFont(FONT_TEN);
        this.jLabel2.setText(PER_DAY);
        this.jPanel2.add(this.jLabel2);
        this.jPanel3.add(this.jPanel2);
        this.checkPanel.setLayout(new FlowLayout(1, 0, 1));
        this.jPanel3.add(this.checkPanel);
        this.add(this.jPanel3);
        this.rageText.setFont(FONT_TEN);
        this.rageText.setLineWrap(true);
        this.rageText.setWrapStyleWord(true);
        this.add(this.rageText);
    }

    public void setColor() {
        this.setLocalColor();
        this.refresh();
    }

    public void setLocalColor() {
        this.jPanel1.setBackground(CharacterPanel.header);
        this.jPanel1.setBorder(new LineBorder(CharacterPanel.border));
        this.jPanel3.setBackground(CharacterPanel.header);
        this.jPanel2.setBackground(CharacterPanel.header);
        this.jPanel2.setBorder(new LineBorder(CharacterPanel.header));
        this.checkPanel.setBackground(CharacterPanel.white);
        this.checkPanel.setBorder(new LineBorder(CharacterPanel.header));
        this.rageText.setBorder(new LineBorder(CharacterPanel.header));
    }

    public void setPc(PlayerCharacter playerCharacter, Properties properties) {
        this.pc = playerCharacter;
        this.pcProperties = properties;
    }

    public void refresh() {
        int n = VarToken.getIntVarToken((PlayerCharacter)this.pc, (String)RAGE_TIMES, (boolean)false);
        if (n > 0) {
            this.setVisible(true);
            int n2 = VarToken.getIntVarToken((PlayerCharacter)this.pc, (String)GREATER_RAGE, (boolean)false);
            int n3 = VarToken.getIntVarToken((PlayerCharacter)this.pc, (String)TIRELESS_RAGE, (boolean)false);
            int n4 = VarToken.getIntVarToken((PlayerCharacter)this.pc, (String)MIGHTY_RAGE, (boolean)false);
            if (n4 == 1) {
                this.rageText.setText("The Barbarian temporarily gains +8 to Strength, +8 to Constitution, and a +4 morale bonus on Will saves, but suffers a -2 penalty to AC.A fit of rage lasts for a number of rounds equal to 3 + the character's (newly improved) Constitution modifier. The barbarian can only fly into a rage once per encounter, and only a certain number of times per day (determined by level). Entering a rage takes no time itself, but the barbarian can only do it during his action.");
            } else if (n3 == 1) {
                this.rageText.setText("The Barbarian temporarily gains +6 to Strength, +6 to Constitution, and a +3 morale bonus on Will saves, but suffers a -2 penalty to AC.A fit of rage lasts for a number of rounds equal to 3 + the character's (newly improved) Constitution modifier. The barbarian can only fly into a rage once per encounter, and only a certain number of times per day (determined by level). Entering a rage takes no time itself, but the barbarian can only do it during his action.");
            } else if (n2 == 1) {
                this.rageText.setText("The Barbarian temporarily gains +6 to Strength, +6 to Constitution, and a +3 morale bonus on Will saves, but suffers a -2 penalty to AC.A fit of rage lasts for a number of rounds equal to 3 + the character's (newly improved) Constitution modifier. At the end of the rage, the barbarian is fatigued (-2 to Strength, -2 to Dexterity, can't charge or run) for the duration of that encounterThe barbarian can only fly into a rage once per encounter, and only a certain number of times per day (determined by level). Entering a rage takes no time itself, but the barbarian can only do it during his action.");
            } else {
                this.rageText.setText("The Barbarian temporarily gains +4 to Strength, +4 to Constitution, and a +2 morale bonus on Will saves, but suffers a -2 penalty to AC.A fit of rage lasts for a number of rounds equal to 3 + the character's (newly improved) Constitution modifier. At the end of the rage, the barbarian is fatigued (-2 to Strength, -2 to Dexterity, can't charge or run) for the duration of that encounterThe barbarian can only fly into a rage once per encounter, and only a certain number of times per day (determined by level). Entering a rage takes no time itself, but the barbarian can only do it during his action.");
            }
            this.addCheckBoxes(n);
        } else {
            this.setVisible(false);
        }
        this.updatePane();
    }

    private void addCheckBoxes(int n) {
        if (this.checkList.size() != n) {
            this.checkList.clear();
            for (int i = 0; i < n; ++i) {
                JComponent jComponent;
                if (i % 5 == 0 && i != 0) {
                    jComponent = new JLabel();
                    jComponent.setFont(FONT_TEN);
                    ((JLabel)jComponent).setText(SPACE);
                    this.checkPanel.add(jComponent);
                }
                jComponent = new JCheckBox();
                jComponent.setBackground(CharacterPanel.white);
                jComponent.setBorder(null);
                this.checkList.add((JCheckBox)jComponent);
                this.checkPanel.add(jComponent);
                ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        RagePane.this.pc.setDirty(true);
                        RagePane.this.updateProperties();
                    }
                });
            }
        }
    }

    public void updateProperties() {
        if (this.updateProperties) {
            int n = 0;
            for (JCheckBox jCheckBox : this.checkList) {
                if (!jCheckBox.isSelected()) continue;
                ++n;
            }
            this.pcProperties.put(PROPERTY_RAGEPANE, (Object)n);
        }
    }

    public void updatePane() {
        try {
            int n = Integer.parseInt((String)this.pcProperties.get(PROPERTY_RAGEPANE));
            for (JCheckBox jCheckBox : this.checkList) {
                if (n > 0) {
                    jCheckBox.setSelected(true);
                    --n;
                    continue;
                }
                jCheckBox.setSelected(false);
            }
            this.updateProperties = true;
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void destruct() {
    }
}

