/*
 * Decompiled with CFR 0.152.
 */
package plugin.charactersheet.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import pcgen.core.PlayerCharacter;
import pcgen.core.bonus.BonusObj;
import pcgen.core.character.EquipSet;
import pcgen.gui.panes.FlippingSplitPane;
import plugin.charactersheet.gui.CharacterPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectPanel
extends JPanel
implements ActionListener {
    private JPanel eqSetPanel;
    private ButtonGroup eqSets;
    private JPanel modifiersPanel;
    private FlippingSplitPane splitPane1;
    private PlayerCharacter pc;
    private int serial = 0;
    private Map<String, Component> tempBonusWidgets = new HashMap<String, Component>();
    private Map<String, JRadioButton> eqSetWidgets = new HashMap<String, JRadioButton>();
    private CharacterPanel parent;

    public SelectPanel(CharacterPanel characterPanel) {
        this.parent = characterPanel;
        this.initComponents();
    }

    private void initComponents() {
        this.eqSets = new ButtonGroup();
        this.splitPane1 = new FlippingSplitPane();
        this.eqSetPanel = new JPanel();
        this.modifiersPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.splitPane1.setOrientation(0);
        this.splitPane1.setResizeWeight(0.5);
        this.eqSetPanel.setLayout(new BoxLayout(this.eqSetPanel, 1));
        this.splitPane1.setLeftComponent((Component)this.eqSetPanel);
        this.modifiersPanel.setLayout(new BoxLayout(this.modifiersPanel, 1));
        this.splitPane1.setRightComponent((Component)this.modifiersPanel);
        this.add((Component)this.splitPane1, "Center");
    }

    public void setPc(PlayerCharacter playerCharacter) throws Exception {
        if (this.pc != playerCharacter) {
            this.pc = playerCharacter;
            this.serial = 0;
            this.removeAllBoxes();
            this.updateSelections();
        }
    }

    public void refresh() {
        if (this.serial < this.pc.getSerial()) {
            this.updateSelections();
            this.serial = this.pc.getSerial();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.pc.setCalcEquipSetId(actionEvent.getActionCommand());
        this.parent.refresh();
    }

    private void removeAllBoxes() {
        this.tempBonusWidgets.clear();
        this.modifiersPanel.removeAll();
        this.eqSetPanel.removeAll();
        for (JRadioButton jRadioButton : this.eqSetWidgets.values()) {
            this.eqSets.remove(jRadioButton);
        }
        this.eqSetWidgets.clear();
    }

    private Set<String> tempBonus2Set(List<BonusObj> list) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (BonusObj bonusObj : list) {
            treeSet.add(bonusObj.getName());
        }
        return treeSet;
    }

    private Set<String> equipSet2Set(List<EquipSet> list) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (EquipSet equipSet : list) {
            if (!equipSet.getRootIdPath().equals(equipSet.getIdPath())) continue;
            treeSet.add(equipSet.getIdPath());
        }
        return treeSet;
    }

    private void updateSelections() {
        Set<String> set = this.tempBonus2Set(this.pc.getTempBonusList());
        TreeSet<String> treeSet = new TreeSet<String>(this.tempBonusWidgets.keySet());
        treeSet.removeAll(set);
        set.removeAll(this.tempBonusWidgets.keySet());
        if (!set.isEmpty()) {
            this.addTempBonus(set);
        }
        if (!treeSet.isEmpty()) {
            this.removeTempBonus(treeSet);
        }
        set.clear();
        treeSet.clear();
        set.addAll(this.equipSet2Set(this.pc.getEquipSet()));
        treeSet.addAll(this.eqSetWidgets.keySet());
        treeSet.removeAll(set);
        set.removeAll(this.eqSetWidgets.keySet());
        if (!set.isEmpty()) {
            this.addEquipSets(set);
        }
        if (!treeSet.isEmpty()) {
            this.removeEquipSets(treeSet);
        }
    }

    private void addEquipSets(Set<String> set) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (EquipSet object : this.pc.getEquipSet()) {
            hashMap.put(object.getIdPath(), object.getName());
        }
        for (String string : set) {
            String string2 = (String)hashMap.get(string);
            JRadioButton jRadioButton = new JRadioButton(string2);
            jRadioButton.setActionCommand(string);
            jRadioButton.addActionListener(this);
            this.eqSets.add(jRadioButton);
            this.eqSetPanel.add(jRadioButton);
            this.eqSetWidgets.put(string, jRadioButton);
        }
    }

    private void removeEquipSets(Set<String> set) {
        for (String string : set) {
            JRadioButton jRadioButton = this.eqSetWidgets.remove(string);
            this.eqSets.remove(jRadioButton);
            this.eqSetPanel.remove(jRadioButton);
        }
    }

    private void addTempBonus(Set<String> set) {
        for (String string : set) {
            JCheckBox jCheckBox = new JCheckBox(string, !this.pc.getTempBonusFilters().contains(string));
            jCheckBox.addItemListener(new CheckBoxUpdater(string, this.pc, this.parent));
            this.modifiersPanel.add(jCheckBox);
            this.tempBonusWidgets.put(string, jCheckBox);
        }
    }

    private void removeTempBonus(Set<String> set) {
        for (String string : set) {
            Component component = this.tempBonusWidgets.get(string);
            if (component == null) continue;
            this.modifiersPanel.remove(component);
            this.tempBonusWidgets.remove(string);
        }
    }

    private static class CheckBoxUpdater
    implements ItemListener {
        private String bonus;
        private PlayerCharacter playerCharacter;
        private CharacterPanel aParent;

        public CheckBoxUpdater(String string, PlayerCharacter playerCharacter, CharacterPanel characterPanel) {
            this.aParent = characterPanel;
            this.bonus = string;
            this.playerCharacter = playerCharacter;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 2) {
                this.playerCharacter.setTempBonusFilter(this.bonus);
            }
            if (itemEvent.getStateChange() == 1) {
                this.playerCharacter.unsetTempBonusFilter(this.bonus);
            }
            this.aParent.refresh();
        }
    }
}

