/*
 * Decompiled with CFR 0.152.
 */
package plugin.charactersheet.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;
import pcgen.core.PlayerCharacter;
import pcgen.io.exporttoken.StatToken;
import pcgen.io.exporttoken.VarToken;
import pcgen.util.Delta;
import plugin.charactersheet.gui.CharacterPanel;

public class TurnPane
extends JPanel {
    private PlayerCharacter pc;
    private String turnType;
    private List<JCheckBox> checkList = new ArrayList<JCheckBox>();
    private Properties pcProperties;
    private boolean updateProperties = false;
    private JPanel checkPanel;
    private JPanel titlePanel;
    private JLabel title;
    private JPanel col1Header;
    private JPanel col1row1;
    private JPanel col1row2;
    private JPanel col1row3;
    private JPanel col1row4;
    private JPanel col1row5;
    private JPanel col1row6;
    private JPanel col1row7;
    private JPanel col1row8;
    private JPanel col1row9;
    private JPanel col2Header;
    private JPanel col2row1;
    private JPanel col2row2;
    private JPanel col2row3;
    private JPanel col2row4;
    private JPanel col2row5;
    private JPanel col2row6;
    private JPanel col2row7;
    private JPanel col2row8;
    private JPanel col2row9;
    private JLabel turn1;
    private JLabel turn2;
    private JLabel turn3;
    private JLabel turn4;
    private JLabel turn5;
    private JLabel turn6;
    private JLabel turn7;
    private JLabel turn8;
    private JLabel turn9;
    private JPanel turnCheckPanel;
    private JPanel turnCheckLabelPanel;
    private JLabel turnCheck;
    private JPanel turnLevelPanel;
    private JPanel turnLevelLabelPanel;
    private JLabel turnLevel;
    private JPanel turnDamagePanel;
    private JPanel turnDamageLabelPanel;
    private JLabel turnDamage;
    private JPanel turnDayLabelPanel;
    private JLabel turnDay;
    private JTextArea turnTextArea;

    public TurnPane() {
        this.initComponents();
        this.setLocalColor();
    }

    private void initComponents() {
        this.titlePanel = new JPanel();
        this.title = new JLabel();
        this.turnCheckLabelPanel = new JPanel();
        this.turnCheckPanel = new JPanel();
        this.turnCheck = new JLabel();
        this.setLayout(new GridBagLayout());
        this.titlePanel.setLayout(new FlowLayout(1, 1, 0));
        this.title.setFont(new Font("Dialog", 1, 14));
        this.title.setText("TURN/REBUKE UNDEAD");
        this.titlePanel.add(this.title);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        this.add((Component)this.titlePanel, gridBagConstraints);
        this.col1Header = new JPanel();
        this.col1row1 = new JPanel();
        this.col1row2 = new JPanel();
        this.col1row3 = new JPanel();
        this.col1row4 = new JPanel();
        this.col1row5 = new JPanel();
        this.col1row6 = new JPanel();
        this.col1row7 = new JPanel();
        this.col1row8 = new JPanel();
        this.col1row9 = new JPanel();
        this.col1Header.setLayout(new BoxLayout(this.col1Header, 1));
        this.col1Header.add(new JLabel("Turning Check"));
        this.col1Header.add(new JLabel("Result"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)this.col1Header, gridBagConstraints);
        this.col1row1.setLayout(new FlowLayout(1, 1, 0));
        JLabel jLabel = new JLabel();
        jLabel.setFont(new Font("Dialog", 0, 10));
        jLabel.setText("Up to 0");
        this.col1row1.add(jLabel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        this.add((Component)this.col1row1, gridBagConstraints);
        this.col1row2.setLayout(new FlowLayout(1, 1, 0));
        JLabel jLabel2 = new JLabel();
        jLabel2.setFont(new Font("Dialog", 0, 10));
        jLabel2.setText("1-3");
        this.col1row2.add(jLabel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        this.add((Component)this.col1row2, gridBagConstraints);
        this.col1row3.setLayout(new FlowLayout(1, 1, 0));
        JLabel jLabel3 = new JLabel();
        jLabel3.setFont(new Font("Dialog", 0, 10));
        jLabel3.setText("4-6");
        this.col1row3.add(jLabel3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        this.add((Component)this.col1row3, gridBagConstraints);
        this.col1row4.setLayout(new FlowLayout(1, 1, 0));
        JLabel jLabel4 = new JLabel();
        jLabel4.setFont(new Font("Dialog", 0, 10));
        jLabel4.setText("7-9");
        this.col1row4.add(jLabel4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        this.add((Component)this.col1row4, gridBagConstraints);
        this.col1row5.setLayout(new FlowLayout(1, 1, 0));
        JLabel jLabel5 = new JLabel();
        jLabel5.setFont(new Font("Dialog", 0, 10));
        jLabel5.setText("10-12");
        this.col1row5.add(jLabel5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        this.add((Component)this.col1row5, gridBagConstraints);
        this.col1row6.setLayout(new FlowLayout(1, 1, 0));
        JLabel jLabel6 = new JLabel();
        jLabel6.setFont(new Font("Dialog", 0, 10));
        jLabel6.setText("13-15");
        this.col1row6.add(jLabel6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 1;
        this.add((Component)this.col1row6, gridBagConstraints);
        this.col1row7.setLayout(new FlowLayout(1, 1, 0));
        JLabel jLabel7 = new JLabel();
        jLabel7.setFont(new Font("Dialog", 0, 10));
        jLabel7.setText("16-18");
        this.col1row7.add(jLabel7);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 1;
        this.add((Component)this.col1row7, gridBagConstraints);
        this.col1row8.setLayout(new FlowLayout(1, 1, 0));
        JLabel jLabel8 = new JLabel();
        jLabel8.setFont(new Font("Dialog", 0, 10));
        jLabel8.setText("19-21");
        this.col1row8.add(jLabel8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 1;
        this.add((Component)this.col1row8, gridBagConstraints);
        this.col1row9.setLayout(new FlowLayout(1, 1, 0));
        JLabel jLabel9 = new JLabel();
        jLabel9.setFont(new Font("Dialog", 0, 10));
        jLabel9.setText("22+");
        this.col1row9.add(jLabel9);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 1;
        this.add((Component)this.col1row9, gridBagConstraints);
        this.col2Header = new JPanel();
        this.col2row1 = new JPanel();
        this.col2row2 = new JPanel();
        this.col2row3 = new JPanel();
        this.col2row4 = new JPanel();
        this.col2row5 = new JPanel();
        this.col2row6 = new JPanel();
        this.col2row7 = new JPanel();
        this.col2row8 = new JPanel();
        this.col2row9 = new JPanel();
        this.turn1 = new JLabel();
        this.turn2 = new JLabel();
        this.turn3 = new JLabel();
        this.turn4 = new JLabel();
        this.turn5 = new JLabel();
        this.turn6 = new JLabel();
        this.turn7 = new JLabel();
        this.turn8 = new JLabel();
        this.turn9 = new JLabel();
        this.col2Header.setLayout(new BoxLayout(this.col2Header, 1));
        this.col2Header.add(new JLabel("Undead Affected"));
        this.col2Header.add(new JLabel("(Maximum Hit Dice)"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)this.col2Header, gridBagConstraints);
        this.col2row1.setLayout(new FlowLayout(1, 1, 0));
        this.turn1.setFont(new Font("Dialog", 0, 10));
        this.col2row1.add(this.turn1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        this.add((Component)this.col2row1, gridBagConstraints);
        this.col2row2.setLayout(new FlowLayout(1, 1, 0));
        this.turn2.setFont(new Font("Dialog", 0, 10));
        this.col2row2.add(this.turn2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        this.add((Component)this.col2row2, gridBagConstraints);
        this.col2row3.setLayout(new FlowLayout(1, 1, 0));
        this.turn3.setFont(new Font("Dialog", 0, 10));
        this.col2row3.add(this.turn3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        this.add((Component)this.col2row3, gridBagConstraints);
        this.col2row4.setLayout(new FlowLayout(1, 1, 0));
        this.turn4.setFont(new Font("Dialog", 0, 10));
        this.col2row4.add(this.turn4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        this.add((Component)this.col2row4, gridBagConstraints);
        this.col2row5.setLayout(new FlowLayout(1, 1, 0));
        this.turn5.setFont(new Font("Dialog", 0, 10));
        this.col2row5.add(this.turn5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        this.add((Component)this.col2row5, gridBagConstraints);
        this.col2row6.setLayout(new FlowLayout(1, 1, 0));
        this.turn6.setFont(new Font("Dialog", 0, 10));
        this.col2row6.add(this.turn6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 1;
        this.add((Component)this.col2row6, gridBagConstraints);
        this.col2row7.setLayout(new FlowLayout(1, 1, 0));
        this.turn7.setFont(new Font("Dialog", 0, 10));
        this.col2row7.add(this.turn7);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 1;
        this.add((Component)this.col2row7, gridBagConstraints);
        this.col2row8.setLayout(new FlowLayout(1, 1, 0));
        this.turn8.setFont(new Font("Dialog", 0, 10));
        this.col2row8.add(this.turn8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 1;
        this.add((Component)this.col2row8, gridBagConstraints);
        this.col2row9.setLayout(new FlowLayout(1, 1, 0));
        this.turn9.setFont(new Font("Dialog", 0, 10));
        this.col2row9.add(this.turn9);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 1;
        this.add((Component)this.col2row9, gridBagConstraints);
        this.turnCheckLabelPanel = new JPanel();
        this.turnCheckPanel = new JPanel();
        this.turnCheck = new JLabel();
        this.turnCheckLabelPanel.setLayout(new FlowLayout(2, 1, 0));
        JLabel jLabel10 = new JLabel();
        jLabel10.setFont(new Font("Dialog", 0, 10));
        jLabel10.setText("Turn check");
        this.turnCheckLabelPanel.add(jLabel10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)this.turnCheckLabelPanel, gridBagConstraints);
        this.turnCheckPanel.setLayout(new FlowLayout(1, 1, 0));
        this.turnCheck.setFont(new Font("Dialog", 0, 10));
        this.turnCheckPanel.add(this.turnCheck);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)this.turnCheckPanel, gridBagConstraints);
        this.turnLevelLabelPanel = new JPanel();
        this.turnLevelPanel = new JPanel();
        this.turnLevel = new JLabel();
        this.turnLevelLabelPanel.setLayout(new FlowLayout(2, 1, 0));
        JLabel jLabel11 = new JLabel();
        jLabel11.setFont(new Font("Dialog", 0, 10));
        jLabel11.setText("Turn Level");
        this.turnLevelLabelPanel.add(jLabel11);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)this.turnLevelLabelPanel, gridBagConstraints);
        this.turnLevelPanel.setLayout(new FlowLayout(1, 1, 0));
        this.turnLevel.setFont(new Font("Dialog", 0, 10));
        this.turnLevelPanel.add(this.turnLevel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)this.turnLevelPanel, gridBagConstraints);
        this.turnDamageLabelPanel = new JPanel();
        this.turnDamagePanel = new JPanel();
        this.turnDamage = new JLabel();
        this.turnDamageLabelPanel.setLayout(new FlowLayout(1, 1, 0));
        JLabel jLabel12 = new JLabel();
        jLabel12.setFont(new Font("Dialog", 0, 10));
        jLabel12.setText("Turn Damage");
        this.turnDamageLabelPanel.add(jLabel12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        this.add((Component)this.turnDamageLabelPanel, gridBagConstraints);
        this.turnDamagePanel.setLayout(new FlowLayout(1, 1, 0));
        this.turnDamage.setFont(new Font("Dialog", 0, 10));
        this.turnDamagePanel.add(this.turnDamage);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        this.add((Component)this.turnDamagePanel, gridBagConstraints);
        this.turnDayLabelPanel = new JPanel();
        this.turnDay = new JLabel();
        this.turnDayLabelPanel.setLayout(new FlowLayout(2, 1, 0));
        this.turnDayLabelPanel.add(this.turnDay);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 1;
        this.add((Component)this.turnDayLabelPanel, gridBagConstraints);
        this.checkPanel = new JPanel();
        this.checkPanel.setLayout(new FlowLayout(1, 0, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        this.add((Component)this.checkPanel, gridBagConstraints);
        this.turnTextArea = new JTextArea();
        this.turnTextArea.setLineWrap(true);
        this.turnTextArea.setFont(new Font("Dialog", 0, 10));
        this.turnTextArea.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 8;
        gridBagConstraints.fill = 1;
        this.add((Component)this.turnTextArea, gridBagConstraints);
    }

    public void setColor() {
        this.setLocalColor();
        this.refresh();
    }

    public void setLocalColor() {
        this.setBackground(CharacterPanel.white);
        this.setBorder(new LineBorder(CharacterPanel.border));
        this.titlePanel.setBackground(CharacterPanel.header);
        this.titlePanel.setBorder(new LineBorder(CharacterPanel.border));
        this.col1Header.setBackground(CharacterPanel.header);
        this.col1Header.setBorder(new LineBorder(CharacterPanel.border));
        this.col1row1.setBackground(CharacterPanel.bodyLight);
        this.col1row2.setBackground(CharacterPanel.bodyMedLight);
        this.col1row3.setBackground(CharacterPanel.bodyLight);
        this.col1row4.setBackground(CharacterPanel.bodyMedLight);
        this.col1row5.setBackground(CharacterPanel.bodyLight);
        this.col1row6.setBackground(CharacterPanel.bodyMedLight);
        this.col1row7.setBackground(CharacterPanel.bodyLight);
        this.col1row8.setBackground(CharacterPanel.bodyMedLight);
        this.col1row9.setBackground(CharacterPanel.bodyLight);
        this.col2Header.setBackground(CharacterPanel.header);
        this.col2Header.setBorder(new LineBorder(CharacterPanel.border));
        this.col2row1.setBackground(CharacterPanel.bodyLight);
        this.col2row2.setBackground(CharacterPanel.bodyMedLight);
        this.col2row3.setBackground(CharacterPanel.bodyLight);
        this.col2row4.setBackground(CharacterPanel.bodyMedLight);
        this.col2row5.setBackground(CharacterPanel.bodyLight);
        this.col2row6.setBackground(CharacterPanel.bodyMedLight);
        this.col2row7.setBackground(CharacterPanel.bodyLight);
        this.col2row8.setBackground(CharacterPanel.bodyMedLight);
        this.col2row9.setBackground(CharacterPanel.bodyLight);
        this.turnCheckPanel.setBackground(CharacterPanel.white);
        this.turnCheckPanel.setBorder(new LineBorder(CharacterPanel.border));
        this.turnCheckLabelPanel.setBackground(CharacterPanel.header);
        this.turnCheckLabelPanel.setBorder(new LineBorder(CharacterPanel.border));
        this.turnLevelPanel.setBackground(CharacterPanel.white);
        this.turnLevelPanel.setBorder(new LineBorder(CharacterPanel.border));
        this.turnLevelLabelPanel.setBackground(CharacterPanel.header);
        this.turnLevelLabelPanel.setBorder(new LineBorder(CharacterPanel.border));
        this.turnDamageLabelPanel.setBackground(CharacterPanel.header);
        this.turnDamageLabelPanel.setBorder(new LineBorder(CharacterPanel.border));
        this.turnDamagePanel.setBackground(CharacterPanel.white);
        this.turnDamagePanel.setBorder(new LineBorder(CharacterPanel.border));
        this.turnDayLabelPanel.setBackground(CharacterPanel.header);
        this.turnDayLabelPanel.setBorder(new LineBorder(CharacterPanel.border));
        this.checkPanel.setBackground(CharacterPanel.white);
        this.checkPanel.setBorder(new LineBorder(CharacterPanel.border));
        this.turnTextArea.setBorder(new LineBorder(CharacterPanel.border));
    }

    public void setPc(PlayerCharacter playerCharacter, Properties properties, String string) {
        this.pc = playerCharacter;
        this.pcProperties = properties;
        this.turnType = string;
        this.setVisible(false);
    }

    private String getEffectType(PlayerCharacter playerCharacter, String string) {
        if (playerCharacter.hasRealFeatNamed("Turn " + string) || playerCharacter.hasFeatVirtual("Turn " + string)) {
            return "Turn";
        }
        if (playerCharacter.hasRealFeatNamed("Rebuke " + string) || playerCharacter.hasFeatVirtual("Rebuke " + string)) {
            return "Rebuke";
        }
        return "";
    }

    public void refresh() {
        try {
            int n = VarToken.getIntVarToken((PlayerCharacter)this.pc, (String)("TurnLevel" + this.turnType), (boolean)false);
            if (n > 0) {
                this.setVisible(true);
                int n2 = VarToken.getIntVarToken((PlayerCharacter)this.pc, (String)("TurnCheck" + this.turnType), (boolean)false);
                int n3 = VarToken.getIntVarToken((PlayerCharacter)this.pc, (String)("TurnTimes" + this.turnType), (boolean)false);
                int n4 = 2;
                int n5 = 6;
                int n6 = VarToken.getIntVarToken((PlayerCharacter)this.pc, (String)("TurnDamagePlus" + this.turnType), (boolean)false);
                if (n6 > 0) {
                    n4 = VarToken.getIntVarToken((PlayerCharacter)this.pc, (String)("TurnDice" + this.turnType), (boolean)false);
                    n5 = VarToken.getIntVarToken((PlayerCharacter)this.pc, (String)("TurnDieSize" + this.turnType), (boolean)false);
                } else {
                    n6 = n + Integer.parseInt(StatToken.getModToken((PlayerCharacter)this.pc, (int)5));
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("1d20+").append(n2);
                this.turnCheck.setText(stringBuffer.toString());
                this.turnLevel.setText(Integer.toString(n));
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append(n4).append("d").append(n5).append(Delta.toString((int)n6));
                this.turnDamage.setText(stringBuffer2.toString());
                StringBuffer stringBuffer3 = new StringBuffer();
                stringBuffer3.append("Turns/day (").append(n3).append(")");
                this.turnDay.setText(stringBuffer3.toString());
                this.turn1.setText(Integer.toString(n - 4));
                this.turn2.setText(Integer.toString(n - 3));
                this.turn3.setText(Integer.toString(n - 2));
                this.turn4.setText(Integer.toString(n - 1));
                this.turn5.setText(Integer.toString(n));
                this.turn6.setText(Integer.toString(n + 1));
                this.turn7.setText(Integer.toString(n + 2));
                this.turn8.setText(Integer.toString(n + 3));
                this.turn9.setText(Integer.toString(n + 4));
                this.addCheckBoxes(n3);
                StringBuffer stringBuffer4 = new StringBuffer();
                if (this.getEffectType(this.pc, this.turnType).equals("Turn")) {
                    this.title.setText("Turn " + this.turnType);
                    stringBuffer4.append("Note: You destroy ").append(this.turnType).append(" creatures if they have up to ").append(n / 2).append(" Hit Dice");
                    this.turnTextArea.setText(stringBuffer4.toString());
                } else {
                    this.title.setText("Rebuke " + this.turnType);
                    stringBuffer4.append("Note: You command ").append(this.turnType).append(" creatures if they have up to ").append(n).append(" Hit Dice");
                    this.turnTextArea.setText(stringBuffer4.toString());
                }
                this.updatePane();
            } else {
                this.setVisible(false);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception in " + this.turnType);
            this.setVisible(false);
        }
    }

    private void addCheckBoxes(int n) {
        if (this.checkList.size() != n) {
            this.checkList.clear();
            this.checkPanel.removeAll();
            for (int i = 0; i < n; ++i) {
                JComponent jComponent;
                if (i % 5 == 0 && i != 0) {
                    jComponent = new JLabel();
                    jComponent.setFont(new Font("Dialog", 0, 10));
                    ((JLabel)jComponent).setText(" ");
                    this.checkPanel.add(jComponent);
                }
                jComponent = new JCheckBox();
                jComponent.setBackground(new Color(255, 255, 255));
                jComponent.setBorder(null);
                this.checkList.add((JCheckBox)jComponent);
                this.checkPanel.add(jComponent);
                ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        TurnPane.this.pc.setDirty(true);
                        TurnPane.this.updateProperties();
                    }
                });
            }
        }
    }

    public void updateProperties() {
        if (this.updateProperties) {
            int n = 0;
            for (JCheckBox jCheckBox : this.checkList) {
                if (!jCheckBox.isSelected()) continue;
                ++n;
            }
            this.pcProperties.put("cs.TurnPane." + this.turnType, Integer.toString(n));
        }
    }

    public void updatePane() {
        try {
            int n = Integer.parseInt((String)this.pcProperties.get("cs.TurnPane." + this.turnType));
            for (JCheckBox jCheckBox : this.checkList) {
                if (n > 0) {
                    jCheckBox.setSelected(true);
                    --n;
                    continue;
                }
                jCheckBox.setSelected(false);
            }
            this.updateProperties = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void destruct() {
    }
}

