/*
 * Decompiled with CFR 0.152.
 */
package plugin.charactersheet.gui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;
import plugin.charactersheet.gui.CharacterPanel;
import plugin.charactersheet.gui.WeaponPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeaponListPane
extends JPanel {
    private PlayerCharacter pc;
    private List<WeaponPane> weaponList = new ArrayList<WeaponPane>();
    private int serial = 0;

    public WeaponListPane() {
        this.initComponents();
        this.setLocalColor();
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
    }

    public void setColor() {
        this.setLocalColor();
        for (WeaponPane weaponPane : this.weaponList) {
            weaponPane.setColor();
        }
    }

    public void setLocalColor() {
        this.setBackground(CharacterPanel.white);
    }

    public void setPc(PlayerCharacter playerCharacter) {
        if (this.pc != playerCharacter) {
            this.pc = playerCharacter;
            this.serial = 0;
        }
    }

    public synchronized void refresh() {
        if (this.serial < this.pc.getSerial()) {
            this.pc.setCalcEquipmentList(this.pc.getUseTempMods());
            List list = this.pc.getExpandedWeapons(0);
            this.addEqPanes(list);
            this.serial = this.pc.getSerial();
        }
        this.revalidate();
        this.repaint();
    }

    public void clear() {
        this.removeAll();
        for (int i = this.weaponList.size() - 1; i >= 0; --i) {
            WeaponPane weaponPane = this.weaponList.get(i);
            weaponPane.clear();
            this.weaponList.remove(weaponPane);
            weaponPane = null;
        }
        this.weaponList.clear();
    }

    private void addEqPanes(List<Equipment> list) {
        this.clear();
        int n = 1;
        for (Equipment equipment : list) {
            WeaponPane weaponPane = new WeaponPane();
            weaponPane.setWeapon(this.pc, equipment);
            this.weaponList.add(weaponPane);
            weaponPane.refresh();
            this.add(weaponPane);
            ++n;
        }
    }

    public void destruct() {
        this.clear();
    }
}

