/*
 * Decompiled with CFR 0.152.
 */
package plugin.charactersheet.gui;

import gmgen.gui.GridBoxLayout;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;
import pcgen.io.exporttoken.WeaponToken;
import plugin.charactersheet.CharacterSheetUtils;
import plugin.charactersheet.gui.CharacterPanel;

public class WeaponTitlePane
extends JPanel {
    private PlayerCharacter pc;
    private Equipment eq;
    private JPanel titleContainerPanel;
    private JPanel weaponTitlePanel;
    private JLabel weaponTitle;
    private JTextArea weaponSubTitle;
    private JPanel dataContainerPanel;
    private JPanel currentHandPanel;
    private JPanel typePanel;
    private JPanel sizePanel;
    private JPanel criticalPanel;
    private JPanel currentHandDataPanel;
    private JLabel currentHand;
    private JPanel typeDataPanel;
    private JLabel damageType;
    private JPanel sizeDataPanel;
    private JLabel weaponSize;
    private JPanel criticalDataPanel;
    private JLabel critical;
    private static final String DIALOG = "Dialog";
    private static final Font FONT_TEN = new Font("Dialog", 1, 10);
    private static final String CURR_HAND = "Current Hand";
    private static final String TYPE = "Type";
    private static final String SIZE = "Size";
    private static final String CRITICAL = "Critical";
    private static final String SPACE = " ";
    private static final String BLANK = "";
    private static final String STAR = "*";

    public WeaponTitlePane() {
        this.initComponents();
        this.setColor();
    }

    private void initComponents() {
        this.titleContainerPanel = new JPanel();
        this.weaponTitlePanel = new JPanel();
        this.weaponTitle = new JLabel();
        this.weaponSubTitle = new JTextArea();
        this.dataContainerPanel = new JPanel();
        this.currentHandPanel = new JPanel();
        this.currentHandDataPanel = new JPanel();
        this.currentHand = new JLabel();
        this.typePanel = new JPanel();
        this.typeDataPanel = new JPanel();
        this.damageType = new JLabel();
        this.sizePanel = new JPanel();
        this.sizeDataPanel = new JPanel();
        this.weaponSize = new JLabel();
        this.criticalPanel = new JPanel();
        this.criticalDataPanel = new JPanel();
        this.critical = new JLabel();
        this.setLayout(new BoxLayout(this, 0));
        this.titleContainerPanel.setLayout(new BoxLayout(this.titleContainerPanel, 1));
        this.weaponTitlePanel.setLayout(new FlowLayout(1, 1, 0));
        this.weaponTitle.setFont(new Font(DIALOG, 1, 16));
        this.weaponTitlePanel.add(this.weaponTitle);
        this.titleContainerPanel.add(this.weaponTitlePanel);
        this.weaponSubTitle.setFont(FONT_TEN);
        this.weaponSubTitle.setLineWrap(true);
        this.weaponSubTitle.setWrapStyleWord(true);
        this.titleContainerPanel.add(this.weaponSubTitle);
        this.add(this.titleContainerPanel);
        this.dataContainerPanel.setLayout((LayoutManager)new GridBoxLayout(2, 4));
        JLabel jLabel = new JLabel();
        this.currentHandPanel.setLayout(new FlowLayout(1, 1, 0));
        jLabel.setFont(FONT_TEN);
        jLabel.setText(CURR_HAND);
        this.currentHandPanel.add(jLabel);
        this.dataContainerPanel.add(this.currentHandPanel);
        JLabel jLabel2 = new JLabel();
        this.typePanel.setLayout(new FlowLayout(1, 1, 0));
        jLabel2.setFont(FONT_TEN);
        jLabel2.setText(TYPE);
        this.typePanel.add(jLabel2);
        this.dataContainerPanel.add(this.typePanel);
        JLabel jLabel3 = new JLabel();
        this.sizePanel.setLayout(new FlowLayout(1, 1, 0));
        jLabel3.setFont(FONT_TEN);
        jLabel3.setText(SIZE);
        this.sizePanel.add(jLabel3);
        this.dataContainerPanel.add(this.sizePanel);
        JLabel jLabel4 = new JLabel();
        this.criticalPanel.setLayout(new FlowLayout(1, 1, 0));
        jLabel4.setFont(FONT_TEN);
        jLabel4.setText(CRITICAL);
        this.criticalPanel.add(jLabel4);
        this.dataContainerPanel.add(this.criticalPanel);
        this.currentHandDataPanel.setLayout(new FlowLayout(1, 1, 0));
        this.currentHand.setFont(FONT_TEN);
        this.currentHand.setText(SPACE);
        this.currentHandDataPanel.add(this.currentHand);
        this.dataContainerPanel.add(this.currentHandDataPanel);
        this.typeDataPanel.setLayout(new FlowLayout(1, 1, 0));
        this.damageType.setFont(FONT_TEN);
        this.damageType.setText(SPACE);
        this.typeDataPanel.add(this.damageType);
        this.dataContainerPanel.add(this.typeDataPanel);
        this.sizeDataPanel.setLayout(new FlowLayout(1, 1, 0));
        this.weaponSize.setFont(FONT_TEN);
        this.weaponSize.setText(SPACE);
        this.sizeDataPanel.add(this.weaponSize);
        this.dataContainerPanel.add(this.sizeDataPanel);
        this.criticalDataPanel.setLayout(new FlowLayout(1, 1, 0));
        this.critical.setFont(FONT_TEN);
        this.critical.setText(SPACE);
        this.criticalDataPanel.add(this.critical);
        this.dataContainerPanel.add(this.criticalDataPanel);
        this.add(this.dataContainerPanel);
    }

    public void setColor() {
        this.setBackground(CharacterPanel.border);
        this.setBorder(new LineBorder(CharacterPanel.border));
        this.titleContainerPanel.setBackground(CharacterPanel.header);
        this.titleContainerPanel.setBorder(new LineBorder(CharacterPanel.border));
        this.weaponTitlePanel.setBackground(CharacterPanel.header);
        this.weaponSubTitle.setBackground(CharacterPanel.header);
        this.weaponSubTitle.setBorder(null);
        this.dataContainerPanel.setBackground(CharacterPanel.border);
        this.currentHandPanel.setBackground(CharacterPanel.header);
        this.currentHandPanel.setBorder(new LineBorder(CharacterPanel.border));
        this.currentHandDataPanel.setBackground(CharacterPanel.bodyLight);
        this.currentHandDataPanel.setBorder(new LineBorder(CharacterPanel.border));
        this.typePanel.setBackground(CharacterPanel.header);
        this.typePanel.setBorder(new LineBorder(CharacterPanel.border));
        this.typeDataPanel.setBackground(CharacterPanel.bodyLight);
        this.typeDataPanel.setBorder(new LineBorder(CharacterPanel.border));
        this.sizePanel.setBackground(CharacterPanel.header);
        this.sizePanel.setBorder(new LineBorder(CharacterPanel.border));
        this.sizeDataPanel.setBackground(CharacterPanel.bodyLight);
        this.sizeDataPanel.setBorder(new LineBorder(CharacterPanel.border));
        this.criticalPanel.setBackground(CharacterPanel.header);
        this.criticalPanel.setBorder(new LineBorder(CharacterPanel.border));
        this.criticalDataPanel.setBackground(CharacterPanel.bodyLight);
        this.criticalDataPanel.setBorder(new LineBorder(CharacterPanel.border));
    }

    public void setWeapon(PlayerCharacter playerCharacter, Equipment equipment) {
        this.pc = playerCharacter;
        this.eq = equipment;
        this.refresh();
    }

    public void refresh() {
        String string = BLANK;
        if (this.eq.isEquipped()) {
            string = STAR;
        }
        this.weaponTitle.setText(CharacterSheetUtils.getTitle(new StringBuffer(this.eq.longName()).append(this.eq.getAppliedName()).toString(), string, BLANK));
        this.weaponSubTitle.setText(CharacterSheetUtils.getSubTitle(new StringBuffer(this.eq.longName()).append(this.eq.getAppliedName()).toString()));
        this.currentHand.setText(WeaponToken.getHandToken((Equipment)this.eq));
        this.weaponSize.setText(WeaponToken.getSizeToken((Equipment)this.eq));
        this.damageType.setText(WeaponToken.getTypeToken((Equipment)this.eq));
        StringBuffer stringBuffer = new StringBuffer();
        this.critical.setText(stringBuffer.append(WeaponToken.getCritToken((PlayerCharacter)this.pc, (Equipment)this.eq)).append('/').append('x').append(WeaponToken.getMultToken((PlayerCharacter)this.pc, (Equipment)this.eq)).toString());
    }
}

