/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.Race;
import pcgen.core.WeaponProf;
import pcgen.persistence.lst.GlobalLstToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NaturalattacksLst
implements GlobalLstToken {
    public String getTokenName() {
        return "NATURALATTACKS";
    }

    public boolean parse(PObject pObject, String string, int n) {
        List<Equipment> list = NaturalattacksLst.parseNaturalAttacks(pObject, string);
        for (Equipment equipment : list) {
            pObject.addNaturalWeapon(equipment, n);
        }
        return true;
    }

    private static List<Equipment> parseNaturalAttacks(PObject pObject, String string) {
        String string2 = "M";
        if (pObject instanceof PCTemplate) {
            string2 = ((PCTemplate)pObject).getTemplateSize();
        } else if (pObject instanceof Race) {
            string2 = ((Race)pObject).getSize();
        }
        if (string2 == null) {
            string2 = "M";
        }
        int n = 1;
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        if (stringTokenizer.countTokens() == 1) {
            bl = true;
        }
        ArrayList<Equipment> arrayList = new ArrayList<Equipment>();
        while (stringTokenizer.hasMoreTokens()) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), ",");
            Equipment equipment = NaturalattacksLst.createNaturalWeapon(stringTokenizer2, string2);
            if (equipment != null) {
                if (n == 1) {
                    equipment.setModifiedName("Natural/Primary");
                } else {
                    equipment.setModifiedName("Natural/Secondary");
                }
                if (bl && equipment.isOnlyNaturalWeapon()) {
                    equipment.setOnlyNaturalWeapon(true);
                } else {
                    equipment.setOnlyNaturalWeapon(false);
                }
                equipment.setOutputIndex(0);
                equipment.setOutputSubindex(n);
                arrayList.add(equipment);
            }
            ++n;
        }
        return arrayList;
    }

    private static Equipment createNaturalWeapon(StringTokenizer stringTokenizer, String string) {
        String string2;
        String string3 = stringTokenizer.nextToken();
        if (string3.equalsIgnoreCase("None")) {
            return null;
        }
        Equipment equipment = new Equipment();
        String string4 = stringTokenizer.nextToken();
        equipment.setName(string3);
        equipment.setTypeInfo(string4);
        equipment.setWeight("0");
        equipment.setSize(string, true);
        String string5 = stringTokenizer.nextToken();
        boolean bl = true;
        if (string5.length() > 0 && string5.charAt(0) == '*') {
            string5 = string5.substring(1);
            bl = false;
        }
        int n = 0;
        try {
            n = Integer.parseInt(string5) - 1;
        }
        catch (NumberFormatException numberFormatException) {
            Logging.errorPrint((String)("Non-numeric value for number of attacks: '" + string5 + "'"));
        }
        if (n > 0) {
            equipment.addBonusList("WEAPON|ATTACKS|" + n);
            equipment.setOnlyNaturalWeapon(false);
        } else {
            equipment.setOnlyNaturalWeapon(true);
        }
        equipment.setDamage(stringTokenizer.nextToken());
        equipment.setCritRange("1");
        equipment.setCritMult(2);
        equipment.setProfName(string3);
        int n2 = 0;
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                Logging.errorPrint((String)("Non-numeric value for hands required: '" + string2 + "'"));
            }
        }
        equipment.setSlots(n2);
        equipment.setQty(new Float(1.0f));
        equipment.setNumberCarried(new Float(1.0f));
        equipment.setAttacksProgress(bl);
        string2 = Globals.getWeaponProfKeyed((String)string3);
        if (string2 == null) {
            string2 = new WeaponProf();
            string2.setTypeInfo(string4);
            string2.setName(string3);
            string2.setKeyName(string3);
            Globals.addWeaponProf((WeaponProf)string2);
        }
        equipment.addAutoArray("WEAPONPROF", string3);
        return equipment;
    }
}

