/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.PlayerCharacter;
import pcgen.core.QualifiedObject;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.ListKey;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;

public class DeityToken
extends Token {
    public static final String TOKENNAME = "DEITY";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String string, PlayerCharacter playerCharacter, ExportHandler exportHandler) {
        String string2 = "";
        if (playerCharacter.getDeity() != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
            String string3 = "OUTPUTNAME";
            Deity deity = playerCharacter.getDeity();
            if (stringTokenizer.countTokens() > 1) {
                stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken();
            }
            if ("NAME".equals(string3)) {
                string2 = DeityToken.getNameToken(deity);
            } else if ("OUTPUTNAME".equals(string3)) {
                string2 = DeityToken.getOutputNameToken(deity);
            } else if ("DOMAINLIST".equals(string3)) {
                string2 = DeityToken.getDomainListToken(deity);
            } else if ("FOLLOWERALIGNMENT".equals(string3)) {
                string2 = DeityToken.getFollowerAlignmentToken(deity);
            } else if ("ALIGNMENT".equals(string3)) {
                string2 = DeityToken.getAlignmentToken(deity);
            } else if ("APPEARANCE".equals(string3)) {
                string2 = DeityToken.getAppearanceToken(deity);
            } else if ("DESCRIPTION".equals(string3)) {
                string2 = DeityToken.getDescriptionToken(playerCharacter, deity);
            } else if ("HOLYITEM".equals(string3)) {
                string2 = DeityToken.getHolyItemToken(deity);
            } else if ("FAVOREDWEAPON".equals(string3)) {
                string2 = DeityToken.getFavoredWeaponToken(deity);
            } else if ("PANTHEONLIST".equals(string3)) {
                string2 = DeityToken.getPantheonListToken(deity);
            } else if ("SOURCE".equals(string3)) {
                string2 = DeityToken.getSourceToken(deity);
            } else if ("SA".equals(string3)) {
                string2 = DeityToken.getSAToken(deity);
            } else if ("TITLE".equals(string3)) {
                string2 = DeityToken.getTitleToken(deity);
            } else if ("WORSHIPPERS".equals(string3)) {
                string2 = DeityToken.getWorshippersToken(deity);
            }
        }
        return string2;
    }

    public static String getAlignmentToken(Deity deity) {
        return deity.getAlignment();
    }

    public static String getAppearanceToken(Deity deity) {
        return deity.getAppearance();
    }

    public static String getDescriptionToken(PlayerCharacter playerCharacter, Deity deity) {
        return deity.getDescription(playerCharacter);
    }

    public static String getDomainListToken(Deity deity) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (QualifiedObject qualifiedObject : deity.getDomainList()) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            bl = false;
            stringBuffer.append(((Domain)qualifiedObject.getObject(null)).getDisplayName());
        }
        return stringBuffer.toString();
    }

    public static String getFavoredWeaponToken(Deity deity) {
        return deity.getFavoredWeapon();
    }

    public static String getFollowerAlignmentToken(Deity deity) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        String string = deity.getFollowerAlignments();
        for (int i = 0; i < string.length(); ++i) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            bl = false;
            stringBuffer.append(SettingsHandler.getGame().getShortAlignmentAtIndex(string.charAt(i) - 48));
        }
        return stringBuffer.toString();
    }

    public static String getHolyItemToken(Deity deity) {
        return deity.getHolyItem();
    }

    public static String getNameToken(Deity deity) {
        return deity.getDisplayName();
    }

    public static String getOutputNameToken(Deity deity) {
        return deity.getOutputName();
    }

    public static String getPantheonListToken(Deity deity) {
        return CoreUtility.join((Collection)deity.getPantheonList(), (String)", ");
    }

    public static String getSAToken(Deity deity) {
        if (deity.containsListFor(ListKey.SPECIAL_ABILITY)) {
            return CoreUtility.join((Collection)deity.getListFor(ListKey.SPECIAL_ABILITY), (String)", ");
        }
        return "";
    }

    public static String getSourceToken(Deity deity) {
        return deity.getDefaultSourceString();
    }

    public static String getTitleToken(Deity deity) {
        return deity.getTitle();
    }

    public static String getWorshippersToken(Deity deity) {
        return deity.getWorshippers();
    }
}

