/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep;

import java.util.Stack;
import java.util.Vector;
import org.nfunk.jep.ASTConstant;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.ASTStart;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.ParserVisitor;
import org.nfunk.jep.SimpleNode;
import org.nfunk.jep.SymbolTable;
import org.nfunk.jep.Variable;
import org.nfunk.jep.function.PostfixMathCommandI;
import org.nfunk.jep.function.SpecialEvaluationI;

public class EvaluatorVisitor
implements ParserVisitor {
    protected Stack stack = new Stack();
    protected Vector errorList = null;
    protected SymbolTable symTab = null;
    protected boolean errorFlag;
    private static final boolean debug = false;

    protected void addToErrorList(String string) {
        if (this.errorList != null) {
            this.errorList.addElement(string);
        }
    }

    public Object getValue(Node node, Vector vector, SymbolTable symbolTable) throws Exception {
        if (node == null) {
            throw new IllegalArgumentException("topNode parameter is null");
        }
        this.errorList = vector;
        this.symTab = symbolTable;
        this.errorFlag = false;
        this.stack.removeAllElements();
        try {
            node.jjtAccept(this, null);
        }
        catch (ParseException parseException) {
            this.addToErrorList(parseException.getMessage());
            throw parseException;
        }
        if (this.errorFlag || this.stack.size() != 1) {
            throw new Exception("EvaluatorVisitor.getValue(): Error during evaluation");
        }
        return this.stack.pop();
    }

    public Object visit(SimpleNode simpleNode, Object object) throws ParseException {
        throw new ParseException("No visit method for " + simpleNode.getClass().toString());
    }

    public Object visit(ASTStart aSTStart, Object object) throws ParseException {
        throw new ParseException("Start node encountered during evaluation");
    }

    public Object visit(ASTFunNode aSTFunNode, Object object) throws ParseException {
        if (aSTFunNode == null) {
            return null;
        }
        PostfixMathCommandI postfixMathCommandI = aSTFunNode.getPFMC();
        if (postfixMathCommandI == null) {
            throw new ParseException("No function class associated with " + aSTFunNode.getName());
        }
        if (postfixMathCommandI instanceof SpecialEvaluationI) {
            return ((SpecialEvaluationI)((Object)aSTFunNode.getPFMC())).evaluate(aSTFunNode, object, this, this.stack);
        }
        object = aSTFunNode.childrenAccept(this, object);
        if (postfixMathCommandI.getNumberOfParameters() == -1) {
            postfixMathCommandI.setCurNumberOfParameters(aSTFunNode.jjtGetNumChildren());
        }
        postfixMathCommandI.run(this.stack);
        return object;
    }

    public Object visit(ASTVarNode aSTVarNode, Object object) throws ParseException {
        Variable variable = aSTVarNode.getVar();
        if (variable == null) {
            String string = "Could not evaluate " + aSTVarNode.getName() + ": ";
            throw new ParseException(string + " variable not set");
        }
        Object object2 = variable.getValue();
        if (object2 == null) {
            String string = "Could not evaluate " + aSTVarNode.getName() + ": ";
            throw new ParseException(string + "the variable was not found in the symbol table");
        }
        this.stack.push(object2);
        return object;
    }

    public Object visit(ASTConstant aSTConstant, Object object) {
        this.stack.push(aSTConstant.getValue());
        return object;
    }
}

