/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep;

import java.util.Enumeration;
import java.util.Hashtable;
import org.nfunk.jep.Variable;
import org.nfunk.jep.VariableFactory;

public class SymbolTable
extends Hashtable {
    protected VariableFactory vf;

    public SymbolTable(VariableFactory variableFactory) {
        this.vf = variableFactory;
    }

    private SymbolTable() {
    }

    public Object get(Object object) {
        return this.getValue(object);
    }

    public Object getValue(Object object) {
        Variable variable = (Variable)super.get(object);
        if (variable == null) {
            return null;
        }
        return variable.getValue();
    }

    public Variable getVar(String string) {
        return (Variable)super.get(string);
    }

    public Object put(Object object, Object object2) {
        return this.makeVarIfNeeded((String)object, object2);
    }

    public boolean setVarValue(String string, Object object) {
        Variable variable = (Variable)super.get(string);
        if (variable != null) {
            return variable.setValue(object);
        }
        return false;
    }

    public Variable addVariable(String string, Object object) {
        Variable variable = (Variable)super.get(string);
        if (variable != null) {
            return null;
        }
        variable = this.vf.createVariable(string, object);
        super.put(string, variable);
        variable.setValidValue(true);
        return variable;
    }

    public Variable addConstant(String string, Object object) {
        Variable variable = this.addVariable(string, object);
        if (variable != null) {
            variable.setIsConstant(true);
        }
        return variable;
    }

    public Variable makeVarIfNeeded(String string, Object object) {
        Variable variable = (Variable)super.get(string);
        if (variable != null) {
            variable.setValue(object);
            return variable;
        }
        variable = this.vf.createVariable(string, object);
        super.put(string, variable);
        return variable;
    }

    public Variable makeVarIfNeeded(String string) {
        Variable variable = (Variable)super.get(string);
        if (variable != null) {
            return variable;
        }
        variable = this.vf.createVariable(string, null);
        super.put(string, variable);
        return variable;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Variable variable = (Variable)enumeration.nextElement();
            stringBuffer.append(variable.toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public void clearValues() {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Variable variable = (Variable)enumeration.nextElement();
            if (variable.isConstant()) continue;
            variable.setValidValue(false);
        }
    }

    public VariableFactory getVariableFactory() {
        return this.vf;
    }
}

