/*
 * Decompiled with CFR 0.152.
 */
package gmgen.plugin;

import gmgen.plugin.Dice;
import gmgen.plugin.Effect;
import gmgen.plugin.InitHolder;
import gmgen.plugin.SystemHP;
import gmgen.plugin.SystemInitiative;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Combatant
implements InitHolder {
    public SystemInitiative init;
    protected List<Effect> effects = new ArrayList<Effect>();
    protected String comType = "Enemy";
    protected String status = "";
    protected SystemHP hitPoints;
    protected int duration;
    protected int number;

    public abstract void setCR(float var1);

    public abstract float getCR();

    public void setCombatantType(String string) {
        this.comType = string;
    }

    public String getCombatantType() {
        return this.comType;
    }

    public void setDuration(int n) {
        this.duration = n;
    }

    public int getDuration() {
        return this.duration;
    }

    public List<Effect> getEffects() {
        return this.effects;
    }

    public SystemHP getHP() {
        return this.hitPoints;
    }

    @Override
    public SystemInitiative getInitiative() {
        return this.init;
    }

    public abstract void setName(String var1);

    public void setNumber(int n) {
        this.number = n;
    }

    public int getNumber() {
        return this.number;
    }

    @Override
    public Vector<String> getRowVector(List<String> list) {
        Vector<String> vector = new Vector<String>();
        for (String string : list) {
            if (string.equals("Name")) {
                vector.add(this.getName());
                continue;
            }
            if (string.equals("Player")) {
                vector.add(this.getPlayer());
                continue;
            }
            if (string.equals("Status")) {
                vector.add(this.getStatus());
                continue;
            }
            if (string.equals("+")) {
                vector.add("" + this.init.getModifier());
                continue;
            }
            if (string.equals("Init")) {
                vector.add("" + this.init.getCurrentInitiative());
                continue;
            }
            if (string.equals("Dur")) {
                if (this.duration == 0) {
                    vector.add("");
                    continue;
                }
                vector.add("" + this.getDuration());
                continue;
            }
            if (string.equals("#")) {
                vector.add("" + this.number);
                continue;
            }
            if (string.equals("HP")) {
                int n = this.hitPoints.getCurrent();
                int n2 = this.hitPoints.getSubdual();
                if (n2 == 0) {
                    vector.add("" + n);
                    continue;
                }
                if (n2 <= 0) continue;
                vector.add(n + "/" + n2 + "s");
                continue;
            }
            if (string.equals("HP Max")) {
                vector.add("" + this.hitPoints.getMax());
                continue;
            }
            if (!string.equals("Type")) continue;
            vector.add(this.comType);
        }
        return vector;
    }

    @Override
    public void setStatus(String string) {
        this.status = string;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    public abstract void setXP(int var1);

    public abstract int getXP();

    public void addEffect(Effect effect) {
        this.effects.add(effect);
    }

    public void bleed() {
        this.setStatus(this.hitPoints.bleed());
    }

    public void damage(int n) {
        this.setStatus(this.hitPoints.damage(n));
    }

    public int decDuration() {
        if (this.duration > 0) {
            --this.duration;
            if (this.duration == 0) {
                this.setStatus(this.hitPoints.endDurationedStatus());
            }
        }
        return this.duration;
    }

    @Override
    public void endRound() {
        this.hitPoints.endRound();
    }

    public void heal(int n) {
        this.setStatus(this.hitPoints.heal(n));
    }

    public void kill() {
        this.setStatus(this.hitPoints.kill());
    }

    public void nonLethalDamage(boolean bl) {
        this.setStatus(this.hitPoints.nonLethalDamage(bl));
        if (bl) {
            this.setDuration(new Dice(4, 1).roll() + 1);
        } else {
            this.setDuration(1);
        }
    }

    public void raise() {
        this.setStatus(this.hitPoints.raise());
    }

    public void stabilize() {
        this.setStatus(this.hitPoints.stabilize());
    }

    public void subdualDamage(int n) {
        this.setStatus(this.hitPoints.subdualDamage(n));
    }

    public String toString() {
        return this.getName();
    }

    public abstract String toHtmlString();
}

