/*
 * Decompiled with CFR 0.152.
 */
package gmgen.plugin;

import gmgen.plugin.Combatant;
import gmgen.plugin.PcgSystemInitiative;
import gmgen.plugin.PlayerCharacterOutput;
import gmgen.plugin.SystemAttribute;
import gmgen.plugin.SystemHP;
import gmgen.pluginmgr.GMBComponent;
import gmgen.pluginmgr.GMBus;
import gmgen.pluginmgr.messages.OpenPCGRequestMessage;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;
import pcgen.core.CharacterDomain;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PCStat;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.StatList;
import pcgen.core.character.CharacterSpell;
import pcgen.core.spell.Spell;
import pcgen.util.Logging;
import pcgen.util.enumeration.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PcgCombatant
extends Combatant {
    protected PlayerCharacter pc;
    protected PcRenderer renderer;
    protected float crAdj = 0.0f;

    public PcgCombatant(PlayerCharacter playerCharacter) {
        this.pc = playerCharacter;
        Globals.setCurrentPC(playerCharacter);
        this.init = new PcgSystemInitiative(playerCharacter);
        StatList statList = playerCharacter.getStatList();
        this.hitPoints = new SystemHP(new SystemAttribute("Constitution", statList.getTotalStatFor("CON")), playerCharacter.hitPoints(), playerCharacter.hitPoints());
        this.setCombatantType("PC");
    }

    public PcgCombatant(PlayerCharacter playerCharacter, String string) {
        this(playerCharacter);
        this.setCombatantType(string);
    }

    public PcgCombatant(Element element, GMBComponent gMBComponent) {
        try {
            File file = new File(element.getChild("PCG").getAttribute("file").getValue());
            OpenPCGRequestMessage openPCGRequestMessage = new OpenPCGRequestMessage(gMBComponent, file, true);
            GMBus.send(openPCGRequestMessage);
            this.pc = openPCGRequestMessage.getPlayerCharacter();
            Globals.setCurrentPC(this.pc);
            this.init = new PcgSystemInitiative(this.pc);
            StatList statList = this.pc.getStatList();
            this.hitPoints = new SystemHP(new SystemAttribute("Constitution", statList.getTotalStatFor("CON")), this.pc.hitPoints(), this.pc.hitPoints());
            this.setStatus(element.getAttribute("status").getValue());
            this.setCombatantType(element.getAttribute("type").getValue());
            this.init.setBonus(element.getChild("Initiative").getAttribute("bonus").getIntValue());
            try {
                this.init.setCurrentInitiative(element.getChild("Initiative").getAttribute("current").getIntValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.hitPoints.setMax(element.getChild("HitPoints").getAttribute("max").getIntValue());
            this.hitPoints.setCurrent(element.getChild("HitPoints").getAttribute("current").getIntValue());
            this.hitPoints.setSubdual(element.getChild("HitPoints").getAttribute("subdual").getIntValue());
            this.hitPoints.setState(element.getChild("HitPoints").getAttribute("state").getValue());
        }
        catch (Exception exception) {
            Logging.errorPrint("Initiative", exception);
        }
    }

    @Override
    public void setCR(float f) {
        Globals.setCurrentPC(this.pc);
        this.crAdj = f - (float)this.pc.calcCR();
    }

    @Override
    public float getCR() {
        Globals.setCurrentPC(this.pc);
        return (float)this.pc.calcCR() + this.crAdj;
    }

    @Override
    public void setName(String string) {
        this.pc.setName(string);
        this.pc.setDirty(true);
    }

    @Override
    public String getName() {
        return this.pc.getName();
    }

    public PlayerCharacter getPC() {
        return this.pc;
    }

    public void setPlayer(String string) {
        this.pc.setPlayersName(string);
        this.pc.setDirty(true);
    }

    @Override
    public String getPlayer() {
        return this.pc.getPlayersName();
    }

    @Override
    public Element getSaveElement() {
        Element element = new Element("PcgCombatant");
        Element element2 = new Element("Initiative");
        Element element3 = new Element("HitPoints");
        Element element4 = new Element("PCG");
        element4.setAttribute("file", this.pc.getFileName() + "");
        element.addContent(element4);
        element2.setAttribute("bonus", this.init.getModifier() + "");
        if (this.init.getCurrentInitiative() > 0) {
            element2.setAttribute("current", this.init.getCurrentInitiative() + "");
        }
        element.addContent(element2);
        element3.setAttribute("current", this.hitPoints.getCurrent() + "");
        element3.setAttribute("subdual", this.hitPoints.getSubdual() + "");
        element3.setAttribute("max", this.hitPoints.getMax() + "");
        element3.setAttribute("state", this.hitPoints.getState() + "");
        element.addContent(element3);
        element.setAttribute("name", this.getName());
        element.setAttribute("player", this.getPlayer());
        element.setAttribute("status", this.getStatus());
        element.setAttribute("type", this.getCombatantType());
        return element;
    }

    @Override
    public void setXP(int n) {
        this.pc.setXP(n);
        this.pc.setDirty(true);
    }

    @Override
    public int getXP() {
        return this.pc.getXP();
    }

    @Override
    public void editRow(List<String> list, int n, Object object) {
        String string = list.get(n);
        String string2 = String.valueOf(object);
        if (string.equals("Name")) {
            this.setName(string2);
        } else if (string.equals("Player")) {
            this.setPlayer(string2);
        } else if (string.equals("Status")) {
            this.setStatus(string2);
        } else if (string.equals("+")) {
            Integer n2 = Integer.valueOf(string2);
            this.init.setBonus(n2);
        } else if (string.equals("Init")) {
            Integer n3 = Integer.valueOf(string2);
            this.init.setCurrentInitiative(n3);
        } else if (string.equals("#")) {
            Integer n4 = Integer.valueOf(string2);
            this.setNumber(n4);
        } else if (string.equals("HP")) {
            Integer n5 = Integer.valueOf(string2);
            this.hitPoints.setCurrent(n5);
        } else if (string.equals("HP Max")) {
            Integer n6 = Integer.valueOf(string2);
            this.hitPoints.setMax(n6);
        } else if (string.equals("Dur")) {
            Integer n7 = Integer.valueOf(string2);
            this.setDuration(n7);
        } else if (string.equals("Type")) {
            this.setCombatantType(string2);
        }
    }

    @Override
    public String toHtmlString() {
        if (this.renderer == null) {
            this.renderer = new PcRenderer();
        }
        return this.renderer.getHtmlText();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PcRenderer {
        protected String htmlString;
        protected int serial = 0;

        public String getHtmlText() {
            if (this.serial < PcgCombatant.this.pc.getSerial() || this.htmlString == null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<html>");
                Globals.setCurrentPC(PcgCombatant.this.pc);
                stringBuffer.append(this.getStatBlockHeader());
                stringBuffer.append("<body class='Normal' lang='EN-US'>");
                stringBuffer.append(this.getStatBlockTitle());
                stringBuffer.append(this.getStatBlockCore());
                stringBuffer.append("<DIV style='MARGIN: 0px 10px'>");
                stringBuffer.append(this.getStatBlockLineSkills());
                stringBuffer.append(this.getStatBlockLinePossessions());
                try {
                    stringBuffer.append(this.getStatBlockLineSpells());
                }
                catch (Exception exception) {
                    Logging.errorPrint(exception.getMessage(), exception);
                }
                stringBuffer.append("</DIV>");
                stringBuffer.append("<br>");
                stringBuffer.append("</html>");
                this.serial = PcgCombatant.this.pc.getSerial();
                this.htmlString = stringBuffer.toString();
            }
            return this.htmlString;
        }

        protected String getStatBlockCore() {
            int n;
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            PlayerCharacterOutput playerCharacterOutput = new PlayerCharacterOutput(PcgCombatant.this.pc);
            stringBuffer.append("<font class='type'>CR</font> ");
            stringBuffer.append(playerCharacterOutput.getCR());
            stringBuffer.append("; ");
            stringBuffer.append("<font class='type'>Size</font> ");
            stringBuffer.append(playerCharacterOutput.getSize());
            stringBuffer.append("; ");
            stringBuffer.append("<font class='type'>Type</font> ");
            stringBuffer.append(playerCharacterOutput.getRaceType());
            stringBuffer.append("; ");
            stringBuffer.append("<font class='type'>HD</font> ");
            stringBuffer.append(playerCharacterOutput.getHitDice());
            stringBuffer.append("; ");
            stringBuffer.append("<font class='type'>hp</font> ");
            stringBuffer.append(playerCharacterOutput.getHitPoints());
            stringBuffer.append("; ");
            stringBuffer.append("<font class='type'>Init</font> <font class='highlight'>");
            stringBuffer.append(playerCharacterOutput.getInitTotal());
            stringBuffer.append("</font> (");
            stringBuffer.append(playerCharacterOutput.getInitStatMod());
            stringBuffer.append("Dex, ");
            stringBuffer.append(playerCharacterOutput.getInitMiscMod());
            stringBuffer.append("Misc); ");
            stringBuffer.append("<font class='type'>Spd</font> ");
            stringBuffer.append(playerCharacterOutput.getSpeed());
            stringBuffer.append("; ");
            stringBuffer.append("<font class='type'>AC</font> <font class='highlight'>");
            stringBuffer.append(playerCharacterOutput.getAC());
            stringBuffer.append("</font> (flatfooted <font class='highlight'>");
            stringBuffer.append(playerCharacterOutput.getACFlatFooted());
            stringBuffer.append("</font>, touch <font class='highlight'>");
            stringBuffer.append(playerCharacterOutput.getACTouch());
            stringBuffer.append("</font>); ");
            stringBuffer.append("<font class='type'>Melee:</font> <a href='attack:Melee\\");
            stringBuffer.append(playerCharacterOutput.getMeleeTotal());
            stringBuffer.append("' class='highlight'>");
            stringBuffer.append(playerCharacterOutput.getMeleeTotal());
            stringBuffer.append("</a>; ");
            stringBuffer.append("<font class='type'>Ranged:</font> <a href='attack:Ranged\\");
            stringBuffer.append(playerCharacterOutput.getRangedTotal());
            stringBuffer.append("' class='highlight'>");
            stringBuffer.append(playerCharacterOutput.getRangedTotal());
            stringBuffer.append("</a>; ");
            stringBuffer.append("<font class='type'>Weapons:</font>");
            List<Equipment> list = PcgCombatant.this.pc.getExpandedWeapons(0);
            for (n2 = 0; n2 < list.size(); ++n2) {
                Equipment equipment = list.get(n2);
                stringBuffer.append("<a href=\"attack:");
                stringBuffer.append(playerCharacterOutput.getWeaponName(equipment));
                stringBuffer.append("\\");
                stringBuffer.append(playerCharacterOutput.getWeaponToHit(n2));
                stringBuffer.append("\\");
                stringBuffer.append(playerCharacterOutput.getWeaponRange(equipment));
                stringBuffer.append("\\");
                stringBuffer.append(playerCharacterOutput.getWeaponType(equipment));
                stringBuffer.append("\\");
                stringBuffer.append(playerCharacterOutput.getWeaponDamage(n2));
                stringBuffer.append("\\");
                stringBuffer.append(playerCharacterOutput.getWeaponCritRange(n2));
                stringBuffer.append("\\");
                stringBuffer.append(playerCharacterOutput.getWeaponCritMult(n2));
                stringBuffer.append("\\");
                stringBuffer.append(playerCharacterOutput.getWeaponHand(equipment));
                stringBuffer.append("\\");
                stringBuffer.append(playerCharacterOutput.getWeaponSize(equipment));
                stringBuffer.append("\\");
                stringBuffer.append(playerCharacterOutput.getWeaponSpecialProperties(equipment));
                stringBuffer.append("\" class=\"dialog\"> ");
                stringBuffer.append(playerCharacterOutput.getWeaponName(equipment));
                stringBuffer.append(" ");
                stringBuffer.append(playerCharacterOutput.getWeaponToHit(n2));
                stringBuffer.append(" ");
                stringBuffer.append(playerCharacterOutput.getWeaponRange(equipment));
                stringBuffer.append("/");
                stringBuffer.append(playerCharacterOutput.getWeaponType(equipment));
                stringBuffer.append(" (");
                stringBuffer.append(playerCharacterOutput.getWeaponDamage(n2));
                stringBuffer.append(" ");
                stringBuffer.append(playerCharacterOutput.getWeaponCritRange(n2));
                stringBuffer.append("/x");
                stringBuffer.append(playerCharacterOutput.getWeaponCritMult(n2));
                stringBuffer.append(" ");
                stringBuffer.append(playerCharacterOutput.getWeaponHand(equipment));
                stringBuffer.append(" ");
                stringBuffer.append(playerCharacterOutput.getWeaponSize(equipment));
                stringBuffer.append(" ");
                stringBuffer.append(playerCharacterOutput.getWeaponSpecialProperties(equipment));
                stringBuffer.append(") </a> or ");
            }
            stringBuffer.append("<a href=\"attack:Unarmed\\");
            stringBuffer.append(playerCharacterOutput.getExportToken("WEAPONH.TOTALHIT"));
            stringBuffer.append("\\\\B\\");
            stringBuffer.append(playerCharacterOutput.getExportToken("WEAPONH.DAMAGE"));
            stringBuffer.append("\\");
            stringBuffer.append(playerCharacterOutput.getExportToken("WEAPONH.CRIT"));
            stringBuffer.append("\\");
            stringBuffer.append(playerCharacterOutput.getExportToken("WEAPONH.MULT"));
            stringBuffer.append("\" class=\"dialog\"> ");
            stringBuffer.append("Unarmed ");
            stringBuffer.append(playerCharacterOutput.getExportToken("WEAPONH.TOTALHIT"));
            stringBuffer.append(" (");
            stringBuffer.append(playerCharacterOutput.getExportToken("WEAPONH.DAMAGE"));
            stringBuffer.append(" ");
            stringBuffer.append(playerCharacterOutput.getExportToken("WEAPONH.CRIT"));
            stringBuffer.append("/x");
            stringBuffer.append(playerCharacterOutput.getExportToken("WEAPONH.MULT"));
            stringBuffer.append(") </a> or ");
            stringBuffer.append("<a href=\"attack:Grapple\\");
            stringBuffer.append(playerCharacterOutput.getExportToken("ATTACK.GRAPPLE.TOTAL"));
            stringBuffer.append("\\\\B\\");
            stringBuffer.append(playerCharacterOutput.getExportToken("WEAPONH.DAMAGE"));
            stringBuffer.append("\\");
            stringBuffer.append(playerCharacterOutput.getExportToken("WEAPONH.CRIT"));
            stringBuffer.append("\\");
            stringBuffer.append(playerCharacterOutput.getExportToken("WEAPONH.MULT"));
            stringBuffer.append("\" class=\"dialog\"> ");
            stringBuffer.append("Grapple ");
            stringBuffer.append(playerCharacterOutput.getExportToken("ATTACK.GRAPPLE.TOTAL"));
            stringBuffer.append(" (");
            stringBuffer.append(playerCharacterOutput.getExportToken("WEAPONH.DAMAGE"));
            stringBuffer.append(" ");
            stringBuffer.append(playerCharacterOutput.getExportToken("WEAPONH.CRIT"));
            stringBuffer.append("/x");
            stringBuffer.append(playerCharacterOutput.getExportToken("WEAPONH.MULT"));
            stringBuffer.append(")</a>; ");
            stringBuffer.append("<font class='type'>SA:</font> ");
            stringBuffer.append(playerCharacterOutput.getSpecialAbilities());
            n2 = PcgCombatant.this.pc.getVariableValue("TurnTimesUndead", "").intValue();
            if (n2 > 0) {
                int n3 = PcgCombatant.this.pc.getVariableValue("TurnDiceUndead", "").intValue();
                n = PcgCombatant.this.pc.getVariableValue("TurnDieSizeUndead", "").intValue();
                int n4 = PcgCombatant.this.pc.getVariableValue("TurnDamagePlusUndead", "").intValue();
                int n5 = PcgCombatant.this.pc.getVariableValue("TurnLevelUndead", "").intValue();
                int n6 = PcgCombatant.this.pc.getVariableValue("TurnCheckUndead", "").intValue();
                stringBuffer.append("; <font class='type'>Turn/Rebuke Undead:</font> Turning level <a href=\"dice:Turn Undead (Max HD Affected)\\max(min(max((ceil((1d20" + (n6 > 0 ? "+" : "") + n6 + ")/3)-4),-4),4)+" + n5 + ",0)" + '\"' + " class=" + '\"' + "dialog" + '\"' + "> " + n5 + "</a>, Turn Damage: " + "<a href=" + '\"' + "dice:Turn Damage (Total HD Affected)\\" + "max(" + n3 + "d" + n + (n4 > 0 ? "+" : "") + n4 + ",0)" + '\"' + " class=" + '\"' + "dialog" + '\"' + "> " + n3 + "d" + n + (n4 > 0 ? "+" : "") + n4 + "</a>, " + n2 + "/day");
            }
            stringBuffer.append("; ");
            stringBuffer.append("<font class='type'>Vision:</font> ");
            stringBuffer.append(playerCharacterOutput.getVision());
            stringBuffer.append(" ");
            stringBuffer.append("<font class='type'>AL:</font> ");
            stringBuffer.append(playerCharacterOutput.getAlignmentShort());
            stringBuffer.append("; ");
            stringBuffer.append("<font class='type'>Sv:</font> Fort <font class='highlight'>");
            stringBuffer.append("<a href='save:FORTITUDE\\");
            stringBuffer.append(playerCharacterOutput.getSaveFort());
            stringBuffer.append("' class='highlight'> ");
            stringBuffer.append(playerCharacterOutput.getSaveFort());
            stringBuffer.append("</a>");
            stringBuffer.append("</font>, Ref <font class='highlight'>");
            stringBuffer.append("<a href='save:REFLEX\\");
            stringBuffer.append(playerCharacterOutput.getSaveRef());
            stringBuffer.append("' class='highlight'> ");
            stringBuffer.append(playerCharacterOutput.getSaveRef());
            stringBuffer.append("</a>");
            stringBuffer.append("</font>, Will <font class='highlight'>");
            stringBuffer.append("<a href='save:WILL\\");
            stringBuffer.append(playerCharacterOutput.getSaveWill());
            stringBuffer.append("' class='highlight'> ");
            stringBuffer.append(playerCharacterOutput.getSaveWill());
            stringBuffer.append("</a>");
            stringBuffer.append("</font>; ");
            StatList statList = playerCharacterOutput.getStatList();
            for (n = 0; n < statList.size(); ++n) {
                PCStat pCStat = statList.getStatAt(n);
                if (PcgCombatant.this.pc.isNonAbility(n)) {
                    stringBuffer.append("<font class='type'>");
                    stringBuffer.append(pCStat.getAbb());
                    stringBuffer.append("</font>");
                    stringBuffer.append("*");
                    stringBuffer.append("&nbsp;(");
                    stringBuffer.append("0");
                    stringBuffer.append(") ");
                    continue;
                }
                stringBuffer.append("<font class='type'>");
                stringBuffer.append(pCStat.getAbb());
                stringBuffer.append("</font> ");
                stringBuffer.append(playerCharacterOutput.getStat(pCStat.getAbb()));
                stringBuffer.append("&nbsp;(");
                stringBuffer.append("<a href='check:");
                stringBuffer.append(pCStat.getAbb());
                stringBuffer.append("\\1d20");
                stringBuffer.append(playerCharacterOutput.getStatMod(pCStat.getAbb()));
                stringBuffer.append("' class='dialog'>");
                stringBuffer.append(playerCharacterOutput.getStatMod(pCStat.getAbb()));
                stringBuffer.append("</a>) ");
            }
            stringBuffer.append("</p>");
            return stringBuffer.toString();
        }

        protected String getStatBlockHeader() {
            StringBuffer stringBuffer = new StringBuffer();
            PlayerCharacterOutput playerCharacterOutput = new PlayerCharacterOutput(PcgCombatant.this.pc);
            stringBuffer.append("<head><title>");
            stringBuffer.append(playerCharacterOutput.getName());
            stringBuffer.append(" - ");
            stringBuffer.append(PcgCombatant.this.pc.getPlayersName());
            stringBuffer.append("(");
            stringBuffer.append(PcgCombatant.this.pc.getCostPool());
            stringBuffer.append(" Points) in GMGEN Statblock Format");
            stringBuffer.append("</title>");
            stringBuffer.append("<style type='text/css'>");
            stringBuffer.append("a:link {color: #006699}");
            stringBuffer.append("a:visited {color: #006699}");
            stringBuffer.append("a:hover {color: #006699}");
            stringBuffer.append("a:active {color: #006699}");
            stringBuffer.append(".type {color:#555555;font-weight:bold}");
            stringBuffer.append(".highlight {color:#FF0000}");
            stringBuffer.append(".dialog {color:#006699}");
            stringBuffer.append("</style></head>");
            return stringBuffer.toString();
        }

        protected String getStatBlockLinePossessions() {
            StringBuffer stringBuffer = new StringBuffer();
            PlayerCharacterOutput playerCharacterOutput = new PlayerCharacterOutput(PcgCombatant.this.pc);
            stringBuffer.append("<p><font class='type'>Possessions:</font>&nbsp;");
            stringBuffer.append(playerCharacterOutput.getEquipmentList());
            stringBuffer.append("</p>");
            return stringBuffer.toString();
        }

        protected String getStatBlockLineSkills() {
            StringBuffer stringBuffer = new StringBuffer();
            PlayerCharacterOutput playerCharacterOutput = new PlayerCharacterOutput(PcgCombatant.this.pc);
            stringBuffer.append("<p><font class='type'>Skills and Feats:</font>&nbsp;");
            PcgCombatant.this.pc.getAllSkillList(true);
            int n = SettingsHandler.getIncludeSkills();
            if (n == 3) {
                n = SettingsHandler.getSkillsTab_IncludeSkills();
            }
            ArrayList<Skill> arrayList = PcgCombatant.this.pc.getSkillListInOutputOrder(PcgCombatant.this.pc.getPartialSkillList(Visibility.OUTPUT_ONLY));
            boolean bl = true;
            for (Skill skill : arrayList) {
                if (!bl) {
                    stringBuffer.append(", ");
                }
                bl = false;
                if (skill.getKeyStat().compareToIgnoreCase("None") != 0) {
                    int n2 = skill.modifier(PcgCombatant.this.pc) - PcgCombatant.this.pc.getStatList().getStatModFor(skill.getKeyStat());
                    Logging.debugPrint("modSkill: " + n2);
                }
                int n3 = skill.modifier(PcgCombatant.this.pc) + skill.getTotalRank(PcgCombatant.this.pc).intValue();
                stringBuffer.append("<a href='skill:");
                stringBuffer.append(skill.getOutputName());
                stringBuffer.append("\\1d20");
                stringBuffer.append(n3 < 0 ? Integer.toString(n3) : "+" + n3);
                stringBuffer.append("' class='dialog'> ");
                stringBuffer.append(skill.getOutputName());
                stringBuffer.append(" (");
                stringBuffer.append(n3);
                stringBuffer.append(")</a>");
            }
            stringBuffer.append("; ");
            stringBuffer.append(playerCharacterOutput.getFeatList());
            stringBuffer.append("</p>");
            return stringBuffer.toString();
        }

        protected String getStatBlockLineSpells() {
            Object object;
            StringBuffer stringBuffer = new StringBuffer();
            PlayerCharacterOutput playerCharacterOutput = new PlayerCharacterOutput(PcgCombatant.this.pc);
            if (PcgCombatant.this.pc.hasCharacterDomainList()) {
                stringBuffer.append("<p>");
                stringBuffer.append("<font class='type'>Deity:</font>");
                stringBuffer.append(playerCharacterOutput.getDeity());
                stringBuffer.append("<br>");
                stringBuffer.append("<font class='type'>Domains:</font>&nbsp;");
                boolean bl = true;
                for (CharacterDomain object22 : PcgCombatant.this.pc.getCharacterDomainList()) {
                    if (!bl) {
                        stringBuffer.append(", ");
                    }
                    bl = false;
                    object = object22.getDomain();
                    stringBuffer.append(playerCharacterOutput.getDomainName((Domain)object));
                    stringBuffer.append(" (");
                    stringBuffer.append(playerCharacterOutput.getDomainPower(PcgCombatant.this.pc, (Domain)object));
                    stringBuffer.append(")");
                }
                stringBuffer.append("</p>");
            }
            stringBuffer.append("<p>");
            ArrayList<PObject> arrayList = new ArrayList<PObject>(PcgCombatant.this.pc.getClassList());
            arrayList.add((PCClass)((Object)PcgCombatant.this.pc.getRace()));
            ArrayList<String> arrayList2 = new ArrayList<String>(PcgCombatant.this.pc.getSpellBooks());
            arrayList2.add(Globals.getDefaultSpellBook());
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                this.statBlockLineSpellBook(PcgCombatant.this.pc, stringBuffer, arrayList, (String)object);
            }
            return stringBuffer.toString();
        }

        protected void statBlockLineSpellBook(PlayerCharacter playerCharacter, StringBuffer stringBuffer, ArrayList<PObject> arrayList, String string) {
            boolean bl = false;
            for (PObject pObject : arrayList) {
                if (pObject == null) continue;
                int n = 0;
                List<CharacterSpell> list = pObject.getSpellSupport().getCharacterSpell(null, string, n);
                if (list.size() >= 1) {
                    if (!bl) {
                        stringBuffer.append("<br><font class='type'>" + string + ":</font><br> ");
                    }
                    stringBuffer.append("<font class='type'>" + pObject.getDisplayName() + ":</font><br> ");
                    bl = true;
                }
                while (list.size() >= 1) {
                    stringBuffer.append("<font class='type'>Level " + n + ":</font> ");
                    boolean bl2 = true;
                    for (CharacterSpell characterSpell : list) {
                        if (!bl2) {
                            stringBuffer.append(", ");
                        }
                        bl2 = false;
                        Spell spell = characterSpell.getSpell();
                        stringBuffer.append("<a href=\"spell:");
                        stringBuffer.append(spell.getDisplayName());
                        stringBuffer.append("\\");
                        stringBuffer.append(playerCharacter.parseSpellString(spell, spell.getDescription(playerCharacter), characterSpell.getOwner()));
                        stringBuffer.append("\\");
                        stringBuffer.append(spell.getRange());
                        stringBuffer.append("\\");
                        stringBuffer.append(spell.getCastingTime());
                        stringBuffer.append("\\");
                        stringBuffer.append(spell.getSaveInfo());
                        stringBuffer.append("\\");
                        stringBuffer.append(playerCharacter.parseSpellString(spell, spell.getDuration(), characterSpell.getOwner()));
                        stringBuffer.append("\\");
                        stringBuffer.append(playerCharacter.parseSpellString(spell, spell.getTarget(), characterSpell.getOwner()));
                        stringBuffer.append("\" class=\"dialog\">");
                        stringBuffer.append(spell.getDisplayName());
                        stringBuffer.append("</a>");
                    }
                    stringBuffer.append("<br>");
                    list = pObject.getSpellSupport().getCharacterSpell(null, string, ++n);
                }
            }
        }

        protected String getStatBlockTitle() {
            StringBuffer stringBuffer = new StringBuffer();
            PlayerCharacterOutput playerCharacterOutput = new PlayerCharacterOutput(PcgCombatant.this.pc);
            stringBuffer.append("<p class='gork'><font size='+1'><b>");
            stringBuffer.append(playerCharacterOutput.getName());
            stringBuffer.append(", ");
            stringBuffer.append(playerCharacterOutput.getGender());
            stringBuffer.append(" ");
            stringBuffer.append(playerCharacterOutput.getRaceName());
            String string = playerCharacterOutput.getRegion();
            if (!"".equals(string) && string != null && !"None".equals(string)) {
                stringBuffer.append(" From " + string + " ");
            }
            stringBuffer.append(playerCharacterOutput.getClasses() + " ");
            stringBuffer.append("</b></font></p>");
            return stringBuffer.toString();
        }
    }
}

