/*
 * Decompiled with CFR 0.152.
 */
package gmgen.plugin;

import gmgen.plugin.Event;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Spell
extends Event {
    protected String anEffect;
    protected String aName;
    protected String aPlayer;
    protected String aStatus = "Active";
    protected boolean anAlert;
    protected int aDuration;

    public Spell(String string, String string2, String string3, int n, int n2, boolean bl) {
        super(string, string2, string3, n, n2, bl);
    }

    public Spell(Element element) {
        try {
            String string = element.getAttribute("name").getValue();
            String string2 = element.getAttribute("player").getValue();
            String string3 = element.getAttribute("status").getValue();
            String string4 = element.getAttribute("effect").getValue();
            int n = element.getChild("Initiative").getAttribute("duration").getIntValue();
            int n2 = element.getChild("Initiative").getAttribute("initiative").getIntValue();
            boolean bl = element.getChild("Initiative").getAttribute("alert").getBooleanValue();
            this.setValues(string, string2, string3, string4, n, n2, bl);
        }
        catch (Exception exception) {
            Logging.errorPrint("Initiative", exception);
        }
    }

    @Override
    public String getEndText() {
        return "Spell " + this.getName() + "'s Duration Expired";
    }

    @Override
    public Vector<String> getRowVector(List<String> list) {
        Vector<String> vector = new Vector<String>();
        for (String string : list) {
            if (string.equals("Name")) {
                vector.add("Spell: " + this.getName());
                continue;
            }
            if (string.equals("Player")) {
                vector.add("Owner: " + this.getPlayer());
                continue;
            }
            if (string.equals("Status")) {
                vector.add(this.getStatus());
                continue;
            }
            if (string.equals("+")) {
                vector.add("");
                continue;
            }
            if (string.equals("Init")) {
                vector.add("" + this.init.getCurrentInitiative());
                continue;
            }
            if (string.equals("Dur")) {
                vector.add("" + this.getDuration());
                continue;
            }
            if (string.equals("#")) {
                vector.add("");
                continue;
            }
            if (string.equals("HP")) {
                vector.add("");
                continue;
            }
            if (string.equals("HP Max")) {
                vector.add("");
                continue;
            }
            if (!string.equals("Type")) continue;
            vector.add("-");
        }
        return vector;
    }

    @Override
    public Element getSaveElement() {
        Element element = new Element("Spell");
        Element element2 = new Element("Initiative");
        element2.setAttribute("initiative", this.init.getCurrentInitiative() + "");
        element2.setAttribute("duration", this.getDuration() + "");
        element2.setAttribute("alert", this.isAlert() + "");
        element.addContent(element2);
        element.setAttribute("name", this.getName());
        element.setAttribute("player", this.getPlayer());
        element.setAttribute("status", this.getStatus());
        element.setAttribute("effect", this.getEffect());
        return element;
    }
}

