/*
 * Decompiled with CFR 0.152.
 */
package gmgen.plugin;

import gmgen.plugin.Combatant;
import gmgen.plugin.PcgCombatant;
import gmgen.plugin.SystemAttribute;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.StatList;

public class SystemHP {
    private String state = "";
    private SystemAttribute attribute;
    private boolean firstround;
    private int current;
    private int max;
    private int subdual;

    public SystemHP(SystemAttribute systemAttribute, int n, int n2) {
        this.attribute = systemAttribute;
        this.max = n;
        this.current = n2;
    }

    public SystemHP(SystemAttribute systemAttribute, int n) {
        this(systemAttribute, n, n);
    }

    public SystemHP(int n) {
        this(new SystemAttribute("Attribute", 10), n, n);
    }

    public void setAttribute(SystemAttribute systemAttribute) {
        this.attribute = systemAttribute;
    }

    public SystemAttribute getAttribute() {
        return this.attribute;
    }

    public void setCurrent(int n) {
        int n2 = n;
        if (n2 > this.max) {
            n2 = this.max;
        }
        if (n2 > this.current) {
            this.heal(n2 - this.current);
        } else if (n2 < this.current) {
            this.damage(this.current - n2);
        }
    }

    public int getCurrent() {
        return this.current;
    }

    public static boolean isD20ModernMassive(Combatant combatant, int n) {
        if (combatant instanceof PcgCombatant) {
            PcgCombatant pcgCombatant = (PcgCombatant)combatant;
            PlayerCharacter playerCharacter = pcgCombatant.getPC();
            Globals.setCurrentPC(playerCharacter);
            StatList statList = playerCharacter.getStatList();
            if (n > statList.getTotalStatFor("CON")) {
                return true;
            }
        } else if (n > combatant.getHP().getAttribute().getValue()) {
            return true;
        }
        return false;
    }

    public static boolean isDndMassive(Combatant combatant, int n) {
        int n2 = 50;
        if (SettingsHandler.getGMGenOption("Initiative.Damage.Massive.SizeMod", true) && combatant instanceof PcgCombatant) {
            PcgCombatant pcgCombatant = (PcgCombatant)combatant;
            PlayerCharacter playerCharacter = pcgCombatant.getPC();
            String string = playerCharacter.getSize();
            if (string.equals("Fine")) {
                n2 = 10;
            }
            if (string.equals("Diminutive")) {
                n2 = 20;
            }
            if (string.equals("Tiny")) {
                n2 = 30;
            }
            if (string.equals("Small")) {
                n2 = 40;
            }
            if (string.equals("Large")) {
                n2 = 60;
            }
            if (string.equals("Huge")) {
                n2 = 70;
            }
            if (string.equals("Gargantuan")) {
                n2 = 80;
            }
            if (string.equals("Colossal")) {
                n2 = 90;
            }
        }
        return n >= n2;
    }

    public static boolean isHouseHalfMassive(Combatant combatant, int n) {
        SystemHP systemHP = combatant.getHP();
        return n > systemHP.getMax();
    }

    public void setMax(int n) {
        this.max = n;
        if (this.max > this.current) {
            this.current = this.max;
        }
    }

    public int getMax() {
        return this.max;
    }

    public void setState(String string) {
        this.state = string;
    }

    public String getState() {
        return this.state;
    }

    public void setSubdual(int n) {
        this.subdualDamage(n - this.getSubdual());
    }

    public int getSubdual() {
        return this.subdual;
    }

    public String bleed() {
        if (this.state.equals("Bleeding") && !this.firstround) {
            this.damage(1);
        }
        return this.state;
    }

    public String damage(int n) {
        int n2;
        if (this.current > -1 && this.current - n < 0 && (n2 = SettingsHandler.getGMGenOption("Initiative.Damage.Dying.Start", true)) == 0) {
            this.firstround = true;
        }
        this.current -= n;
        n2 = SettingsHandler.getGMGenOption("Initiative.Damage.Disabled", 1);
        int n3 = 0;
        if (n2 == 2) {
            n3 = -1 * Math.max(0, this.attribute.getModifier());
        }
        if (this.current <= 0 && this.current >= n3) {
            this.state = "Disabled";
        } else if (this.current < n3) {
            this.state = "Bleeding";
        }
        int n4 = SettingsHandler.getGMGenOption("Initiative.Damage.Death", 1);
        if (n4 == 1) {
            if (this.current <= -10) {
                this.state = "Dead";
                this.current = 0;
            }
        } else if (n4 == 2 && this.current <= -1 * this.attribute.getValue()) {
            this.state = "Dead";
            this.current = 0;
        }
        this.checkSubdual();
        return this.state;
    }

    public String endDurationedStatus() {
        if (this.state.equals("Unconsious") || this.state.equals("Dazed")) {
            this.state = "";
        }
        return this.state;
    }

    public void endRound() {
        this.firstround = false;
    }

    public String heal(int n) {
        if (!this.state.equals("Dead")) {
            this.current += n;
            this.subdual -= n;
            if (this.current > this.max) {
                this.current = this.max;
            }
            if (this.subdual < 0) {
                this.subdual = 0;
            }
            if (this.state.equals("Bleeding")) {
                this.state = "Stable";
            }
            if (this.current > 0) {
                this.state = "";
            }
            this.checkSubdual();
        }
        return this.state;
    }

    public String kill() {
        this.state = "Dead";
        this.current = 0;
        return this.state;
    }

    public String nonLethalDamage(boolean bl) {
        if (this.state.equals("")) {
            this.state = bl ? "Unconsious" : "Dazed";
        }
        return this.state;
    }

    public String raise() {
        if (this.state.equals("Dead")) {
            this.state = "";
            this.current = 1;
        }
        return this.state;
    }

    public String stabilize() {
        if (this.state.equals("Bleeding")) {
            this.state = "Stable";
        }
        return this.state;
    }

    public String subdualDamage(int n) {
        this.subdual += n;
        return this.checkSubdual();
    }

    private String checkSubdual() {
        int n = SettingsHandler.getGMGenOption("Initiative.Damage.Disabled", 1);
        int n2 = 0;
        if (n == 2) {
            n2 = Math.max(0, this.attribute.getModifier());
        }
        if ((this.state.equals("") || this.state.equals("Staggered") || this.state.equals("Unconsious")) && this.subdual > 0) {
            if (this.subdual >= this.current && this.subdual <= this.current + n2) {
                this.state = "Staggered";
            } else if (this.subdual > this.current + n2) {
                this.state = "Unconsious";
            }
        }
        return this.state;
    }
}

