/*
 * Decompiled with CFR 0.152.
 */
package gmgen.pluginmgr;

import gmgen.GMGenSystem;
import gmgen.gui.PreferencesPluginsPanel;
import gmgen.pluginmgr.Plugin;
import gmgen.pluginmgr.PluginLoader;
import gmgen.pluginmgr.RequiredPlugin;
import gmgen.util.MiscUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import pcgen.core.SettingsHandler;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.core.prereq.PrerequisiteTestFactory;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.TokenStore;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriterFactory;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriterInterface;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.persistence.lst.prereq.PrerequisiteParserInterface;
import pcgen.util.Logging;
import pcgen.util.PCGenCommand;
import pcgen.util.PJEP;
import pcgen.util.UnreachableError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JARClassLoader
extends ClassLoader {
    private static final JARClassLoader NO_CLASS = new JARClassLoader();
    private static Hashtable<String, JARClassLoader> classHash = new Hashtable();
    private Plugin.JAR jar;
    private List<String> pluginClasses = new ArrayList<String>();
    private ZipFile zipFile;

    public JARClassLoader() {
    }

    public JARClassLoader(String string) throws IOException {
        this.zipFile = new ZipFile(string);
        this.jar = new Plugin.JAR(string, this);
        Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement().getName();
            if (!string2.endsWith(".class")) continue;
            classHash.put(MiscUtilities.fileToClass(string2), this);
            this.pluginClasses.add(string2);
        }
        PluginLoader.addPluginJAR(this.jar);
    }

    public ZipFile getZipFile() {
        return this.zipFile;
    }

    public void closeZipFile() {
        if (this.zipFile == null) {
            return;
        }
        try {
            this.zipFile.close();
        }
        catch (IOException iOException) {
            Logging.errorPrint(iOException.getMessage(), iOException);
        }
        this.zipFile = null;
    }

    @Override
    public Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        JARClassLoader jARClassLoader = classHash.get(string);
        if (jARClassLoader == NO_CLASS) {
            throw new ClassNotFoundException(string);
        }
        if (jARClassLoader != null) {
            return jARClassLoader._loadClass(string, bl);
        }
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            Class<?> clazz = classLoader != null ? classLoader.loadClass(string) : this.findSystemClass(string);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            classHash.put(string, NO_CLASS);
            throw classNotFoundException;
        }
    }

    public void startAllPlugins(String string) {
        ArrayList<Plugin> arrayList = new ArrayList<Plugin>();
        for (String string2 : this.pluginClasses) {
            String object = MiscUtilities.fileToClass(string2);
            try {
                Plugin plugin = this.loadPluginClass(object, string);
                if (plugin == null) continue;
                arrayList.add(plugin);
            }
            catch (Throwable throwable) {
                Logging.errorPrint("Error while starting plugin " + throwable.getMessage(), throwable);
                this.jar.addPlugin(new Plugin.Broken(object));
                Object[] objectArray = new String[]{throwable.toString()};
                PluginLoader.pluginError(this.jar.getPath(), "plugin-error.start-error", objectArray);
            }
        }
        Collections.sort(arrayList, new Plugin.PluginComperator());
        for (Plugin plugin : arrayList) {
            if (Logging.isDebugMode()) {
                Logging.debugPrint("Starting " + string + " plugin " + plugin.getName() + " (version " + MiscUtilities.buildToVersion(plugin.getVersion()) + ")");
            }
            this.jar.addPlugin(plugin);
        }
    }

    private Class<?> _loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(string);
        if (clazz != null) {
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        String string2 = MiscUtilities.classToFile(string);
        try {
            ZipEntry zipEntry = this.zipFile.getEntry(string2);
            if (zipEntry == null) {
                throw new ClassNotFoundException(string);
            }
            InputStream inputStream = this.zipFile.getInputStream(zipEntry);
            int n = (int)zipEntry.getSize();
            byte[] byArray = new byte[n];
            int n2 = 0;
            int n3 = 0;
            while (n2 < n) {
                if ((n2 = inputStream.read(byArray, n3 += n2, n -= n2)) != -1) continue;
                Logging.debugPrint("Failed to load class " + string + " from " + this.zipFile.getName());
                throw new ClassNotFoundException(string);
            }
            clazz = this.defineClass(string, byArray, 0, byArray.length);
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        catch (IOException iOException) {
            Logging.errorPrint(iOException.getMessage(), iOException);
            throw new ClassNotFoundException(string);
        }
    }

    private boolean checkDependencies(String string) {
        String string2;
        int n = 0;
        while ((string2 = SettingsHandler.getGMGenOption("plugin." + string + ".depend." + n++, null)) != null) {
            Object[] objectArray;
            int n2 = string2.indexOf(32);
            if (n2 == -1) {
                Logging.debugPrint(string + " has an invalid" + " dependency: " + string2);
                return false;
            }
            String string3 = string2.substring(0, n2);
            String string4 = string2.substring(n2 + 1);
            if (string3.equals("jdk")) {
                if (MiscUtilities.compareStrings(System.getProperty("java.version"), string4, false) >= 0) continue;
                Object[] objectArray2 = new String[]{string4, System.getProperty("java.version")};
                PluginLoader.pluginError(this.jar.getPath(), "plugin-error.dep-jdk", objectArray2);
                return false;
            }
            if (string3.equals("gmgen")) {
                if (string4.length() != 11) {
                    Logging.debugPrint("Invalid GMGen version number: " + string4);
                    return false;
                }
                if (MiscUtilities.compareStrings(GMGenSystem.getBuild(), string4, false) >= 0) continue;
                String string5 = MiscUtilities.buildToVersion(string4);
                objectArray = new String[]{string5, GMGenSystem.getVersion()};
                PluginLoader.pluginError(this.jar.getPath(), "plugin-error.dep-jedit", objectArray);
                return false;
            }
            if (string3.equals("plugin")) {
                int n3 = string4.indexOf(32);
                if (n3 == -1) {
                    Logging.debugPrint(string + " has an invalid dependency: " + string2 + " (version is missing)");
                    return false;
                }
                objectArray = string4.substring(0, n3);
                String string6 = string4.substring(n3 + 1);
                String string7 = SettingsHandler.getGMGenOption("plugin." + (String)objectArray + ".version", null);
                if (string7 == null) {
                    Object[] objectArray3 = new String[]{string6, objectArray};
                    PluginLoader.pluginError(this.jar.getPath(), "plugin-error.dep-plugin.no-version", objectArray3);
                    return false;
                }
                if (MiscUtilities.compareStrings(string7, string6, false) < 0) {
                    Object[] objectArray4 = new String[]{string6, objectArray, string7};
                    PluginLoader.pluginError(this.jar.getPath(), "plugin-error.dep-plugin", objectArray4);
                    return false;
                }
                if (!(PluginLoader.getPlugin((String)objectArray) instanceof Plugin.Broken)) continue;
                Object[] objectArray5 = new String[]{objectArray};
                PluginLoader.pluginError(this.jar.getPath(), "plugin-error.dep-plugin.broken", objectArray5);
                return false;
            }
            if (string3.equals("class")) {
                try {
                    this.loadClass(string4, false);
                    continue;
                }
                catch (Exception exception) {
                    objectArray = new String[]{string4};
                    PluginLoader.pluginError(this.jar.getPath(), "plugin-error.dep-class", objectArray);
                    return false;
                }
            }
            Logging.debugPrint(string + " has unknown" + " dependency: " + string2);
            return false;
        }
        return true;
    }

    private Plugin loadPluginClass(String string, String string2) throws Exception {
        for (Plugin plugin : PluginLoader.getPlugins()) {
            if (!plugin.getClass().getName().equals(string)) continue;
            PluginLoader.pluginError(this.jar.getPath(), "plugin-error.already-loaded", null);
            return null;
        }
        if (!this.checkDependencies(string)) {
            this.jar.addPlugin(new Plugin.Broken(string));
            return null;
        }
        Class<?> clazz = this.loadClass(string, true);
        int n = clazz.getModifiers();
        if (string2.equals("Tokens")) {
            this.loadOutputTokenClass(clazz, n);
            this.loadLstTokens(clazz, n);
            this.loadBonusTokens(clazz, string, n);
            this.loadPreTokens(clazz, n);
            this.loadJepCommands(clazz, n);
        }
        return this.loadPluginClass(clazz, n, string, string2);
    }

    private Plugin loadPluginClass(Class<?> clazz, int n, String string, String string2) throws Exception {
        if (!Modifier.isInterface(n) && !Modifier.isAbstract(n) && Plugin.class.isAssignableFrom(clazz)) {
            Plugin plugin = (Plugin)clazz.newInstance();
            boolean bl = true;
            if (!RequiredPlugin.class.isAssignableFrom(clazz)) {
                bl = this.addPreferencesPanel(clazz, plugin);
            }
            if (bl && plugin.getPluginSystem().equals(string2)) {
                if (plugin.getVersion() == null || plugin.getName() == null) {
                    Logging.debugPrint("Plugin " + string + " needs" + " 'name' and 'version' properties.");
                    this.jar.addPlugin(new Plugin.Broken(string));
                    return null;
                }
                return plugin;
            }
        }
        return null;
    }

    private void loadOutputTokenClass(Class<?> clazz, int n) throws Exception {
        if (!Modifier.isInterface(n) && !Modifier.isAbstract(n) && Token.class.isAssignableFrom(clazz)) {
            Token token = (Token)clazz.newInstance();
            ExportHandler.addToTokenMap(token);
        }
    }

    private void loadLstTokens(Class<?> clazz, int n) throws Exception {
        if (!Modifier.isInterface(n) && !Modifier.isAbstract(n) && LstToken.class.isAssignableFrom(clazz)) {
            LstToken lstToken = (LstToken)clazz.newInstance();
            TokenStore.inst().addToTokenMap(lstToken);
        }
    }

    private void loadBonusTokens(Class<?> clazz, String string, int n) throws Exception {
        if (!Modifier.isInterface(n) && !Modifier.isAbstract(n) && BonusObj.class.isAssignableFrom(clazz)) {
            Bonus.addBonusClass(clazz, string);
        }
    }

    private void loadPreTokens(Class<?> clazz, int n) throws Exception {
        if (!Modifier.isInterface(n) && !Modifier.isAbstract(n)) {
            if (PrerequisiteParserInterface.class.isAssignableFrom(clazz)) {
                PrerequisiteParserInterface prerequisiteParserInterface = (PrerequisiteParserInterface)clazz.newInstance();
                PreParserFactory.register(prerequisiteParserInterface);
            } else if (PrerequisiteTest.class.isAssignableFrom(clazz)) {
                PrerequisiteTest prerequisiteTest = (PrerequisiteTest)clazz.newInstance();
                PrerequisiteTestFactory.register(prerequisiteTest);
            } else if (PrerequisiteWriterInterface.class.isAssignableFrom(clazz)) {
                PrerequisiteWriterInterface prerequisiteWriterInterface = (PrerequisiteWriterInterface)clazz.newInstance();
                PrerequisiteWriterFactory.register(prerequisiteWriterInterface);
            }
        }
    }

    private void loadJepCommands(Class clazz, int n) throws Exception {
        if (!Modifier.isInterface(n) && !Modifier.isAbstract(n) && PCGenCommand.class.isAssignableFrom(clazz)) {
            PJEP.addCommand(clazz);
        }
    }

    private boolean addPreferencesPanel(Class<?> clazz, Plugin plugin) {
        boolean bl = true;
        try {
            Field field = clazz.getField("LOG_NAME");
            String string = (String)field.get(plugin);
            String string2 = plugin.getName();
            String string3 = plugin.getPluginSystem();
            PreferencesPluginsPanel.addPanel(string, string2, string3);
            bl = SettingsHandler.getGMGenOption(string + ".Load", true);
        }
        catch (SecurityException securityException) {
            throw new UnreachableError("Access to Class " + clazz + " should not be prohibited", securityException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnreachableError("Access to Method LOG_NAME in Class " + clazz + " should not be prohibited", illegalAccessException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Logging.errorPrint(clazz.getName() + " does not have LOG_NAME defined, " + "Plugin class implemented improperly");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logging.errorPrint(clazz.getName() + " does not have LOG_NAME defined to " + "take a Plugin as the argument, " + "Plugin class implemented improperly");
        }
        return bl;
    }
}

