/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.List;
import pcgen.core.AbilityCategory;
import pcgen.core.AbilityUtilities;
import pcgen.core.Categorisable;
import pcgen.core.Globals;
import pcgen.core.HasCost;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.SpecialAbility;
import pcgen.core.chooser.ChooserUtilities;
import pcgen.core.levelability.LevelAbility;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.utils.IntegerKey;
import pcgen.core.utils.ListKey;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.core.utils.StringKey;
import pcgen.util.Logging;
import pcgen.util.chooser.ChooserFactory;
import pcgen.util.enumeration.Tab;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Ability
extends PObject
implements HasCost,
Categorisable {
    private boolean multiples = false;
    private boolean needsSaving = false;
    private boolean stacks = false;
    private Nature theNature = Nature.NORMAL;

    public void setAddSpellLevel(int n) {
        this.integerChar.put(IntegerKey.ADD_SPELL_LEVEL, n);
    }

    public int getAddSpellLevel() {
        Integer n = (Integer)this.integerChar.get(IntegerKey.ADD_SPELL_LEVEL);
        return n == null ? 0 : n;
    }

    public void setAddString(String string) {
        this.stringChar.put(StringKey.ADD, string);
    }

    public String getAddString() {
        String string = (String)this.stringChar.get(StringKey.ADD);
        return string == null ? "" : string;
    }

    public void setBenefit(String string) {
        this.stringChar.put(StringKey.BENEFIT, string);
    }

    public String getBenefit() {
        String string = (String)this.stringChar.get(StringKey.BENEFIT);
        return string == null ? "" : string;
    }

    public String getBenefitDescription() {
        if (SettingsHandler.useFeatBenefits() && this.getBenefit().length() > 1) {
            return this.getBenefit();
        }
        return this.getDescription();
    }

    @Override
    public String getDescription(PlayerCharacter playerCharacter) {
        if (SettingsHandler.useFeatBenefits() && this.getBenefit().length() > 1) {
            return this.getBenefit();
        }
        return super.getDescription(playerCharacter);
    }

    public void setCategory(String string) {
        this.stringChar.put(StringKey.CATEGORY, string);
    }

    @Override
    public String getCategory() {
        String string = (String)this.stringChar.get(StringKey.CATEGORY);
        return string == null ? "FEAT" : string;
    }

    public boolean isFeat() {
        return "FEAT".equals(this.getCategory());
    }

    @Override
    public void setCost(String string) {
        this.stringChar.put(StringKey.COST, string);
    }

    @Override
    public double getCost() {
        return Double.parseDouble(this.getCostString());
    }

    public String getCostString() {
        String string = (String)this.stringChar.get(StringKey.COST);
        return string == null ? "1" : string;
    }

    public double getCost(PlayerCharacter playerCharacter) {
        return playerCharacter.getVariableValue(this.getCostString(), "").doubleValue();
    }

    public void setFeatType(Nature nature) {
        if (nature == Nature.ANY) {
            return;
        }
        this.theNature = nature;
    }

    public Nature getFeatType() {
        return this.theNature;
    }

    boolean matchesType(String string) {
        return this.isType(string);
    }

    public void setMultiples(String string) {
        char c;
        this.multiples = string.length() == 0 ? false : (c = string.charAt(0)) == 'y' || c == 'Y';
    }

    public boolean isMultiples() {
        return this.multiples;
    }

    public void setNeedsSaving(boolean bl) {
        this.needsSaving = bl;
    }

    public boolean needsSaving() {
        return this.needsSaving;
    }

    public void setStacks(String string) {
        this.stacks = string.length() > 0 && string.charAt(0) == 'Y';
    }

    public boolean isStacks() {
        return this.stacks;
    }

    public boolean canAddAssociation(String string) {
        return this.isStacks() || this.isMultiples() && !this.containsAssociated(string);
    }

    @Override
    public Ability clone() {
        try {
            return (Ability)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ShowMessageDelegate.showMessageDialog(cloneNotSupportedException.getMessage(), "PCGen", MessageType.ERROR);
            return null;
        }
    }

    @Override
    public String getPCCText() {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(this.getDisplayName());
        stringBuffer.append("\tCATEGORY:").append(this.getCategory());
        stringBuffer.append("\tCOST:").append(String.valueOf(this.getCost()));
        if (this.isMultiples()) {
            stringBuffer.append("\tMULT:Y");
        }
        if (this.isStacks()) {
            stringBuffer.append("\tSTACK:Y");
        }
        if (this.getAddSpellLevel() != 0) {
            stringBuffer.append("\tADDSPELLLEVEL:").append(this.getAddSpellLevel());
        }
        if (this.getAddString().length() != 0) {
            stringBuffer.append("\tADD:").append(this.getAddString());
        }
        stringBuffer.append("\tVISIBLE:");
        switch (this.getVisibility()) {
            case HIDDEN: {
                stringBuffer.append("EXPORT");
                break;
            }
            case OUTPUT_ONLY: {
                stringBuffer.append("EXPORT");
                break;
            }
            case DISPLAY_ONLY: {
                stringBuffer.append("DISPLAY");
                break;
            }
            default: {
                stringBuffer.append("YES");
            }
        }
        if (this.getChoiceToModify().length() != 0) {
            stringBuffer.append("\tMODIFYABILITYCHOICE:" + this.getChoiceToModify());
        }
        stringBuffer.append(super.getPCCText(false));
        return stringBuffer.toString();
    }

    public String qualifiedName() {
        StringBuffer stringBuffer = new StringBuffer(this.getOutputName());
        if (this.getAssociatedCount() > 0 && !this.getKeyName().startsWith("Armor Proficiency")) {
            if (this.getChoiceString().length() == 0 || this.multiples && this.stacks) {
                if (this.getAssociatedCount() > 1) {
                    stringBuffer.append(" (");
                    stringBuffer.append((int)((double)this.getAssociatedCount() * this.getCost()));
                    stringBuffer.append("x)");
                }
            } else {
                int n = 0;
                stringBuffer.append(" (");
                for (int i = 0; i < this.getAssociatedCount(true); ++i) {
                    if (n > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(this.getAssociated(i, true));
                    ++n;
                }
                stringBuffer.append(')');
            }
        }
        return stringBuffer.toString();
    }

    @Override
    protected List<SpecialAbility> addSpecialAbilitiesToList(List<SpecialAbility> list, PlayerCharacter playerCharacter) {
        List<SpecialAbility> list2 = this.getListFor(ListKey.SPECIAL_ABILITY);
        if (list2 != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (SpecialAbility specialAbility : list2) {
                String string = specialAbility.getKeyName();
                int n = string.indexOf("%CHOICE");
                if (n >= 0) {
                    stringBuffer.setLength(0);
                    stringBuffer.append(string.substring(0, n));
                    if (this.getAssociatedCount() != 0) {
                        for (int i = 0; i < this.getAssociatedCount(); ++i) {
                            if (i != 0) {
                                stringBuffer.append(" ,");
                            }
                            stringBuffer.append(this.getAssociated(i));
                        }
                    } else {
                        stringBuffer.append("<undefined>");
                    }
                    stringBuffer.append(string.substring(n + 7));
                    specialAbility = new SpecialAbility(stringBuffer.toString(), specialAbility.getSASource(), specialAbility.getSADesc());
                }
                list.add(specialAbility);
            }
        }
        return list;
    }

    boolean canBeSelectedBy(PlayerCharacter playerCharacter) {
        return PrereqHandler.passesAll(this.getPreReqList(), playerCharacter, this);
    }

    public boolean modChoices(PlayerCharacter playerCharacter, boolean bl, AbilityCategory abilityCategory) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        return this.modChoices(arrayList, arrayList2, true, playerCharacter, bl, abilityCategory);
    }

    public boolean modChoices(List list, List list2, boolean bl, PlayerCharacter playerCharacter, boolean bl2, AbilityCategory abilityCategory) {
        return ChooserUtilities.modChoices(this, list, list2, bl, playerCharacter, bl2, abilityCategory);
    }

    @Override
    int numberInList(String string) {
        String string2;
        int n = 0;
        if (string.lastIndexOf(61) > -1) {
            string = string.substring(string.lastIndexOf(61) + 1);
        }
        if (string.lastIndexOf(43) > -1 && "0123456789".lastIndexOf((string2 = string.substring(string.lastIndexOf(43) + 1)).substring(0, 1)) > 0) {
            string = string.substring(0, string.lastIndexOf(43));
        }
        if (string.lastIndexOf(45) > -1 && "0123456789".lastIndexOf((string2 = string.substring(string.lastIndexOf(45) + 1)).substring(0, 1)) > 0) {
            string = string.substring(0, string.lastIndexOf(45));
        }
        for (int i = 0; i < this.getAssociatedCount(); ++i) {
            if (!this.getAssociated(i).equalsIgnoreCase(string)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public LevelAbility addAddList(int n, String string) {
        if (string.startsWith("TEMPLATE|")) {
            this.setAddString(string);
            return null;
        }
        return super.addAddList(n, string);
    }

    @Override
    boolean isTypeHidden(String string) {
        return Globals.isAbilityTypeHidden(string);
    }

    public void setChoiceToModify(String string) {
        this.stringChar.put(StringKey.CHOICE_TO_MODIFY, string);
    }

    public String getChoiceToModify() {
        String string = (String)this.stringChar.get(StringKey.CHOICE_TO_MODIFY);
        return string == null ? "" : string;
    }

    public boolean modifyChoice(PlayerCharacter playerCharacter) {
        Ability ability;
        Object object;
        String string = this.getChoiceToModify();
        if (string.length() == 0) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = new ArrayList();
        if (string.startsWith("TYPE=") || string.startsWith("TYPE=")) {
            String string2 = string.substring(5);
            for (Ability ability2 : playerCharacter.aggregateFeatList()) {
                if (!ability2.isType(string2)) continue;
                arrayList.add(ability2.getKeyName());
            }
            switch (arrayList.size()) {
                case 0: {
                    Logging.debugPrint("PC does not have an ability of type: " + string2);
                    return false;
                }
                case 1: {
                    string = (String)arrayList.get(0);
                    break;
                }
                default: {
                    object = ChooserFactory.getChooserInstance();
                    object.setPoolFlag(false);
                    object.setPool(1);
                    object.setTitle("Select a " + SettingsHandler.getGame().getSingularTabName(Tab.ABILITIES) + " to modify");
                    Globals.sortChooserLists(arrayList, arrayList2);
                    object.setAvailableList(arrayList);
                    object.setSelectedList(arrayList2);
                    object.setVisible(true);
                    int n = object.getSelectedList().size();
                    if (n == 0) {
                        return false;
                    }
                    string = (String)object.getSelectedList().get(0);
                }
            }
        }
        if ((ability = playerCharacter.getFeatNamed(string)) == null) {
            Logging.debugPrint("PC does not have ability: " + string);
            return false;
        }
        if (!ability.isMultiples()) {
            Logging.debugPrint("MULT:NO for: " + string);
            return false;
        }
        ability.modChoices(arrayList, arrayList2, false, playerCharacter, true, SettingsHandler.getGame().getAbilityCategory(this.getCategory()));
        int n = arrayList2.size();
        if (arrayList.size() == 0 || n == 0) {
            return false;
        }
        object = ChooserFactory.getChooserInstance();
        object.setPoolFlag(true);
        object.setPool(0);
        object.setTitle("Modify selections for " + string);
        Globals.sortChooserLists(arrayList, arrayList2);
        object.setAvailableList(arrayList);
        object.setSelectedList(arrayList2);
        object.setVisible(true);
        int n2 = object.getSelectedList().size();
        if (n2 != n) {
            return false;
        }
        ability.clearAssociated();
        for (int i = 0; i < n2; ++i) {
            ability.addAssociated((String)object.getSelectedList().get(i));
        }
        return true;
    }

    @Override
    public int compareTo(Object object) {
        if (object != null) {
            try {
                Ability ability = (Ability)object;
                if (this.getCategory().compareToIgnoreCase(ability.getCategory()) != 0) {
                    return this.getCategory().compareToIgnoreCase(ability.getCategory());
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            return this.keyName.compareToIgnoreCase(((PObject)object).keyName);
        }
        return 1;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof Ability && this.compareTo(object) == 0;
    }

    public int hashCode() {
        return this.keyName.hashCode();
    }

    public boolean isSameBaseAbility(Ability ability) {
        return AbilityUtilities.areSameAbility((Categorisable)this, ability);
    }

    public String getDisplayNameWithChoices() {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Nature {
        NORMAL,
        AUTOMATIC,
        VIRTUAL,
        ANY;

    }
}

