/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import pcgen.core.Ability;
import pcgen.core.AbilityUtilities;
import pcgen.core.Categorisable;
import pcgen.core.EquipmentUtilities;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.PreParserFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbilityInfo
implements Comparable<Object>,
Categorisable {
    protected String keyName;
    protected String category;
    private Ability realThing;
    private List<Prerequisite> prereqList;
    private ArrayList<String> decorations;
    protected char delim = (char)60;
    private static final String split1 = "[<>\\|]";
    private static final String split2 = "[\\[\\]\\|]";

    public AbilityInfo(String string, String string2) {
        this.category = string;
        this.extractPrereqs(string2);
    }

    public AbilityInfo() {
        this.category = "";
        this.keyName = "";
    }

    public Ability getAbility() {
        if (this.realThing == null) {
            this.realThing = AbilityUtilities.retrieveAbilityKeyed(this.category, this.keyName);
            this.decorations = new ArrayList();
            if (this.realThing != null && !this.realThing.getKeyName().equals(this.keyName)) {
                EquipmentUtilities.getUndecoratedName(this.keyName, this.decorations);
            }
        }
        return this.realThing;
    }

    public Iterator<String> getChoicesIterator() {
        List<Object> list = this.getAbility() != null ? this.decorations : Collections.emptyList();
        return list.iterator();
    }

    @Override
    public final String getCategory() {
        return this.category;
    }

    @Override
    public final String getKeyName() {
        return this.keyName;
    }

    public String toString() {
        return this.keyName;
    }

    protected void extractPrereqs(String string) {
        int n = string.indexOf(this.delim);
        if (n < 0) {
            this.keyName = string;
        } else {
            if (this.prereqList == null) {
                this.prereqList = new ArrayList<Prerequisite>();
            }
            List<String> list = Arrays.asList(string.split(this.delim == '<' ? split1 : split2));
            Iterator<String> iterator = list.iterator();
            this.keyName = iterator.next();
            try {
                PreParserFactory preParserFactory = PreParserFactory.getInstance();
                while (iterator.hasNext()) {
                    Prerequisite prerequisite = preParserFactory.parse(iterator.next());
                    if (prerequisite == null) continue;
                    this.prereqList.add(prerequisite);
                }
            }
            catch (PersistenceLayerException persistenceLayerException) {
                persistenceLayerException.printStackTrace();
            }
        }
    }

    public boolean qualifies(PlayerCharacter playerCharacter) {
        if (this.prereqList == null) {
            return true;
        }
        return PrereqHandler.passesAll(this.prereqList, playerCharacter, this.getAbility());
    }

    @Override
    public int compareTo(Object object) {
        String string = this.category;
        try {
            string = ((AbilityInfo)object).getCategory();
            if (string.compareTo(this.category) != 0) {
                return string.compareTo(this.getCategory());
            }
            return ((AbilityInfo)object).getKeyName().compareTo(this.getKeyName());
        }
        catch (ClassCastException classCastException) {
            try {
                Ability ability = (Ability)object;
                return this.getAbility().compareTo(ability);
            }
            catch (ClassCastException classCastException2) {
                PObject pObject = (PObject)object;
                return this.keyName.compareTo(pObject.getKeyName());
            }
        }
    }

    @Override
    public String getDisplayName() {
        return this.getKeyName();
    }
}

