/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import pcgen.core.Globals;
import pcgen.core.KitUtilities;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.RollingMethods;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.core.utils.ListKey;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BioSet
extends PObject {
    private Map<String, String> ageMap = new HashMap<String, String>();
    private Map<String, List<String>> raceMap = new HashMap<String, List<String>>();
    private Map<String, List<String>> userMap = new HashMap<String, List<String>>();

    public Map<String, String> getAgeMap() {
        return this.ageMap;
    }

    public String getAgeMapIndex(String string, int n) {
        String string2 = this.ageMap.get(string + "." + String.valueOf(n));
        if (string2 == null || string2.indexOf("BONUS:") < 0) {
            string2 = this.ageMap.get("None." + String.valueOf(n));
        }
        return string2;
    }

    public String getAgeSetLine(PlayerCharacter playerCharacter) {
        int n = this.getPCAgeSet(playerCharacter);
        return this.getAgeMapIndex(playerCharacter.getRegion(), n);
    }

    public int getAgeSetNamed(String string) {
        String string2 = string.toLowerCase();
        for (Map.Entry<String, String> entry : this.ageMap.entrySet()) {
            int n;
            String string3 = entry.getValue().toLowerCase();
            if (!string3.equals(string2) && !string3.startsWith(string2 + "\t") || (n = (string3 = entry.getKey()).indexOf(46)) < 0) continue;
            return Integer.parseInt(string3.substring(n + 1));
        }
        return -1;
    }

    public int getPCAgeSet(PlayerCharacter playerCharacter) {
        String string;
        int n;
        List<String> list = this.getValueInMaps(playerCharacter.getRegion() + ".", playerCharacter.getRace().getKeyName().trim(), ".BASEAGE");
        if (list == null) {
            return 0;
        }
        int n2 = playerCharacter.getAge();
        int n3 = -1;
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext() && n2 >= (n = Integer.parseInt(string = iterator.next()))) {
            ++n3;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        return n3;
    }

    public String getRacePCCText(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("REGION:").append(string).append("\n\n");
        SortedMap<Integer, SortedMap<String, String>> sortedMap = this.getRaceTagsByAge(string, string2, false);
        return this.appendAgesetInfo(sortedMap, stringBuffer);
    }

    public List<String> getTagForRace(String string, String string2, String string3) {
        return this.getValueInMaps(string, string2, "." + string3);
    }

    public int addToAgeMap(String string, String string2, int n) {
        int n2 = string2.indexOf(124);
        if (n2 >= 0) {
            n = Integer.parseInt(string2.substring(0, n2));
            this.ageMap.put(string + "." + n, string2.substring(n2 + 1));
        } else {
            this.ageMap.put(string + "." + string2, null);
        }
        return n;
    }

    public void addToRaceMap(String string, String string2, String string3, int n) {
        BioSet.addToMap(this.raceMap, string, string2, string3, n);
    }

    public void addToUserMap(String string, String string2, String string3, int n) {
        BioSet.addToMap(this.userMap, string, string2, string3, n);
    }

    private static void addToMap(Map<String, List<String>> map, String string, String string2, String string3, int n) {
        int n2 = string3.indexOf(58);
        if (n2 < 0) {
            Logging.errorPrint("Invalid value sent to map: " + string3 + " (for " + string2 + ")");
            return;
        }
        String string4 = string + "." + string2 + "." + string3.substring(0, n2);
        String string5 = string3.substring(n2 + 1);
        List<String> list = map.get(string4);
        if (list == null) {
            list = new ArrayList<String>();
        }
        while (list.size() < n + 1) {
            list.add("0");
        }
        list.set(n, string5);
        map.put(string4, list);
    }

    public void clearUserMap() {
        this.userMap.clear();
    }

    public void copyRaceTags(String string, String string2, String string3, String string4) {
        SortedMap<Integer, SortedMap<String, String>> sortedMap = this.getRaceTagsByAge(string, string2, true);
        for (Integer n : sortedMap.keySet()) {
            SortedMap sortedMap2 = (SortedMap)sortedMap.get(n);
            for (String string5 : sortedMap2.keySet()) {
                int n2 = n;
                if ("AGESET".equals(string5)) continue;
                SortedMap sortedMap3 = (SortedMap)sortedMap2.get(string5);
                for (String string6 : sortedMap3.keySet()) {
                    String string7 = (String)sortedMap3.get(string6);
                    this.addToUserMap(string3, string4, string6 + ":" + string7, n2);
                }
            }
        }
    }

    public void makeKitSelectionFor(PlayerCharacter playerCharacter) {
        Object object;
        int n = this.getPCAgeSet(playerCharacter);
        if (playerCharacter.hasMadeKitSelectionForAgeSet(n)) {
            return;
        }
        String string = this.getAgeMapIndex(playerCharacter.getRegion(), n);
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t", false);
        stringTokenizer.nextToken();
        PObject pObject = new PObject();
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            if (!((String)object).startsWith("KIT:")) continue;
            pObject.setKitString("0|" + ((String)object).substring(4));
        }
        playerCharacter.setArmorProfListStable(false);
        object = pObject.getSafeListFor(ListKey.KITS);
        for (int i = 0; i > object.size(); ++i) {
            KitUtilities.makeKitSelections(0, (String)object.get(i), i, playerCharacter);
        }
        playerCharacter.setHasMadeKitSelectionForAgeSet(n, true);
    }

    public void randomize(String string, PlayerCharacter playerCharacter) {
        if (playerCharacter == null || playerCharacter.getRace() == null) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("AGECAT")) {
                this.generateAge(Integer.parseInt(string2.substring(6)), false, playerCharacter);
                continue;
            }
            arrayList.add(string2);
        }
        if (arrayList.contains("AGE")) {
            this.generateAge(0, true, playerCharacter);
        }
        if (arrayList.contains("HT") || arrayList.contains("WT")) {
            this.generateHeightWeight(playerCharacter);
        }
        if (arrayList.contains("EYES")) {
            playerCharacter.setEyeColor(this.generateBioValue(".EYES", playerCharacter));
        }
        if (arrayList.contains("HAIR")) {
            playerCharacter.setHairColor(this.generateBioValue(".HAIR", playerCharacter));
        }
        if (arrayList.contains("SKIN")) {
            playerCharacter.setSkinColor(this.generateBioValue(".SKINTONE", playerCharacter));
        }
    }

    public void removeFromUserMap(String string, String string2, String string3) {
        int n = string3.indexOf(58);
        String string4 = n < 0 ? string + "." + string2 + "." + string3 : string + "." + string2 + "." + string3.substring(0, n);
        this.userMap.remove(string4);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("AgeMap: ").append(this.ageMap.toString()).append("\n");
        stringBuffer.append("RaceMap: ").append(this.raceMap.toString()).append("\n");
        stringBuffer.append("UserMap: ").append(this.userMap.toString()).append("\n");
        return stringBuffer.toString();
    }

    private static String replaceString(String string, String string2, int n) {
        String string3 = string;
        int n2 = string3.indexOf(string2);
        if (n2 >= 0) {
            String string4 = string3.substring(0, n2);
            String string5 = string3.substring(n2 + string2.length());
            string3 = string4 + n + string5;
        }
        return string3;
    }

    private SortedMap<Integer, SortedMap<String, String>> getRaceTagsByAge(String string, String string2, boolean bl) {
        List<String> list;
        String string3 = "";
        if (bl) {
            int n = string2.indexOf(40);
            string3 = n >= 0 ? string2.substring(0, n).trim() + '%' : string2 + '%';
        }
        SortedMap<Integer, SortedMap<String, String>> sortedMap = this.setupAgeSet(string);
        for (String string4 : this.raceMap.keySet()) {
            if (!string4.startsWith(string + "." + string2 + ".") && !string4.startsWith(string + "." + string3 + ".")) continue;
            list = this.raceMap.get(string4);
            this.addTagToAgeSet(sortedMap, string4, list);
        }
        for (String string4 : this.userMap.keySet()) {
            if (!string4.startsWith(string + "." + string2 + ".") && !string4.startsWith(string + "." + string3 + ".")) continue;
            list = this.userMap.get(string4);
            this.addTagToAgeSet(sortedMap, string4, list);
        }
        return sortedMap;
    }

    private String getTokenNumberInMaps(String string, int n, String string2, String string3) {
        List<String> list = this.getValueInMaps(string2, string3, string);
        if (list == null) {
            return null;
        }
        if (list.size() <= n) {
            return "0";
        }
        return list.get(n);
    }

    private List<String> getValueInMaps(String string, String string2, String string3) {
        String string4 = string2.indexOf(40) >= 0 ? string2.substring(0, string2.indexOf(40)).trim() + '%' : string2 + '%';
        List<String> list = this.mapFind(this.userMap, string, string2, string3, string4);
        if (list != null) {
            return list;
        }
        return this.mapFind(this.raceMap, string, string2, string3, string4);
    }

    private void addTagToAgeSet(SortedMap sortedMap, String string, Object object) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() >= 3) {
            stringTokenizer.nextToken();
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            if (object instanceof List) {
                List list = (List)object;
                Iterator iterator = list.iterator();
                for (int i = 0; i < sortedMap.size() && iterator.hasNext(); ++i) {
                    String string4 = (String)iterator.next();
                    SortedMap sortedMap2 = (SortedMap)sortedMap.get(i);
                    TreeMap<String, String> treeMap = (TreeMap<String, String>)sortedMap2.get(string2);
                    if (treeMap == null) {
                        treeMap = new TreeMap<String, String>();
                        sortedMap2.put(string2, treeMap);
                    }
                    treeMap.put(string3, string4);
                }
            } else {
                SortedMap sortedMap3 = (SortedMap)sortedMap.get(0);
                TreeMap<String, Object> treeMap = (TreeMap<String, Object>)sortedMap3.get(string2);
                if (treeMap == null) {
                    treeMap = new TreeMap<String, Object>();
                    sortedMap3.put(string2, treeMap);
                }
                treeMap.put(string3, object);
            }
        }
    }

    private String appendAgesetInfo(SortedMap sortedMap, StringBuffer stringBuffer) {
        for (Integer n : sortedMap.keySet()) {
            SortedMap sortedMap2 = (SortedMap)sortedMap.get(n);
            stringBuffer.append("AGESET:").append(n).append("|");
            stringBuffer.append(sortedMap2.get("AGESET")).append("\n");
            for (String string : sortedMap2.keySet()) {
                if ("AGESET".equals(string)) continue;
                SortedMap sortedMap3 = (SortedMap)sortedMap2.get(string);
                for (String string2 : sortedMap3.keySet()) {
                    stringBuffer.append("RACENAME:").append(string).append("\t\t");
                    stringBuffer.append(string2).append(':').append(sortedMap3.get(string2)).append("\n");
                }
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private void generateAge(int n, boolean bl, PlayerCharacter playerCharacter) {
        Object object;
        String string = this.getTokenNumberInMaps(".BASEAGE", n, playerCharacter.getRegion(), playerCharacter.getRace().getKeyName().trim());
        if (string == null) {
            return;
        }
        int n2 = Integer.parseInt(string);
        int n3 = -1;
        String string2 = this.getTokenNumberInMaps(".CLASS", n, playerCharacter.getRegion(), playerCharacter.getRace().getKeyName().trim());
        if (string2 != null && !string2.equals("0")) {
            object = new StringTokenizer(string2, "|");
            while (((StringTokenizer)object).hasMoreTokens()) {
                int n4;
                int n5;
                String string3 = ((StringTokenizer)object).nextToken();
                String string4 = string3.substring((n5 = string3.indexOf("[")) + 1, n4 = string3.indexOf("]"));
                if (string4.startsWith("BASEAGEADD:")) {
                    string4 = string4.substring(11);
                }
                string3 = string3.substring(0, n5);
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                while (stringTokenizer.hasMoreTokens() && n3 < 0) {
                    String string5 = stringTokenizer.nextToken();
                    if (playerCharacter.getClassKeyed(string5) == null) continue;
                    n3 = RollingMethods.roll(string4);
                }
            }
        }
        if (n3 < 0 && !bl && (string2 = this.getTokenNumberInMaps(".AGEDIEROLL", n, playerCharacter.getRegion(), playerCharacter.getRace().getKeyName().trim())) != null) {
            n3 = RollingMethods.roll(string2);
        }
        if (n3 >= 0 && n2 > 0) {
            int n6;
            object = this.getTokenNumberInMaps(".MAXAGE", n, playerCharacter.getRegion(), playerCharacter.getRace().getKeyName().trim());
            if (object != null && n2 + n3 > (n6 = Integer.parseInt((String)object))) {
                n3 = n6 - n2;
            }
            playerCharacter.setAge(n2 + n3);
        }
    }

    private String generateBioValue(String string, PlayerCharacter playerCharacter) {
        String string2;
        String string3 = this.getTokenNumberInMaps(string, 0, playerCharacter.getRegion(), playerCharacter.getRace().getKeyName().trim());
        if (string3 != null && string3.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "|");
            ArrayList<String> arrayList = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            int n = RollingMethods.roll(1, arrayList.size()) - 1;
            string2 = (String)arrayList.get(n);
        } else {
            string2 = "";
        }
        return string2;
    }

    private void generateHeightWeight(PlayerCharacter playerCharacter) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string = null;
        String string2 = this.getTokenNumberInMaps(".SEX", 0, playerCharacter.getRegion(), playerCharacter.getRace().getKeyName().trim());
        if (string2 == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "[]", false);
        while (stringTokenizer.hasMoreTokens()) {
            if (stringTokenizer.nextToken().equals(playerCharacter.getGender())) {
                String string3 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "|", false);
                while (stringTokenizer2.hasMoreTokens()) {
                    String string4 = stringTokenizer2.nextToken();
                    if (string4.startsWith("BASEHT:")) {
                        n = Integer.parseInt(string4.substring(7));
                        continue;
                    }
                    if (string4.startsWith("BASEWT:")) {
                        n2 = Integer.parseInt(string4.substring(7));
                        continue;
                    }
                    if (string4.startsWith("HTDIEROLL:")) {
                        n3 = RollingMethods.roll(string4.substring(10));
                        continue;
                    }
                    if (string4.startsWith("WTDIEROLL:")) {
                        n4 = RollingMethods.roll(string4.substring(10));
                        continue;
                    }
                    if (!string4.startsWith("TOTALWT:")) continue;
                    string = string4.substring(8);
                }
                if (n != 0 && n3 != 0) {
                    playerCharacter.setHeight(n + n3);
                }
                if (string == null || n2 == 0 || n4 == 0) break;
                string = BioSet.replaceString(string, "HTDIEROLL", n3);
                string = BioSet.replaceString(string, "BASEWT", n2);
                string = BioSet.replaceString(string, "WTDIEROLL", n4);
                playerCharacter.setWeight(playerCharacter.getVariableValue(string, "").intValue());
                break;
            }
            stringTokenizer.nextToken();
        }
    }

    private List<String> mapFind(Map<String, List<String>> map, String string, String string2, String string3, String string4) {
        List<String> list;
        String string5 = string;
        if (!string5.endsWith(".")) {
            string5 = string5 + ".";
        }
        if ((list = map.get(string5 + string2 + string3)) != null) {
            return list;
        }
        int n = string4.length();
        if (n != 0 && (list = map.get(string5 + string4 + string3)) != null) {
            return list;
        }
        if (!string.equals("None")) {
            list = map.get("None." + string2 + string3);
            if (list != null) {
                return list;
            }
            if (n != 0) {
                list = map.get("None." + string4 + string3);
            }
        }
        return list;
    }

    private SortedMap<Integer, SortedMap<String, String>> setupAgeSet(String string) {
        TreeMap<Integer, SortedMap<String, String>> treeMap = new TreeMap<Integer, SortedMap<String, String>>();
        for (String string2 : this.ageMap.keySet()) {
            if (!string2.startsWith(string + ".")) continue;
            Integer n = Integer.valueOf(string2.substring(string.length() + 1));
            String string3 = this.ageMap.get(string2);
            TreeMap<String, String> treeMap2 = new TreeMap<String, String>();
            treeMap2.put("AGESET", string3);
            treeMap.put(n, treeMap2);
        }
        return treeMap;
    }

    @Override
    public List<BonusObj> getActiveBonuses(PlayerCharacter playerCharacter) {
        ArrayList<BonusObj> arrayList = new ArrayList<BonusObj>();
        arrayList.addAll(super.getActiveBonuses(playerCharacter));
        String string = Globals.getBioSet().getAgeSetLine(playerCharacter);
        if (string == null) {
            return arrayList;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            BonusObj bonusObj;
            String string2 = stringTokenizer.nextToken();
            if (!string2.startsWith("BONUS:") || (bonusObj = Bonus.newBonus(string2.substring(6))) == null) continue;
            bonusObj.setCreatorObject(Globals.getBioSet());
            bonusObj.setApplied(true);
            arrayList.add(bonusObj);
        }
        return arrayList;
    }
}

