/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.PlayerCharacter;
import pcgen.core.PrereqObject;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DamageReduction
extends PrereqObject
implements Comparable<DamageReduction>,
Cloneable {
    private String theReduction = "0";
    private String theBypass = "-";
    private PlayerCharacter thePC = null;
    private static final int NO_JOIN = -1;
    private static final int AND_JOIN = 0;
    private static final int OR_JOIN = 1;
    private int join = 0;

    public DamageReduction(String string, String string2) {
        this.theReduction = string;
        this.theBypass = string2;
        String string3 = this.theBypass.toLowerCase();
        this.join = string3.indexOf(" and ") != -1 ? 0 : (string3.indexOf(" or ") != -1 ? 1 : -1);
    }

    public void setPC(PlayerCharacter playerCharacter) {
        if (this.thePC == null) {
            this.thePC = playerCharacter;
        }
    }

    public String getBypass() {
        return this.theBypass;
    }

    public void setBypass(String string) {
        this.theBypass = string;
    }

    public String getReduction() {
        return this.theReduction;
    }

    public int getReductionValue() {
        if (this.thePC != null) {
            int n = this.thePC.getVariableValue(this.theReduction, "getDR").intValue();
            return n += (int)this.thePC.getTotalBonusTo("DR", this.theBypass);
        }
        try {
            return Integer.parseInt(this.theReduction);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public void setReduction(String string) {
        this.theReduction = string;
    }

    public Collection<String> getBypassList() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.theBypass, " ");
        HashSet<String> hashSet = new HashSet<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if ("or".equalsIgnoreCase(string) || "and".equalsIgnoreCase(string)) continue;
            hashSet.add(string.toLowerCase());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public String toString() {
        if (this.thePC == null) {
            String string = this.theReduction;
            int n = this.getReductionValue();
            if (n < 0) {
                string = "variable";
            }
            return string + "/" + this.theBypass;
        }
        if (this.qualifies(this.thePC)) {
            return this.getReductionValue() + "/" + this.theBypass;
        }
        return "";
    }

    public boolean equals(Object object) {
        Collection<String> collection;
        if (!(object instanceof DamageReduction)) {
            return false;
        }
        Collection<String> collection2 = this.getBypassList();
        if (collection2.containsAll(collection = ((DamageReduction)object).getBypassList()) && collection.containsAll(collection2)) {
            return this.getReductionValue() == ((DamageReduction)object).getReductionValue();
        }
        return false;
    }

    @Override
    public int compareTo(DamageReduction damageReduction) {
        int n;
        int n2 = this.getReductionValue();
        return n2 < (n = damageReduction.getReductionValue()) ? 1 : (n2 > n ? -1 : 0);
    }

    public int hashCode() {
        ArrayList<String> arrayList = new ArrayList<String>(this.getBypassList());
        Collections.sort(arrayList);
        int n = 0;
        Iterator<String> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            n += iterator.next().hashCode();
        }
        return this.theReduction.hashCode() + n;
    }

    public static DamageReduction addDRs(DamageReduction damageReduction, DamageReduction damageReduction2) {
        DamageReduction damageReduction3;
        DamageReduction damageReduction4 = damageReduction.qualifies(damageReduction.thePC) ? damageReduction : null;
        DamageReduction damageReduction5 = damageReduction3 = damageReduction2.qualifies(damageReduction2.thePC) ? damageReduction2 : null;
        if (damageReduction4 == null && damageReduction3 != null) {
            return damageReduction3;
        }
        if (damageReduction4 != null && damageReduction3 == null) {
            return damageReduction4;
        }
        if (damageReduction4 == null && damageReduction3 == null) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>(damageReduction.getBypassList());
        HashSet<String> hashSet2 = new HashSet<String>(damageReduction2.getBypassList());
        if (damageReduction.getBypass().equalsIgnoreCase(damageReduction2.getBypass())) {
            return new DamageReduction(Math.max(damageReduction.getReductionValue(), damageReduction2.getReductionValue()) + "", damageReduction.getBypass());
        }
        hashSet.retainAll(hashSet2);
        if (hashSet.size() > 0) {
            if (damageReduction.join == 1 && damageReduction2.join != 1) {
                if (damageReduction2.getReductionValue() >= damageReduction.getReductionValue()) {
                    return damageReduction2;
                }
            } else if (damageReduction2.join == 1 && damageReduction.join != 1) {
                if (damageReduction.getReductionValue() >= damageReduction2.getReductionValue()) {
                    return damageReduction;
                }
            } else if (damageReduction.join == -1 && damageReduction2.join != 1) {
                if (damageReduction2.getReductionValue() >= damageReduction.getReductionValue()) {
                    return damageReduction2;
                }
            } else if (damageReduction2.join == -1 && damageReduction.join != 1) {
                if (damageReduction.getReductionValue() >= damageReduction2.getReductionValue()) {
                    return damageReduction;
                }
            } else if (damageReduction.getReductionValue() == damageReduction2.getReductionValue() && damageReduction.join != 1 && damageReduction2.join != 1) {
                HashSet<String> hashSet3 = new HashSet<String>(damageReduction.getBypassList());
                hashSet3.addAll(hashSet2);
                boolean bl = false;
                StringBuffer stringBuffer = new StringBuffer();
                Iterator<String> iterator = hashSet3.iterator();
                while (iterator.hasNext()) {
                    if (bl) {
                        stringBuffer.append(" and ");
                    }
                    stringBuffer.append(iterator.next());
                    bl = true;
                }
                return new DamageReduction(damageReduction.getReduction(), stringBuffer.toString());
            }
        } else if (damageReduction.join != 1 && damageReduction2.join != 1 && damageReduction.getReductionValue() == damageReduction2.getReductionValue()) {
            return new DamageReduction(damageReduction.getReduction(), damageReduction.getBypass() + " and " + damageReduction2.getBypass());
        }
        return null;
    }

    public static String combineDRs(DamageReduction damageReduction, DamageReduction damageReduction2) {
        DamageReduction damageReduction3;
        DamageReduction damageReduction4 = damageReduction.qualifies(damageReduction.thePC) ? damageReduction : null;
        DamageReduction damageReduction5 = damageReduction3 = damageReduction2.qualifies(damageReduction2.thePC) ? damageReduction2 : null;
        if (damageReduction4 == null && damageReduction3 != null) {
            return damageReduction3.toString();
        }
        if (damageReduction4 != null && damageReduction3 == null) {
            return damageReduction4.toString();
        }
        if (damageReduction4 == null && damageReduction3 == null) {
            return "";
        }
        DamageReduction damageReduction6 = DamageReduction.addDRs(damageReduction, damageReduction2);
        if (damageReduction6 == null) {
            if (damageReduction.compareTo(damageReduction2) <= 0) {
                return damageReduction.toString() + "; " + damageReduction2.toString();
            }
            return damageReduction2.toString() + "; " + damageReduction.toString();
        }
        return damageReduction6.toString();
    }

    private static List<DamageReduction> parseOrList(PlayerCharacter playerCharacter, List<DamageReduction> list) {
        ArrayList<DamageReduction> arrayList = new ArrayList<DamageReduction>();
        Iterator<DamageReduction> iterator = list.iterator();
        while (iterator.hasNext()) {
            DamageReduction damageReduction = iterator.next();
            damageReduction.setPC(playerCharacter);
            if (!damageReduction.qualifies(playerCharacter) || damageReduction.getBypass().toLowerCase().indexOf(" or ") == -1) continue;
            arrayList.add(damageReduction);
            iterator.remove();
        }
        return arrayList;
    }

    private static List<DamageReduction> parseAndList(List<DamageReduction> list) {
        ArrayList<DamageReduction> arrayList = new ArrayList<DamageReduction>();
        for (DamageReduction damageReduction : list) {
            String string = damageReduction.getBypass().replaceAll(" AND ", " and ");
            String[] stringArray = string.split(" and ");
            if (stringArray.length == 1) {
                arrayList.add(damageReduction);
                continue;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                DamageReduction damageReduction2 = new DamageReduction(damageReduction.getReduction(), stringArray[i]);
                arrayList.add(damageReduction2);
            }
        }
        return arrayList;
    }

    private static List<DamageReduction> processList(List<DamageReduction> list, List<DamageReduction> list2) {
        String[] stringArray;
        String string;
        ArrayList<DamageReduction> arrayList = new ArrayList<DamageReduction>();
        HashMap<String, DamageReduction> hashMap = new HashMap<String, DamageReduction>();
        for (DamageReduction damageReduction : list) {
            string = damageReduction.getBypass().toLowerCase();
            if (damageReduction.getReductionValue() == -1) {
                arrayList.add(damageReduction);
                continue;
            }
            stringArray = (String[])hashMap.get(string);
            if (stringArray == null) {
                hashMap.put(string, damageReduction);
                continue;
            }
            if (damageReduction.getReductionValue() <= stringArray.getReductionValue()) continue;
            hashMap.remove(stringArray.getBypass().toLowerCase());
            hashMap.put(string, damageReduction);
        }
        arrayList.addAll(hashMap.values());
        for (DamageReduction damageReduction : list2) {
            string = damageReduction.getBypass().replaceAll(" OR ", " or ");
            stringArray = string.split(" or ");
            boolean bl = true;
            for (int i = 0; i < stringArray.length; ++i) {
                DamageReduction damageReduction2 = (DamageReduction)hashMap.get(stringArray[i].toLowerCase());
                if (damageReduction2 == null || damageReduction2.getReductionValue() < damageReduction.getReductionValue()) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            arrayList.add(damageReduction);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private static void mergeAnds(List<DamageReduction> list) {
        DamageReduction damageReduction = null;
        Iterator<DamageReduction> iterator = list.iterator();
        while (iterator.hasNext()) {
            DamageReduction damageReduction2 = iterator.next();
            if (damageReduction2.join == 1) continue;
            if (damageReduction != null && damageReduction2.getReductionValue() == damageReduction.getReductionValue()) {
                damageReduction.setBypass(damageReduction.getBypass() + " and " + damageReduction2.getBypass());
                iterator.remove();
                continue;
            }
            damageReduction = damageReduction2;
        }
    }

    private static void mergeAnds(List<DamageReduction> list, PlayerCharacter playerCharacter) {
        if (playerCharacter == null) {
            DamageReduction.mergeAnds(list);
            return;
        }
        DamageReduction damageReduction = null;
        Iterator<DamageReduction> iterator = list.iterator();
        while (iterator.hasNext()) {
            DamageReduction damageReduction2 = iterator.next();
            if (!damageReduction2.qualifies(playerCharacter)) {
                iterator.remove();
                continue;
            }
            if (damageReduction2.join == 1) continue;
            if (damageReduction != null && damageReduction2.getReductionValue() == damageReduction.getReductionValue()) {
                damageReduction.setBypass(damageReduction.getBypass() + " and " + damageReduction2.getBypass());
                iterator.remove();
                continue;
            }
            damageReduction = damageReduction2;
        }
    }

    public static List<DamageReduction> getDRList(PlayerCharacter playerCharacter, List<DamageReduction> list) {
        ArrayList<DamageReduction> arrayList = new ArrayList<DamageReduction>(list);
        List<DamageReduction> list2 = DamageReduction.parseOrList(playerCharacter, arrayList);
        List<DamageReduction> list3 = DamageReduction.parseAndList(arrayList);
        List<DamageReduction> list4 = DamageReduction.processList(list3, list2);
        return Collections.unmodifiableList(list4);
    }

    public static String getDRString(PlayerCharacter playerCharacter, List<DamageReduction> list) {
        ArrayList<DamageReduction> arrayList = new ArrayList<DamageReduction>(DamageReduction.getDRList(playerCharacter, list));
        DamageReduction.mergeAnds(arrayList, playerCharacter);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (DamageReduction damageReduction : arrayList) {
            String string;
            if (bl) {
                stringBuffer.append("; ");
            }
            if ((string = damageReduction.toString()) == null || string.trim().length() <= 0) continue;
            stringBuffer.append(damageReduction.toString());
            bl = true;
        }
        return stringBuffer.toString();
    }

    @Override
    public DamageReduction clone() throws CloneNotSupportedException {
        DamageReduction damageReduction = (DamageReduction)super.clone();
        if (this.hasPreReqs()) {
            damageReduction.clearPreReq();
            for (Prerequisite prerequisite : this.getPreReqList()) {
                damageReduction.addPreReq(prerequisite.clone());
            }
        }
        return damageReduction;
    }

    public String getPCCText(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("DR:");
        stringBuffer.append(this.theReduction);
        stringBuffer.append("/");
        stringBuffer.append(this.theBypass);
        StringWriter stringWriter = new StringWriter();
        for (Prerequisite prerequisite : this.getPreReqList()) {
            if (!bl && "class".equals(prerequisite.getKind())) continue;
            PrerequisiteWriter prerequisiteWriter = new PrerequisiteWriter();
            try {
                stringWriter.write("|");
                prerequisiteWriter.write(stringWriter, prerequisite);
            }
            catch (PersistenceLayerException persistenceLayerException) {
                persistenceLayerException.printStackTrace();
            }
            stringBuffer.append(stringWriter);
        }
        return stringBuffer.toString();
    }

    public boolean isForClassLevel(String string) {
        for (Prerequisite prerequisite : this.getPreReqList()) {
            if (!DamageReduction.isPrereqForClassLevel(prerequisite, string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrereqForClassLevel(Prerequisite prerequisite, String string) {
        return prerequisite.getKind().equals("class") && prerequisite.getKey().equals(string);
    }
}

