/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Domain;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.QualifiedObject;
import pcgen.core.SpecialAbility;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteOperator;
import pcgen.core.prereq.PrerequisiteUtilities;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.ListKey;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.core.utils.StringKey;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Deity
extends PObject {
    private boolean d_allDomains = false;

    public Deity() {
        this.buildDomainList(null, null);
        this.listChar.initializeListFor(ListKey.PANTHEON);
        this.listChar.initializeListFor(ListKey.RACEPANTHEON);
        this.listChar.initializeListFor(ListKey.DOMAIN);
    }

    public void addDomain(String string, List<Prerequisite> list) {
        Domain domain = Globals.getDomainKeyed(string);
        if (domain != null) {
            this.listChar.addToListFor(ListKey.DOMAIN, new QualifiedObject<Domain>(domain, list));
        } else {
            Logging.debugPrint("Can not find domain: '" + string + "'.");
        }
    }

    public void addPantheon(String string) {
        string = string.trim();
        this.listChar.addToListFor(ListKey.PANTHEON, string);
        Globals.getPantheons().add(string);
    }

    public void addRacePantheon(String string) {
        string = string.trim();
        this.listChar.addToListFor(ListKey.RACEPANTHEON, string);
        Globals.getPantheons().add(string);
    }

    public boolean canBeSelectedBy(List<PCClass> list, int n, PlayerCharacter playerCharacter) {
        boolean bl;
        try {
            bl = this.acceptableClass(list.iterator()) && this.allowsAlignment(n, playerCharacter) && PrereqHandler.passesAll(this.getPreReqList(), playerCharacter, this);
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    @Override
    public Deity clone() {
        try {
            return (Deity)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ShowMessageDelegate.showMessageDialog(cloneNotSupportedException.getMessage(), "PCGen", MessageType.ERROR);
            return null;
        }
    }

    public String getAlignment() {
        String string = (String)this.stringChar.get(StringKey.ALIGNMENT);
        return string == null ? "" : string;
    }

    public String getAppearance() {
        String string = (String)this.stringChar.get(StringKey.APPEARANCE);
        return string == null ? "" : string;
    }

    public List<QualifiedObject<Domain>> getDomainList() {
        return this.getListFor(ListKey.DOMAIN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDomainListPIString() {
        String string = (String)this.stringChar.get(StringKey.DOMAIN_LIST_PI);
        if (string == null) {
            Deity deity = this;
            synchronized (deity) {
                if (string == null) {
                    StringBuffer stringBuffer = new StringBuffer(100);
                    stringBuffer.append("<html>");
                    if (this.d_allDomains) {
                        stringBuffer.append("ALL");
                    } else {
                        boolean bl = false;
                        for (QualifiedObject<Domain> qualifiedObject : this.getDomainList()) {
                            if (qualifiedObject == null) continue;
                            Domain domain = qualifiedObject.getObject(null);
                            if (bl) {
                                stringBuffer.append(',');
                            } else {
                                bl = stringBuffer.length() > 0;
                            }
                            stringBuffer.append(domain.piSubString());
                        }
                    }
                    stringBuffer.append("</html>");
                    this.stringChar.put(StringKey.DOMAIN_LIST_PI, stringBuffer.toString());
                }
            }
        }
        return (String)this.stringChar.get(StringKey.DOMAIN_LIST_PI);
    }

    public String getFavoredWeapon() {
        String string = (String)this.stringChar.get(StringKey.FAVORED_WEAPON);
        return string == null ? "" : string;
    }

    public String getFollowerAlignments() {
        String string = (String)this.stringChar.get(StringKey.FOLLOWER_ALIGNMENTS);
        return string == null ? "" : string;
    }

    public String getHolyItem() {
        String string = (String)this.stringChar.get(StringKey.HOLY_ITEM);
        return string == null ? "None" : string;
    }

    public List<String> getPantheonList() {
        return this.getListFor(ListKey.PANTHEON);
    }

    @Override
    public String getPCCText() {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(this.getDisplayName());
        List<QualifiedObject<Domain>> list = this.getListFor(ListKey.DOMAIN);
        if (list != null && list.size() != 0) {
            stringBuffer.append("\tDOMAINS:");
            object2 = null;
            boolean bl = true;
            object = list.iterator();
            while (object.hasNext()) {
                QualifiedObject<Domain> qualifiedObject = object.next();
                Domain domain = qualifiedObject.getObject(null);
                List<Prerequisite> list2 = qualifiedObject.getPrereqs();
                if (object2 != null && !object2.equals(list2)) {
                    stringBuffer.append(PrerequisiteUtilities.getPrerequisitePCCText((List)object2, "|"));
                    stringBuffer.append("\tDOMAINS:");
                    bl = true;
                } else if (!bl) {
                    stringBuffer.append(",");
                } else {
                    bl = false;
                }
                object2 = list2;
                stringBuffer.append(domain.getKeyName());
            }
            if (object2 != null) {
                stringBuffer.append(PrerequisiteUtilities.getPrerequisitePCCText((List)object2, "|"));
            }
        }
        if (((String)(object2 = this.getFollowerAlignments())).length() != 0) {
            stringBuffer.append("\tFOLLOWERALIGN:").append((String)object2);
        }
        if (this.getHolyItem().length() != 0) {
            stringBuffer.append("\tSYMBOL:").append(this.getHolyItem());
        }
        if (this.getFavoredWeapon().length() != 0) {
            stringBuffer.append("\tDEITYWEAP:").append(this.getFavoredWeapon());
        }
        stringBuffer.append("\tALIGN:").append(this.getAlignment());
        List<String> list3 = this.getPantheonList();
        if (list3.size() != 0) {
            stringBuffer.append("\tPANTHEON:").append(CoreUtility.join(list3, "|"));
        }
        if ((object = this.getRacePantheonList()).size() != 0) {
            stringBuffer.append("\tRACE:").append(CoreUtility.join(object, "|"));
        }
        stringBuffer.append(super.getPCCText(false));
        return stringBuffer.toString();
    }

    public List<String> getRacePantheonList() {
        return this.getListFor(ListKey.RACEPANTHEON);
    }

    public String getTitle() {
        String string = (String)this.stringChar.get(StringKey.TITLE);
        return string == null ? "" : string;
    }

    public final String getWorshippers() {
        String string = (String)this.stringChar.get(StringKey.WORSHIPPERS);
        return string == null ? "" : string;
    }

    public boolean hasDomain(Domain domain) {
        if (this.d_allDomains) {
            return true;
        }
        for (QualifiedObject<Domain> qualifiedObject : this.getDomainList()) {
            if (!qualifiedObject.getObject(null).equals(domain)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDomainKeyed(String string) {
        Domain domain = Globals.getDomainKeyed(string);
        return this.hasDomain(domain);
    }

    @Override
    public String preReqHTMLStrings(PlayerCharacter playerCharacter, boolean bl) {
        Object object;
        ArrayList<Prerequisite> arrayList = new ArrayList<Prerequisite>();
        this.addPreReqTo(arrayList);
        ArrayList<Prerequisite> arrayList2 = new ArrayList<Prerequisite>();
        String string = "";
        String string2 = this.getFollowerAlignments();
        if (string2.length() != 0) {
            Logging.debugPrint("preReqHTMLStrings: " + string2);
            for (int i = 0; i < string2.length(); ++i) {
                object = new Prerequisite();
                ((Prerequisite)object).setKind("align");
                ((Prerequisite)object).setOperator(PrerequisiteOperator.EQ);
                ((Prerequisite)object).setKey(string2.substring(i, i + 1));
                arrayList2.add((Prerequisite)object);
            }
            string = "One of (" + PrerequisiteUtilities.preReqHTMLStringsForList(playerCharacter, null, arrayList2, bl) + ")";
        }
        String string3 = string;
        object = PrerequisiteUtilities.preReqHTMLStringsForList(playerCharacter, null, arrayList, bl);
        if (!((String)object).equals("")) {
            string3 = string3 + ", " + (String)object;
        }
        return string3;
    }

    public void removeDomain(String string) {
        Domain domain = Globals.getDomainKeyed(string);
        if (domain != null) {
            for (QualifiedObject<Domain> qualifiedObject : this.listChar.getListFor(ListKey.DOMAIN)) {
                if (!domain.equals(qualifiedObject.getObject(null))) continue;
                this.listChar.removeFromListFor(ListKey.DOMAIN, qualifiedObject);
            }
        } else {
            Logging.debugPrint("Can not find domain: '" + string + "'.");
        }
    }

    public void setAppearance(String string) {
        this.stringChar.put(StringKey.APPEARANCE, string);
    }

    public void setAlignment(String string) {
        this.stringChar.put(StringKey.ALIGNMENT, string);
    }

    public void setDomainList(List<QualifiedObject<Domain>> list) {
        this.listChar.removeListFor(ListKey.DOMAIN);
        this.listChar.addAllToListFor(ListKey.DOMAIN, list);
        this.stringChar.put(StringKey.DOMAIN_LIST_PI, null);
    }

    public void setDomainNameList(List<String> list, List<Prerequisite> list2) {
        this.stringChar.put(StringKey.DOMAIN_LIST_PI, null);
        this.d_allDomains = false;
        this.buildDomainList(list, list2);
    }

    public void setFavoredWeapon(String string) {
        this.stringChar.put(StringKey.FAVORED_WEAPON, string);
    }

    public void setFollowerAlignments(String string) {
        this.stringChar.put(StringKey.FOLLOWER_ALIGNMENTS, string);
    }

    public void setHolyItem(String string) {
        this.stringChar.put(StringKey.HOLY_ITEM, string);
    }

    public void setPantheonList(List<String> list) {
        for (String string : list) {
            this.addPantheon(string);
        }
    }

    public void setRacePantheonList(List<String> list) {
        for (String string : list) {
            this.addRacePantheon(string);
        }
    }

    public void setTitle(String string) {
        this.stringChar.put(StringKey.TITLE, string);
    }

    public final void setWorshippers(String string) {
        this.stringChar.put(StringKey.WORSHIPPERS, string);
    }

    @Override
    protected List<SpecialAbility> addSpecialAbilitiesToList(List<SpecialAbility> list, PlayerCharacter playerCharacter) {
        List<SpecialAbility> list2 = this.getListFor(ListKey.SPECIAL_ABILITY);
        if (list2 == null || list2.isEmpty()) {
            return list;
        }
        for (SpecialAbility specialAbility : list2) {
            if (!specialAbility.pcQualifiesFor(playerCharacter)) continue;
            list.add(specialAbility);
        }
        return list;
    }

    private boolean acceptableClass(Iterator<PCClass> iterator) {
        boolean bl;
        boolean bl2 = bl = !iterator.hasNext();
        while (iterator.hasNext() && !bl) {
            PCClass pCClass = iterator.next();
            for (String string : pCClass.getDeityList()) {
                if (!"ANY".equals(string) && !"ALL".equals(string) && !this.getKeyName().equals(string)) continue;
                bl = true;
            }
        }
        return bl;
    }

    private boolean allowsAlignment(int n, PlayerCharacter playerCharacter) {
        String string;
        StringTokenizer stringTokenizer;
        int n2;
        int n3;
        String string2 = this.getFollowerAlignments();
        while ((n3 = string2.indexOf(91)) >= 0 && (n2 = string2.indexOf(93, n3)) >= 0 && (stringTokenizer = new StringTokenizer(string = string2.substring(n3 + 1, n2), "=", false)).countTokens() == 3) {
            PlayerCharacter playerCharacter2;
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            String string5 = stringTokenizer.nextToken();
            boolean bl = false;
            if ("VARDEFINED".equals(string3) && (playerCharacter2 = playerCharacter) != null && playerCharacter2.hasVariable(string4)) {
                bl = true;
            }
            if (bl) {
                string2 = string2.substring(0, n3) + string5 + string2.substring(n2 + 1);
                continue;
            }
            string2 = string2.substring(0, n3) + string2.substring(n2 + 1);
        }
        if (string2.length() != 0) {
            return string2.lastIndexOf(String.valueOf(n)) >= 0;
        }
        return true;
    }

    private void buildDomainList(List<String> list, List<Prerequisite> list2) {
        if (list == null || list.size() == 0) {
            return;
        }
        if (list.contains("ALL") || list.contains("ANY")) {
            for (Domain domain : Globals.getDomainList()) {
                this.listChar.addToListFor(ListKey.DOMAIN, new QualifiedObject<Domain>(domain, list2));
            }
        } else {
            for (String string : list) {
                boolean bl = true;
                if (string.equals(".CLEAR")) {
                    this.listChar.removeListFor(ListKey.DOMAIN);
                    this.listChar.initializeListFor(ListKey.DOMAIN);
                    continue;
                }
                if (string.startsWith(".CLEAR.")) {
                    string = string.substring(7);
                    bl = false;
                }
                if (bl) {
                    this.addDomain(string, list2);
                    continue;
                }
                this.removeDomain(string);
            }
        }
    }
}

