/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.List;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.PrereqObject;
import pcgen.util.Logging;

public class Description
extends PrereqObject {
    private List<String> theComponents = new ArrayList<String>();
    private List<String> theVariables = null;
    private PObject theOwner = null;
    private static final String VAR_NAME = "%NAME";
    private static final String VAR_CHOICE = "%CHOICE";
    private static final String VAR_LIST = "%LIST";
    private static final String VAR_MARKER = "$$VAR:";

    public Description(String string) {
        int n = 0;
        int n2 = -1;
        while ((n2 = string.indexOf(37, n)) != -1) {
            String string2 = string.substring(n, n2);
            if (string2.length() > 0) {
                this.theComponents.add(string2);
            }
            if (n2 == string.length() - 1) {
                this.theComponents.add("%");
                return;
            }
            if (string.charAt(n2 + 1) == '{') {
                n = string.indexOf(125, n2 + 1) + 1;
                String string3 = string.substring(n2 + 1, n);
                try {
                    Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    Logging.errorPrintLocalised("Errors.Description.InvalidVariableReplacement", string3);
                }
                this.theComponents.add(VAR_MARKER + string3);
                continue;
            }
            if (string.charAt(n2 + 1) == '%') {
                n = n2 + 2;
                this.theComponents.add("%");
                continue;
            }
            for (n = n2 + 1; n < string.length(); ++n) {
                char c = string.charAt(n);
                try {
                    Integer.parseInt(String.valueOf(c));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    break;
                }
            }
            if (n > n2 + 1) {
                this.theComponents.add(VAR_MARKER + string.substring(n2 + 1, n));
                continue;
            }
            this.theComponents.add(string.substring(n2, n2 + 1));
        }
        this.theComponents.add(string.substring(n));
    }

    public void addVariable(String string) {
        if (this.theVariables == null) {
            this.theVariables = new ArrayList<String>();
        }
        this.theVariables.add(string);
    }

    public void setOwner(PObject pObject) {
        this.theOwner = pObject;
    }

    public PObject getOwner() {
        return this.theOwner;
    }

    public String getDescription(PlayerCharacter playerCharacter) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.qualifies(playerCharacter)) {
            for (String string : this.theComponents) {
                if (string.startsWith(VAR_MARKER)) {
                    int n = Integer.parseInt(string.substring(VAR_MARKER.length()));
                    if (this.theVariables == null || n > this.theVariables.size()) {
                        stringBuffer.append("");
                        continue;
                    }
                    String string2 = this.theVariables.get(n - 1);
                    if (string2.equals(VAR_NAME)) {
                        if (this.theOwner == null) continue;
                        stringBuffer.append(this.theOwner.getDisplayName());
                        continue;
                    }
                    if (string2.equals(VAR_CHOICE)) {
                        if (this.theOwner == null || this.theOwner.getAssociatedCount() <= 0) continue;
                        stringBuffer.append(this.theOwner.getAssociated(0));
                        continue;
                    }
                    if (string2.equals(VAR_LIST)) {
                        if (this.theOwner == null) continue;
                        for (int i = 0; i < this.theOwner.getAssociatedCount(true); ++i) {
                            if (i > 0) {
                                stringBuffer.append(",");
                            }
                            stringBuffer.append(this.theOwner.getAssociated(i, true));
                        }
                        continue;
                    }
                    if (string2.startsWith("\"")) {
                        stringBuffer.append(string2.substring(1, string2.length() - 1));
                        continue;
                    }
                    stringBuffer.append(playerCharacter.getVariableValue(string2, "Description").intValue());
                    continue;
                }
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public String getPCCText() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.theComponents) {
            if (string.startsWith(VAR_MARKER)) {
                int n = Integer.parseInt(string.substring(VAR_MARKER.length()));
                stringBuffer.append('%' + String.valueOf(n));
                continue;
            }
            stringBuffer.append(string);
        }
        if (this.theVariables != null) {
            for (String string : this.theVariables) {
                stringBuffer.append("|");
                stringBuffer.append(string);
            }
        }
        stringBuffer.append(super.getPCCText());
        return stringBuffer.toString();
    }
}

